/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.AbstractCommonCheckinAction;
import com.intellij.openapi.vcs.actions.CommonCheckinFilesAction;
import com.intellij.openapi.vcs.actions.CommonCheckinFilesActionKt;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u001b\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a2\u0006\u0002\u0010\u0013J \u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\b\u0010\u0019\u001a\u00020\tH\u0014\u00a8\u0006\u001a"}, d2={"Lcom/intellij/openapi/vcs/actions/CommonCheckinFilesAction;", "Lcom/intellij/openapi/vcs/actions/AbstractCommonCheckinAction;", "()V", "appendSubject", "", "dataContext", "Lcom/intellij/openapi/vcs/actions/VcsContext;", "checkinActionName", "approximatelyHasRoots", "", "getActionName", "getInitiallySelectedChangeList", "Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "context", "project", "Lcom/intellij/openapi/project/Project;", "getRoots", "", "Lcom/intellij/openapi/vcs/FilePath;", "(Lcom/intellij/openapi/vcs/actions/VcsContext;)[Lcom/intellij/openapi/vcs/FilePath;", "isApplicableRoot", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "status", "Lcom/intellij/openapi/vcs/FileStatus;", "isForceUpdateCommitStateFromContext", "intellij.platform.vcs.impl"})
public class CommonCheckinFilesAction
extends AbstractCommonCheckinAction {
    @Override
    @NotNull
    protected String getActionName(@NotNull VcsContext dataContext) {
        Intrinsics.checkParameterIsNotNull((Object)dataContext, (String)"dataContext");
        AbstractVcs abstractVcs = CommonCheckinFilesActionKt.access$getCommonVcs(dataContext);
        String actionName = abstractVcs != null && (abstractVcs = abstractVcs.getCheckinEnvironment()) != null ? abstractVcs.getCheckinOperationName() : null;
        String string = actionName;
        if (string == null) {
            String string2 = VcsBundle.message((String)"vcs.command.name.checkin", (Object[])new Object[0]);
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"message(\"vcs.command.name.checkin\")");
        }
        return this.appendSubject(dataContext, string);
    }

    private final String appendSubject(VcsContext dataContext, String checkinActionName) {
        List roots = SequencesKt.toList((Sequence)SequencesKt.take((Sequence)CommonCheckinFilesActionKt.access$getRoots(dataContext), (int)2));
        if (roots.isEmpty()) {
            return checkinActionName;
        }
        String messageKey = ((FilePath)roots.get(0)).isDirectory() ? "action.name.checkin.directory" : "action.name.checkin.file";
        String string = VcsBundle.message((String)StringUtil.pluralize((String)messageKey, (int)roots.size()), (Object[])new Object[]{checkinActionName});
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"message(pluralize(messag\u2026size), checkinActionName)");
        return string;
    }

    @Override
    @NotNull
    protected LocalChangeList getInitiallySelectedChangeList(@NotNull VcsContext context, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)changeListManager, (String)"ChangeListManager.getInstance(project)");
        ChangeListManager manager = changeListManager;
        LocalChangeList localChangeList = manager.getDefaultChangeList();
        Intrinsics.checkExpressionValueIsNotNull((Object)localChangeList, (String)"manager.defaultChangeList");
        LocalChangeList defaultChangeList = localChangeList;
        LocalChangeList result2 = null;
        for (FilePath root : this.getRoots(context)) {
            LocalChangeList localChangeList2;
            Collection changes2;
            if (root.getVirtualFile() == null) continue;
            Intrinsics.checkExpressionValueIsNotNull((Object)manager.getChangesIn(root), (String)"manager.getChangesIn(root)");
            if (ContainerUtil.intersects((Collection)changes2, (Collection)defaultChangeList.getChanges())) {
                return defaultChangeList;
            }
            if ((Change)CollectionsKt.firstOrNull((Iterable)changes2) != null) {
                Change change;
                boolean bl = false;
                boolean bl2 = false;
                Change it = change;
                boolean bl3 = false;
                localChangeList2 = manager.getChangeList(it);
            } else {
                localChangeList2 = null;
            }
            result2 = localChangeList2;
        }
        LocalChangeList localChangeList3 = result2;
        if (localChangeList3 == null) {
            localChangeList3 = defaultChangeList;
        }
        return localChangeList3;
    }

    @Override
    protected boolean approximatelyHasRoots(@NotNull VcsContext dataContext) {
        boolean bl;
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)dataContext, (String)"dataContext");
            Project project = dataContext.getProject();
            if (project == null) {
                Intrinsics.throwNpe();
            }
            ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
            Intrinsics.checkExpressionValueIsNotNull((Object)changeListManager, (String)"ChangeListManager.getIns\u2026ce(dataContext.project!!)");
            ChangeListManager manager = changeListManager;
            Sequence $this$any$iv = SequencesKt.mapNotNull((Sequence)CommonCheckinFilesActionKt.access$getRoots(dataContext), (Function1)approximatelyHasRoots.1.INSTANCE);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl2 = false;
                VirtualFile virtualFile = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"it");
                FileStatus fileStatus = manager.getStatus(it);
                Intrinsics.checkExpressionValueIsNotNull((Object)fileStatus, (String)"manager.getStatus(it)");
                if (!this.isApplicableRoot(virtualFile, fileStatus, dataContext)) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    protected boolean isApplicableRoot(@NotNull VirtualFile file, @NotNull FileStatus status, @NotNull VcsContext dataContext) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)status, (String)"status");
        Intrinsics.checkParameterIsNotNull((Object)dataContext, (String)"dataContext");
        return Intrinsics.areEqual((Object)status, (Object)FileStatus.UNKNOWN) ^ true && Intrinsics.areEqual((Object)status, (Object)FileStatus.IGNORED) ^ true;
    }

    @Override
    @NotNull
    protected FilePath[] getRoots(@NotNull VcsContext dataContext) {
        Intrinsics.checkParameterIsNotNull((Object)dataContext, (String)"dataContext");
        FilePath[] filePathArray = dataContext.getSelectedFilePaths();
        Intrinsics.checkExpressionValueIsNotNull((Object)filePathArray, (String)"dataContext.selectedFilePaths");
        return filePathArray;
    }

    @Override
    protected boolean isForceUpdateCommitStateFromContext() {
        return true;
    }
}

