/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java.pdex;

import java.awt.EventQueue;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.util.function.Predicate;
import javax.swing.JMenuItem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import processing.app.Language;
import processing.app.Messages;
import processing.app.Platform;
import processing.mode.java.JavaEditor;
import processing.mode.java.JavaMode;
import processing.mode.java.pdex.ASTUtils;
import processing.mode.java.pdex.PreprocessedSketch;
import processing.mode.java.pdex.PreprocessingService;
import processing.mode.java.pdex.ShowUsage;

class InspectMode {
    final JavaEditor editor;
    final PreprocessingService pps;
    final ShowUsage usage;
    boolean inspectModeEnabled;
    boolean isMouse1Down;
    boolean isMouse2Down;
    boolean isHotkeyDown;
    Predicate<MouseEvent> mouseEventHotkeyTest = Platform.isMacOS() ? InputEvent::isMetaDown : InputEvent::isControlDown;
    Predicate<KeyEvent> keyEventHotkeyTest = Platform.isMacOS() ? e -> e.getKeyCode() == 157 : e -> e.getKeyCode() == 17;

    InspectMode(final JavaEditor editor, PreprocessingService pps, ShowUsage usage) {
        this.editor = editor;
        this.pps = pps;
        this.usage = usage;
        JMenuItem showUsageItem = new JMenuItem(Language.text((String)"editor.popup.jump_to_declaration"));
        showUsageItem.addActionListener(e -> this.handleInspect());
        editor.getTextArea().getRightClickPopup().add(showUsageItem);
        editor.getJavaTextArea().getPainter().addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                InspectMode.this.isMouse1Down = InspectMode.this.isMouse1Down || e.getButton() == 1;
                InspectMode.this.isMouse2Down = InspectMode.this.isMouse2Down || e.getButton() == 2;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                boolean releasingMouse2;
                boolean releasingMouse1 = e.getButton() == 1;
                boolean bl = releasingMouse2 = e.getButton() == 2;
                if (JavaMode.inspectModeHotkeyEnabled && InspectMode.this.inspectModeEnabled && InspectMode.this.isMouse1Down && releasingMouse1) {
                    InspectMode.this.handleInspect(e);
                } else if (!InspectMode.this.inspectModeEnabled && InspectMode.this.isMouse2Down && releasingMouse2) {
                    InspectMode.this.handleInspect(e);
                }
                InspectMode.this.isMouse1Down = InspectMode.this.isMouse1Down && !releasingMouse1;
                InspectMode.this.isMouse2Down = InspectMode.this.isMouse2Down && !releasingMouse2;
            }
        });
        editor.getJavaTextArea().getPainter().addMouseMotionListener((MouseMotionListener)new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (editor.isSelectionActive()) {
                    InspectMode.this.inspectModeEnabled = false;
                    InspectMode.this.isMouse2Down = false;
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                InspectMode.this.isMouse1Down = false;
                InspectMode.this.isMouse2Down = false;
                InspectMode.this.inspectModeEnabled = InspectMode.this.isHotkeyDown = InspectMode.this.mouseEventHotkeyTest.test(e);
            }
        });
        editor.getJavaTextArea().addMouseWheelListener(new MouseAdapter(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (InspectMode.this.isMouse1Down) {
                    InspectMode.this.inspectModeEnabled = false;
                }
            }
        });
        editor.getJavaTextArea().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                InspectMode.this.isHotkeyDown = InspectMode.this.isHotkeyDown || InspectMode.this.keyEventHotkeyTest.test(e);
                InspectMode.this.inspectModeEnabled = InspectMode.this.inspectModeEnabled || !InspectMode.this.isMouse1Down && InspectMode.this.isHotkeyDown;
            }

            @Override
            public void keyReleased(KeyEvent e) {
                InspectMode.this.isHotkeyDown = InspectMode.this.isHotkeyDown && !InspectMode.this.keyEventHotkeyTest.test(e);
                InspectMode.this.inspectModeEnabled = InspectMode.this.inspectModeEnabled && InspectMode.this.isHotkeyDown;
            }
        });
    }

    void handleInspect() {
        int off = this.editor.getSelectionStart();
        int tabIndex = this.editor.getSketch().getCurrentCodeIndex();
        this.pps.whenDoneBlocking(ps -> this.handleInspect((PreprocessedSketch)ps, tabIndex, off));
    }

    void handleInspect(MouseEvent evt) {
        int off = this.editor.getJavaTextArea().xyToOffset(evt.getX(), evt.getY());
        if (off < 0) {
            return;
        }
        int tabIndex = this.editor.getSketch().getCurrentCodeIndex();
        this.pps.whenDoneBlocking(ps -> this.handleInspect((PreprocessedSketch)ps, tabIndex, off));
    }

    private void handleInspect(PreprocessedSketch ps, int tabIndex, int offset) {
        CompilationUnit root = ps.compilationUnit;
        int javaOffset = ps.tabOffsetToJavaOffset(tabIndex, offset);
        SimpleName simpleName = ASTUtils.getSimpleNameAt((ASTNode)root, javaOffset, javaOffset);
        if (simpleName == null) {
            Messages.log((String)"no simple name found at click location");
            return;
        }
        IBinding binding = ASTUtils.resolveBinding(simpleName);
        if (binding == null) {
            Messages.log((String)"binding not resolved");
            return;
        }
        String key = binding.getKey();
        ASTNode decl = ps.compilationUnit.findDeclaringNode(key);
        if (decl == null) {
            Messages.log((String)"decl not found, showing usage instead");
            this.usage.findUsageAndUpdateTree(ps, binding);
            return;
        }
        SimpleName declName = null;
        switch (binding.getKind()) {
            case 2: {
                declName = ((TypeDeclaration)decl).getName();
                break;
            }
            case 4: {
                declName = ((MethodDeclaration)decl).getName();
                break;
            }
            case 3: {
                declName = ((VariableDeclaration)decl).getName();
            }
        }
        if (declName == null) {
            Messages.log((String)("decl name not found " + decl));
            return;
        }
        if (declName.equals((Object)simpleName)) {
            this.usage.findUsageAndUpdateTree(ps, binding);
        } else {
            Messages.log((String)("found declaration, offset " + decl.getStartPosition() + ", name: " + declName));
            PreprocessedSketch.SketchInterval si = ps.mapJavaToSketch((ASTNode)declName);
            if (!ps.inRange(si)) {
                return;
            }
            EventQueue.invokeLater(() -> this.editor.highlight(sketchInterval.tabIndex, sketchInterval.startTabOffset, sketchInterval.stopTabOffset));
        }
    }

    void dispose() {
    }
}

