/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.quickbar;

import java.util.Objects;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.css.PseudoClass;
import javafx.geometry.Pos;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;

public class BaseQuickbarButton
extends Button {
    private static final PseudoClass SELECTED_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"selected");
    private BooleanProperty displayText = new SimpleBooleanProperty(false){

        protected void invalidated() {
            if (this.get()) {
                BaseQuickbarButton.this.setContentDisplay(ContentDisplay.LEFT);
                BaseQuickbarButton.this.setAlignment(Pos.CENTER_LEFT);
            } else {
                BaseQuickbarButton.this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                BaseQuickbarButton.this.setAlignment(Pos.CENTER);
            }
        }
    };
    private BooleanProperty selected = new SimpleBooleanProperty(false){

        protected void invalidated() {
            BaseQuickbarButton.this.pseudoClassStateChanged(SELECTED_PSEUDOCLASS_STATE, this.get());
            BaseQuickbarButton.this.setDisable(this.get());
        }
    };

    public BaseQuickbarButton() {
        this.getStyleClass().addAll((Object[])new String[]{"quickbar-navigation-button"});
        this.setMaxWidth(Double.MAX_VALUE);
        this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        this.setAlignment(Pos.CENTER);
        this.graphicProperty().addListener((o, oldVal, newVal) -> {
            if (Objects.nonNull(newVal)) {
                newVal.getStyleClass().add((Object)"quickbar-navigation-button-graphic");
            }
        });
    }

    public final BooleanProperty displayTextProperty() {
        return this.displayText;
    }

    public final void setDisplayText(boolean value) {
        this.displayTextProperty().set(value);
    }

    public final boolean isDisplayText() {
        return this.displayText.get();
    }

    public final BooleanProperty selectedProperty() {
        return this.selected;
    }

    public final void setSelected(boolean value) {
        this.selectedProperty().set(value);
    }

    public final boolean isSelected() {
        return this.selected.get();
    }
}

