/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.selection;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.fontawesome.utils.FontAwesomeIconFactory;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Labeled;
import javafx.scene.control.Tooltip;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.pdf.PdfDescriptorLoadingStatus;
import org.pdfsam.support.RequireUtils;

public class LoadingStatusIndicatorUpdater
implements Consumer<PdfDescriptorLoadingStatus> {
    private Labeled indicator;

    public LoadingStatusIndicatorUpdater(Labeled indicator) {
        RequireUtils.requireNotNull((Object)indicator, (String)"Cannot set loading status on a null indicator");
        this.indicator = indicator;
    }

    @Override
    public void accept(PdfDescriptorLoadingStatus t) {
        FontAwesomeIcon icon = Optional.ofNullable(t).map(PdfDescriptorLoadingStatus::getIcon).orElse(null);
        if (Objects.nonNull(icon)) {
            FontAwesomeIconFactory.get().setIcon(this.indicator, (GlyphIcons)icon, ContentDisplay.CENTER);
        } else {
            this.indicator.setGraphic(null);
        }
        if (t != null && StringUtils.isNotBlank((CharSequence)t.getDescription())) {
            this.indicator.setTooltip(new Tooltip(t.getDescription()));
        } else {
            this.indicator.setTooltip(null);
        }
    }
}

