/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.output;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import org.sejda.io.BufferedCountingChannelWriter;
import org.sejda.io.CountingWritableByteChannel;
import org.sejda.sambox.contentstream.operator.Operator;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSStream;
import org.sejda.sambox.cos.IndirectCOSObjectReference;
import org.sejda.sambox.output.DefaultCOSWriter;

public class ContentStreamWriter
extends DefaultCOSWriter {
    public ContentStreamWriter(CountingWritableByteChannel channel) {
        super(channel);
    }

    public ContentStreamWriter(BufferedCountingChannelWriter writer) {
        super(writer);
    }

    public void writeTokens(List<Object> tokens) throws IOException {
        for (Object token : tokens) {
            if (token instanceof COSBase) {
                ((COSBase)token).accept(this);
                this.writeSpace();
                continue;
            }
            if (token instanceof Operator) {
                this.writeOperator((Operator)token);
                continue;
            }
            throw new IOException("Unsupported type in content stream:" + token);
        }
    }

    public void writeTokens(Operator ... tokens) throws IOException {
        for (Operator token : tokens) {
            this.writeOperator(token);
        }
    }

    public void writeOperator(List<COSBase> operands, Operator operator) throws IOException {
        for (COSBase operand : operands) {
            operand.accept(this);
            this.writeSpace();
        }
        this.writeOperator(operator);
    }

    public void writeContent(byte[] byteArray) throws IOException {
        this.writer().write(byteArray);
    }

    public void writeEOL() throws IOException {
        this.writer().writeEOL();
    }

    public void writeSpace() throws IOException {
        this.writer().write((byte)32);
    }

    private void writeOperator(Operator token) throws IOException {
        this.writer().write(token.getName().getBytes(StandardCharsets.ISO_8859_1));
        if (token.getName().equals("BI")) {
            this.writeEOL();
            COSDictionary imageParams = Optional.ofNullable(token.getImageParameters()).orElseGet(COSDictionary::new);
            for (COSName key : imageParams.keySet()) {
                key.accept(this);
                this.writeSpace();
                COSBase imageParamsDictionaryObject = imageParams.getDictionaryObject(key);
                if (imageParamsDictionaryObject != null) {
                    imageParamsDictionaryObject.accept(this);
                }
                this.writeEOL();
            }
            this.writer().write("ID".getBytes(StandardCharsets.US_ASCII));
            this.writeEOL();
            this.writer().write(token.getImageData());
            this.writeEOL();
            this.writer().write("EI".getBytes(StandardCharsets.US_ASCII));
        }
        this.writeEOL();
    }

    @Override
    public void visit(COSStream value) {
        throw new UnsupportedOperationException("Cannot write a stream inside a stream");
    }

    @Override
    public void visit(IndirectCOSObjectReference value) {
        throw new UnsupportedOperationException("Cannot write an indirect object reference inside a stream");
    }

    @Override
    public void writeComplexObjectSeparator() {
    }
}

