# -*- coding: binary -*-
module Msf::Exploit::Remote::HTTP::Wordpress::URIs

  # Returns the Wordpress Login URL
  #
  # @return [String] Wordpress Login URL
  def wordpress_url_login
    normalize_uri(target_uri.path, 'wp-login.php')
  end

  # Returns the Wordpress Post URL
  #
  # @param post_id [Integer] Post ID
  # @return [String] Wordpress Post URL
  def wordpress_url_post(post_id)
    normalize_uri(target_uri.path, "?p=#{post_id}")
  end

  # Returns the Wordpress Author URL
  #
  # @param author_id [Integer] Author ID
  # @return [String] Wordpress Author URL
  def wordpress_url_author(author_id)
    normalize_uri(target_uri.path, "?author=#{author_id}")
  end

  # Returns the Wordpress RSS feed URL
  #
  # @return [String] Wordpress RSS URL
  def wordpress_url_rss
    normalize_uri(target_uri.path, '?feed=rss2')
  end

  # Returns the Wordpress RDF feed URL
  #
  # @return [String] Wordpress RDF URL
  def wordpress_url_rdf
    normalize_uri(target_uri.path, 'feed/rdf/')
  end

  # Returns the Wordpress ATOM feed URL
  #
  # @return [String] Wordpress ATOM URL
  def wordpress_url_atom
    normalize_uri(target_uri.path, 'feed/atom/')
  end

  # Returns the Wordpress Readme file URL
  #
  # @return [String] Wordpress Readme file URL
  def wordpress_url_readme
    normalize_uri(target_uri.path, 'readme.html')
  end

  # Returns the Wordpress Sitemap URL
  #
  # @return [String] Wordpress Sitemap URL
  def wordpress_url_sitemap
    normalize_uri(target_uri.path, 'sitemap.xml')
  end

  # Returns the Wordpress OPML URL
  #
  # @return [String] Wordpress OPML URL
  def wordpress_url_opml
    normalize_uri(target_uri.path, 'wp-links-opml.php')
  end

  # Returns the Wordpress Backend URL
  #
  # @return [String] Wordpress Backend URL
  def wordpress_url_backend
    normalize_uri(target_uri.path, 'wp-admin/')
  end

  # Returns the Wordpress Admin Ajax URL
  #
  # @return [String] Wordpress Admin Ajax URL
  def wordpress_url_admin_ajax
    normalize_uri(wordpress_url_backend, 'admin-ajax.php')
  end

  # Returns the Wordpress Admin Posts URL
  #
  # @return [String] Wordpress Admin Post URL
  def wordpress_url_admin_post
    normalize_uri(wordpress_url_backend, 'admin-post.php')
  end

  # Returns the Wordpress Admin Update URL
  #
  # @return [String] Wordpress Admin Update URL
  def wordpress_url_admin_update
    normalize_uri(wordpress_url_backend, 'update.php')
  end

  # Returns the Wordpress wp-content dir URL
  #
  # @return [String] Wordpress wp-content dir URL
  def wordpress_url_wp_content
    normalize_uri(target_uri.path, wp_content_dir)
  end

  # Returns the Wordpress plugins dir URL
  #
  # @return [String] Wordpress plugins dir URL
  def wordpress_url_plugins
    normalize_uri(wordpress_url_wp_content, 'plugins')
  end

  # Returns the Wordpress themes dir URL
  #
  # @return [String] Wordpress themes dir URL
  def wordpress_url_themes
    normalize_uri(wordpress_url_wp_content, 'themes')
  end

  # Returns the Wordpress uploads dir URL
  #
  # @return [String] Wordpress uploads dir URL
  def wordpress_url_uploads
    normalize_uri(wordpress_url_wp_content, 'uploads')
  end

  # Returns the Wordpress XMLRPC URL
  #
  # @return [String] Wordpress XMLRPC URL
  def wordpress_url_xmlrpc
    normalize_uri(target_uri.path, 'xmlrpc.php')
  end

  # Returns the Wordpress REST API URL
  #
  # @return [String] Wordpress REST API URL
  def wordpress_url_rest_api
    normalize_uri(target_uri.path, 'index.php/wp-json/wp/v2')
  end

end
