/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Pattern;

public class SocketUtilsIPV6 {
    public static String getIPV6Address(String ip2) {
        return new IPv6Address().fromString(ip2).toString();
    }

    public static String getIPV6NetMask(String ip2) {
        IPv6Network strangeNetwork = new IPv6Network().fromString(ip2);
        return strangeNetwork.getNetmask().asAddress().toString();
    }

    public static class IPv6Network {
        private IPv6NetworkMask networkMask;
        private IPv6Address first;
        private IPv6Address last;
        private IPv6Address address;

        private IPv6Network(IPv6Address address2, IPv6NetworkMask networkMask) {
            this.first = address2.maskWithNetworkMask(networkMask);
            this.last = address2.maximumAddressWithNetworkMask(networkMask);
            this.address = address2.maskWithNetworkMask(networkMask);
            this.networkMask = networkMask;
        }

        private IPv6Network() {
        }

        public IPv6Network fromString(String string2) {
            if (string2.indexOf(47) == -1) {
                throw new IllegalArgumentException("Expected format is network-address/prefix-length");
            }
            String networkAddressString = this.parseNetworkAddress(string2);
            int prefixLength = this.parsePrefixLength(string2);
            IPv6Address networkAddress = new IPv6Address().fromString(networkAddressString);
            return new IPv6Network(networkAddress, new IPv6NetworkMask(prefixLength));
        }

        private String parseNetworkAddress(String string2) {
            return string2.substring(0, string2.indexOf(47));
        }

        private int parsePrefixLength(String string2) {
            try {
                return Integer.parseInt(string2.substring(string2.indexOf(47) + 1));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Prefix length should be a positive integer");
            }
        }

        public IPv6NetworkMask getNetmask() {
            return this.networkMask;
        }
    }

    public static class IPv6NetworkMask {
        private final int prefixLength;

        IPv6NetworkMask(int prefixLength) {
            if (prefixLength < 0 || prefixLength > 128) {
                throw new IllegalArgumentException("prefix length should be in interval [0, 128]");
            }
            this.prefixLength = prefixLength;
        }

        public int asPrefixLength() {
            return this.prefixLength;
        }

        public IPv6Address asAddress() {
            if (this.prefixLength == 128) {
                return new IPv6Address(-1L, -1L);
            }
            if (this.prefixLength == 64) {
                return new IPv6Address(-1L, 0L);
            }
            if (this.prefixLength > 64) {
                int remainingPrefixLength = this.prefixLength - 64;
                return new IPv6Address(-1L, -1L << 64 - remainingPrefixLength);
            }
            return new IPv6Address(-1L << 64 - this.prefixLength, 0L);
        }
    }

    public static class IPv6Address {
        private static final int N_SHORTS = 8;
        private long highBits;
        private long lowBits;

        IPv6Address(long highBits, long lowBits) {
            this.highBits = highBits;
            this.lowBits = lowBits;
        }

        private IPv6Address() {
        }

        public IPv6Address fromString(String string2) {
            if (string2 == null) {
                throw new IllegalArgumentException("can not parse [null]");
            }
            String withoutScope = this.removeScope(string2);
            String withoutIPv4MappedNotation = this.rewriteIPv4MappedNotation(withoutScope);
            String longNotation = this.expandShortNotation(withoutIPv4MappedNotation);
            long[] longs = this.tryParseStringArrayIntoLongArray(string2, longNotation);
            return this.mergeLongArrayIntoIPv6Address(longs);
        }

        public InetAddress toInetAddress() throws UnknownHostException {
            return Inet6Address.getByName(this.toString());
        }

        private IPv6Address mergeLongArrayIntoIPv6Address(long[] longs) {
            long high = 0L;
            long low = 0L;
            for (int i2 = 0; i2 < longs.length; ++i2) {
                if (this.inHighRange(i2)) {
                    high |= longs[i2] << (longs.length - i2 - 1) * 16;
                    continue;
                }
                low |= longs[i2] << (longs.length - i2 - 1) * 16;
            }
            return new IPv6Address(high, low);
        }

        private String rewriteIPv4MappedNotation(String string2) {
            if (!string2.contains(".")) {
                return string2;
            }
            int lastColon = string2.lastIndexOf(":");
            String firstPart = string2.substring(0, lastColon + 1);
            String mappedIPv4Part = string2.substring(lastColon + 1);
            if (mappedIPv4Part.contains(".")) {
                String[] dotSplits = Pattern.compile("\\.").split(mappedIPv4Part);
                if (dotSplits.length != 4) {
                    throw new IllegalArgumentException(String.format("can not parse [%s]", string2));
                }
                StringBuilder rewrittenString = new StringBuilder();
                rewrittenString.append(firstPart);
                int byteZero = Integer.parseInt(dotSplits[0]);
                int byteOne = Integer.parseInt(dotSplits[1]);
                int byteTwo = Integer.parseInt(dotSplits[2]);
                int byteThree = Integer.parseInt(dotSplits[3]);
                rewrittenString.append(String.format("%02x", byteZero));
                rewrittenString.append(String.format("%02x", byteOne));
                rewrittenString.append(":");
                rewrittenString.append(String.format("%02x", byteTwo));
                rewrittenString.append(String.format("%02x", byteThree));
                return rewrittenString.toString();
            }
            throw new IllegalArgumentException(String.format("can not parse [%s]", string2));
        }

        private long[] tryParseStringArrayIntoLongArray(String string2, String longNotation) {
            try {
                return this.parseStringArrayIntoLongArray(longNotation.split(":"));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("can not parse [" + string2 + "]");
            }
        }

        private long[] parseStringArrayIntoLongArray(String[] strings) {
            long[] longs = new long[strings.length];
            for (int i2 = 0; i2 < strings.length; ++i2) {
                longs[i2] = Long.parseLong(strings[i2], 16);
            }
            return longs;
        }

        private String expandShortNotation(String string2) {
            if (!string2.contains("::")) {
                return string2;
            }
            if (string2.equals("::")) {
                return this.generateZeroes(8);
            }
            int numberOfColons = this.countOccurrences(string2, ':');
            if (string2.startsWith("::")) {
                return string2.replace("::", this.generateZeroes(9 - numberOfColons));
            }
            if (string2.endsWith("::")) {
                return string2.replace("::", ":" + this.generateZeroes(9 - numberOfColons));
            }
            return string2.replace("::", ":" + this.generateZeroes(8 - numberOfColons));
        }

        private int countOccurrences(String haystack, char needle) {
            int count2 = 0;
            for (int i2 = 0; i2 < haystack.length(); ++i2) {
                if (haystack.charAt(i2) != needle) continue;
                ++count2;
            }
            return count2;
        }

        private String generateZeroes(int number) {
            StringBuilder builder = new StringBuilder();
            for (int i2 = 0; i2 < number; ++i2) {
                builder.append("0:");
            }
            return builder.toString();
        }

        private String removeScope(String string2) {
            int hasScope = string2.indexOf(37);
            if (hasScope != -1) {
                return string2.substring(0, hasScope);
            }
            return string2;
        }

        public IPv6Address add(int value2) {
            long newLowBits = this.lowBits + (long)value2;
            if (value2 >= 0) {
                if (this.isLessThanUnsigned(newLowBits, this.lowBits)) {
                    return new IPv6Address(this.highBits + 1L, newLowBits);
                }
                return new IPv6Address(this.highBits, newLowBits);
            }
            if (this.isLessThanUnsigned(this.lowBits, newLowBits)) {
                return new IPv6Address(this.highBits - 1L, newLowBits);
            }
            return new IPv6Address(this.highBits, newLowBits);
        }

        public IPv6Address subtract(int value2) {
            long newLowBits = this.lowBits - (long)value2;
            if (value2 >= 0) {
                if (this.isLessThanUnsigned(this.lowBits, newLowBits)) {
                    return new IPv6Address(this.highBits - 1L, newLowBits);
                }
                return new IPv6Address(this.highBits, newLowBits);
            }
            if (this.isLessThanUnsigned(newLowBits, this.lowBits)) {
                return new IPv6Address(this.highBits + 1L, newLowBits);
            }
            return new IPv6Address(this.highBits, newLowBits);
        }

        private boolean isLessThanUnsigned(long a, long b2) {
            return a < b2 ^ a < 0L != b2 < 0L;
        }

        public IPv6Address maskWithNetworkMask(IPv6NetworkMask networkMask) {
            if (networkMask.asPrefixLength() == 128) {
                return this;
            }
            if (networkMask.asPrefixLength() == 64) {
                return new IPv6Address(this.highBits, 0L);
            }
            if (networkMask.asPrefixLength() == 0) {
                return new IPv6Address(0L, 0L);
            }
            if (networkMask.asPrefixLength() > 64) {
                int remainingPrefixLength = networkMask.asPrefixLength() - 64;
                return new IPv6Address(this.highBits, this.lowBits & -1L << 64 - remainingPrefixLength);
            }
            return new IPv6Address(this.highBits & -1L << 64 - networkMask.asPrefixLength(), 0L);
        }

        public IPv6Address maximumAddressWithNetworkMask(IPv6NetworkMask networkMask) {
            if (networkMask.asPrefixLength() == 128) {
                return this;
            }
            if (networkMask.asPrefixLength() == 64) {
                return new IPv6Address(this.highBits, -1L);
            }
            if (networkMask.asPrefixLength() > 64) {
                int remainingPrefixLength = networkMask.asPrefixLength() - 64;
                return new IPv6Address(this.highBits, this.lowBits | -1L >>> remainingPrefixLength);
            }
            return new IPv6Address(this.highBits | -1L >>> networkMask.asPrefixLength(), -1L);
        }

        public boolean isIPv4Mapped() {
            return this.highBits == 0L && (this.lowBits & 0xFFFF000000000000L) == 0L && (this.lowBits & 0xFFFF00000000L) == 0xFFFF00000000L;
        }

        public String toString() {
            if (this.isIPv4Mapped()) {
                return this.toIPv4MappedAddressString();
            }
            return this.toShortHandNotationString();
        }

        private String toIPv4MappedAddressString() {
            int byteZero = (int)((this.lowBits & 0xFF000000L) >> 24);
            int byteOne = (int)((this.lowBits & 0xFF0000L) >> 16);
            int byteTwo = (int)((this.lowBits & 0xFF00L) >> 8);
            int byteThree = (int)(this.lowBits & 0xFFL);
            StringBuilder result2 = new StringBuilder("::ffff:");
            result2.append(byteZero).append(".").append(byteOne).append(".").append(byteTwo).append(".").append(byteThree);
            return result2.toString();
        }

        private String toShortHandNotationString() {
            String[] strings = this.toArrayOfShortStrings();
            StringBuilder result2 = new StringBuilder();
            int[] shortHandNotationPositionAndLength = this.startAndLengthOfLongestRunOfZeroes();
            int shortHandNotationPosition = shortHandNotationPositionAndLength[0];
            int shortHandNotationLength = shortHandNotationPositionAndLength[1];
            boolean useShortHandNotation = shortHandNotationLength > 1;
            for (int i2 = 0; i2 < strings.length; ++i2) {
                if (useShortHandNotation && i2 == shortHandNotationPosition) {
                    if (i2 == 0) {
                        result2.append("::");
                        continue;
                    }
                    result2.append(":");
                    continue;
                }
                if (i2 > shortHandNotationPosition && i2 < shortHandNotationPosition + shortHandNotationLength) continue;
                result2.append(strings[i2]);
                if (i2 >= 7) continue;
                result2.append(":");
            }
            return result2.toString().toLowerCase();
        }

        private String[] toArrayOfShortStrings() {
            short[] shorts = this.toShortArray();
            String[] strings = new String[shorts.length];
            for (int i2 = 0; i2 < shorts.length; ++i2) {
                strings[i2] = String.format("%x", shorts[i2]);
            }
            return strings;
        }

        private short[] toShortArray() {
            short[] shorts = new short[8];
            for (int i2 = 0; i2 < 8; ++i2) {
                shorts[i2] = this.inHighRange(i2) ? (short)(this.highBits << i2 * 16 >>> 112 & 0xFFFFL) : (short)(this.lowBits << i2 * 16 >>> 112 & 0xFFFFL);
            }
            return shorts;
        }

        private boolean inHighRange(int shortNumber) {
            return shortNumber >= 0 && shortNumber < 4;
        }

        int[] startAndLengthOfLongestRunOfZeroes() {
            int longestConsecutiveZeroes = 0;
            int longestConsecutiveZeroesPos = -1;
            short[] shorts = this.toShortArray();
            for (int pos2 = 0; pos2 < shorts.length; ++pos2) {
                int consecutiveZeroesAtCurrentPos = this.countConsecutiveZeroes(shorts, pos2);
                if (consecutiveZeroesAtCurrentPos <= longestConsecutiveZeroes) continue;
                longestConsecutiveZeroes = consecutiveZeroesAtCurrentPos;
                longestConsecutiveZeroesPos = pos2;
            }
            return new int[]{longestConsecutiveZeroesPos, longestConsecutiveZeroes};
        }

        private int countConsecutiveZeroes(short[] shorts, int offset2) {
            int count2 = 0;
            for (int i2 = offset2; i2 < shorts.length && shorts[i2] == 0; ++i2) {
                ++count2;
            }
            return count2;
        }

        public long getHighBits() {
            return this.highBits;
        }

        public long getLowBits() {
            return this.lowBits;
        }

        public int numberOfTrailingZeroes() {
            return this.lowBits == 0L ? Long.numberOfTrailingZeros(this.highBits) + 64 : Long.numberOfTrailingZeros(this.lowBits);
        }

        public int numberOfTrailingOnes() {
            IPv6Address plusOne = this.add(1);
            return plusOne.getLowBits() == 0L ? Long.numberOfTrailingZeros(plusOne.getHighBits()) + 64 : Long.numberOfTrailingZeros(plusOne.getLowBits());
        }

        public int numberOfLeadingZeroes() {
            return this.highBits == 0L ? Long.numberOfLeadingZeros(this.lowBits) + 64 : Long.numberOfLeadingZeros(this.highBits);
        }

        public int numberOfLeadingOnes() {
            IPv6Address flipped = new IPv6Address(this.highBits ^ 0xFFFFFFFFFFFFFFFFL, this.lowBits ^ 0xFFFFFFFFFFFFFFFFL);
            return flipped.numberOfLeadingZeroes();
        }
    }
}

