/*
 * Decompiled with CFR 0.152.
 */
package org.jbibtex;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

public class CharacterFilterReader
extends FilterReader {
    public CharacterFilterReader(Reader reader) {
        super(reader);
    }

    protected boolean accept(char c) {
        if (c == '\t' || c == '\n' || c == '\f' || c == '\r' || c == ' ') {
            return true;
        }
        if (c >= '!' && c <= '\u007f') {
            return true;
        }
        if (c >= '\u00c0' && c <= '\u00d6' || c >= '\u00d8' && c <= '\u00f6' || c >= '\u00f8' && c <= '\u00ff') {
            return true;
        }
        return c >= '\u0100' && c <= '\u1fff' || c == '\u20ac' || c == '\u2122';
    }

    @Override
    public int read() throws IOException {
        int result;
        do {
            if ((result = super.read()) >= 0) continue;
            return -1;
        } while (!this.accept((char)result));
        return result;
    }

    @Override
    public int read(char[] buffer, int offset, int length) throws IOException {
        int count = super.read(buffer, offset, length);
        if (count < 0) {
            return -1;
        }
        int readOffset = offset;
        int writeOffset = offset;
        for (int i = 0; i < count; ++i) {
            char c = buffer[readOffset];
            ++readOffset;
            if (!this.accept(c)) continue;
            buffer[writeOffset] = c;
            ++writeOffset;
        }
        return count - (readOffset - writeOffset);
    }
}

