/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirNamedFunction;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirVariable;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0013\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0013\u001a\u00020\u0005J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0015\u001a\u00020\bJ\u0010\u0010\u0016\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0017\u001a\u00020\u000bJ\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0019\u001a\u00020\u000eJ\u0016\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0006J\u0016\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\tJ\u0016\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\fJ\u0016\u0010!\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u000fR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/fir/backend/Fir2IrCallableCache;", "", "()V", "localClassCache", "", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "localFunctionCache", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "parameterCache", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "variableCache", "Lorg/jetbrains/kotlin/fir/expressions/FirVariable;", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "clear", "", "getLocalClass", "localClass", "getLocalFunction", "localFunction", "getParameter", "parameter", "getVariable", "variable", "putLocalClass", "irClass", "putLocalFunction", "irFunction", "putParameter", "firParameter", "irParameter", "putVariable", "firVariable", "irVariable", "fir2ir"})
public final class Fir2IrCallableCache {
    private final Map<FirValueParameter, IrValueParameter> parameterCache;
    private final Map<FirVariable, IrVariable> variableCache;
    private final Map<FirClass, IrClass> localClassCache;
    private final Map<FirFunction, IrSimpleFunction> localFunctionCache;

    @Nullable
    public final IrValueParameter getParameter(@NotNull FirValueParameter parameter2) {
        Intrinsics.checkParameterIsNotNull((Object)parameter2, (String)"parameter");
        return this.parameterCache.get(parameter2);
    }

    public final void putParameter(@NotNull FirValueParameter firParameter, @NotNull IrValueParameter irParameter2) {
        Intrinsics.checkParameterIsNotNull((Object)firParameter, (String)"firParameter");
        Intrinsics.checkParameterIsNotNull((Object)irParameter2, (String)"irParameter");
        this.parameterCache.put(firParameter, irParameter2);
    }

    @Nullable
    public final IrVariable getVariable(@NotNull FirVariable variable2) {
        Intrinsics.checkParameterIsNotNull((Object)variable2, (String)"variable");
        return this.variableCache.get(variable2);
    }

    public final void putVariable(@NotNull FirVariable firVariable, @NotNull IrVariable irVariable2) {
        Intrinsics.checkParameterIsNotNull((Object)firVariable, (String)"firVariable");
        Intrinsics.checkParameterIsNotNull((Object)irVariable2, (String)"irVariable");
        this.variableCache.put(firVariable, irVariable2);
    }

    @Nullable
    public final IrClass getLocalClass(@NotNull FirClass localClass) {
        Intrinsics.checkParameterIsNotNull((Object)localClass, (String)"localClass");
        return this.localClassCache.get(localClass);
    }

    public final void putLocalClass(@NotNull FirClass localClass, @NotNull IrClass irClass) {
        Intrinsics.checkParameterIsNotNull((Object)localClass, (String)"localClass");
        Intrinsics.checkParameterIsNotNull((Object)irClass, (String)"irClass");
        boolean bl = !(localClass instanceof FirRegularClass) || Intrinsics.areEqual((Object)((FirRegularClass)localClass).getVisibility(), (Object)Visibilities.LOCAL);
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.localClassCache.put(localClass, irClass);
    }

    @Nullable
    public final IrSimpleFunction getLocalFunction(@NotNull FirFunction localFunction) {
        Intrinsics.checkParameterIsNotNull((Object)localFunction, (String)"localFunction");
        return this.localFunctionCache.get(localFunction);
    }

    public final void putLocalFunction(@NotNull FirFunction localFunction, @NotNull IrSimpleFunction irFunction) {
        Intrinsics.checkParameterIsNotNull((Object)localFunction, (String)"localFunction");
        Intrinsics.checkParameterIsNotNull((Object)irFunction, (String)"irFunction");
        boolean bl = !(localFunction instanceof FirNamedFunction) || Intrinsics.areEqual((Object)((FirNamedFunction)localFunction).getVisibility(), (Object)Visibilities.LOCAL);
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.localFunctionCache.put(localFunction, irFunction);
    }

    public final void clear() {
        this.parameterCache.clear();
        this.variableCache.clear();
        this.localClassCache.clear();
        this.localFunctionCache.clear();
    }

    public Fir2IrCallableCache() {
        Map map2;
        Fir2IrCallableCache fir2IrCallableCache = this;
        boolean bl = false;
        fir2IrCallableCache.parameterCache = map2 = (Map)new LinkedHashMap();
        fir2IrCallableCache = this;
        bl = false;
        fir2IrCallableCache.variableCache = map2 = (Map)new LinkedHashMap();
        fir2IrCallableCache = this;
        bl = false;
        fir2IrCallableCache.localClassCache = map2 = (Map)new LinkedHashMap();
        fir2IrCallableCache = this;
        bl = false;
        fir2IrCallableCache.localFunctionCache = map2 = (Map)new LinkedHashMap();
    }
}

