/*
 * Decompiled with CFR 0.152.
 */
package groovy.xml.dom;

import java.io.OutputStream;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Element;

public class DOMUtil {
    public static String serialize(Element element) {
        StringWriter sw = new StringWriter();
        DOMUtil.serialize(element, new StreamResult(sw));
        return sw.toString();
    }

    public static void serialize(Element element, OutputStream os) {
        DOMUtil.serialize(element, new StreamResult(os));
    }

    private static void serialize(Element element, StreamResult outputTarget) {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        StringWriter sw = new StringWriter();
        try {
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(new DOMSource(element), outputTarget);
        }
        catch (TransformerException e) {
            // empty catch block
        }
    }
}

