/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.ui.editor;

import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.php.composer.ui.editor.ComposerFormPage;
import org.eclipse.php.composer.ui.editor.ComposerSection;
import org.eclipse.php.composer.ui.editor.FormLayoutFactory;
import org.eclipse.php.composer.ui.parts.StructuredViewerPart;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class StructuredViewerSection
extends ComposerSection {
    protected StructuredViewerPart viewerPart;
    private boolean doSelection;

    public StructuredViewerSection(ComposerFormPage formPage, Composite parent, int style, String[] buttonLabels) {
        this(formPage, parent, style, true, buttonLabels);
    }

    public StructuredViewerSection(ComposerFormPage formPage, Composite parent, int style, boolean titleBar, String[] buttonLabels) {
        super(formPage, parent, style, titleBar);
        this.viewerPart = this.createViewerPart(buttonLabels);
        this.viewerPart.setMinimumSize(50, 50);
        FormToolkit toolkit = formPage.getManagedForm().getToolkit();
        this.createClient(this.getSection(), toolkit);
        this.doSelection = true;
    }

    protected void createViewerPartControl(Composite parent, int style, int span, FormToolkit toolkit) {
        this.viewerPart.createControl(parent, style, span, toolkit);
        MenuManager popupMenuManager = new MenuManager();
        IMenuListener listener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager mng) {
                StructuredViewerSection.this.fillContextMenu(mng);
            }
        };
        popupMenuManager.addMenuListener(listener);
        popupMenuManager.setRemoveAllWhenShown(true);
        Control control = this.viewerPart.getControl();
        Menu menu = popupMenuManager.createContextMenu(control);
        control.setMenu(menu);
        this.registerPopupMenu(popupMenuManager);
    }

    protected void registerPopupMenu(MenuManager popupMenuManager) {
    }

    protected Composite createClientContainer(Composite parent, int span, FormToolkit toolkit) {
        Composite container = toolkit.createComposite(parent);
        container.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, span));
        return container;
    }

    protected abstract StructuredViewerPart createViewerPart(String[] var1);

    protected void fillContextMenu(IMenuManager manager) {
    }

    protected void buttonSelected(int index) {
    }

    protected ISelection getViewerSelection() {
        return this.viewerPart.getViewer().getSelection();
    }

    protected void doPaste(Object targetObject, Object[] sourceObjects) {
    }

    protected boolean canPaste(Object targetObject, Object[] sourceObjects) {
        return false;
    }

    public void setFocus() {
        this.viewerPart.getControl().setFocus();
    }

    public StructuredViewerPart getStructuredViewerPart() {
        return this.viewerPart;
    }

    protected int getNewSelectionIndex(int thisIndex, int length) {
        if (thisIndex == length - 1) {
            return thisIndex - 1;
        }
        return thisIndex + 1;
    }

    protected int getArrayIndex(Object[] array, Object object) {
        int i = 0;
        while (i < array.length) {
            if (array[i].equals(object)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected void doSelect(boolean select) {
        this.doSelection = select;
    }

    protected boolean canSelect() {
        return this.doSelection;
    }
}

