/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import com.sun.jdi.InvocationException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.debug.core.IEvaluationRunnable;
import org.eclipse.jdt.debug.core.IJavaArray;
import org.eclipse.jdt.debug.core.IJavaArrayType;
import org.eclipse.jdt.debug.core.IJavaClassType;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaInterfaceType;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaPrimitiveValue;
import org.eclipse.jdt.debug.core.IJavaReferenceType;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.eval.IAstEvaluationEngine;
import org.eclipse.jdt.debug.eval.ICompiledExpression;
import org.eclipse.jdt.debug.eval.IEvaluationListener;
import org.eclipse.jdt.debug.eval.IEvaluationResult;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.core.JavaDebugUtils;
import org.eclipse.jdt.internal.debug.core.logicalstructures.JDIAllInstancesValue;
import org.eclipse.jdt.internal.debug.core.model.JDINullValue;
import org.eclipse.jdt.internal.debug.core.model.JDIReferenceListValue;
import org.eclipse.jdt.internal.debug.ui.DebugUIMessages;
import org.eclipse.jdt.internal.debug.ui.DetailFormatter;
import org.eclipse.jdt.internal.debug.ui.IJDIPreferencesConstants;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JavaDebugOptionsManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;

public class JavaDetailFormattersManager
implements IPropertyChangeListener,
IDebugEventSetListener,
ILaunchesListener {
    private static JavaDetailFormattersManager fgDefault;
    private HashMap<String, DetailFormatter> fDetailFormattersMap;
    private HashMap<Key, Expression> fCacheMap;

    public static JavaDetailFormattersManager getDefault() {
        if (fgDefault == null) {
            fgDefault = new JavaDetailFormattersManager();
        }
        return fgDefault;
    }

    private JavaDetailFormattersManager() {
        this.populateDetailFormattersMap();
        JDIDebugUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        DebugUITools.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.fCacheMap = new HashMap();
    }

    private void populateDetailFormattersMap() {
        String[] detailFormattersList = JavaDebugOptionsManager.parseList(JDIDebugUIPlugin.getDefault().getPreferenceStore().getString(IJDIPreferencesConstants.PREF_DETAIL_FORMATTERS_LIST));
        this.fDetailFormattersMap = new HashMap(detailFormattersList.length / 3);
        int i = 0;
        int length = detailFormattersList.length;
        while (i < length) {
            String typeName = detailFormattersList[i++];
            String snippet = detailFormattersList[i++].replace('\u0000', ',');
            boolean enabled = !"0".equals(detailFormattersList[i++]);
            this.fDetailFormattersMap.put(typeName, new DetailFormatter(typeName, snippet, enabled));
        }
    }

    public void computeValueDetail(final IJavaValue objectValue, final IJavaThread thread, final IValueDetailListener listener) {
        thread.queueRunnable(new Runnable(){

            @Override
            public void run() {
                JavaDetailFormattersManager.this.resolveFormatter(objectValue, thread, listener);
            }
        });
    }

    private void resolveFormatter(IJavaValue value, IJavaThread thread, IValueDetailListener listener) {
        EvaluationListener evaluationListener = new EvaluationListener(value, thread, listener);
        if (value instanceof IJavaObject) {
            IJavaObject objectValue = (IJavaObject)value;
            try {
                if (value instanceof JDIAllInstancesValue) {
                    listener.detailComputed((IValue)value, ((JDIAllInstancesValue)value).getDetailString());
                    return;
                }
                if (value instanceof JDIReferenceListValue) {
                    listener.detailComputed((IValue)value, ((JDIReferenceListValue)value).getDetailString());
                    return;
                }
                IJavaDebugTarget debugTarget = (IJavaDebugTarget)thread.getDebugTarget();
                Expression expression = this.getCompiledExpression(objectValue, debugTarget, thread);
                if (expression != null) {
                    expression.getEngine().evaluateExpression(expression.getExpression(), objectValue, thread, (IEvaluationListener)evaluationListener, 128, false);
                    return;
                }
            }
            catch (CoreException e) {
                listener.detailComputed((IValue)value, e.toString());
                return;
            }
        }
        try {
            evaluationListener.valueToString(value);
        }
        catch (DebugException e) {
            String detail = e.getStatus().getMessage();
            if (e.getStatus().getException() instanceof UnsupportedOperationException) {
                detail = DebugUIMessages.JavaDetailFormattersManager_7;
            } else if (e.getStatus().getCode() == 102) {
                detail = DebugUIMessages.JavaDetailFormattersManager_6;
            }
            listener.detailComputed((IValue)value, detail);
        }
    }

    private IJavaProject getJavaProject(IJavaObject javaValue, IJavaThread thread) throws CoreException {
        IType type = null;
        if (javaValue instanceof IJavaArray) {
            IJavaArrayType arrType = (IJavaArrayType)javaValue.getJavaType();
            IJavaType compType = arrType.getComponentType();
            while (compType instanceof IJavaArrayType) {
                compType = ((IJavaArrayType)compType).getComponentType();
            }
            type = JavaDebugUtils.resolveType((IJavaType)compType);
        } else {
            type = JavaDebugUtils.resolveType((IJavaValue)javaValue);
        }
        if (type != null) {
            return type.getJavaProject();
        }
        IJavaStackFrame stackFrame = null;
        IJavaDebugTarget target = (IJavaDebugTarget)javaValue.getDebugTarget().getAdapter(IJavaDebugTarget.class);
        if (target != null && (stackFrame = (IJavaStackFrame)thread.getTopStackFrame()) != null && !stackFrame.getDebugTarget().equals(target)) {
            stackFrame = null;
        }
        if (stackFrame == null) {
            return null;
        }
        return JavaDebugUtils.resolveJavaProject((IJavaStackFrame)stackFrame);
    }

    public DetailFormatter getDetailFormatterFromInterface(IJavaClassType type) {
        try {
            IJavaInterfaceType[] inter = type.getAllInterfaces();
            DetailFormatter formatter = null;
            int i = 0;
            while (i < inter.length) {
                formatter = this.fDetailFormattersMap.get(inter[i].getName());
                if (formatter != null) {
                    return formatter;
                }
                ++i;
            }
            return null;
        }
        catch (DebugException debugException) {
            return null;
        }
    }

    public boolean hasInterfaceDetailFormatter(IJavaType type) {
        if (type instanceof IJavaClassType) {
            return this.getDetailFormatterFromInterface((IJavaClassType)type) != null;
        }
        return false;
    }

    public DetailFormatter getDetailFormatterFromSuperclass(IJavaClassType type) {
        block4: {
            try {
                if (type != null) break block4;
                return null;
            }
            catch (DebugException debugException) {
                return null;
            }
        }
        DetailFormatter formatter = this.fDetailFormattersMap.get(type.getName());
        if (formatter != null && formatter.isEnabled()) {
            return formatter;
        }
        return this.getDetailFormatterFromSuperclass(type.getSuperclass());
    }

    public boolean hasSuperclassDetailFormatter(IJavaType type) {
        if (type instanceof IJavaClassType) {
            return this.getDetailFormatterFromSuperclass((IJavaClassType)type) != null;
        }
        return false;
    }

    public boolean hasAssociatedDetailFormatter(IJavaType type) {
        return this.getAssociatedDetailFormatter(type) != null;
    }

    public DetailFormatter getAssociatedDetailFormatter(IJavaType type) {
        String typeName;
        block4: {
            typeName = "";
            try {
                while (type instanceof IJavaArrayType) {
                    type = ((IJavaArrayType)type).getComponentType();
                }
                if (type instanceof IJavaClassType) {
                    typeName = type.getName();
                    break block4;
                }
                return null;
            }
            catch (DebugException debugException) {
                return null;
            }
        }
        return this.fDetailFormattersMap.get(typeName);
    }

    public void setAssociatedDetailFormatter(DetailFormatter detailFormatter) {
        this.fDetailFormattersMap.put(detailFormatter.getTypeName(), detailFormatter);
        this.savePreference();
    }

    private void savePreference() {
        Collection<DetailFormatter> valuesList = this.fDetailFormattersMap.values();
        String[] values = new String[valuesList.size() * 3];
        int i = 0;
        for (DetailFormatter detailFormatter : valuesList) {
            values[i++] = detailFormatter.getTypeName();
            values[i++] = detailFormatter.getSnippet().replace(',', '\u0000');
            String string = values[i++] = detailFormatter.isEnabled() ? "1" : "0";
        }
        String pref = JavaDebugOptionsManager.serializeList(values);
        JDIDebugUIPlugin.getDefault().getPreferenceStore().setValue(IJDIPreferencesConstants.PREF_DETAIL_FORMATTERS_LIST, pref);
    }

    private String getDetailFormatter(IJavaClassType type) throws DebugException {
        String snippet = this.getDetailFormatterSuperClass(type);
        if (snippet != null) {
            return snippet;
        }
        IJavaInterfaceType[] allInterfaces = type.getAllInterfaces();
        int i = 0;
        while (i < allInterfaces.length) {
            DetailFormatter detailFormatter = this.fDetailFormattersMap.get(allInterfaces[i].getName());
            if (detailFormatter != null && detailFormatter.isEnabled()) {
                return detailFormatter.getSnippet();
            }
            ++i;
        }
        return null;
    }

    private String getDetailFormatterSuperClass(IJavaClassType type) throws DebugException {
        if (type == null) {
            return null;
        }
        DetailFormatter detailFormatter = this.fDetailFormattersMap.get(type.getName());
        if (detailFormatter != null && detailFormatter.isEnabled()) {
            return detailFormatter.getSnippet();
        }
        return this.getDetailFormatterSuperClass(type.getSuperclass());
    }

    private Expression getCompiledExpression(IJavaObject javaObject, IJavaDebugTarget debugTarget, IJavaThread thread) throws CoreException {
        IAstEvaluationEngine evaluationEngine;
        ICompiledExpression res;
        IJavaProject project;
        IJavaType type = javaObject.getJavaType();
        if (type == null) {
            return null;
        }
        String typeName = type.getName();
        Key key = new Key(typeName, debugTarget);
        if (this.fCacheMap.containsKey(key)) {
            return this.fCacheMap.get(key);
        }
        String snippet = null;
        if (type instanceof IJavaClassType) {
            snippet = this.getDetailFormatter((IJavaClassType)type);
        }
        if (type instanceof IJavaArrayType && JavaCore.compareJavaVersions((String)debugTarget.getVersion(), (String)"9") < 0) {
            snippet = this.getArraySnippet((IJavaArray)javaObject);
        }
        if (snippet != null && (project = this.getJavaProject(javaObject, thread)) != null && (res = (evaluationEngine = JDIDebugPlugin.getDefault().getEvaluationEngine(project, debugTarget)).getCompiledExpression(snippet, javaObject)) != null) {
            Expression exp = new Expression(res, evaluationEngine);
            this.fCacheMap.put(key, exp);
            return exp;
        }
        return null;
    }

    protected String getArraySnippet(IJavaArray value) throws DebugException {
        String sig;
        String signature = value.getSignature();
        int nesting = Signature.getArrayCount((String)signature);
        if (nesting > 1 && ((sig = Signature.getElementType((String)signature)).length() == 1 || "Ljava/lang/String;".equals(sig))) {
            return null;
        }
        if (((IJavaArrayType)value.getJavaType()).getComponentType() instanceof IJavaReferenceType) {
            int maxEntries;
            int length = value.getLength();
            int maxLength = JavaDetailFormattersManager.getMaxDetailLength();
            if (maxLength > 0 && length > (maxEntries = maxLength / 3 + 1)) {
                StringBuilder snippet = new StringBuilder();
                snippet.append("Object[] shorter = new Object[");
                snippet.append(maxEntries);
                snippet.append("]; System.arraycopy(this, 0, shorter, 0, ");
                snippet.append(maxEntries);
                snippet.append("); ");
                snippet.append("return java.util.Arrays.asList(shorter).toString();");
                return snippet.toString();
            }
            return "java.util.Arrays.asList(this).toString()";
        }
        return null;
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property.equals(IJDIPreferencesConstants.PREF_DETAIL_FORMATTERS_LIST) || property.equals(IJDIPreferencesConstants.PREF_SHOW_DETAILS) || property.equals("org.eclipse.debug.ui.max_detail_length")) {
            IJavaStackFrame frame;
            this.populateDetailFormattersMap();
            this.fCacheMap.clear();
            IAdaptable selected = DebugUITools.getDebugContext();
            if (selected != null && (frame = (IJavaStackFrame)selected.getAdapter(IJavaStackFrame.class)) != null) {
                DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)frame, 16)});
            }
        }
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            if (event.getSource() instanceof IJavaDebugTarget && event.getKind() == 8) {
                this.deleteCacheForTarget((IJavaDebugTarget)event.getSource());
            }
            ++i;
        }
    }

    public void launchesAdded(ILaunch[] launches) {
    }

    public void launchesChanged(ILaunch[] launches) {
    }

    public void launchesRemoved(ILaunch[] launches) {
        int i = 0;
        while (i < launches.length) {
            ILaunch launch = launches[i];
            IDebugTarget[] debugTargets = launch.getDebugTargets();
            int j = 0;
            while (j < debugTargets.length) {
                if (debugTargets[j] instanceof IJavaDebugTarget) {
                    this.deleteCacheForTarget((IJavaDebugTarget)debugTargets[j]);
                }
                ++j;
            }
            ++i;
        }
    }

    private synchronized void deleteCacheForTarget(IJavaDebugTarget debugTarget) {
        Iterator<Key> iter = this.fCacheMap.keySet().iterator();
        while (iter.hasNext()) {
            Key key = iter.next();
            if (key.fDebugTarget != debugTarget) continue;
            iter.remove();
        }
    }

    public void removeAssociatedDetailFormatter(DetailFormatter detailFormatter) {
        this.fDetailFormattersMap.remove(detailFormatter.getTypeName());
        this.savePreference();
    }

    private static int getMaxDetailLength() {
        return DebugUITools.getPreferenceStore().getInt("org.eclipse.debug.ui.max_detail_length");
    }

    private static class EvaluationListener
    implements IEvaluationListener {
        private static final String fgToString = "toString";
        private static final String fgToStringSignature = "()Ljava/lang/String;";
        private static final String STRING_SIGNATURE = "Ljava/lang/String;";
        private IJavaValue fValue;
        private IValueDetailListener fListener;
        private IJavaThread fThread;

        public EvaluationListener(IJavaValue value, IJavaThread thread, IValueDetailListener listener) {
            this.fValue = value;
            this.fThread = thread;
            this.fListener = listener;
        }

        public void evaluationComplete(IEvaluationResult result) {
            if (result.hasErrors()) {
                StringBuilder error = new StringBuilder(DebugUIMessages.JavaDetailFormattersManager_Detail_formatter_error___1);
                DebugException exception = result.getException();
                if (exception != null) {
                    Throwable throwable = exception.getStatus().getException();
                    error.append("\n\t\t");
                    if (throwable instanceof InvocationException) {
                        error.append(NLS.bind((String)DebugUIMessages.JavaDetailFormattersManager_An_exception_occurred___0__3, (Object[])new String[]{((InvocationException)throwable).exception().referenceType().name()}));
                    } else if (throwable instanceof UnsupportedOperationException) {
                        error = new StringBuilder();
                        error.append(DebugUIMessages.JavaDetailFormattersManager_7);
                    } else {
                        error.append(exception.getStatus().getMessage());
                    }
                } else {
                    String[] errors = result.getErrorMessages();
                    int i = 0;
                    int length = errors.length;
                    while (i < length) {
                        error.append("\n\t\t").append(errors[i]);
                        ++i;
                    }
                }
                this.fListener.detailComputed((IValue)this.fValue, error.toString());
            } else {
                try {
                    this.valueToString(result.getValue());
                }
                catch (DebugException e) {
                    this.fListener.detailComputed((IValue)this.fValue, e.getStatus().getMessage());
                }
            }
        }

        public void valueToString(final IJavaValue objectValue) throws DebugException {
            String nonEvalResult = null;
            StringBuilder result = null;
            if (objectValue.getSignature() == null) {
                nonEvalResult = DebugUIMessages.JavaDetailFormattersManager_null;
            } else if (objectValue instanceof IJavaPrimitiveValue) {
                result = new StringBuilder();
                this.appendJDIPrimitiveValueString(result, objectValue);
            } else if (this.fThread == null || !this.fThread.isSuspended()) {
                result = new StringBuilder();
                result.append(DebugUIMessages.JavaDetailFormattersManager_no_suspended_threads);
                this.appendJDIValueString(result, objectValue);
            } else if (objectValue instanceof IJavaObject && STRING_SIGNATURE.equals(objectValue.getSignature())) {
                result = new StringBuilder();
                this.appendJDIValueString(result, objectValue);
            }
            if (result != null) {
                nonEvalResult = result.toString();
            }
            if (nonEvalResult != null) {
                this.fListener.detailComputed((IValue)this.fValue, nonEvalResult);
                return;
            }
            IEvaluationRunnable eval = new IEvaluationRunnable(){

                public void run(IJavaThread thread, IProgressMonitor monitor) throws DebugException {
                    StringBuilder buf = new StringBuilder();
                    if (objectValue instanceof IJavaArray) {
                        this.appendArrayDetail(buf, (IJavaArray)objectValue);
                    } else if (objectValue instanceof IJavaObject) {
                        this.appendObjectDetail(buf, (IJavaObject)objectValue);
                    } else {
                        this.appendJDIValueString(buf, objectValue);
                    }
                    fListener.detailComputed((IValue)fValue, buf.toString());
                }
            };
            this.fThread.runEvaluation(eval, null, 128, false);
        }

        protected void appendArrayDetail(StringBuilder result, IJavaArray arrayValue) throws DebugException {
            result.append('[');
            boolean partial = false;
            IJavaValue[] arrayValues = null;
            int maxLength = JavaDetailFormattersManager.getMaxDetailLength();
            int maxEntries = maxLength / 3 + 1;
            int length = -1;
            try {
                length = arrayValue.getLength();
                if (maxLength > 0 && length > maxEntries) {
                    partial = true;
                    IVariable[] variables = arrayValue.getVariables(0, maxEntries);
                    arrayValues = new IJavaValue[variables.length];
                    int i = 0;
                    while (i < variables.length) {
                        arrayValues[i] = (IJavaValue)variables[i].getValue();
                        ++i;
                    }
                } else {
                    arrayValues = arrayValue.getValues();
                }
            }
            catch (DebugException de) {
                JDIDebugUIPlugin.log(de);
                result.append(de.getStatus().getMessage());
                return;
            }
            int i = 0;
            while (i < arrayValues.length) {
                IJavaValue value = arrayValues[i];
                if (value instanceof IJavaArray) {
                    this.appendArrayDetail(result, (IJavaArray)value);
                } else if (value instanceof IJavaObject) {
                    this.appendObjectDetail(result, (IJavaObject)value);
                } else {
                    this.appendJDIValueString(result, value);
                }
                if (i < arrayValues.length - 1) {
                    result.append(',');
                    result.append(' ');
                }
                if (partial && result.length() > maxLength) break;
                ++i;
            }
            if (!partial) {
                result.append(']');
            }
        }

        protected void appendJDIPrimitiveValueString(StringBuilder result, IJavaValue value) throws DebugException {
            result.append(value.getValueString());
        }

        protected void appendJDIValueString(StringBuilder result, IJavaValue value) throws DebugException {
            result.append(value.getValueString());
        }

        protected void appendObjectDetail(StringBuilder result, IJavaObject objectValue) throws DebugException {
            if (objectValue instanceof JDINullValue) {
                this.appendJDIValueString(result, (IJavaValue)objectValue);
                return;
            }
            if (STRING_SIGNATURE.equals(objectValue.getSignature())) {
                this.appendJDIValueString(result, (IJavaValue)objectValue);
            } else {
                IJavaValue toStringValue = objectValue.sendMessage(fgToString, fgToStringSignature, null, this.fThread, false);
                if (toStringValue == null) {
                    result.append(DebugUIMessages.JavaDetailFormattersManager__unknown_);
                } else {
                    this.appendJDIValueString(result, toStringValue);
                }
            }
        }
    }

    private static class Expression {
        private ICompiledExpression fExpression;
        private IAstEvaluationEngine fEngine;

        Expression(ICompiledExpression expression, IAstEvaluationEngine engine) {
            this.fExpression = expression;
            this.fEngine = engine;
        }

        public ICompiledExpression getExpression() {
            return this.fExpression;
        }

        public IAstEvaluationEngine getEngine() {
            return this.fEngine;
        }
    }

    private static class Key {
        private String fTypeName;
        private IJavaDebugTarget fDebugTarget;

        Key(String typeName, IJavaDebugTarget debugTarget) {
            this.fTypeName = typeName;
            this.fDebugTarget = debugTarget;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Key) {
                Key key = (Key)obj;
                return this.fTypeName != null && this.fDebugTarget != null && this.fTypeName.equals(key.fTypeName) && this.fDebugTarget.equals(key.fDebugTarget);
            }
            return false;
        }

        public int hashCode() {
            return this.fTypeName.hashCode() / 2 + this.fDebugTarget.hashCode() / 2;
        }
    }
}

