/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.discovery;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.discovery.AbstractDiscoveryStrategy;
import org.eclipse.equinox.internal.p2.discovery.Messages;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogCategory;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.equinox.internal.p2.discovery.model.Certification;
import org.eclipse.equinox.internal.p2.discovery.model.FeatureFilter;
import org.eclipse.equinox.internal.p2.discovery.model.Tag;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

public class Catalog {
    private List<CatalogItem> items = Collections.emptyList();
    private List<CatalogCategory> categories = Collections.emptyList();
    private List<Certification> certifications = Collections.emptyList();
    private List<CatalogItem> filteredItems = Collections.emptyList();
    private final List<AbstractDiscoveryStrategy> discoveryStrategies = new ArrayList<AbstractDiscoveryStrategy>();
    private List<Tag> tags = Collections.emptyList();
    private Dictionary<Object, Object> environment = System.getProperties();
    private boolean verifyUpdateSiteAvailability = false;
    private Map<String, Version> featureToVersion = null;

    public List<AbstractDiscoveryStrategy> getDiscoveryStrategies() {
        return this.discoveryStrategies;
    }

    public IStatus performDiscovery(IProgressMonitor monitor) {
        MultiStatus status = new MultiStatus("org.eclipse.equinox.p2.discovery", 0, Messages.Catalog_Failed_to_discovery_all_Error, null);
        if (this.discoveryStrategies.isEmpty()) {
            throw new IllegalStateException();
        }
        ArrayList<CatalogItem> newItems = new ArrayList<CatalogItem>();
        ArrayList<CatalogCategory> newCategories = new ArrayList<CatalogCategory>();
        ArrayList<Certification> newCertifications = new ArrayList<Certification>();
        ArrayList<Tag> newTags = new ArrayList<Tag>();
        monitor.beginTask(Messages.Catalog_task_discovering_connectors, 100000);
        try {
            for (AbstractDiscoveryStrategy discoveryStrategy : this.discoveryStrategies) {
                if (monitor.isCanceled()) {
                    status.add(Status.CANCEL_STATUS);
                    break;
                }
                discoveryStrategy.setCategories(newCategories);
                discoveryStrategy.setItems(newItems);
                discoveryStrategy.setCertifications(newCertifications);
                discoveryStrategy.setTags(newTags);
                try {
                    discoveryStrategy.performDiscovery((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)(90000 / this.discoveryStrategies.size())));
                }
                catch (CoreException e) {
                    status.add((IStatus)new Status(4, "org.eclipse.equinox.p2.discovery", NLS.bind((String)Messages.Catalog_Strategy_failed_Error, (Object)discoveryStrategy.getClass().getSimpleName()), (Throwable)e));
                }
            }
            this.update(newCategories, newItems, newCertifications, newTags);
        }
        finally {
            monitor.done();
        }
        return status;
    }

    protected void update(List<CatalogCategory> newCategories, List<CatalogItem> newItems, List<Certification> newCertifications, List<Tag> newTags) {
        this.categories = newCategories;
        this.items = newItems;
        this.certifications = newCertifications;
        this.tags = newTags;
        this.filteredItems = new ArrayList<CatalogItem>();
        this.filterDescriptors();
        this.connectCategoriesToDescriptors();
        this.connectCertificationsToDescriptors();
    }

    public List<CatalogCategory> getCategories() {
        return this.categories;
    }

    public List<CatalogItem> getItems() {
        return this.items;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public List<CatalogItem> getFilteredItems() {
        return this.filteredItems;
    }

    public List<Certification> getCertifications() {
        return this.certifications;
    }

    public Dictionary<Object, Object> getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Dictionary<Object, Object> environment) {
        if (environment == null) {
            throw new IllegalArgumentException();
        }
        this.environment = environment;
    }

    public boolean isVerifyUpdateSiteAvailability() {
        return this.verifyUpdateSiteAvailability;
    }

    public void setVerifyUpdateSiteAvailability(boolean verifyUpdateSiteAvailability) {
        this.verifyUpdateSiteAvailability = verifyUpdateSiteAvailability;
    }

    public Map<String, Version> getFeatureToVersion() {
        return this.featureToVersion;
    }

    public void setFeatureToVersion(Map<String, Version> featureToVersion) {
        this.featureToVersion = featureToVersion;
    }

    private void connectCertificationsToDescriptors() {
        HashMap<String, Certification> idToCertification = new HashMap<String, Certification>();
        for (Certification certification : this.certifications) {
            Certification previous = idToCertification.put(certification.getId(), certification);
            if (previous == null) continue;
            LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.discovery", NLS.bind((String)"Duplicate certification id ''{0}'': declaring sources: {1}, {2}", (Object[])new Object[]{certification.getId(), certification.getSource().getId(), previous.getSource().getId()})));
        }
        for (CatalogItem connector : this.items) {
            if (connector.getCertificationId() == null) continue;
            Certification certification = (Certification)idToCertification.get(connector.getCertificationId());
            if (certification != null) {
                connector.setCertification(certification);
                continue;
            }
            LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.discovery", NLS.bind((String)"Unknown category ''{0}'' referenced by connector ''{1}'' declared in {2}", (Object[])new Object[]{connector.getCertificationId(), connector.getId(), connector.getSource().getId()})));
        }
    }

    private void connectCategoriesToDescriptors() {
        HashMap<String, CatalogCategory> idToCategory = new HashMap<String, CatalogCategory>();
        for (CatalogCategory category : this.categories) {
            CatalogCategory previous = idToCategory.put(category.getId(), category);
            if (previous == null) continue;
            LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.discovery", NLS.bind((String)Messages.Catalog_duplicate_category_id, (Object[])new Object[]{category.getId(), category.getSource().getId(), previous.getSource().getId()})));
        }
        for (CatalogItem connector : this.items) {
            CatalogCategory category = (CatalogCategory)idToCategory.get(connector.getCategoryId());
            if (category != null) {
                category.getItems().add(connector);
                connector.setCategory(category);
                continue;
            }
            LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.discovery", NLS.bind((String)Messages.Catalog_bundle_references_unknown_category, (Object[])new Object[]{connector.getCategoryId(), connector.getId(), connector.getSource().getId()})));
        }
    }

    private void filterDescriptors() {
        block2: for (CatalogItem connector : new ArrayList<CatalogItem>(this.items)) {
            if (connector.getPlatformFilter() != null && connector.getPlatformFilter().trim().length() > 0) {
                boolean match = false;
                try {
                    Filter filter = FrameworkUtil.createFilter((String)connector.getPlatformFilter());
                    match = filter.match(this.environment);
                }
                catch (InvalidSyntaxException invalidSyntaxException) {
                    LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.discovery", NLS.bind((String)Messages.Catalog_illegal_filter_syntax, (Object[])new Object[]{connector.getPlatformFilter(), connector.getId(), connector.getSource().getId()})));
                }
                if (!match) {
                    this.items.remove(connector);
                    this.filteredItems.add(connector);
                }
            }
            for (FeatureFilter featureFilter : connector.getFeatureFilter()) {
                VersionRange versionRange;
                if (this.featureToVersion == null) {
                    this.featureToVersion = this.computeFeatureToVersion();
                }
                boolean match = false;
                Version version = this.featureToVersion.get(featureFilter.getFeatureId());
                if (version != null && (versionRange = new VersionRange(featureFilter.getVersion())).isIncluded(version)) {
                    match = true;
                }
                if (match) continue;
                this.items.remove(connector);
                this.filteredItems.add(connector);
                continue block2;
            }
        }
    }

    private Map<String, Version> computeFeatureToVersion() {
        HashMap<String, Version> map = new HashMap<String, Version>();
        IBundleGroupProvider[] iBundleGroupProviderArray = Platform.getBundleGroupProviders();
        int n = iBundleGroupProviderArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBundleGroupProvider provider = iBundleGroupProviderArray[n2];
            IBundleGroup[] iBundleGroupArray = provider.getBundleGroups();
            int n3 = iBundleGroupArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IBundleGroup bundleGroup = iBundleGroupArray[n4];
                Bundle[] bundleArray = bundleGroup.getBundles();
                int n5 = bundleArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    Bundle bundle = bundleArray[n6];
                    map.put(bundle.getSymbolicName(), bundle.getVersion());
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        return map;
    }

    public void dispose() {
        for (final AbstractDiscoveryStrategy strategy : this.discoveryStrategies) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    strategy.dispose();
                }

                public void handleException(Throwable exception) {
                    LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.discovery", String.valueOf(Messages.Catalog_exception_disposing) + strategy.getClass().getName(), exception));
                }
            });
        }
    }

    public void setTags(List<Tag> tags) {
        this.tags = new ArrayList<Tag>(tags);
    }
}

