/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.utils;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.ServerSocket;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Date;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.SecurityUtils;

public final class IOUtils {
    public static final int DEFAULT_BUFFER_SIZE = 16384;
    private static final boolean USE_NIO_STREAMS = false;

    public static void close(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void close(AutoCloseable closeable) {
        try {
            closeable.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void fastCopy(InputStream src, OutputStream dest) throws IOException {
        IOUtils.fastCopy(src, dest, 16384);
    }

    public static void fastCopy(InputStream src, OutputStream dest, int bufferSize) throws IOException {
        IOUtils.copyStream(src, dest, bufferSize);
    }

    public static void fastCopy(ReadableByteChannel src, WritableByteChannel dest, int bufferSize) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(bufferSize);
        while (src.read(buffer) != -1) {
            buffer.flip();
            dest.write(buffer);
            buffer.compact();
        }
        buffer.flip();
        while (buffer.hasRemaining()) {
            dest.write(buffer);
        }
    }

    public static void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        IOUtils.copyStream(inputStream, outputStream, 16384);
    }

    public static void copyStream(InputStream inputStream, OutputStream outputStream, int bufferSize) throws IOException {
        try {
            byte[] writeBuffer = new byte[bufferSize];
            int br = inputStream.read(writeBuffer);
            while (br != -1) {
                outputStream.write(writeBuffer, 0, br);
                br = inputStream.read(writeBuffer);
            }
            outputStream.flush();
        }
        finally {
            inputStream.close();
        }
    }

    public static void copyStreamPortion(InputStream inputStream, OutputStream outputStream, int portionSize, int bufferSize) throws IOException {
        if (bufferSize > portionSize) {
            bufferSize = portionSize;
        }
        byte[] writeBuffer = new byte[bufferSize];
        int totalRead = 0;
        while (totalRead < portionSize) {
            int bytesToRead = bufferSize;
            if (bytesToRead > portionSize - totalRead) {
                bytesToRead = portionSize - totalRead;
            }
            int bytesRead = inputStream.read(writeBuffer, 0, bytesToRead);
            outputStream.write(writeBuffer, 0, bytesRead);
            totalRead += bytesRead;
        }
        outputStream.flush();
    }

    /*
     * Loose catch block
     */
    public static String toString(File file, String encoding) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream is = new FileInputStream(file);){
            String string;
            InputStreamReader reader;
            Throwable throwable2;
            block19: {
                throwable2 = null;
                Object var6_9 = null;
                reader = new InputStreamReader((InputStream)is, encoding);
                StringWriter writer = new StringWriter();
                IOUtils.copyText(reader, writer, 16384);
                string = writer.toString();
                if (reader == null) break block19;
                ((Reader)reader).close();
            }
            return string;
            {
                catch (Throwable throwable3) {
                    try {
                        if (reader != null) {
                            ((Reader)reader).close();
                        }
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (throwable2 == null) {
                            throwable2 = throwable4;
                        } else if (throwable2 != throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        throw throwable2;
                    }
                }
            }
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
            } else if (throwable != throwable5) {
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
    }

    public static void copyText(Reader reader, Writer writer, int bufferSize) throws IOException {
        char[] writeBuffer = new char[bufferSize];
        int br = reader.read(writeBuffer);
        while (br != -1) {
            writer.write(writeBuffer, 0, br);
            br = reader.read(writeBuffer);
        }
        writer.flush();
    }

    public static void copyText(Reader reader, Writer writer) throws IOException {
        IOUtils.copyText(reader, writer, 16384);
    }

    public static byte[] readFileToBuffer(File file) throws IOException {
        byte[] buffer = new byte[(int)file.length()];
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream is = new FileInputStream(file);){
            IOUtils.readStreamToBuffer(is, buffer);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return buffer;
    }

    public static int readStreamToBuffer(InputStream inputStream, byte[] buffer) throws IOException {
        int totalRead = 0;
        while (totalRead != buffer.length) {
            int br = inputStream.read(buffer, totalRead, buffer.length - totalRead);
            if (br == -1) break;
            totalRead += br;
        }
        return totalRead;
    }

    public static String readLine(InputStream input) throws IOException {
        StringBuilder linebuf = new StringBuilder();
        int b = input.read();
        while (b != 10) {
            if (b == -1) {
                if (linebuf.length() != 0) break;
                return null;
            }
            if (b != 13) {
                linebuf.append((char)b);
            }
            b = input.read();
        }
        return linebuf.toString();
    }

    public static String readFullLine(InputStream input) throws IOException {
        StringBuilder linebuf = new StringBuilder();
        int b = input.read();
        while (true) {
            if (b == -1) {
                if (linebuf.length() != 0) break;
                return null;
            }
            linebuf.append((char)b);
            if (b == 10) break;
            b = input.read();
        }
        return linebuf.toString();
    }

    public static int findFreePort(int minPort, int maxPort) {
        int portRange = Math.abs(maxPort - minPort);
        while (true) {
            int portNum = minPort + SecurityUtils.getRandom().nextInt(portRange);
            try {
                ServerSocket socket = new ServerSocket(portNum);
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
                return portNum;
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
    }

    public static String readToString(Reader is) throws IOException {
        int count;
        StringBuilder result = new StringBuilder(4000);
        char[] buffer = new char[4000];
        while ((count = is.read(buffer)) > 0) {
            result.append(buffer, 0, count);
        }
        return result.toString();
    }

    public static void makeFileBackup(File file) throws IOException {
        Date backupTime;
        File backupFile;
        if (!file.exists()) {
            return;
        }
        String backupFileName = String.valueOf(file.getName()) + ".bak";
        if (!backupFileName.startsWith(".")) {
            backupFileName = "." + backupFileName;
        }
        if ((backupFile = new File(file.getParent(), backupFileName)).exists() && CommonUtils.isSameDay(backupTime = new Date(backupFile.lastModified()), new Date())) {
            return;
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileInputStream fis = new FileInputStream(file);){
            Throwable throwable2 = null;
            Object var7_10 = null;
            try (FileOutputStream fos = new FileOutputStream(backupFile);){
                IOUtils.fastCopy(fis, fos);
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }
}

