/*
 * Decompiled with CFR 0.152.
 */
package javax.tools;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import javax.tools.DocumentationTool;
import javax.tools.JavaCompiler;

public class ToolProvider {
    private static final String systemJavaCompilerModule = "jdk.compiler";
    private static final String systemJavaCompilerName = "com.sun.tools.javac.api.JavacTool";
    private static final String systemDocumentationToolModule = "jdk.javadoc";
    private static final String systemDocumentationToolName = "jdk.javadoc.internal.api.JavadocTool";

    public static JavaCompiler getSystemJavaCompiler() {
        return ToolProvider.getSystemTool(JavaCompiler.class, systemJavaCompilerModule, systemJavaCompilerName);
    }

    public static DocumentationTool getSystemDocumentationTool() {
        return ToolProvider.getSystemTool(DocumentationTool.class, systemDocumentationToolModule, systemDocumentationToolName);
    }

    @Deprecated(since="9")
    public static ClassLoader getSystemToolClassLoader() {
        return null;
    }

    private static <T> T getSystemTool(Class<T> clazz, String moduleName, String className) {
        try {
            ServiceLoader<T> sl = ServiceLoader.load(clazz, ClassLoader.getSystemClassLoader());
            for (T tool : sl) {
                if (!ToolProvider.matches(tool, moduleName)) continue;
                return tool;
            }
        }
        catch (ServiceConfigurationError e) {
            throw new Error(e);
        }
        return null;
    }

    private static <T> boolean matches(T tool, String moduleName) {
        PrivilegedAction<Boolean> pa = () -> {
            Module toolModule = tool.getClass().getModule();
            String toolModuleName = toolModule.getName();
            return toolModuleName.equals(moduleName);
        };
        return AccessController.doPrivileged(pa);
    }
}

