(function() {
  var CompositeDisposable, Dialog, Disposable, Emitter, Point, Range, TextEditor, getFullExtension, path, ref;

  ref = require('atom'), TextEditor = ref.TextEditor, CompositeDisposable = ref.CompositeDisposable, Disposable = ref.Disposable, Emitter = ref.Emitter, Range = ref.Range, Point = ref.Point;

  path = require('path');

  getFullExtension = require("./helpers").getFullExtension;

  module.exports = Dialog = (function() {
    function Dialog(arg) {
      var baseName, blurHandler, extension, iconClass, initialPath, prompt, ref1, select, selectionEnd, selectionStart;
      ref1 = arg != null ? arg : {}, initialPath = ref1.initialPath, select = ref1.select, iconClass = ref1.iconClass, prompt = ref1.prompt;
      this.emitter = new Emitter();
      this.disposables = new CompositeDisposable();
      this.element = document.createElement('div');
      this.element.classList.add('tree-view-dialog');
      this.promptText = document.createElement('label');
      this.promptText.classList.add('icon');
      if (iconClass) {
        this.promptText.classList.add(iconClass);
      }
      this.promptText.textContent = prompt;
      this.element.appendChild(this.promptText);
      this.miniEditor = new TextEditor({
        mini: true
      });
      blurHandler = (function(_this) {
        return function() {
          if (document.hasFocus()) {
            return _this.close();
          }
        };
      })(this);
      this.miniEditor.element.addEventListener('blur', blurHandler);
      this.disposables.add(new Disposable((function(_this) {
        return function() {
          return _this.miniEditor.element.removeEventListener('blur', blurHandler);
        };
      })(this)));
      this.disposables.add(this.miniEditor.onDidChange((function(_this) {
        return function() {
          return _this.showError();
        };
      })(this)));
      this.element.appendChild(this.miniEditor.element);
      this.errorMessage = document.createElement('div');
      this.errorMessage.classList.add('error-message');
      this.element.appendChild(this.errorMessage);
      atom.commands.add(this.element, {
        'core:confirm': (function(_this) {
          return function() {
            return _this.onConfirm(_this.miniEditor.getText());
          };
        })(this),
        'core:cancel': (function(_this) {
          return function() {
            return _this.cancel();
          };
        })(this)
      });
      this.miniEditor.setText(initialPath);
      if (select) {
        extension = getFullExtension(initialPath);
        baseName = path.basename(initialPath);
        selectionStart = initialPath.length - baseName.length;
        if (baseName === extension) {
          selectionEnd = initialPath.length;
        } else {
          selectionEnd = initialPath.length - extension.length;
        }
        this.miniEditor.setSelectedBufferRange(Range(Point(0, selectionStart), Point(0, selectionEnd)));
      }
    }

    Dialog.prototype.attach = function() {
      this.panel = atom.workspace.addModalPanel({
        item: this
      });
      this.miniEditor.element.focus();
      return this.miniEditor.scrollToCursorPosition();
    };

    Dialog.prototype.close = function() {
      var activePane, panel;
      panel = this.panel;
      this.panel = null;
      if (panel != null) {
        panel.destroy();
      }
      this.emitter.dispose();
      this.disposables.dispose();
      this.miniEditor.destroy();
      activePane = atom.workspace.getCenter().getActivePane();
      if (!activePane.isDestroyed()) {
        return activePane.activate();
      }
    };

    Dialog.prototype.cancel = function() {
      var ref1;
      this.close();
      return (ref1 = document.querySelector('.tree-view')) != null ? ref1.focus() : void 0;
    };

    Dialog.prototype.showError = function(message) {
      if (message == null) {
        message = '';
      }
      this.errorMessage.textContent = message;
      if (message) {
        this.element.classList.add('error');
        return window.setTimeout(((function(_this) {
          return function() {
            return _this.element.classList.remove('error');
          };
        })(this)), 300);
      }
    };

    return Dialog;

  })();

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
