Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

var _atom = require('atom');

'use babel';

var GoToLineView = (function () {
  function GoToLineView() {
    var _this = this;

    _classCallCheck(this, GoToLineView);

    this.miniEditor = new _atom.TextEditor({ mini: true });
    this.miniEditor.element.addEventListener('blur', this.close.bind(this));

    this.message = document.createElement('div');
    this.message.classList.add('message');

    this.element = document.createElement('div');
    this.element.classList.add('go-to-line');
    this.element.appendChild(this.miniEditor.element);
    this.element.appendChild(this.message);

    this.panel = atom.workspace.addModalPanel({
      item: this,
      visible: false
    });
    atom.commands.add('atom-text-editor', 'go-to-line:toggle', function () {
      _this.toggle();
      return false;
    });
    atom.commands.add(this.miniEditor.element, 'core:confirm', function () {
      _this.navigate();
    });
    atom.commands.add(this.miniEditor.element, 'core:cancel', function () {
      _this.close();
    });
    this.miniEditor.onWillInsertText(function (arg) {
      if (arg.text.match(/[^0-9:]/)) {
        arg.cancel();
      }
    });
    this.miniEditor.onDidChange(function () {
      _this.navigate({ keepOpen: true });
    });
  }

  _createClass(GoToLineView, [{
    key: 'toggle',
    value: function toggle() {
      this.panel.isVisible() ? this.close() : this.open();
    }
  }, {
    key: 'close',
    value: function close() {
      if (!this.panel.isVisible()) return;
      this.miniEditor.setText('');
      this.panel.hide();
      if (this.miniEditor.element.hasFocus()) {
        this.restoreFocus();
      }
    }
  }, {
    key: 'navigate',
    value: function navigate() {
      var options = arguments.length <= 0 || arguments[0] === undefined ? {} : arguments[0];

      var lineNumber = this.miniEditor.getText();
      var editor = atom.workspace.getActiveTextEditor();
      if (!options.keepOpen) {
        this.close();
      }
      if (!editor || !lineNumber.length) return;

      var currentRow = editor.getCursorBufferPosition().row;
      var rowLineNumber = lineNumber.split(/:+/)[0] || '';
      var row = rowLineNumber.length > 0 ? parseInt(rowLineNumber) - 1 : currentRow;
      var columnLineNumber = lineNumber.split(/:+/)[1] || '';
      var column = columnLineNumber.length > 0 ? parseInt(columnLineNumber) - 1 : -1;

      var position = new _atom.Point(row, column);
      editor.setCursorBufferPosition(position);
      editor.unfoldBufferRow(row);
      if (column < 0) {
        editor.moveToFirstCharacterOfLine();
      }
      editor.scrollToBufferPosition(position, {
        center: true
      });
    }
  }, {
    key: 'storeFocusedElement',
    value: function storeFocusedElement() {
      this.previouslyFocusedElement = document.activeElement;
      return this.previouslyFocusedElement;
    }
  }, {
    key: 'restoreFocus',
    value: function restoreFocus() {
      if (this.previouslyFocusedElement && this.previouslyFocusedElement.parentElement) {
        return this.previouslyFocusedElement.focus();
      }
      atom.views.getView(atom.workspace).focus();
    }
  }, {
    key: 'open',
    value: function open() {
      if (this.panel.isVisible() || !atom.workspace.getActiveTextEditor()) return;
      this.storeFocusedElement();
      this.panel.show();
      this.message.textContent = 'Enter a <row> or <row>:<column> to go there. Examples: "3" for row 3 or "2:7" for row 2 and column 7';
      this.miniEditor.element.focus();
    }
  }]);

  return GoToLineView;
})();

exports['default'] = {
  activate: function activate() {
    return new GoToLineView();
  }
};
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi9idWlsZC9hdG9tL3NyYy9hdG9tLTEuMzkuMS9vdXQvYXBwL25vZGVfbW9kdWxlcy9nby10by1saW5lL2xpYi9nby10by1saW5lLXZpZXcuanMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7b0JBRWtDLE1BQU07O0FBRnhDLFdBQVcsQ0FBQzs7SUFJTixZQUFZO0FBQ0wsV0FEUCxZQUFZLEdBQ0Y7OzswQkFEVixZQUFZOztBQUVkLFFBQUksQ0FBQyxVQUFVLEdBQUcscUJBQWUsRUFBRSxJQUFJLEVBQUUsSUFBSSxFQUFFLENBQUMsQ0FBQztBQUNqRCxRQUFJLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQyxnQkFBZ0IsQ0FBQyxNQUFNLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQzs7QUFFeEUsUUFBSSxDQUFDLE9BQU8sR0FBRyxRQUFRLENBQUMsYUFBYSxDQUFDLEtBQUssQ0FBQyxDQUFDO0FBQzdDLFFBQUksQ0FBQyxPQUFPLENBQUMsU0FBUyxDQUFDLEdBQUcsQ0FBQyxTQUFTLENBQUMsQ0FBQzs7QUFFdEMsUUFBSSxDQUFDLE9BQU8sR0FBRyxRQUFRLENBQUMsYUFBYSxDQUFDLEtBQUssQ0FBQyxDQUFDO0FBQzdDLFFBQUksQ0FBQyxPQUFPLENBQUMsU0FBUyxDQUFDLEdBQUcsQ0FBQyxZQUFZLENBQUMsQ0FBQztBQUN6QyxRQUFJLENBQUMsT0FBTyxDQUFDLFdBQVcsQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQyxDQUFDO0FBQ2xELFFBQUksQ0FBQyxPQUFPLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsQ0FBQzs7QUFFdkMsUUFBSSxDQUFDLEtBQUssR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLGFBQWEsQ0FBQztBQUN4QyxVQUFJLEVBQUUsSUFBSTtBQUNWLGFBQU8sRUFBRSxLQUFLO0tBQ2YsQ0FBQyxDQUFDO0FBQ0gsUUFBSSxDQUFDLFFBQVEsQ0FBQyxHQUFHLENBQUMsa0JBQWtCLEVBQUUsbUJBQW1CLEVBQUUsWUFBTTtBQUMvRCxZQUFLLE1BQU0sRUFBRSxDQUFDO0FBQ2QsYUFBTyxLQUFLLENBQUM7S0FDZCxDQUFDLENBQUM7QUFDSCxRQUFJLENBQUMsUUFBUSxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLE9BQU8sRUFBRSxjQUFjLEVBQUUsWUFBTTtBQUMvRCxZQUFLLFFBQVEsRUFBRSxDQUFDO0tBQ2pCLENBQUMsQ0FBQztBQUNILFFBQUksQ0FBQyxRQUFRLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsT0FBTyxFQUFFLGFBQWEsRUFBRSxZQUFNO0FBQzlELFlBQUssS0FBSyxFQUFFLENBQUM7S0FDZCxDQUFDLENBQUM7QUFDSCxRQUFJLENBQUMsVUFBVSxDQUFDLGdCQUFnQixDQUFDLFVBQUEsR0FBRyxFQUFJO0FBQ3RDLFVBQUksR0FBRyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsU0FBUyxDQUFDLEVBQUU7QUFDN0IsV0FBRyxDQUFDLE1BQU0sRUFBRSxDQUFDO09BQ2Q7S0FDRixDQUFDLENBQUM7QUFDSCxRQUFJLENBQUMsVUFBVSxDQUFDLFdBQVcsQ0FBQyxZQUFNO0FBQ2hDLFlBQUssUUFBUSxDQUFDLEVBQUUsUUFBUSxFQUFFLElBQUksRUFBRSxDQUFDLENBQUM7S0FDbkMsQ0FBQyxDQUFDO0dBQ0o7O2VBbkNHLFlBQVk7O1dBcUNWLGtCQUFHO0FBQ1AsVUFBSSxDQUFDLEtBQUssQ0FBQyxTQUFTLEVBQUUsR0FBRyxJQUFJLENBQUMsS0FBSyxFQUFFLEdBQUcsSUFBSSxDQUFDLElBQUksRUFBRSxDQUFDO0tBQ3JEOzs7V0FFSSxpQkFBRztBQUNOLFVBQUksQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLFNBQVMsRUFBRSxFQUFFLE9BQU87QUFDcEMsVUFBSSxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsRUFBRSxDQUFDLENBQUM7QUFDNUIsVUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLEVBQUUsQ0FBQztBQUNsQixVQUFJLElBQUksQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDLFFBQVEsRUFBRSxFQUFFO0FBQ3RDLFlBQUksQ0FBQyxZQUFZLEVBQUUsQ0FBQztPQUNyQjtLQUNGOzs7V0FFTyxvQkFBZTtVQUFkLE9BQU8seURBQUcsRUFBRTs7QUFDbkIsVUFBTSxVQUFVLEdBQUcsSUFBSSxDQUFDLFVBQVUsQ0FBQyxPQUFPLEVBQUUsQ0FBQztBQUM3QyxVQUFNLE1BQU0sR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLG1CQUFtQixFQUFFLENBQUM7QUFDcEQsVUFBSSxDQUFDLE9BQU8sQ0FBQyxRQUFRLEVBQUU7QUFDckIsWUFBSSxDQUFDLEtBQUssRUFBRSxDQUFDO09BQ2Q7QUFDRCxVQUFJLENBQUMsTUFBTSxJQUFJLENBQUMsVUFBVSxDQUFDLE1BQU0sRUFBRSxPQUFPOztBQUUxQyxVQUFNLFVBQVUsR0FBRyxNQUFNLENBQUMsdUJBQXVCLEVBQUUsQ0FBQyxHQUFHLENBQUM7QUFDeEQsVUFBTSxhQUFhLEdBQUcsVUFBVSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUMsSUFBSSxFQUFFLENBQUM7QUFDdEQsVUFBTSxHQUFHLEdBQ1AsYUFBYSxDQUFDLE1BQU0sR0FBRyxDQUFDLEdBQUcsUUFBUSxDQUFDLGFBQWEsQ0FBQyxHQUFHLENBQUMsR0FBRyxVQUFVLENBQUM7QUFDdEUsVUFBTSxnQkFBZ0IsR0FBRyxVQUFVLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQyxJQUFJLEVBQUUsQ0FBQztBQUN6RCxVQUFNLE1BQU0sR0FDVixnQkFBZ0IsQ0FBQyxNQUFNLEdBQUcsQ0FBQyxHQUFHLFFBQVEsQ0FBQyxnQkFBZ0IsQ0FBQyxHQUFHLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQzs7QUFFcEUsVUFBTSxRQUFRLEdBQUcsZ0JBQVUsR0FBRyxFQUFFLE1BQU0sQ0FBQyxDQUFDO0FBQ3hDLFlBQU0sQ0FBQyx1QkFBdUIsQ0FBQyxRQUFRLENBQUMsQ0FBQztBQUN6QyxZQUFNLENBQUMsZUFBZSxDQUFDLEdBQUcsQ0FBQyxDQUFDO0FBQzVCLFVBQUksTUFBTSxHQUFHLENBQUMsRUFBRTtBQUNkLGNBQU0sQ0FBQywwQkFBMEIsRUFBRSxDQUFDO09BQ3JDO0FBQ0QsWUFBTSxDQUFDLHNCQUFzQixDQUFDLFFBQVEsRUFBRTtBQUN0QyxjQUFNLEVBQUUsSUFBSTtPQUNiLENBQUMsQ0FBQztLQUNKOzs7V0FFa0IsK0JBQUc7QUFDcEIsVUFBSSxDQUFDLHdCQUF3QixHQUFHLFFBQVEsQ0FBQyxhQUFhLENBQUM7QUFDdkQsYUFBTyxJQUFJLENBQUMsd0JBQXdCLENBQUM7S0FDdEM7OztXQUVXLHdCQUFHO0FBQ2IsVUFDRSxJQUFJLENBQUMsd0JBQXdCLElBQzdCLElBQUksQ0FBQyx3QkFBd0IsQ0FBQyxhQUFhLEVBQzNDO0FBQ0EsZUFBTyxJQUFJLENBQUMsd0JBQXdCLENBQUMsS0FBSyxFQUFFLENBQUM7T0FDOUM7QUFDRCxVQUFJLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLENBQUMsS0FBSyxFQUFFLENBQUM7S0FDNUM7OztXQUVHLGdCQUFHO0FBQ0wsVUFBSSxJQUFJLENBQUMsS0FBSyxDQUFDLFNBQVMsRUFBRSxJQUFJLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxtQkFBbUIsRUFBRSxFQUFFLE9BQU87QUFDNUUsVUFBSSxDQUFDLG1CQUFtQixFQUFFLENBQUM7QUFDM0IsVUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLEVBQUUsQ0FBQztBQUNsQixVQUFJLENBQUMsT0FBTyxDQUFDLFdBQVcsR0FDdEIsc0dBQXNHLENBQUM7QUFDekcsVUFBSSxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsS0FBSyxFQUFFLENBQUM7S0FDakM7OztTQW5HRyxZQUFZOzs7cUJBc0dIO0FBQ2IsVUFBUSxFQUFBLG9CQUFHO0FBQ1QsV0FBTyxJQUFJLFlBQVksRUFBRSxDQUFDO0dBQzNCO0NBQ0YiLCJmaWxlIjoiL2J1aWxkL2F0b20vc3JjL2F0b20tMS4zOS4xL291dC9hcHAvbm9kZV9tb2R1bGVzL2dvLXRvLWxpbmUvbGliL2dvLXRvLWxpbmUtdmlldy5qcyIsInNvdXJjZXNDb250ZW50IjpbIid1c2UgYmFiZWwnO1xuXG5pbXBvcnQgeyBQb2ludCwgVGV4dEVkaXRvciB9IGZyb20gJ2F0b20nO1xuXG5jbGFzcyBHb1RvTGluZVZpZXcge1xuICBjb25zdHJ1Y3RvcigpIHtcbiAgICB0aGlzLm1pbmlFZGl0b3IgPSBuZXcgVGV4dEVkaXRvcih7IG1pbmk6IHRydWUgfSk7XG4gICAgdGhpcy5taW5pRWRpdG9yLmVsZW1lbnQuYWRkRXZlbnRMaXN0ZW5lcignYmx1cicsIHRoaXMuY2xvc2UuYmluZCh0aGlzKSk7XG5cbiAgICB0aGlzLm1lc3NhZ2UgPSBkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdkaXYnKTtcbiAgICB0aGlzLm1lc3NhZ2UuY2xhc3NMaXN0LmFkZCgnbWVzc2FnZScpO1xuXG4gICAgdGhpcy5lbGVtZW50ID0gZG9jdW1lbnQuY3JlYXRlRWxlbWVudCgnZGl2Jyk7XG4gICAgdGhpcy5lbGVtZW50LmNsYXNzTGlzdC5hZGQoJ2dvLXRvLWxpbmUnKTtcbiAgICB0aGlzLmVsZW1lbnQuYXBwZW5kQ2hpbGQodGhpcy5taW5pRWRpdG9yLmVsZW1lbnQpO1xuICAgIHRoaXMuZWxlbWVudC5hcHBlbmRDaGlsZCh0aGlzLm1lc3NhZ2UpO1xuXG4gICAgdGhpcy5wYW5lbCA9IGF0b20ud29ya3NwYWNlLmFkZE1vZGFsUGFuZWwoe1xuICAgICAgaXRlbTogdGhpcyxcbiAgICAgIHZpc2libGU6IGZhbHNlXG4gICAgfSk7XG4gICAgYXRvbS5jb21tYW5kcy5hZGQoJ2F0b20tdGV4dC1lZGl0b3InLCAnZ28tdG8tbGluZTp0b2dnbGUnLCAoKSA9PiB7XG4gICAgICB0aGlzLnRvZ2dsZSgpO1xuICAgICAgcmV0dXJuIGZhbHNlO1xuICAgIH0pO1xuICAgIGF0b20uY29tbWFuZHMuYWRkKHRoaXMubWluaUVkaXRvci5lbGVtZW50LCAnY29yZTpjb25maXJtJywgKCkgPT4ge1xuICAgICAgdGhpcy5uYXZpZ2F0ZSgpO1xuICAgIH0pO1xuICAgIGF0b20uY29tbWFuZHMuYWRkKHRoaXMubWluaUVkaXRvci5lbGVtZW50LCAnY29yZTpjYW5jZWwnLCAoKSA9PiB7XG4gICAgICB0aGlzLmNsb3NlKCk7XG4gICAgfSk7XG4gICAgdGhpcy5taW5pRWRpdG9yLm9uV2lsbEluc2VydFRleHQoYXJnID0+IHtcbiAgICAgIGlmIChhcmcudGV4dC5tYXRjaCgvW14wLTk6XS8pKSB7XG4gICAgICAgIGFyZy5jYW5jZWwoKTtcbiAgICAgIH1cbiAgICB9KTtcbiAgICB0aGlzLm1pbmlFZGl0b3Iub25EaWRDaGFuZ2UoKCkgPT4ge1xuICAgICAgdGhpcy5uYXZpZ2F0ZSh7IGtlZXBPcGVuOiB0cnVlIH0pO1xuICAgIH0pO1xuICB9XG5cbiAgdG9nZ2xlKCkge1xuICAgIHRoaXMucGFuZWwuaXNWaXNpYmxlKCkgPyB0aGlzLmNsb3NlKCkgOiB0aGlzLm9wZW4oKTtcbiAgfVxuXG4gIGNsb3NlKCkge1xuICAgIGlmICghdGhpcy5wYW5lbC5pc1Zpc2libGUoKSkgcmV0dXJuO1xuICAgIHRoaXMubWluaUVkaXRvci5zZXRUZXh0KCcnKTtcbiAgICB0aGlzLnBhbmVsLmhpZGUoKTtcbiAgICBpZiAodGhpcy5taW5pRWRpdG9yLmVsZW1lbnQuaGFzRm9jdXMoKSkge1xuICAgICAgdGhpcy5yZXN0b3JlRm9jdXMoKTtcbiAgICB9XG4gIH1cblxuICBuYXZpZ2F0ZShvcHRpb25zID0ge30pIHtcbiAgICBjb25zdCBsaW5lTnVtYmVyID0gdGhpcy5taW5pRWRpdG9yLmdldFRleHQoKTtcbiAgICBjb25zdCBlZGl0b3IgPSBhdG9tLndvcmtzcGFjZS5nZXRBY3RpdmVUZXh0RWRpdG9yKCk7XG4gICAgaWYgKCFvcHRpb25zLmtlZXBPcGVuKSB7XG4gICAgICB0aGlzLmNsb3NlKCk7XG4gICAgfVxuICAgIGlmICghZWRpdG9yIHx8ICFsaW5lTnVtYmVyLmxlbmd0aCkgcmV0dXJuO1xuXG4gICAgY29uc3QgY3VycmVudFJvdyA9IGVkaXRvci5nZXRDdXJzb3JCdWZmZXJQb3NpdGlvbigpLnJvdztcbiAgICBjb25zdCByb3dMaW5lTnVtYmVyID0gbGluZU51bWJlci5zcGxpdCgvOisvKVswXSB8fCAnJztcbiAgICBjb25zdCByb3cgPVxuICAgICAgcm93TGluZU51bWJlci5sZW5ndGggPiAwID8gcGFyc2VJbnQocm93TGluZU51bWJlcikgLSAxIDogY3VycmVudFJvdztcbiAgICBjb25zdCBjb2x1bW5MaW5lTnVtYmVyID0gbGluZU51bWJlci5zcGxpdCgvOisvKVsxXSB8fCAnJztcbiAgICBjb25zdCBjb2x1bW4gPVxuICAgICAgY29sdW1uTGluZU51bWJlci5sZW5ndGggPiAwID8gcGFyc2VJbnQoY29sdW1uTGluZU51bWJlcikgLSAxIDogLTE7XG5cbiAgICBjb25zdCBwb3NpdGlvbiA9IG5ldyBQb2ludChyb3csIGNvbHVtbik7XG4gICAgZWRpdG9yLnNldEN1cnNvckJ1ZmZlclBvc2l0aW9uKHBvc2l0aW9uKTtcbiAgICBlZGl0b3IudW5mb2xkQnVmZmVyUm93KHJvdyk7XG4gICAgaWYgKGNvbHVtbiA8IDApIHtcbiAgICAgIGVkaXRvci5tb3ZlVG9GaXJzdENoYXJhY3Rlck9mTGluZSgpO1xuICAgIH1cbiAgICBlZGl0b3Iuc2Nyb2xsVG9CdWZmZXJQb3NpdGlvbihwb3NpdGlvbiwge1xuICAgICAgY2VudGVyOiB0cnVlXG4gICAgfSk7XG4gIH1cblxuICBzdG9yZUZvY3VzZWRFbGVtZW50KCkge1xuICAgIHRoaXMucHJldmlvdXNseUZvY3VzZWRFbGVtZW50ID0gZG9jdW1lbnQuYWN0aXZlRWxlbWVudDtcbiAgICByZXR1cm4gdGhpcy5wcmV2aW91c2x5Rm9jdXNlZEVsZW1lbnQ7XG4gIH1cblxuICByZXN0b3JlRm9jdXMoKSB7XG4gICAgaWYgKFxuICAgICAgdGhpcy5wcmV2aW91c2x5Rm9jdXNlZEVsZW1lbnQgJiZcbiAgICAgIHRoaXMucHJldmlvdXNseUZvY3VzZWRFbGVtZW50LnBhcmVudEVsZW1lbnRcbiAgICApIHtcbiAgICAgIHJldHVybiB0aGlzLnByZXZpb3VzbHlGb2N1c2VkRWxlbWVudC5mb2N1cygpO1xuICAgIH1cbiAgICBhdG9tLnZpZXdzLmdldFZpZXcoYXRvbS53b3Jrc3BhY2UpLmZvY3VzKCk7XG4gIH1cblxuICBvcGVuKCkge1xuICAgIGlmICh0aGlzLnBhbmVsLmlzVmlzaWJsZSgpIHx8ICFhdG9tLndvcmtzcGFjZS5nZXRBY3RpdmVUZXh0RWRpdG9yKCkpIHJldHVybjtcbiAgICB0aGlzLnN0b3JlRm9jdXNlZEVsZW1lbnQoKTtcbiAgICB0aGlzLnBhbmVsLnNob3coKTtcbiAgICB0aGlzLm1lc3NhZ2UudGV4dENvbnRlbnQgPVxuICAgICAgJ0VudGVyIGEgPHJvdz4gb3IgPHJvdz46PGNvbHVtbj4gdG8gZ28gdGhlcmUuIEV4YW1wbGVzOiBcIjNcIiBmb3Igcm93IDMgb3IgXCIyOjdcIiBmb3Igcm93IDIgYW5kIGNvbHVtbiA3JztcbiAgICB0aGlzLm1pbmlFZGl0b3IuZWxlbWVudC5mb2N1cygpO1xuICB9XG59XG5cbmV4cG9ydCBkZWZhdWx0IHtcbiAgYWN0aXZhdGUoKSB7XG4gICAgcmV0dXJuIG5ldyBHb1RvTGluZVZpZXcoKTtcbiAgfVxufTtcbiJdfQ==