"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.BareGithubDotcomMarkdown = void 0;

var _eventKit = require("event-kit");

var _react = _interopRequireDefault(require("react"));

var _reactDom = _interopRequireDefault(require("react-dom"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _issueishLink = require("./issueish-link");

var _userMentionTooltipItem = _interopRequireDefault(require("../items/user-mention-tooltip-item"));

var _issueishTooltipItem = _interopRequireDefault(require("../items/issueish-tooltip-item"));

var _relayEnvironment = _interopRequireDefault(require("./relay-environment"));

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BareGithubDotcomMarkdown extends _react["default"].Component {
  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'handleClick', 'openLinkInNewTab', 'openLinkInThisTab', 'openLinkInBrowser');
  }

  componentDidMount() {
    this.commandSubscriptions = atom.commands.add(_reactDom["default"].findDOMNode(this), {
      'github:open-link-in-new-tab': this.openLinkInNewTab,
      'github:open-link-in-browser': this.openLinkInBrowser,
      'github:open-link-in-this-tab': this.openLinkInThisTab
    });
    this.setupComponentHandlers();
    this.setupTooltipHandlers();
  }

  componentDidUpdate() {
    this.setupTooltipHandlers();
  }

  setupComponentHandlers() {
    this.component.addEventListener('click', this.handleClick);
    this.componentHandlers = new _eventKit.Disposable(() => {
      this.component.removeEventListener('click', this.handleClick);
    });
  }

  setupTooltipHandlers() {
    if (this.tooltipSubscriptions) {
      this.tooltipSubscriptions.dispose();
    }

    this.tooltipSubscriptions = new _eventKit.CompositeDisposable();
    this.component.querySelectorAll('.user-mention').forEach(node => {
      const item = new _userMentionTooltipItem["default"](node.textContent, this.props.relayEnvironment);
      this.tooltipSubscriptions.add(atom.tooltips.add(node, {
        trigger: 'hover',
        delay: 0,
        "class": 'github-Popover',
        item
      }));
      this.tooltipSubscriptions.add(new _eventKit.Disposable(() => item.destroy()));
    });
    this.component.querySelectorAll('.issue-link').forEach(node => {
      const item = new _issueishTooltipItem["default"](node.getAttribute('href'), this.props.relayEnvironment);
      this.tooltipSubscriptions.add(atom.tooltips.add(node, {
        trigger: 'hover',
        delay: 0,
        "class": 'github-Popover',
        item
      }));
      this.tooltipSubscriptions.add(new _eventKit.Disposable(() => item.destroy()));
    });
  }

  componentWillUnmount() {
    this.commandSubscriptions.dispose();
    this.componentHandlers.dispose();
    this.tooltipSubscriptions && this.tooltipSubscriptions.dispose();
  }

  render() {
    return _react["default"].createElement("div", {
      className: "github-DotComMarkdownHtml native-key-bindings",
      tabIndex: "-1",
      ref: c => {
        this.component = c;
      },
      dangerouslySetInnerHTML: {
        __html: this.props.html
      }
    });
  }

  handleClick(event) {
    if (event.target.dataset.url) {
      return this.props.handleClickEvent(event, event.target.dataset.url);
    } else {
      return null;
    }
  }

  openLinkInNewTab(event) {
    return this.props.openIssueishLinkInNewTab(event.target.dataset.url);
  }

  openLinkInThisTab(event) {
    const {
      repoOwner,
      repoName,
      issueishNumber
    } = (0, _issueishLink.getDataFromGithubUrl)(event.target.dataset.url);
    this.props.switchToIssueish(repoOwner, repoName, issueishNumber);
  }

  openLinkInBrowser(event) {
    return this.props.openLinkInBrowser(event.target.getAttribute('href'));
  }

}

exports.BareGithubDotcomMarkdown = BareGithubDotcomMarkdown;

_defineProperty(BareGithubDotcomMarkdown, "propTypes", {
  relayEnvironment: _propTypes["default"].object.isRequired,
  html: _propTypes["default"].string.isRequired,
  switchToIssueish: _propTypes["default"].func.isRequired,
  handleClickEvent: _propTypes["default"].func,
  openIssueishLinkInNewTab: _propTypes["default"].func,
  openLinkInBrowser: _propTypes["default"].func
});

_defineProperty(BareGithubDotcomMarkdown, "defaultProps", {
  handleClickEvent: _issueishLink.handleClickEvent,
  openIssueishLinkInNewTab: _issueishLink.openIssueishLinkInNewTab,
  openLinkInBrowser: _issueishLink.openLinkInBrowser
});

class GithubDotcomMarkdown extends _react["default"].Component {
  render() {
    return _react["default"].createElement(_relayEnvironment["default"].Consumer, null, relayEnvironment => _react["default"].createElement(BareGithubDotcomMarkdown, _extends({
      relayEnvironment: relayEnvironment
    }, this.props)));
  }

}

exports["default"] = GithubDotcomMarkdown;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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