"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes2 = require("../prop-types");

var _prCheckoutController = require("../controllers/pr-checkout-controller");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class CheckoutButton extends _react["default"].Component {
  render() {
    const {
      checkoutOp
    } = this.props;
    const extraClasses = this.props.classNames || [];
    let buttonText = 'Checkout';
    let buttonTitle = null;

    if (!checkoutOp.isEnabled()) {
      buttonTitle = checkoutOp.getMessage();
      const reason = checkoutOp.why();

      if (reason === _prCheckoutController.checkoutStates.HIDDEN) {
        return null;
      }

      buttonText = reason.when({
        current: 'Checked out',
        "default": 'Checkout'
      });
      extraClasses.push(this.props.classNamePrefix + reason.when({
        disabled: 'disabled',
        busy: 'busy',
        current: 'current'
      }));
    }

    const classNames = (0, _classnames["default"])('btn', 'btn-primary', 'checkoutButton', ...extraClasses);
    return _react["default"].createElement("button", {
      className: classNames,
      disabled: !checkoutOp.isEnabled(),
      title: buttonTitle,
      onClick: () => checkoutOp.run()
    }, buttonText);
  }

}

exports["default"] = CheckoutButton;

_defineProperty(CheckoutButton, "propTypes", {
  checkoutOp: _propTypes2.EnableableOperationPropType.isRequired,
  classNamePrefix: _propTypes["default"].string.isRequired,
  classNames: _propTypes["default"].array
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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