"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _yubikiri = _interopRequireDefault(require("yubikiri"));

var _reactRelay = require("react-relay");

var _commentDecorationsController = _interopRequireDefault(require("../controllers/comment-decorations-controller"));

var _observeModel = _interopRequireDefault(require("../views/observe-model"));

var _relayEnvironment = _interopRequireDefault(require("../views/relay-environment"));

var _propTypes2 = require("../prop-types");

var _keytarStrategy = require("../shared/keytar-strategy");

var _relayNetworkLayerManager = _interopRequireDefault(require("../relay-network-layer-manager"));

var _helpers = require("../helpers");

var _aggregatedReviewsContainer = _interopRequireDefault(require("./aggregated-reviews-container"));

var _commentPositioningContainer = _interopRequireDefault(require("./comment-positioning-container"));

var _prPatchContainer = _interopRequireDefault(require("./pr-patch-container"));

var _graphql;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class CommentDecorationsContainer extends _react["default"].Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "renderWithLocalRepositoryData", repoData => {
      if (!repoData) {
        return null;
      }

      return _react["default"].createElement(_observeModel["default"], {
        model: this.props.loginModel,
        fetchParams: [repoData],
        fetchData: this.fetchToken
      }, token => this.renderWithToken(token, {
        repoData
      }));
    });

    _defineProperty(this, "fetchRepositoryData", repository => {
      return (0, _yubikiri["default"])({
        branches: repository.getBranches(),
        remotes: repository.getRemotes(),
        currentRemote: repository.getCurrentGitHubRemote(),
        workingDirectoryPath: repository.getWorkingDirectoryPath()
      });
    });

    _defineProperty(this, "fetchToken", (loginModel, repoData) => {
      const endpoint = repoData.currentRemote.getEndpoint();

      if (!endpoint) {
        return null;
      }

      return loginModel.getToken(endpoint.getLoginAccount());
    });
  }

  render() {
    return _react["default"].createElement(_observeModel["default"], {
      model: this.props.localRepository,
      fetchData: this.fetchRepositoryData
    }, this.renderWithLocalRepositoryData);
  }

  renderWithToken(token, {
    repoData
  }) {
    if (!token || token === _keytarStrategy.UNAUTHENTICATED || token === _keytarStrategy.INSUFFICIENT) {
      // we're not going to prompt users to log in to render decorations for comments
      // just let it go and move on with our lives.
      return null;
    }

    const head = repoData.branches.getHeadBranch();

    if (!head.isPresent()) {
      return null;
    }

    const push = head.getPush();

    if (!push.isPresent() || !push.isRemoteTracking()) {
      return null;
    }

    const pushRemote = repoData.remotes.withName(push.getRemoteName());

    if (!pushRemote.isPresent() || !pushRemote.isGithubRepo()) {
      return null;
    }

    const endpoint = repoData.currentRemote.getEndpoint();

    const environment = _relayNetworkLayerManager["default"].getEnvironmentForHost(endpoint, token);

    const query = _graphql || (_graphql = function () {
      const node = require("./__generated__/commentDecorationsContainerQuery.graphql");

      if (node.hash && node.hash !== "8154acbf4c24d190f6fdf0254ae73817") {
        console.error("The definition of 'commentDecorationsContainerQuery' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
      }

      return require("./__generated__/commentDecorationsContainerQuery.graphql");
    });

    const variables = {
      headOwner: pushRemote.getOwner(),
      headName: pushRemote.getRepo(),
      headRef: push.getRemoteRef(),
      first: 1,
      reviewCount: _helpers.PAGE_SIZE,
      reviewCursor: null,
      threadCount: _helpers.PAGE_SIZE,
      threadCursor: null,
      commentCount: _helpers.PAGE_SIZE,
      commentCursor: null
    };
    return _react["default"].createElement(_relayEnvironment["default"].Provider, {
      value: environment
    }, _react["default"].createElement(_reactRelay.QueryRenderer, {
      environment: environment,
      query: query,
      variables: variables,
      render: queryResult => this.renderWithGraphQLData(_objectSpread({
        endpoint,
        owner: variables.headOwner,
        repo: variables.headName
      }, queryResult), {
        repoData,
        token
      })
    }));
  }

  renderWithGraphQLData({
    error,
    props,
    endpoint,
    owner,
    repo
  }, {
    repoData,
    token
  }) {
    if (error) {
      // eslint-disable-next-line no-console
      console.warn(`error fetching CommentDecorationsContainer data: ${error}`);
      return null;
    }

    if (!props || !props.repository || !props.repository.ref || props.repository.ref.associatedPullRequests.totalCount === 0) {
      // no loading spinner for you
      // just fetch silently behind the scenes like a good little container
      return null;
    }

    const currentPullRequest = props.repository.ref.associatedPullRequests.nodes[0];

    const queryProps = _objectSpread({
      currentPullRequest
    }, props);

    return _react["default"].createElement(_prPatchContainer["default"], {
      owner: owner,
      repo: repo,
      number: currentPullRequest.number,
      endpoint: endpoint,
      token: token
    }, (patchError, patch) => this.renderWithPatch({
      error: patchError,
      patch
    }, {
      queryProps,
      endpoint,
      owner,
      repo,
      repoData
    }));
  }

  renderWithPatch({
    error,
    patch
  }, {
    queryProps,
    endpoint,
    owner,
    repo,
    repoData
  }) {
    if (error) {
      // eslint-disable-next-line no-console
      console.warn('Error fetching patch for current pull request', error);
      return null;
    }

    return _react["default"].createElement(_aggregatedReviewsContainer["default"], {
      pullRequest: queryProps.currentPullRequest
    }, ({
      errors,
      summaries,
      commentThreads
    }) => {
      if (errors && errors.length > 0) {
        // eslint-disable-next-line no-console
        console.warn('Errors aggregating reviews and comments for current pull request', ...errors);
        return null;
      }

      const aggregationResult = {
        summaries,
        commentThreads
      };
      return this.renderWithResult(aggregationResult, {
        queryProps,
        endpoint,
        owner,
        repo,
        repoData,
        patch
      });
    });
  }

  renderWithResult(aggregationResult, {
    queryProps,
    endpoint,
    owner,
    repo,
    repoData,
    patch
  }) {
    if (!patch) {
      return null;
    }

    return _react["default"].createElement(_commentPositioningContainer["default"], {
      multiFilePatch: patch,
      commentThreads: aggregationResult.commentThreads,
      prCommitSha: queryProps.currentPullRequest.headRefOid,
      localRepository: this.props.localRepository,
      workdir: repoData.workingDirectoryPath
    }, commentTranslations => {
      if (!commentTranslations) {
        return null;
      }

      return _react["default"].createElement(_commentDecorationsController["default"], {
        endpoint: endpoint,
        owner: owner,
        repo: repo,
        workspace: this.props.workspace,
        commands: this.props.commands,
        repoData: repoData,
        commentThreads: aggregationResult.commentThreads,
        commentTranslations: commentTranslations,
        pullRequests: queryProps.repository.ref.associatedPullRequests.nodes
      });
    });
  }

}

exports["default"] = CommentDecorationsContainer;

_defineProperty(CommentDecorationsContainer, "propTypes", {
  workspace: _propTypes["default"].object.isRequired,
  commands: _propTypes["default"].object.isRequired,
  localRepository: _propTypes["default"].object.isRequired,
  loginModel: _propTypes2.GithubLoginModelPropType.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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