/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.awt.Dimension;
import java.util.Vector;
import javax.swing.JComboBox;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.tools.debugger.ContextData;
import org.mozilla.javascript.tools.debugger.FrameHelper;
import org.mozilla.javascript.tools.debugger.Main;

class UpdateContext
implements Runnable {
    Main db;
    ContextData contextData;

    UpdateContext(Main db, Context cx) {
        this.db = db;
        this.contextData = ContextData.get(cx);
    }

    @Override
    public void run() {
        this.db.context.enable();
        JComboBox ctx = this.db.context.context;
        Vector toolTips = this.db.context.toolTips;
        this.db.context.disableUpdate();
        int frameCount = this.contextData.getFrameCount();
        ctx.removeAllItems();
        ctx.setSelectedItem(null);
        toolTips.removeAllElements();
        for (int i = 0; i < frameCount; ++i) {
            FrameHelper frame = this.contextData.getFrame(i);
            String url = frame.getUrl();
            int lineNumber = frame.getLineNumber();
            String shortName = url;
            if (url.length() > 20) {
                shortName = "..." + url.substring(url.length() - 17);
            }
            String location = "\"" + shortName + "\", line " + lineNumber;
            ctx.insertItemAt(location, i);
            location = "\"" + url + "\", line " + lineNumber;
            toolTips.addElement(location);
        }
        this.db.context.enableUpdate();
        if (frameCount != 0) {
            ctx.setSelectedIndex(0);
        }
        ctx.setMinimumSize(new Dimension(50, ctx.getMinimumSize().height));
    }
}

