/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.connections.socket;

import com.sun.star.connection.XConnection;
import com.sun.star.connection.XConnectionBroadcaster;
import com.sun.star.io.XStreamListener;
import com.sun.star.uno.Exception;
import com.sun.star.uno.RuntimeException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;

public class SocketConnection
implements XConnection,
XConnectionBroadcaster {
    public static final boolean DEBUG = false;
    protected String _description;
    protected Socket _socket;
    protected InputStream _inputStream;
    protected OutputStream _outputStream;
    protected ArrayList<XStreamListener> _listeners;
    protected boolean _firstRead;

    public SocketConnection(String description, Socket socket) throws IOException {
        this._description = description + ",localHost=" + socket.getLocalAddress().getHostName() + ",localPort=" + socket.getLocalPort() + ",peerHost=" + socket.getInetAddress().getHostName() + ",peerPort=" + socket.getPort();
        this._socket = socket;
        this._inputStream = new BufferedInputStream(socket.getInputStream());
        this._outputStream = new BufferedOutputStream(socket.getOutputStream());
        this._listeners = new ArrayList();
        this._firstRead = true;
    }

    @Override
    public void addStreamListener(XStreamListener aListener) throws RuntimeException {
        this._listeners.add(aListener);
    }

    @Override
    public void removeStreamListener(XStreamListener aListener) throws RuntimeException {
        this._listeners.remove(aListener);
    }

    private void notifyListeners_open() {
        for (XStreamListener xStreamListener : this._listeners) {
            xStreamListener.started();
        }
    }

    private void notifyListeners_close() {
        for (XStreamListener xStreamListener : this._listeners) {
            xStreamListener.closed();
        }
    }

    private void notifyListeners_error(Exception exception) {
        for (XStreamListener xStreamListener : this._listeners) {
            xStreamListener.error(exception);
        }
    }

    @Override
    public int read(byte[][] bytes, int nBytesToRead) throws com.sun.star.io.IOException, RuntimeException {
        if (this._firstRead) {
            this._firstRead = false;
            this.notifyListeners_open();
        }
        String errMessage = null;
        int read_bytes = 0;
        bytes[0] = new byte[nBytesToRead];
        try {
            int count;
            do {
                if ((count = this._inputStream.read(bytes[0], read_bytes, nBytesToRead - read_bytes)) != -1) continue;
                errMessage = "EOF reached - " + this.getDescription();
            } while ((read_bytes += count) >= 0 && read_bytes < nBytesToRead && count >= 0);
        }
        catch (IOException ioException) {
            errMessage = ioException.toString();
        }
        if (errMessage != null) {
            com.sun.star.io.IOException unoIOException = new com.sun.star.io.IOException(errMessage);
            this.notifyListeners_error(unoIOException);
            throw unoIOException;
        }
        return read_bytes;
    }

    @Override
    public void write(byte[] aData) throws com.sun.star.io.IOException, RuntimeException {
        try {
            this._outputStream.write(aData);
        }
        catch (IOException ioException) {
            com.sun.star.io.IOException unoIOException = new com.sun.star.io.IOException(ioException);
            this.notifyListeners_error(unoIOException);
            throw unoIOException;
        }
    }

    @Override
    public void flush() throws com.sun.star.io.IOException, RuntimeException {
        try {
            this._outputStream.flush();
        }
        catch (IOException ioException) {
            com.sun.star.io.IOException unoIOException = new com.sun.star.io.IOException(ioException);
            this.notifyListeners_error(unoIOException);
            throw unoIOException;
        }
    }

    @Override
    public void close() throws com.sun.star.io.IOException, RuntimeException {
        try {
            this._socket.close();
        }
        catch (IOException ioException) {
            com.sun.star.io.IOException unoIOException = new com.sun.star.io.IOException(ioException);
            this.notifyListeners_error(unoIOException);
            throw unoIOException;
        }
        this.notifyListeners_close();
    }

    @Override
    public String getDescription() throws RuntimeException {
        return this._description;
    }
}

