/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.server;

import java.util.Vector;
import org.netbeans.lib.profiler.global.CommonConstants;
import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.lib.profiler.server.ClassLoaderManager;
import org.netbeans.lib.profiler.server.ProfilerInterface;
import org.netbeans.lib.profiler.server.ProfilerServer;
import org.netbeans.lib.profiler.server.ThreadInfo;
import org.netbeans.lib.profiler.server.system.Classes;
import org.netbeans.lib.profiler.server.system.GC;
import org.netbeans.lib.profiler.server.system.Threads;
import org.netbeans.lib.profiler.server.system.Timers;
import org.netbeans.lib.profiler.wireprotocol.MonitoredNumbersResponse;

public class Monitors
implements CommonConstants {
    private static final boolean DEBUG = Boolean.getBoolean("org.netbeans.lib.profiler.server.Monitors");
    protected static Runtime runtime;
    protected static SurvGenAndThreadsMonitor stMonitor;
    protected static long[] generalMNums;
    protected static long[] gcRelTime;
    protected static long[] gcStartTimes;
    protected static long[] gcFinishTimes;
    private static long startTimeMilis;
    private static long startTimeCounts;
    private static boolean threadsSamplingEnabled;
    protected static long time;
    private static ActiveServerState activeServerState;
    private static final Object activeServerStateLock;
    static /* synthetic */ Class class$org$netbeans$lib$profiler$server$Monitors;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MonitoredNumbersResponse getMonitoredNumbers() {
        int n;
        int n2;
        int n3 = Threads.getTotalNumberOfThreads();
        int n4 = n3 - ThreadInfo.getLiveServerThreads();
        int n5 = ProfilerInterface.getNPrerecordedSystemThreads();
        if (n5 != -1) {
            n4 -= n5;
            if (ProfilerServer.isTargetAppMainThreadComplete()) {
                --n4;
            }
        } else {
            n5 = 0;
        }
        GC.getGCRelativeTimeMetrics(gcRelTime);
        Monitors.generalMNums[0] = runtime.freeMemory();
        Monitors.generalMNums[1] = runtime.totalMemory();
        Monitors.generalMNums[2] = n4;
        Monitors.generalMNums[3] = n5;
        Monitors.generalMNums[4] = stMonitor.getNSurvGen();
        Monitors.generalMNums[5] = gcRelTime[0];
        Monitors.generalMNums[6] = gcRelTime[1];
        Monitors.generalMNums[7] = Classes.getLoadedClassCount();
        Monitors.generalMNums[8] = Timers.getProcessCpuTime();
        Monitors.generalMNums[9] = System.currentTimeMillis();
        Object object = activeServerStateLock;
        synchronized (object) {
            n2 = Monitors.activeServerState.getServerState();
            n = Monitors.activeServerState.getProgress();
        }
        object = new MonitoredNumbersResponse(generalMNums, n2, n);
        stMonitor.getThreadsData((MonitoredNumbersResponse)object);
        Monitors.stMonitor.getGCStartFinishData((MonitoredNumbersResponse)object);
        return object;
    }

    public static void initialize() {
        runtime = Runtime.getRuntime();
        gcRelTime = new long[2];
        gcStartTimes = new long[10];
        gcFinishTimes = new long[10];
        generalMNums = new long[10];
        GC.activateGCEpochCounter(true);
        stMonitor = new SurvGenAndThreadsMonitor();
        ThreadInfo.addProfilerServerThread(stMonitor);
        startTimeMilis = System.currentTimeMillis();
        startTimeCounts = Timers.getCurrentTimeInCounts();
        activeServerState = new ActiveServerState(0);
        stMonitor.start();
    }

    static void setThreadsSamplingEnabled(boolean bl) {
        threadsSamplingEnabled = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DeterminateProgress enterServerState(int n, int n2) {
        Object object = activeServerStateLock;
        synchronized (object) {
            activeServerState = new ActiveServerState(activeServerState, n, n2);
            return activeServerState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void enterServerState(int n) {
        Object object = activeServerStateLock;
        synchronized (object) {
            activeServerState = new ActiveServerState(activeServerState, n, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void exitServerState() {
        Object object = activeServerStateLock;
        synchronized (object) {
            activeServerState = activeServerState.parent;
        }
    }

    static void recordThreadStateChange(Thread thread, byte by, long l, Object object) {
        if (threadsSamplingEnabled) {
            return;
        }
        if (l == -1L) {
            l = Timers.getCurrentTimeInCounts();
        }
        long l2 = l - startTimeCounts;
        l = startTimeMilis + (l2 /= Timers.getNoOfCountsInSecond() / 1000L);
        if (DEBUG) {
            switch (by) {
                case 3: {
                    System.err.println("Thread state change: " + thread.getName() + ", Monitor: " + l + ", monitor: " + System.identityHashCode(object));
                    break;
                }
                case 4: {
                    System.err.println("Thread state change: " + thread.getName() + ", Wait: " + l);
                    break;
                }
                case 5: {
                    System.err.println("Thread state change: " + thread.getName() + ", Park: " + l);
                    break;
                }
                case 2: {
                    System.err.println("Thread state change: " + thread.getName() + ", Sleep: " + l);
                    break;
                }
                case 1: {
                    System.err.println("Thread state change: " + thread.getName() + ", Run: " + l);
                }
            }
        }
        if (stMonitor != null) {
            stMonitor.addThreadStateChange(thread, by, l, object);
        }
    }

    public static boolean monitorThreadsStarted() {
        return Monitors.stMonitor.started;
    }

    public static void shutdown() {
        Monitors.stMonitor.terminated = true;
    }

    private static void showTime() {
        long l = Timers.getNoOfCountsInSecond();
        time = (Timers.getCurrentTimeInCounts() - time) * 1000000L / l;
        long l2 = stMonitor.getTime() * 1000000L / l;
        System.out.println("!!! time = " + time + ", time1 = " + l2 + ", sum = " + (time + l2));
    }

    static {
        activeServerStateLock = new Object();
    }

    private static class ActiveServerState
    implements DeterminateProgress {
        private final ActiveServerState parent;
        private final int serverState;
        private final int stepCount;
        private final double stepSize;
        private final boolean indeterminate;
        private int step;
        private final int id;
        private static int counter;
        static final /* synthetic */ boolean $assertionsDisabled;

        ActiveServerState(int n) {
            this(null, n, 0);
        }

        ActiveServerState(ActiveServerState activeServerState, int n, int n2) {
            this.parent = activeServerState;
            this.serverState = n;
            this.stepCount = n2;
            if (n2 == 0) {
                this.stepSize = activeServerState == null ? 1.0 : activeServerState.stepSize;
                this.indeterminate = activeServerState == null ? true : activeServerState.indeterminate;
            } else {
                this.stepSize = activeServerState == null ? 1.0 / (double)n2 : activeServerState.stepSize / (double)n2;
                this.indeterminate = false;
            }
            this.step = 0;
            this.id = counter++;
        }

        private int getServerState() {
            return this.serverState;
        }

        private int getProgress() {
            if (this.indeterminate) {
                return -1;
            }
            return (int)(this.getRealProgress() * 100.0);
        }

        private synchronized double getRealProgress() {
            double d;
            if (this.indeterminate) {
                d = 0.0;
            } else if (this.parent == null) {
                if (!$assertionsDisabled && this.stepCount != 0) {
                    throw new AssertionError((Object)"called for indeterminate state");
                }
                d = 1.0 * (double)this.step / (double)this.stepCount;
            } else {
                d = this.parent.getRealProgress() + this.parent.stepSize * (double)this.step / (double)this.stepCount;
            }
            return d;
        }

        public synchronized void next() {
            if (!$assertionsDisabled && this.stepCount <= 0) {
                throw new AssertionError((Object)"called for indeterminate progress state");
            }
            ++this.step;
            if (this.step >= this.stepCount) {
                this.step = this.stepCount - 1;
            }
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$lib$profiler$server$Monitors == null ? (class$org$netbeans$lib$profiler$server$Monitors = Monitors.class$("org.netbeans.lib.profiler.server.Monitors")) : class$org$netbeans$lib$profiler$server$Monitors).desiredAssertionStatus();
            counter = 0;
        }
    }

    static interface DeterminateProgress {
        public void next();
    }

    static class ThreadDataTable {
        private static final int INITIAL_SIZE = 23;
        private static final int INITIAL_NSTATES = 20;
        private static Object dummyObj = new Object();
        private String[] newThreadClassNames = new String[23];
        private int[] newThreadIds = new int[23];
        private String[] newThreadNames = new String[23];
        private long[] packedStateTimestamps = new long[20];
        private int[] packedThreadIds = new int[23];
        private byte[] packedThreadStates = new byte[460];
        private long[] stateSampleTimestamps;
        private int[] threadIds;
        private boolean[] threadNew;
        private byte[][] threadStates;
        private Object[] threads;
        private boolean jvmSupportsThreadSleepingState;
        private int curStateIdx = 0;
        private int curThreadId = 1;
        private int nFilledSlots = 0;
        private int nNewThreads;
        private int nStates = 20;
        private int nThreads = 0;
        private int size = 23;
        private int threshold = this.size * 3 / 4;
        private int explPos;
        private byte[] explicitStates;
        private int[] explicitThreads;
        private long[] explicitTimeStamps;

        ThreadDataTable() {
            this.threads = new Object[this.size];
            this.threadIds = new int[this.size];
            this.threadStates = new byte[this.size][this.nStates];
            this.stateSampleTimestamps = new long[this.nStates];
            this.threadNew = new boolean[this.size];
            this.jvmSupportsThreadSleepingState = Platform.thisVMSupportsThreadSleepingStateMonitoring();
        }

        public void getThreadsData(MonitoredNumbersResponse monitoredNumbersResponse) {
            Object object;
            if (this.explPos > 0) {
                int[] nArray = new int[this.explPos];
                System.arraycopy(this.explicitThreads, 0, nArray, 0, this.explPos);
                byte[] byArray = new byte[this.explPos];
                System.arraycopy(this.explicitStates, 0, byArray, 0, this.explPos);
                object = new long[this.explPos];
                System.arraycopy(this.explicitTimeStamps, 0, object, 0, this.explPos);
                monitoredNumbersResponse.setExplicitDataOnThreads(nArray, byArray, (long[])object);
                this.explicitStates = new byte[this.explPos];
                this.explicitThreads = new int[this.explPos];
                this.explicitTimeStamps = new long[this.explPos];
                this.explPos = 0;
            } else {
                int n;
                if (this.nThreads > this.packedThreadIds.length) {
                    this.packedThreadIds = new int[this.nThreads];
                }
                if (this.curStateIdx > this.packedStateTimestamps.length) {
                    this.packedStateTimestamps = new long[this.curStateIdx];
                }
                if ((n = this.nThreads * this.curStateIdx) > this.packedThreadStates.length) {
                    this.packedThreadStates = new byte[n];
                }
                int n2 = 0;
                int n3 = 0;
                for (int i = 0; i < this.size; ++i) {
                    if (this.threads[i] == null || this.threads[i] == dummyObj) continue;
                    this.packedThreadIds[n2++] = this.threadIds[i];
                    System.arraycopy(this.threadStates[i], 0, this.packedThreadStates, n3, this.curStateIdx);
                    n3 += this.curStateIdx;
                }
                System.arraycopy(this.stateSampleTimestamps, 0, this.packedStateTimestamps, 0, this.curStateIdx);
                monitoredNumbersResponse.setDataOnThreads(this.nThreads, this.curStateIdx, this.packedThreadIds, this.packedStateTimestamps, this.packedThreadStates);
            }
            if (this.nNewThreads > 0) {
                if (this.nNewThreads > this.newThreadIds.length) {
                    this.newThreadIds = new int[this.nNewThreads];
                    this.newThreadNames = new String[this.nNewThreads];
                    this.newThreadClassNames = new String[this.nNewThreads];
                }
                int n = 0;
                for (int i = 0; i < this.size; ++i) {
                    if (!this.threadNew[i]) continue;
                    this.newThreadIds[n] = this.threadIds[i];
                    object = (Thread)this.threads[i];
                    this.newThreadClassNames[n] = object.getClass().getName();
                    try {
                        this.newThreadNames[n] = ((Thread)object).getName();
                    }
                    catch (NullPointerException nullPointerException) {
                        this.newThreadNames[n] = "*Unknown thread (" + this.threadIds[i] + ")*";
                    }
                    ++n;
                }
                monitoredNumbersResponse.setDataOnNewThreads(this.nNewThreads, this.newThreadIds, this.newThreadNames, this.newThreadClassNames);
            }
        }

        public void incStatusIdx() {
            ++this.curStateIdx;
            if (this.curStateIdx == this.nStates) {
                this.growStatesArrays();
            }
        }

        public void prePut() {
            for (int i = 0; i < this.size; ++i) {
                this.threadStates[i][this.curStateIdx] = 0;
            }
            this.stateSampleTimestamps[this.curStateIdx] = System.currentTimeMillis();
        }

        public void printCurrentStatus() {
            for (int i = 0; i < this.size; ++i) {
                if (this.threads[i] == null || this.threads[i] == dummyObj) continue;
                System.err.print(((Thread)this.threads[i]).getName() + "  ");
                byte[] byArray = this.threadStates[i];
                for (int j = 0; j < this.curStateIdx; ++j) {
                    System.err.print(byArray[j]);
                }
                System.err.println();
            }
            System.err.println();
        }

        void put(Thread thread, int n) {
            int n2 = this.getPosIndex(thread);
            if (this.threads[n2] == null) {
                this.threadNew[n2] = true;
                this.threads[n2] = thread;
                ++this.curThreadId;
                ++this.nThreads;
                ++this.nNewThreads;
                ++this.nFilledSlots;
            }
            if (this.explPos > 0) {
                if (n == 0 || this.threadNew[n2]) {
                    this.addExactState(null, this.threadIds[n2], (byte)n, this.stateSampleTimestamps[this.curStateIdx]);
                }
                n = 1;
            }
            this.threadStates[n2][this.curStateIdx] = (byte)n;
            if (this.nFilledSlots > this.threshold) {
                this.growTable();
            }
        }

        private int getPosIndex(Thread thread) {
            int n = (thread.hashCode() & Integer.MAX_VALUE) % this.size;
            while (this.threads[n] != thread && this.threads[n] != null) {
                n = (n + 1) % this.size;
            }
            return n;
        }

        private void findDeathThreads() {
            if (this.explPos == 0) {
                return;
            }
            for (int i = 0; i < this.size; ++i) {
                if (this.threads[i] == null || this.threads[i] == dummyObj || this.threadStates[i][this.curStateIdx] != 0) continue;
                this.addExactState(null, this.threadIds[i], (byte)0, this.stateSampleTimestamps[this.curStateIdx]);
            }
        }

        public void resetStates() {
            this.nNewThreads = 0;
            if (this.curStateIdx == 0) {
                return;
            }
            int n = this.curStateIdx - 1;
            for (int i = 0; i < this.size; ++i) {
                if (this.threads[i] == null || this.threads[i] == dummyObj) continue;
                this.threadNew[i] = false;
                if (this.threadStates[i][n] != 0) continue;
                this.threads[i] = dummyObj;
                --this.nThreads;
            }
            this.curStateIdx = 0;
        }

        private void growStatesArrays() {
            int n = this.nStates;
            this.nStates *= 2;
            for (int i = 0; i < this.size; ++i) {
                byte[] byArray = this.threadStates[i];
                this.threadStates[i] = new byte[this.nStates];
                System.arraycopy(byArray, 0, this.threadStates[i], 0, n);
            }
            long[] lArray = this.stateSampleTimestamps;
            this.stateSampleTimestamps = new long[this.nStates];
            System.arraycopy(lArray, 0, this.stateSampleTimestamps, 0, n);
        }

        private void growTable() {
            int n;
            int n2 = this.size;
            this.size = this.nThreads * 4 / 3 * 2 + 1;
            if (this.size < n2) {
                this.size = n2;
            }
            this.threshold = this.size * 3 / 4;
            Object[] objectArray = this.threads;
            int[] nArray = this.threadIds;
            byte[][] byArray = this.threadStates;
            boolean[] blArray = this.threadNew;
            this.threads = new Object[this.size];
            this.threadIds = new int[this.size];
            this.threadStates = new byte[this.size][];
            this.threadNew = new boolean[this.size];
            for (n = 0; n < n2; ++n) {
                if (objectArray[n] == null || objectArray[n] == dummyObj) continue;
                Object object = objectArray[n];
                int n3 = (object.hashCode() & Integer.MAX_VALUE) % this.size;
                while (this.threads[n3] != null) {
                    n3 = (n3 + 1) % this.size;
                }
                this.threadNew[n3] = blArray[n];
                this.threads[n3] = object;
                this.threadIds[n3] = nArray[n];
                this.threadStates[n3] = byArray[n];
            }
            for (n = 0; n < this.size; ++n) {
                if (this.threadStates[n] != null) continue;
                this.threadStates[n] = new byte[this.nStates];
            }
            this.nFilledSlots = this.nThreads;
        }

        void addExactState(Thread thread, int n, byte by, long l) {
            int n2 = n;
            if (n2 == -1) {
                n2 = this.findThreadId(thread);
            }
            if (n2 == -1) {
                return;
            }
            if (this.explicitThreads == null) {
                this.explicitStates = new byte[20];
                this.explicitThreads = new int[20];
                this.explicitTimeStamps = new long[20];
            }
            if (this.explicitStates.length == this.explPos) {
                byte[] byArray = new byte[this.explPos * 2];
                System.arraycopy(this.explicitStates, 0, byArray, 0, this.explicitStates.length);
                this.explicitStates = byArray;
                int[] nArray = new int[this.explPos * 2];
                System.arraycopy(this.explicitThreads, 0, nArray, 0, this.explicitThreads.length);
                this.explicitThreads = nArray;
                long[] lArray = new long[this.explPos * 2];
                System.arraycopy(this.explicitTimeStamps, 0, lArray, 0, this.explicitTimeStamps.length);
                this.explicitTimeStamps = lArray;
            }
            this.explicitStates[this.explPos] = by;
            this.explicitThreads[this.explPos] = n2;
            this.explicitTimeStamps[this.explPos] = l;
            ++this.explPos;
        }

        private int findThreadId(Thread thread) {
            int n = this.getPosIndex(thread);
            if (this.threads[n] == thread) {
                return this.threadIds[n];
            }
            return -1;
        }
    }

    static class SurvGenAndThreadsMonitor
    extends Thread {
        public volatile boolean started;
        public volatile boolean terminated;
        private LongList gcFinishs;
        private LongList gcStarts;
        private ThreadDataTable threadTable;
        private Vector markerObjects;
        private int[] allThreadStatusRough;
        private Thread[] allThreadsRough;
        private int savedGCEpoch = GC.getCurrentGCEpoch();
        private long lastGCFinish;
        private long lastGCStart;
        private long time;
        private long time0;

        SurvGenAndThreadsMonitor() {
            super("*** JFluid Monitor thread ***");
            this.markerObjects = new Vector();
            this.allThreadsRough = new Thread[20];
            this.allThreadStatusRough = new int[20];
            this.threadTable = new ThreadDataTable();
            this.gcStarts = new LongList(16);
            this.gcFinishs = new LongList(16);
            this.setPriority(10);
            this.setDaemon(true);
        }

        public int getNSurvGen() {
            return this.markerObjects.size();
        }

        public synchronized void getThreadsData(MonitoredNumbersResponse monitoredNumbersResponse) {
            this.threadTable.getThreadsData(monitoredNumbersResponse);
            this.threadTable.resetStates();
        }

        public long getTime() {
            long l = this.time;
            this.time = 0L;
            return l;
        }

        public synchronized void addThreadStateChange(Thread thread, byte by, long l, Object object) {
            if (this.started && !this.terminated) {
                this.threadTable.addExactState(thread, -1, by, l);
            }
        }

        public void run() {
            this.started = true;
            int n = 3;
            while (!this.terminated) {
                this.updateSurvGenData();
                this.updateThreadsData();
                this.updateGCStartFinishData();
                if (--n == 0) {
                    ClassLoaderManager.checkForUnloadedClasses();
                    n = 3;
                }
                ThreadInfo.releaseDeadThreads();
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
            ThreadInfo.removeProfilerServerThread(this);
        }

        synchronized void updateGCStartFinishData() {
            long l = this.lastGCStart;
            long l2 = this.lastGCFinish;
            GC.getGCStartFinishTimes(gcStartTimes, gcFinishTimes);
            for (int i = 0; i < 10; ++i) {
                long l3 = gcStartTimes[i];
                long l4 = gcFinishTimes[i];
                if (l3 > this.lastGCStart) {
                    this.gcStarts.add(l3 & 0xFFFFFFFFFFFFFFL);
                    l = l3;
                }
                if (l4 <= this.lastGCFinish) continue;
                this.gcFinishs.add(l4 & 0xFFFFFFFFFFFFFFL);
                l2 = l4;
            }
            this.lastGCStart = l;
            this.lastGCFinish = l2;
        }

        private synchronized void getGCStartFinishData(MonitoredNumbersResponse monitoredNumbersResponse) {
            long[] lArray = this.gcStarts.getArray();
            long[] lArray2 = this.gcFinishs.getArray();
            this.gcStarts.clear();
            this.gcFinishs.clear();
            monitoredNumbersResponse.setGCstartFinishData(lArray, lArray2);
        }

        private void updateSurvGenData() {
            int n = GC.getCurrentGCEpoch();
            if (n != this.savedGCEpoch) {
                this.markerObjects.add(new Object());
                this.savedGCEpoch = n;
                int n2 = this.markerObjects.size() - 1;
                int n3 = n2 + 1;
                for (int i = 0; i < n2; ++i) {
                    if (!GC.objectsAdjacent(this.markerObjects.get(i), this.markerObjects.get(i + 1))) continue;
                    this.markerObjects.remove(i);
                    --i;
                    --n2;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateThreadsData() {
            Thread thread = ProfilerServer.isTargetAppMainThreadComplete() ? ProfilerServer.getMainThread() : null;
            this.allThreadsRough = Threads.getAllThreads(this.allThreadsRough);
            if (this.allThreadStatusRough.length < this.allThreadsRough.length) {
                this.allThreadStatusRough = new int[this.allThreadsRough.length];
            }
            Threads.getThreadsStatus(this.allThreadsRough, this.allThreadStatusRough);
            if (DEBUG) {
                for (int i = 0; i < this.allThreadsRough.length && this.allThreadsRough[i] != null; ++i) {
                    System.err.println("org.netbeans.lib.profiler.server.Monitors.DEBUG: " + this.allThreadsRough[i].getName() + ", status: " + this.allThreadStatusRough[i]);
                }
            }
            SurvGenAndThreadsMonitor survGenAndThreadsMonitor = this;
            synchronized (survGenAndThreadsMonitor) {
                Thread thread2;
                this.threadTable.prePut();
                for (int i = 0; i < this.allThreadsRough.length && (thread2 = this.allThreadsRough[i]) != null; ++i) {
                    if (thread2 == this || thread2 == thread || ThreadInfo.isProfilerServerThread(thread2)) continue;
                    this.threadTable.put(thread2, this.allThreadStatusRough[i]);
                }
                this.threadTable.findDeathThreads();
                this.threadTable.incStatusIdx();
            }
            if (DEBUG) {
                System.err.println("Final thread table: ");
                this.threadTable.printCurrentStatus();
            }
        }
    }

    static class LongList {
        long[] data;
        int size;

        LongList(int n) {
            this.data = new long[n];
        }

        long[] getArray() {
            long[] lArray = new long[this.size];
            System.arraycopy(this.data, 0, lArray, 0, this.size);
            return lArray;
        }

        void add(long l) {
            this.ensureSize();
            this.data[this.size++] = l;
        }

        void clear() {
            this.size = 0;
        }

        void ensureSize() {
            if (this.size >= this.data.length) {
                int n = this.size * 3 / 2 + 1;
                long[] lArray = new long[n];
                System.arraycopy(this.data, 0, lArray, 0, this.size);
                this.data = lArray;
            }
        }
    }
}

