/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.modules.profiler.snaptracer.impl.swing.HorizontalLayout;

public final class TransparentToolBar
extends JPanel {
    private static Boolean NEEDS_PANEL;
    private static Boolean CUSTOM_FILLER;
    private final JToolBar toolbar;
    private final ItemListener listener = new ItemListener();

    public TransparentToolBar() {
        this.toolbar = TransparentToolBar.needsPanel() ? null : new JToolBar();
        this.setOpaque(false);
        if (this.toolbar == null) {
            this.setLayout(new HorizontalLayout(false));
        } else {
            this.toolbar.setBorderPainted(false);
            this.toolbar.setFloatable(false);
            this.toolbar.setRollover(true);
            this.toolbar.setOpaque(false);
            this.toolbar.setBorder(BorderFactory.createEmptyBorder());
            this.setLayout(new BorderLayout());
            this.add((Component)this.toolbar, "Center");
        }
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                if ((hierarchyEvent.getChangeFlags() & 4L) != 0L && TransparentToolBar.this.isShowing()) {
                    TransparentToolBar.this.removeHierarchyListener(this);
                    for (Component component : TransparentToolBar.this.getComponents()) {
                        if (!(component instanceof AbstractButton)) continue;
                        TransparentToolBar.this.listener.refresh((AbstractButton)component);
                    }
                }
            }
        });
    }

    public void addItem(JComponent jComponent) {
        jComponent.setOpaque(false);
        if (jComponent instanceof JButton) {
            ((JButton)jComponent).setDefaultCapable(false);
        }
        if (this.toolbar != null) {
            this.toolbar.add(jComponent);
        } else {
            this.add(jComponent);
            if (jComponent instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)jComponent;
                abstractButton.addMouseListener(this.listener);
                abstractButton.addChangeListener(this.listener);
                abstractButton.addFocusListener(this.listener);
                abstractButton.setRolloverEnabled(true);
            }
        }
    }

    public void removeItem(JComponent jComponent) {
        if (this.toolbar != null) {
            this.toolbar.remove(jComponent);
        } else {
            if (jComponent instanceof AbstractButton) {
                jComponent.removeMouseListener(this.listener);
                ((AbstractButton)jComponent).removeChangeListener(this.listener);
                jComponent.removeFocusListener(this.listener);
            }
            this.remove(jComponent);
        }
    }

    public void addSeparator() {
        JToolBar.Separator separator = new JToolBar.Separator();
        separator.setOrientation(1);
        this.addItem(separator);
    }

    public void addFiller() {
        Dimension dimension = new Dimension(0, 0);
        Dimension dimension2 = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        final boolean bl = TransparentToolBar.customFiller();
        Box.Filler filler = new Box.Filler(dimension, dimension, dimension2){

            @Override
            public Dimension getPreferredSize() {
                if (bl) {
                    int n = TransparentToolBar.this.getSize().width;
                    int n2 = TransparentToolBar.this.getMinimumSize().width;
                    int n3 = n - n2;
                    return new Dimension(Math.max(n3, 0), 0);
                }
                return super.getPreferredSize();
            }

            @Override
            protected void paintComponent(Graphics graphics) {
            }
        };
        this.addItem(filler);
    }

    private static boolean needsPanel() {
        if (NEEDS_PANEL == null) {
            NEEDS_PANEL = UIUtils.isGTKLookAndFeel();
        }
        return NEEDS_PANEL;
    }

    private static boolean customFiller() {
        if (CUSTOM_FILLER == null) {
            CUSTOM_FILLER = UIUtils.isGTKLookAndFeel() || UIUtils.isNimbusLookAndFeel();
        }
        return CUSTOM_FILLER;
    }

    private static final class ItemListener
    extends MouseAdapter
    implements ChangeListener,
    FocusListener {
        private static final String PROP_HOVERED = "BUTTON_HOVERED";

        private ItemListener() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
            abstractButton.putClientProperty(PROP_HOVERED, Boolean.TRUE);
            this.refresh(abstractButton);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
            abstractButton.putClientProperty(PROP_HOVERED, Boolean.FALSE);
            this.refresh(abstractButton);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.refresh((AbstractButton)changeEvent.getSource());
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.refresh((AbstractButton)focusEvent.getSource());
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.refresh((AbstractButton)focusEvent.getSource());
        }

        private void refresh(AbstractButton abstractButton) {
            abstractButton.setBackground(UIUtils.getProfilerResultsBackground());
            boolean bl = Boolean.TRUE.equals(abstractButton.getClientProperty(PROP_HOVERED));
            boolean bl2 = abstractButton.isEnabled() && (bl || abstractButton.isSelected() || abstractButton.isFocusOwner());
            abstractButton.setOpaque(bl2);
            abstractButton.setContentAreaFilled(bl2);
            abstractButton.repaint();
        }
    }
}

