/*
 * Copyright (c) 2012, 2019, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_am extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_DE = "\u1300\u122d\u1218\u1295";
        final String metaValue_GR = "\u130d\u122a\u12ad";
        final String metaValue_NR = "\u1293\u12a1\u1229";
        final String metaValue_ar = "\u12d3\u1228\u1265\u129b";
        final String metaValue_ja = "\u1303\u1353\u1295\u129b";
        final String metaValue_ko = "\u12ae\u122a\u12eb\u129b";
        final String metaValue_type_colHiraganaQuaternary_no = "\u12ab\u1293 \u1208\u12ed\u1270\u1205 \u12f0\u122d\u12f5\u122d";
        final Object[][] data = new Object[][] {
            { "ksh", "\u12ae\u120e\u129d\u12eb\u1295" },
            { "key.colStrength", "\u12e8\u12f5\u122d\u12f0\u122b \u12a0\u1245\u121d" },
            { "Zsym", "\u121d\u120d\u12ad\u1276\u127d" },
            { "cch", "\u12a0\u1275\u1233\u121d" },
            { "egy", "\u12e8\u1325\u1295\u1273\u12ca \u130d\u1265\u133d\u129b" },
            { "teo", "\u1274\u1236" },
            { "AC", "\u12a0\u1234\u1295\u123d\u1295 \u12f0\u1234\u1275" },
            { "tet", "\u1274\u1270\u121d" },
            { "AD", "\u12a0\u1295\u12f6\u122b" },
            { "AE", "\u12e8\u1270\u1263\u1260\u1229\u1275 \u12a0\u1228\u1265 \u12a4\u121d\u122c\u1275\u1235" },
            { "nl_BE", "\u134d\u120c\u121a\u123d" },
            { "AF", "\u12a0\u134d\u130b\u1292\u1235\u1273\u1295" },
            { "AG", "\u12a0\u1295\u1272\u1313 \u12a5\u1293 \u1263\u1229\u12f3" },
            { "type.ca.ethiopic", "\u12e8\u12a2\u1275\u12ee\u1335\u12eb \u12e8\u1240\u1295 \u12a0\u1246\u1323\u1320\u122d" },
            { "AI", "\u12a0\u1295\u1309\u12a2\u120b" },
            { "key.tz", "\u12e8\u1230\u12d3\u1275 \u1230\u1245" },
            { "AL", "\u12a0\u120d\u1263\u1292\u12eb" },
            { "AM", "\u12a0\u122d\u121c\u1292\u12eb" },
            { "AO", "\u12a0\u1295\u1310\u120b" },
            { "AQ", "\u12a0\u1295\u1273\u122d\u12ad\u1272\u12ab" },
            { "AR", "\u12a0\u122d\u1300\u1295\u1272\u1293" },
            { "AS", "\u12e8\u12a0\u121c\u122a\u12ab \u1233\u121e\u12a0" },
            { "AT", "\u12a6\u1235\u1275\u122a\u12eb" },
            { "AU", "\u12a0\u12cd\u1235\u1275\u122b\u120d\u12eb" },
            { "AW", "\u12a0\u1229\u1263" },
            { "en_US", "\u12e8\u12a0\u121c\u122a\u12ab \u12a5\u1295\u130d\u120a\u12dd\u129b" },
            { "AX", "\u12e8\u12a0\u120b\u1295\u12f5 \u12f0\u1234\u1276\u127d" },
            { "key.colNormalization", "\u1218\u12f0\u1260\u129b \u12f5\u122d\u12f0\u122b" },
            { "AZ", "\u12a0\u12d8\u122d\u1263\u1303\u1295" },
            { "BA", "\u1266\u1235\u1292\u12eb \u12a5\u1293 \u1204\u122d\u12de\u130e\u126a\u1292\u12eb" },
            { "BB", "\u1263\u122d\u1264\u12f6\u1235" },
            { "ceb", "\u12ab\u1261\u12cb\u1296" },
            { "BD", "\u1263\u1295\u130d\u120b\u12f2\u123d" },
            { "BE", "\u1264\u120d\u1304\u121d" },
            { "BF", "\u1261\u122d\u12aa\u1293 \u134b\u1236" },
            { "BG", "\u1261\u120d\u130c\u122a\u12eb" },
            { "BH", "\u1263\u1205\u122c\u1295" },
            { "BI", "\u1265\u1229\u1295\u12f2" },
            { "BJ", "\u1264\u1292\u1295" },
            { "BL", "\u1245\u12f1\u1235 \u1260\u122d\u1274\u120e\u121c" },
            { "BM", "\u1264\u122d\u1219\u12f3" },
            { "BN", "\u1265\u1229\u1292" },
            { "BO", "\u1266\u120a\u126a\u12eb" },
            { "BQ", "\u12e8\u12ab\u122a\u1262\u12eb\u1295 \u1294\u12d8\u122d\u120b\u1295\u12f5\u1235" },
            { "BR", "\u1265\u122b\u12da\u120d" },
            { "BS", "\u1263\u1203\u121b\u1235" },
            { "xog", "\u1236\u130b" },
            { "BT", "\u1261\u1205\u1273\u1295" },
            { "BV", "\u1261\u126c\u1275 \u12f0\u1234\u1275" },
            { "BW", "\u1266\u1275\u1235\u12cb\u1293" },
            { "BY", "\u1264\u120b\u1229\u1235" },
            { "BZ", "\u1264\u120a\u12d8" },
            { "type.ca.persian", "\u12e8\u1350\u122d\u123d\u12eb \u12e8\u1240\u1295 \u12a0\u1246\u1323\u1320\u122d" },
            { "type.nu.hebr", "\u12e8\u12a5\u1265\u122b\u12ed\u1235\u1325 \u1241\u1325\u122e\u127d" },
            { "CA", "\u12ab\u1293\u12f3" },
            { "CC", "\u12ae\u12ae\u1235(\u12ac\u120a\u1295\u130d) \u12f0\u1234\u1276\u127d" },
            { "mzn", "\u121b\u12db\u1295\u12f0\u122b\u1292" },
            { "CD", "\u12ae\u1295\u130e-\u12aa\u1295\u123b\u1233" },
            { "CF", "\u12e8\u1218\u12ab\u12a8\u1208\u129b\u12cd \u12a0\u134d\u122a\u12ab \u122a\u1350\u1265\u120a\u12ad" },
            { "CG", "\u12ae\u1295\u130e \u1265\u122b\u12db\u126a\u120d" },
            { "CH", "\u1235\u12ca\u12d8\u122d\u120b\u1295\u12f5" },
            { "CI", "\u12ae\u1275 \u12f2\u126f\u122d" },
            { "CK", "\u12a9\u12ad \u12f0\u1234\u1276\u127d" },
            { "CL", "\u127a\u120a" },
            { "CM", "\u12ab\u121c\u1229\u1295" },
            { "CN", "\u127b\u12ed\u1293" },
            { "CO", "\u12ae\u120e\u121d\u1262\u12eb" },
            { "CP", "\u12ad\u120a\u1350\u122d\u1276\u1295 \u12f0\u1234\u1275" },
            { "CR", "\u12ae\u1235\u1273 \u122a\u12ab" },
            { "CU", "\u12a9\u1263" },
            { "CV", "\u12ac\u1355 \u126c\u122d\u12f4" },
            { "CW", "\u12a9\u122b\u1233\u12ce" },
            { "CX", "\u12e8\u1308\u1293 \u12f0\u1234\u1275" },
            { "CY", "\u1233\u12ed\u1355\u1228\u1235" },
            { "CZ", "\u127c\u12ad \u122a\u1351\u1265\u120a\u12ad" },
            { "DE", metaValue_DE },
            { "ace", "\u12a0\u127b\u12ed\u1295\u129b" },
            { "cgg", "\u127a\u130b\u129b" },
            { "DG", "\u12f2\u12ec\u130e \u130b\u122d\u123a\u12eb" },
            { "type.nu.deva", "\u12e8\u12f4\u126b\u1295\u130b\u122a \u12a0\u1203\u12de\u127d" },
            { "DJ", "\u1302\u1261\u1272" },
            { "type.colNumeric.no", "\u12a0\u1203\u12de\u127d\u1295 \u1260\u12e8\u130d\u120d \u12f0\u122d\u12f5\u122d" },
            { "DK", "\u12f4\u1295\u121b\u122d\u12ad" },
            { "ach", "\u12a0\u12ae\u120a\u129b" },
            { "Brai", "\u1265\u122c\u12ed\u120d" },
            { "DM", "\u12f6\u121a\u1292\u12ab" },
            { "type.nu.armnlow", "\u12e8\u12a0\u121c\u122a\u12ab\u1295 \u1295\u12d1\u1235 \u1206\u1204 \u12a0\u1203\u12de\u127d" },
            { "DO", "\u12f6\u121a\u1292\u12ad \u122a\u1351\u1265\u120a\u12ad" },
            { "key.variableTop", "\u12a5\u1295\u12f0\u121d\u120d\u12ad\u1276\u127d \u12f0\u122d\u12f5\u122d" },
            { "tig", "\u1275\u130d\u1228" },
            { "DZ", "\u12a0\u120d\u1304\u122a\u12eb" },
            { "EA", "\u1234\u12a1\u1273\u1293 \u121c\u120a\u120b" },
            { "chb", "\u127a\u1265\u127b" },
            { "EC", "\u12a2\u12b3\u12f6\u122d" },
            { "ada", "\u12a0\u12f3\u1295\u130d\u121c" },
            { "EE", "\u12a4\u1235\u1276\u1292\u12eb" },
            { "EG", "\u130d\u1265\u133d" },
            { "EH", "\u121d\u12d5\u122b\u1263\u12ca \u1233\u1205\u122b" },
            { "chg", "\u127b\u130b\u1273\u12ed" },
            { "type.colNormalization.yes", "\u12e9\u1292\u12ae\u12f5 \u1260\u1218\u12f0\u1260\u129b \u1201\u1294\u1273 \u12f0\u122d\u12f5\u122d" },
            { "chk", "\u1279\u12ad\u1235" },
            { "chn", "\u127a\u1291\u12ad \u1303\u122d\u130e\u1295" },
            { "chp", "\u127a\u1354\u12cd\u12eb\u1295" },
            { "cho", "\u127e\u12ad\u1273\u12cb" },
            { "chr", "\u127c\u122e\u12ac\u129b" },
            { "ER", "\u12a4\u122d\u1275\u122b" },
            { "ES", "\u1235\u1354\u1295" },
            { "ET", "\u12a2\u1275\u12ee\u1335\u12eb" },
            { "EU", "\u12e8\u12a0\u12cd\u122e\u1353 \u1205\u1265\u1228\u1275" },
            { "type.ca.gregorian", "\u12e8\u130d\u122a\u130e\u122a\u12eb\u1295 \u12e8\u1240\u1295 \u12a0\u1246\u1323\u1320\u122d" },
            { "chy", "\u127d\u12ec\u1294" },
            { "type.nu.gujr", "\u12e8\u1309\u1303\u122b\u1272 \u12a0\u1203\u12de\u127d" },
            { "ady", "\u12a0\u12f5\u12ed\u130d\u1204" },
            { "FI", "\u134a\u1295\u120b\u1295\u12f5" },
            { "FJ", "\u134a\u1302" },
            { "FK", "\u12e8\u134e\u12ad\u120b\u1295\u12f5 \u12f0\u1234\u1276\u127d" },
            { "FM", "\u121a\u12ad\u122e\u1294\u12e2\u12eb" },
            { "key.va", "\u12e8\u12a0\u12ab\u1263\u1262 \u12a0\u12ed\u1290\u1275" },
            { "FO", "\u12e8\u134b\u122e \u12f0\u1234\u1276\u127d" },
            { "Taml", "\u1273\u121a\u120d" },
            { "FR", "\u1348\u1228\u1295\u1233\u12ed" },
            { "type.ca.indian", "\u12e8\u1205\u1295\u12f5 \u1265\u1214\u122b\u12ca \u12e8\u1240\u1295 \u12a0\u1246\u1323\u1320\u122d" },
            { "grc", "\u12e8\u1325\u1295\u1273\u12ca \u130d\u122a\u12ad" },
            { "GA", "\u130b\u1266\u1295" },
            { "GB", "\u12a5\u1295\u130d\u120a\u12dd" },
            { "GD", "\u130d\u122c\u1293\u12f3" },
            { "GE", "\u1306\u122d\u1302\u12eb" },
            { "GF", "\u12e8\u1348\u1228\u1295\u1233\u12ed \u1309\u12ca\u12a0\u1293" },
            { "GG", "\u1309\u122d\u1290\u1232" },
            { "GH", "\u130b\u1293" },
            { "GI", "\u1302\u1265\u122b\u120d\u1270\u122d" },
            { "afh", "\u12a0\u134d\u122a\u1202\u120a" },
            { "GL", "\u130d\u122a\u1295\u120b\u1295\u12f5" },
            { "GM", "\u130b\u121d\u1262\u12eb" },
            { "GN", "\u130a\u1292" },
            { "GP", "\u1309\u12cb\u12f0\u1209\u1355" },
            { "GQ", "\u12a2\u12b3\u1276\u122a\u12eb\u120d \u130a\u1292" },
            { "GR", metaValue_GR },
            { "GS", "\u12f0\u1261\u1265 \u1306\u122d\u1302\u12eb \u12a5\u1293 \u12e8\u12f0\u1261\u1265 \u1233\u1295\u12f5\u12ca\u127d \u12f0\u1234\u1276\u127d" },
            { "GT", "\u1309\u12cb\u1272\u121b\u120b" },
            { "GU", "\u1309\u12cb\u121d" },
            { "GW", "\u130a\u1292 \u1262\u1233\u12a6" },
            { "tlh", "\u12ad\u120a\u1295\u130e\u1295\u129b" },
            { "GY", "\u1309\u12eb\u1293" },
            { "ckb", "\u12e8\u1236\u122b\u1292 \u12a9\u122d\u12f5\u129b" },
            { "zxx", "\u124b\u1295\u124b\u12ca \u12ed\u12d8\u1275 \u12a0\u12ed\u12f0\u1208\u121d" },
            { "de_AT", "\u12e8\u12a6\u1235\u1275\u122a\u12eb \u1300\u122d\u1218\u1295" },
            { "HK", "\u1206\u1295\u130d \u12ae\u1295\u130d SAR \u127b\u12ed\u1293" },
            { "HM", "\u12bd\u122d\u12f5 \u12f0\u1234\u1276\u127d\u1293 \u121b\u12ad\u12f6\u1293\u120d\u12f5 \u12f0\u1234\u1276\u127d" },
            { "HN", "\u1206\u1295\u12f1\u122b\u1235" },
            { "HR", "\u12ad\u122e\u12a4\u123d\u12eb" },
            { "agq", "\u12a0\u1308\u121d" },
            { "gsw", "\u12e8\u1235\u12ca\u12dd \u1300\u122d\u1218\u1295" },
            { "HT", "\u1200\u12ed\u1272" },
            { "HU", "\u1200\u1295\u130b\u122a" },
            { "IC", "\u12e8\u12ab\u1293\u122a \u12f0\u1234\u1276\u127d" },
            { "ID", "\u12a2\u1295\u12f6\u1294\u12e2\u12eb" },
            { "IE", "\u12a0\u12e8\u122d\u120b\u1295\u12f5" },
            { "naq", "\u1293\u121b" },
            { "IL", "\u12a5\u1235\u122b\u12a4\u120d" },
            { "IM", "\u12a0\u12ed\u120d \u12a6\u134d \u121b\u1295" },
            { "IN", "\u1205\u1295\u12f5" },
            { "IO", "\u12e8\u1265\u122a\u1273\u1292\u12eb \u1205\u1295\u12f5 \u12cd\u1242\u12eb\u1296\u1235 \u130d\u12db\u1275" },
            { "IQ", "\u12a2\u122b\u1245" },
            { "IR", "\u12a2\u122b\u1295" },
            { "IS", "\u12a0\u12ed\u1235\u120b\u1295\u12f5" },
            { "IT", "\u1323\u120a\u12eb\u1295" },
            { "type.nu.thai", "\u12e8\u1273\u12ed \u12a0\u1203\u12de\u127d" },
            { "type.nu.beng", "\u12e8\u1264\u1295\u130b\u120a \u12a0\u1203\u12de\u127d" },
            { "JE", "\u1300\u122d\u1232" },
            { "type.ca.islamic", "\u12e8\u12a5\u1235\u120b\u121b\u12ca \u12e8\u1230\u12d3\u1275 \u12a0\u1246\u1323\u1320\u122d" },
            { "JM", "\u1303\u121b\u12ed\u12ab" },
            { "Beng", "\u1264\u1295\u130b\u120a" },
            { "JO", "\u1306\u122d\u12f3\u1295" },
            { "JP", "\u1303\u1353\u1295" },
            { "ain", "\u12a0\u12ed\u1291" },
            { "guz", "\u1309\u1235\u120a\u129b" },
            { "type.nu.knda", "\u12e8\u12ab\u1295\u12a0\u12f3 \u12a0\u1203\u12de\u127d" },
            { "de_CH", "\u12e8\u1235\u12ca\u12dd \u12a8\u134d\u1270\u129b \u1300\u122d\u1218\u1295\u129b" },
            { "type.co.phonetic", "\u12e8\u134e\u1290\u1272\u12ad \u12f5\u122d\u12f0\u122b \u1245\u12f0\u121d \u1270\u12a8\u1270\u120d" },
            { "type.ca.buddhist", "\u12e8\u1261\u12f2\u1235\u1275 \u1240\u1295 \u12a0\u1246\u1323\u1320\u122d" },
            { "KE", "\u12ac\u1295\u12eb" },
            { "419", "\u120b\u1272\u1295 \u12a0\u121c\u122a\u12ab" },
            { "KG", "\u12aa\u122d\u130a\u1235\u1273\u1295" },
            { "KH", "\u12ab\u121d\u1266\u12f2\u12eb" },
            { "KI", "\u12aa\u122a\u1263\u1272" },
            { "KM", "\u12ae\u121e\u122e\u1235" },
            { "KN", "\u1245\u12f1\u1235 \u12aa\u1275\u1235 \u12a5\u1293 \u1294\u126a\u1235" },
            { "Knda", "\u12ab\u1295\u12a0\u12f3" },
            { "fr_CA", "\u12e8\u12ab\u1293\u12f3 \u1348\u1228\u1295\u1233\u12ed\u129b" },
            { "KP", "\u1230\u121c\u1295 \u12ae\u122a\u12eb" },
            { "KR", "\u12f0\u1261\u1265 \u12ae\u122a\u12eb" },
            { "fr_CH", "\u12e8\u1235\u12ca\u12dd \u1348\u1228\u1295\u1233\u12ed\u129b" },
            { "KW", "\u12ad\u12cc\u1275" },
            { "tpi", "\u1276\u12ad \u1352\u1232\u1295" },
            { "KY", "\u12ab\u12ed\u121b\u1295 \u12f0\u1234\u1276\u127d" },
            { "KZ", "\u12ab\u12db\u12aa\u1235\u1273\u1295" },
            { "Cyrl", "\u1232\u12ed\u122a\u120d\u12ad" },
            { "LA", "\u120b\u12a6\u1235" },
            { "LB", "\u120a\u1263\u1296\u1235" },
            { "LC", "\u1234\u1295\u1275 \u1209\u127a\u12eb" },
            { "nds", "\u12e8\u1273\u127d\u129b\u12cd \u1300\u122d\u1218\u1295" },
            { "LI", "\u120a\u127d\u1270\u1295\u1235\u1273\u12ed\u1295" },
            { "LK", "\u1232\u122a\u120b\u1295\u12ab" },
            { "akk", "\u12a0\u12ab\u12f2\u12eb\u1295" },
            { "cop", "\u12ae\u1355\u1272\u12ad" },
            { "LR", "\u120b\u12ed\u1264\u122a\u12eb" },
            { "esu", "\u1234\u1295\u1270\u122b\u120d \u12e9\u1352\u12ad" },
            { "LS", "\u120c\u1236\u1276" },
            { "LT", "\u120a\u1271\u12cc\u1292\u12eb" },
            { "LU", "\u1209\u12ad\u1230\u121d\u1260\u122d\u130d" },
            { "LV", "\u120b\u1275\u126a\u12eb" },
            { "Kana", "\u12ab\u1273\u12ab\u1293" },
            { "LY", "\u120a\u1262\u12eb" },
            { "vun", "\u1269\u1295\u1306" },
            { "akz", "\u12a0\u120b\u1263\u121b" },
            { "lag", "\u120b\u1295\u130a" },
            { "Thaa", "\u1273\u1293" },
            { "MA", "\u121e\u122e\u12ae" },
            { "MC", "\u121e\u1293\u12ae" },
            { "MD", "\u121e\u120d\u12f6\u126b" },
            { "ME", "\u121e\u1295\u1270\u1294\u130d\u122e" },
            { "MF", "\u1234\u1295\u1275 \u121b\u122d\u1272\u1295" },
            { "MG", "\u121b\u12f3\u130b\u1235\u12ab\u122d" },
            { "MH", "\u121b\u122d\u123b\u120d \u12a0\u12ed\u120b\u1295\u12f5" },
            { "ale", "\u12a0\u120d\u12e9\u1275" },
            { "Thai", "\u1273\u12ed" },
            { "type.nu.vaii", "\u12e8\u126b\u12ed \u12a0\u1203\u12de\u127d" },
            { "MK", "\u1218\u1244\u12f6\u1295\u12eb" },
            { "ML", "\u121b\u120a" },
            { "MM", "\u121b\u12ed\u1293\u121b\u122d(\u1260\u122d\u121b)" },
            { "MN", "\u121e\u1295\u130e\u120a\u12eb" },
            { "MO", "\u121b\u12ab\u12a1 \u120d\u12e9 \u12e8\u12a0\u1235\u1270\u12f3\u12f0\u122d \u12ad\u120d\u120d \u127b\u12ed\u1293" },
            { "MP", "\u12e8\u1230\u121c\u1293\u12ca \u121b\u122a\u12eb\u1293 \u12f0\u1234\u1276\u127d" },
            { "MQ", "\u121b\u122d\u1272\u1292\u12ad" },
            { "MR", "\u121e\u122a\u1274\u1292\u12eb" },
            { "MS", "\u121e\u1295\u1275\u1234\u122b\u1275" },
            { "type.colAlternate.non-ignorable", "\u121d\u120d\u12ad\u1276\u127d\u1295 \u12f0\u122d\u12f5\u122d" },
            { "MT", "\u121b\u120d\u1273" },
            { "cps", "\u12ab\u1352\u12dd\u1296\u1295" },
            { "MU", "\u121e\u122a\u1238\u1235" },
            { "MV", "\u121b\u120d\u12f2\u126d\u1235" },
            { "MW", "\u121b\u120b\u12ca" },
            { "MX", "\u121c\u12ad\u1232\u12ae" },
            { "type.ca.japanese", "\u12e8\u1303\u1353\u1295 \u12e8\u1240\u1295 \u12a0\u1246\u1323\u1320\u122d" },
            { "MY", "\u121b\u120c\u12e2\u12eb" },
            { "MZ", "\u121e\u12db\u121d\u1262\u12ad" },
            { "NA", "\u1293\u121a\u1262\u12eb" },
            { "type.ca.hebrew", "\u12e8\u12a5\u1265\u122b\u12ca\u12eb\u1295 \u12e8\u1240\u1295 \u12a0\u1246\u1323\u1320\u122d" },
            { "type.co.dictionary", "\u12e8\u1218\u12dd\u1308\u1260 \u1243\u120b\u1275 \u12e8\u12f5\u122d\u12f5\u122d \u1245\u12f0\u121d \u1270\u12a8\u1270\u120d" },
            { "NC", "\u1292\u12cd \u12ab\u120c\u12f6\u1292\u12eb" },
            { "NE", "\u1292\u1300\u122d" },
            { "NF", "\u1296\u122d\u134e\u120d\u12ad \u12f0\u1234\u1275" },
            { "NG", "\u1293\u12ed\u1304\u122a\u12eb" },
            { "NI", "\u1292\u12ab\u122b\u1313" },
            { "NL", "\u1294\u12d8\u122d\u120b\u1295\u12f5" },
            { "NO", "\u1296\u122d\u12cc\u12ed" },
            { "NP", "\u1294\u1353\u120d" },
            { "NR", metaValue_NR },
            { "NU", "\u1292\u12a1\u12ed" },
            { "rof", "\u122e\u121d\u1266" },
            { "NZ", "\u1292\u12cd \u12da\u120b\u1295\u12f5" },
            { "crh", "\u12ad\u122a\u121a\u12eb\u1295 \u1270\u122d\u12aa\u123d" },
            { "type.colAlternate.shifted", "\u127d\u120b \u1263\u12ed \u121d\u120d\u12ad\u1276\u127d\u1295 \u12f0\u122d\u12f5\u122d" },
            { "OM", "\u12a6\u121b\u1295" },
            { "anp", "\u12a0\u1295\u130a\u12ab" },
            { "PA", "\u1353\u1293\u121b" },
            { "type.ca.islamic-civil", "\u12e8\u12a5\u1235\u120b\u121d \u1205\u12dd\u1263\u12ca \u12e8\u1240\u1295 \u12a0\u1246\u1323\u1320\u122d" },
            { "en_GB", "\u12e8\u1265\u122a\u1272\u123d \u12a5\u1295\u130d\u120a\u12dd\u129b" },
            { "PE", "\u1354\u1229" },
            { "PF", "\u12e8\u1348\u1228\u1295\u1233\u12ed \u1356\u120a\u1294\u12e2\u12eb" },
            { "PG", "\u1353\u1351\u12cb \u1292\u12cd \u130a\u1292" },
            { "PH", "\u134a\u120a\u1352\u1295\u1235" },
            { "PK", "\u1353\u12aa\u1235\u1273\u1295" },
            { "PL", "\u1356\u120b\u1295\u12f5" },
            { "PM", "\u1245\u12f1\u1235 \u1352\u12ec\u122d \u12a5\u1293 \u121a\u12a9\u12a4\u120e\u1295" },
            { "PN", "\u1352\u1275\u12ab\u12a2\u122d\u1295 \u12a0\u12ed\u1235\u120b\u1295\u12f5" },
            { "type.colBackwards.yes", "\u12e8\u134a\u12f0\u120d \u132d\u1228\u1276\u127d \u1260\u128b\u120a\u12ee\u123d \u12f0\u122d\u12f5\u122d" },
            { "PR", "\u1356\u122d\u1273 \u122a\u12ae" },
            { "PS", "\u12e8\u134d\u120d\u1235\u1324\u121d \u130d\u12db\u1275" },
            { "PT", "\u1356\u122d\u1271\u130b\u120d" },
            { "PW", "\u1353\u120b\u12cd" },
            { "type.nu.greklow", "\u12e8\u130d\u122a\u12ad \u1295\u12d1\u1235 \u1206\u1204 \u1241\u1325\u122e\u127d" },
            { "PY", "\u1353\u122b\u1313\u12ed" },
            { "tum", "\u1271\u121d\u1261\u12ab" },
            { "Hebr", "\u12a5\u1265\u122b\u12ed\u1235\u1325" },
            { "QA", "\u12b3\u1273\u122d" },
            { "QO", "\u12a0\u12cd\u1275\u120b\u12ed\u1295\u130d \u12a6\u123d\u1295\u12eb" },
            { "001", "\u12d3\u1208\u121d" },
            { "002", "\u12a0\u134d\u122a\u12ab" },
            { "njo", "\u12a6 \u1293\u130b" },
            { "003", "\u1230\u121c\u1295 \u12a0\u121c\u122a\u12ab" },
            { "RE", "\u122a\u12e9\u1292\u12e8\u1295" },
            { "type.colNormalization.no", "\u12eb\u1208\u1218\u12f0\u1260\u129b \u1201\u1294\u1273 \u12f0\u122d\u12f5\u122d" },
            { "005", "\u12f0\u1261\u1265 \u12a0\u121c\u122a\u12ab" },
            { "009", "\u12a6\u123d\u1292\u12a0" },
            { "RO", "\u122e\u121c\u1292\u12eb" },
            { "RS", "\u1230\u122d\u1265\u12eb" },
            { "RU", "\u122b\u123d\u12eb" },
            { "RW", "\u1229\u12cb\u1295\u12f3" },
            { "key.colAlternate", "\u12e8\u121d\u120d\u12ad\u1276\u127d \u12f5\u122d\u12f0\u122b \u127d\u120b \u1260\u1208\u12cd" },
            { "SA", "\u1233\u12cd\u12f5\u12a0\u1228\u1262\u12eb" },
            { "SB", "\u1230\u120e\u121e\u1295 \u12f0\u1234\u1275" },
            { "twq", "\u1273\u1233\u12cb\u1245" },
            { "011", "\u121d\u1235\u122b\u1243\u12ca \u12a0\u134d\u122a\u12ab" },
            { "SC", "\u1232\u123c\u120d\u1235" },
            { "SD", "\u1231\u12f3\u1295" },
            { "013", "\u1218\u12ab\u12a8\u1208\u129b\u12cd \u12a0\u121c\u122a\u12ab" },
            { "SE", "\u1235\u12ca\u12f5\u1295" },
            { "014", "\u121d\u12d5\u122b\u1263\u12ca \u12a0\u134d\u122a\u12ab" },
            { "arc", "\u12a0\u122b\u121b\u12ed\u12ad" },
            { "015", "\u1230\u121c\u1293\u12ca \u12a0\u134d\u122a\u12ab" },
            { "SG", "\u1232\u1295\u130b\u1356\u122d" },
            { "SH", "\u1234\u1295\u1275 \u1204\u1208\u1293" },
            { "type.lb.strict", "\u1320\u1260\u1245 \u12eb\u1208 \u1218\u1235\u1218\u122d \u1218\u1235\u1260\u122a\u12eb \u1245\u1325" },
            { "017", "\u1218\u12ab\u12a8\u1208\u129b\u12cd \u12a0\u134d\u122a\u12ab" },
            { "SI", "\u1235\u120e\u126c\u1292\u12eb" },
            { "018", "\u12f0\u1261\u1263\u12ca \u12a0\u134d\u122a\u12ab" },
            { "SJ", "\u1235\u126b\u120d\u1263\u122d\u12f5 \u12a5\u1293 \u1303\u1295 \u121b\u12e8\u1295" },
            { "019", "\u12a0\u121c\u122a\u12ab" },
            { "SK", "\u1235\u120e\u126b\u12aa\u12eb" },
            { "SL", "\u1234\u122b\u120a\u12ee\u1295" },
            { "SM", "\u1233\u1295 \u121b\u122a\u1296" },
            { "SN", "\u1234\u1294\u130b\u120d" },
            { "SO", "\u1231\u121b\u120c" },
            { "arn", "\u121b\u1351\u127c" },
            { "arp", "\u12a0\u122b\u1353\u1206" },
            { "type.nu.taml", "\u1263\u1205\u120b\u12ca \u12e8\u1273\u121a\u120d \u1241\u1325\u122e\u127d" },
            { "SR", "\u1231\u122a\u1293\u121d" },
            { "aro", "\u12a0\u122b\u12a6\u1293" },
            { "SS", "\u12f0\u1261\u1265 \u1231\u12f3\u1295" },
            { "ST", "\u1233\u12a6 \u1276\u121c \u12a5\u1293 \u1355\u122a\u1295\u1232\u1354" },
            { "arq", "\u12e8\u12a0\u120d\u1304\u122a\u12eb \u12d3\u1228\u1265\u129b" },
            { "SV", "\u12a4\u120d \u1233\u120d\u126b\u12f6\u122d" },
            { "SX", "\u1232\u1295\u1275 \u121b\u122d\u1270\u1295" },
            { "SY", "\u1232\u122a\u12eb" },
            { "SZ", "\u1231\u12cb\u12da\u120b\u1295\u12f5" },
            { "arw", "\u12a0\u122b\u12cb\u12ad" },
            { "TA", "\u1275\u122a\u1235\u1273\u1295 \u12f2 \u12a9\u1295\u1203" },
            { "asa", "\u12a0\u1231" },
            { "type.ms.ussystem", "\u12e8\u12a0\u121c\u122a\u12ab \u1218\u1208\u12aa\u12eb \u1235\u122d\u12d3\u1275" },
            { "021", "\u1230\u121c\u1293\u12ca \u12a0\u121c\u122a\u12ab" },
            { "TC", "\u12e8\u1271\u122d\u12ae\u127d\u1293 \u12e8\u12ab\u12a2\u12ae\u1235 \u12f0\u1234\u1276\u127d" },
            { "TD", "\u127b\u12f5" },
            { "TF", "\u12e8\u1348\u1228\u1295\u1233\u12ed \u12f0\u1261\u1263\u12ca \u130d\u12db\u1276\u127d" },
            { "ase", "\u12e8\u12a0\u121c\u122a\u12ab \u12e8\u121d\u120d\u12ad\u1275 \u124b\u1295\u124b" },
            { "TG", "\u1276\u1310" },
            { "TH", "\u1273\u12ed\u120b\u1295\u12f5" },
            { "TJ", "\u1273\u1303\u12aa\u1235\u1273\u1295" },
            { "029", "\u12ab\u122a\u1262\u12eb\u1295" },
            { "TK", "\u1276\u12ad\u120b\u12cd" },
            { "TL", "\u121d\u1235\u122b\u1245 \u120c\u1235\u1275" },
            { "type.co.searchjl", "\u1260\u1203\u1295\u1309\u120d \u12e8\u1218\u1300\u1218\u122a\u12eb \u1270\u1290\u1263\u1262 \u1348\u120d\u130d" },
            { "TM", "\u1271\u122d\u12ad\u121c\u1292\u1235\u1273\u1295" },
            { "TN", "\u1271\u1292\u12da\u12eb" },
            { "TO", "\u1276\u1295\u130b" },
            { "TR", "\u1271\u122d\u12ad" },
            { "TT", "\u1275\u122a\u1293\u12f3\u12f5 \u12a5\u1293 \u1276\u1264\u130e" },
            { "TV", "\u1271\u126b\u1209" },
            { "TW", "\u1273\u12ed\u12cb\u1295" },
            { "ast", "\u12a0\u12cd\u1235\u1275\u122a\u12eb\u1295" },
            { "TZ", "\u1273\u1295\u12db\u1292\u12eb" },
            { "nmg", "\u12ad\u12cb\u1232\u12ee" },
            { "Zzzz", "\u12eb\u120d\u1273\u12c8\u1240 \u1235\u12ad\u122a\u1355\u1275" },
            { "UA", "\u12e9\u12ad\u122c\u1295" },
            { "rup", "\u12a0\u122e\u121b\u1295\u12eb\u1295" },
            { "030", "\u121d\u12d5\u122b\u1263\u12ca \u12a5\u1232\u12eb" },
            { "sw_CD", "\u12ae\u1295\u130e \u1235\u12cb\u1202\u120a" },
            { "034", "\u12f0\u1261\u1263\u12ca \u12a5\u1232\u12eb" },
            { "035", "\u121d\u12d5\u122b\u1263\u12ca \u12f0\u1261\u1265 \u12a5\u1232\u12eb" },
            { "UG", "\u12e9\u130b\u1295\u12f3" },
            { "type.co.pinyin", "\u1352\u1295\u12ed\u1295 \u12e8\u12f5\u122d\u12f5\u122d \u1245\u12f0\u121d \u1270\u12a8\u1270\u120d" },
            { "type.colHiraganaQuaternary.yes", metaValue_type_colHiraganaQuaternary_no },
            { "039", "\u12f0\u1261\u1263\u12ca \u12a0\u12cd\u122e\u1353" },
            { "Sinh", "\u1232\u1295\u1203\u120b" },
            { "UM", "\u12e8\u12e9 \u12a4\u1235 \u1320\u1228\u134d \u120b\u12ed \u12eb\u1209 \u12f0\u1234\u1276\u127d" },
            { "US", "\u12e9\u1293\u12ed\u1275\u12f5 \u1235\u1274\u1275\u1235" },
            { "haw", "\u1203\u12ca\u12eb\u129b" },
            { "type.co.gb2312han", "\u12e8\u1240\u1208\u1208 \u12e8\u127b\u12ed\u1295\u129b \u12e8\u12f5\u122d\u12f0\u122b \u1245\u12f0\u121d \u1270\u12a8\u1270\u120d - GB2312" },
            { "UY", "\u12a1\u122b\u1313\u12ed" },
            { "UZ", "\u12a1\u12dd\u1264\u12aa\u1235\u1273\u1295" },
            { "tzm", "\u1218\u12ab\u12a8\u1208\u129b \u12a0\u1275\u120b\u1235 \u1273\u121b\u12da\u130d\u1275" },
            { "type.co.stroke", "\u12e8\u1260\u1275\u122d \u12f5\u122d\u12f5\u122d \u1245\u12f0\u121d \u1270\u12a8\u1270\u120d" },
            { "VA", "\u126b\u1272\u12ab\u1295 \u12a8\u1270\u121b" },
            { "VC", "\u1245\u12f1\u1235 \u126a\u1295\u1234\u1295\u1275 \u12a5\u1293 \u130d\u122c\u1293\u12f2\u1295\u1235" },
            { "VE", "\u126c\u1295\u12d9\u12cc\u120b" },
            { "VG", "\u12e8\u12a5\u1295\u130d\u120a\u12dd \u1268\u122d\u1302\u1295 \u12f0\u1234\u1276\u127d" },
            { "VI", "\u12e8\u12a0\u121c\u122a\u12ab \u1268\u122d\u1302\u1295 \u12f0\u1234\u1276\u127d" },
            { "VN", "\u126c\u1275\u1293\u121d" },
            { "type.colBackwards.no", "\u12e8\u134a\u12f0\u120d \u132d\u1228\u1276\u127d\u1295 \u12a5\u1295\u12f0\u1218\u12f0\u1260\u129b \u12f0\u122d\u12f5\u122d" },
            { "VU", "\u126b\u1291\u12a0\u1271" },
            { "rwk", "\u122d\u12cb" },
            { "053", "\u12a0\u12cd\u1235\u1275\u122b\u120a\u12eb" },
            { "054", "\u121c\u120b\u1294\u12e5\u12eb" },
            { "WF", "\u12cb\u120a\u1235 \u12a5\u1293 \u1349\u1271\u1293 \u12f0\u1234\u1276\u127d" },
            { "type.co.traditional", "\u1263\u1205\u120b\u12ca \u12e8\u12f5\u122d\u12f5\u122d \u1245\u12f0\u121d \u1270\u12a8\u1270\u120d" },
            { "057", "\u12e8\u121b\u12ed\u12ad\u122e\u1294\u12e5\u12eb\u1295 \u12ad\u120d\u120d" },
            { "jgo", "\u1295\u130e\u1263\u129b" },
            { "lkt", "\u120b\u12ae\u1273" },
            { "type.nu.finance", "\u12e8\u134b\u12ed\u1293\u1295\u1235 \u1241\u1325\u122e\u127d" },
            { "WS", "\u1233\u121e\u12a0" },
            { "awa", "\u12a0\u12cb\u12f5\u1202" },
            { "061", "\u1356\u120a\u1294\u12e5\u12eb" },
            { "XK", "\u12ae\u1236\u126e" },
            { "Gujr", "\u1309\u1303\u122b\u1272" },
            { "Zxxx", "\u12eb\u120d\u1270\u133b\u1348" },
            { "wbp", "\u12cb\u122d\u120d\u1352\u122a" },
            { "YE", "\u12e8\u1218\u1295" },
            { "nqo", "\u1295\u12ae" },
            { "type.co.standard", "\u1218\u12f0\u1260\u129b" },
            { "YT", "\u121c\u12ed\u12a6\u1274" },
            { "ZA", "\u12f0\u1261\u1265 \u12a0\u134d\u122a\u12ab" },
            { "type.lb.loose", "\u120b\u120b \u12eb\u1208 \u1218\u1235\u1218\u122d \u1218\u1235\u1260\u122a\u12eb \u1245\u1325" },
            { "Deva", "\u12f0\u126b\u1295\u130b\u122a" },
            { "type.nu.geor", "\u12e8\u1306\u122d\u1302\u12eb\u1295 \u1241\u1325\u122e\u127d" },
            { "Hira", "\u1202\u122b\u130b\u1293" },
            { "ZM", "\u12db\u121d\u1262\u12eb" },
            { "ZW", "\u12da\u121d\u1267\u1264" },
            { "ZZ", "\u12eb\u120d\u1273\u12c8\u1240 \u12ad\u120d\u120d" },
            { "type.ms.metric", "\u12e8\u120d\u12ac\u1275 \u1235\u122d\u12d3\u1275" },
            { "type.ca.iso8601", "ISO-8601 \u12e8\u1240\u1295 \u12a0\u1246\u1323\u1320\u122d" },
            { "nso", "\u1230\u121c\u1293\u12ca \u1236\u1276" },
            { "type.nu.telu", "\u12e8\u1270\u120d\u1309 \u12a0\u1203\u12de\u127d" },
            { "loz", "\u120e\u12da\u129b" },
            { "type.colHiraganaQuaternary.no", metaValue_type_colHiraganaQuaternary_no },
            { "jmc", "\u121b\u127b\u121c\u129b" },
            { "type.nu.hansfin", "\u1240\u1208\u120d \u12eb\u1209 \u12e8\u127b\u12ed\u1295\u129b \u1308\u1295\u12d8\u1265 \u1290\u12ad \u1241\u1325\u122e\u127d" },
            { "type.colStrength.secondary", "\u12e8\u134a\u12f0\u120d \u132d\u1228\u1276\u127d\u1295 \u12f0\u122d\u12f5\u122d" },
            { "type.nu.arabext", "\u12e8\u1270\u122b\u12d8\u1219 \u12e8\u12a0\u1228\u1262\u12ad-\u12a2\u1295\u12f2\u12ad \u12a0\u1203\u12de\u127d" },
            { "nus", "\u1291\u12cc\u122d" },
            { "dak", "\u12f3\u12ae\u1273" },
            { "type.nu.fullwide", "\u12e8\u1219\u1209 \u12c8\u122d\u12f5 \u12a0\u1203\u12de\u127d" },
            { "dar", "\u12f3\u122d\u130d\u12cb" },
            { "dav", "\u1273\u12ed\u1273\u129b" },
            { "lrc", "\u1230\u121c\u1293\u12ca \u1209\u122a" },
            { "nwc", "\u12ad\u120b\u1232\u12ad \u1294\u12cb\u122a" },
            { "Khmr", "\u12ad\u1205\u1218\u122d" },
            { "type.nu.roman", "\u12e8\u122e\u121b\u1295 \u1241\u1325\u122e\u127d" },
            { "saq", "\u1233\u121d\u1261\u1229" },
            { "type.nu.native", "\u1275\u12cd\u120d\u12f5 \u12a0\u1203\u12de\u127d" },
            { "Guru", "\u1309\u122d\u1219\u12aa" },
            { "lua", "\u1209\u1263-\u1209\u120f" },
            { "sbp", "\u1233\u1295\u1309" },
            { "nyn", "\u1292\u12eb\u1295\u12ae\u120d\u129b" },
            { "luo", "\u1209\u12a6" },
            { "fil", "\u134a\u120a\u1352\u1295\u129b" },
            { "del", "\u12f3\u120b\u12cc\u122d" },
            { "bal", "\u1263\u1209\u127a" },
            { "ban", "\u1263\u120a\u1294\u1235" },
            { "luy", "\u1209\u12ea\u12eb" },
            { "bar", "\u1263\u126b\u122a\u12eb\u1295" },
            { "bas", "\u1263\u1233" },
            { "bax", "\u1263\u1219\u1295" },
            { "es_ES", "\u12e8\u12a0\u12cd\u122e\u1353 \u1235\u1353\u1295\u123d\u129b" },
            { "aa", "\u12a0\u134b\u122d\u129b" },
            { "ab", "\u12a0\u1265\u1210\u12da\u129b" },
            { "bbc", "\u1263\u1273\u12ab \u1276\u1263" },
            { "key.colCaseFirst", "\u12e8\u12a0\u1262\u12ed/\u1295\u12d1\u1235 \u1206\u1204 \u1245\u12f0\u121d \u1270\u12a8\u1270\u120d" },
            { "ae", "\u12a0\u126c\u1235\u1273\u1295" },
            { "af", "\u12a0\u134d\u122a\u12ab\u1295\u129b" },
            { "ak", "\u12a0\u12ab\u1295\u129b" },
            { "am", "\u12a0\u121b\u122d\u129b" },
            { "Arab", metaValue_ar },
            { "an", "\u12a0\u122b\u130e\u1295\u1235" },
            { "Jpan", metaValue_ja },
            { "ar", metaValue_ar },
            { "as", "\u12a0\u1233\u121c\u12db\u12ca" },
            { "av", "\u12a0\u126b\u122a\u12ad" },
            { "sdh", "\u12f0\u1261\u1263\u12ca \u12a9\u12f2\u123d" },
            { "ay", "\u12a0\u12eb\u121b\u122d\u129b" },
            { "az", "\u12a0\u12d8\u122d\u1263\u1303\u1295\u129b" },
            { "ba", "\u1263\u1235\u12aa\u122d\u129b" },
            { "type.co.unihan", "\u12e8\u1218\u1230\u1228\u1273\u12ca \u1260\u1275\u122d \u12f5\u122d\u12f5\u122d \u1245\u12f0\u121d \u1270\u12a8\u1270\u120d" },
            { "be", "\u1264\u120b\u122b\u123b\u129b" },
            { "bg", "\u1261\u120d\u130b\u122a\u129b" },
            { "bi", "\u1262\u1235\u120b\u121d\u129b" },
            { "bm", "\u1263\u121d\u1263\u122d\u129b" },
            { "bn", "\u1264\u1295\u130b\u120a\u129b" },
            { "bo", "\u1272\u1264\u1273\u1295\u129b" },
            { "dgr", "\u12f6\u130d\u122a\u1265" },
            { "br", "\u1265\u122c\u1276\u1295\u129b" },
            { "bs", "\u1266\u1235\u1292\u12eb\u1295\u129b" },
            { "Mymr", "\u121d\u12eb\u1295\u121b\u122d" },
            { "type.nu.laoo", "\u12e8\u120b\u12a6 \u12a0\u1203\u12de\u127d" },
            { "seh", "\u1234\u1293" },
            { "ca", "\u12ab\u1273\u120b\u1295\u129b" },
            { "ses", "\u12ae\u12ed\u122b\u1266\u122e \u1234\u1292" },
            { "ce", "\u127d\u127d\u1295" },
            { "ch", "\u127b\u121e\u122e" },
            { "co", "\u12ae\u122d\u1232\u12ab\u129b" },
            { "Orya", "\u12a6\u122a\u12eb" },
            { "cr", "\u12ad\u122a" },
            { "cs", "\u127c\u12ad\u129b" },
            { "cu", "\u1278\u122d\u127d \u1235\u120b\u126a\u12ad" },
            { "cv", "\u1279\u126b\u123d" },
            { "cy", "\u12c8\u120d\u123d" },
            { "type.nu.ethi", "\u12e8\u12a2\u1275\u12ee\u1352\u12ad \u1241\u1325\u122e\u127d" },
            { "da", "\u12f4\u1292\u123d" },
            { "pt_PT", "\u12e8\u12a0\u12cd\u122e\u1353 \u1356\u122d\u1279\u130b\u120d\u129b" },
            { "de", metaValue_DE },
            { "bej", "\u1264\u1303" },
            { "din", "\u12f2\u1295\u12ab" },
            { "bem", "\u1264\u121d\u1263" },
            { "type.nu.mong", "\u12e8\u121e\u1295\u130e\u120d\u129b \u12a0\u1203\u12de\u127d" },
            { "dv", "\u12f2\u126c\u1205" },
            { "es_419", "\u12e8\u120b\u1272\u1295 \u12a0\u121c\u122a\u12ab \u1235\u1353\u1292\u123d" },
            { "bew", "\u1264\u1273\u12ca" },
            { "dz", "\u12f5\u12de\u1295\u130d\u12bb\u129b" },
            { "bez", "\u1264\u1293" },
            { "type.ca.chinese", "\u12e8\u127b\u12ed\u1293 \u12e8\u1240\u1295 \u12a0\u1246\u1323\u1320\u122d" },
            { "dje", "\u12db\u122d\u121b\u129b" },
            { "type.nu.grek", "\u12e8\u130d\u122a\u12ad \u1241\u1325\u122e\u127d" },
            { "ee", "\u12a2\u12ca" },
            { "bfd", "\u1263\u1349\u1275" },
            { "type.lb.normal", "\u1218\u12f0\u1260\u129b \u1218\u1235\u1218\u122d \u1218\u1235\u1260\u122a\u12eb \u1245\u1325" },
            { "ro_MD", "\u121e\u120d\u12f3\u126b\u12ca\u1293" },
            { "el", "\u130d\u122a\u12ad\u129b" },
            { "en", "\u12a5\u1295\u130d\u120a\u12dd\u129b" },
            { "eo", "\u12a4\u1235\u1350\u122b\u1295\u1276" },
            { "bfq", "\u1263\u12f3\u130b" },
            { "type.co.big5han", "\u12e8\u1263\u1205\u120b\u12ca \u127b\u12ed\u1295\u129b \u12e8\u12f5\u122d\u12f5\u122d \u1245\u12f0\u121d \u1270\u12a8\u1270\u120d - \u1275\u120d\u12455" },
            { "es", "\u1235\u1353\u1295\u123d\u129b" },
            { "et", "\u12a2\u1235\u1276\u1292\u12eb\u1295\u129b" },
            { "eu", "\u1263\u1235\u12ad\u129b" },
            { "Hang", "\u1210\u1295\u1309\u120d" },
            { "shi", "\u1273\u127c\u120d\u1202\u1275" },
            { "hsb", "\u12e8\u120b\u12ed\u129b\u12cd \u1236\u122d\u1262\u12eb\u1295\u129b" },
            { "Hani", "\u1203\u1295" },
            { "fa", "\u1350\u122d\u123a\u12eb\u129b" },
            { "Hans", "\u1240\u1208\u120d \u12eb\u1208" },
            { "type.nu.latn", "\u12e8\u121d\u1235\u122b\u1243\u12ca \u12a0\u1203\u12de\u127d" },
            { "Hant", "\u1263\u1205\u120b\u12ca" },
            { "shu", "\u127b\u12f2\u12eb\u1295 \u12d3\u1228\u1265\u129b" },
            { "fi", "\u134a\u1292\u123d" },
            { "fj", "\u134a\u1302\u129b" },
            { "bgn", "\u12e8\u121d\u12d5\u122b\u1265 \u1263\u120e\u127a" },
            { "yue", "\u12ab\u1295\u1276\u1292\u12dd" },
            { "fo", "\u134b\u122e\u129b" },
            { "fr", "\u1348\u1228\u1295\u1233\u12ed\u129b" },
            { "sid", "\u1232\u12f3\u121d\u129b" },
            { "fy", "\u12e8\u121d\u12d5\u122b\u1265 \u134d\u122a\u1235\u129b" },
            { "ga", "\u12a0\u12ed\u122a\u123d" },
            { "gd", "\u12a5\u1235\u12ae\u1275\u1235 \u130c\u120d\u12ad\u129b" },
            { "key.colCaseLevel", "\u12e8\u1218\u120d\u12a8\u134a\u12f0\u120d \u1275\u1265 \u12f5\u122d\u12f0\u122b" },
            { "gl", "\u130b\u120a\u123a\u12eb" },
            { "gn", "\u1313\u122b\u1292\u129b" },
            { "bho", "\u1266\u1301\u122a" },
            { "und", "\u12eb\u120d\u1273\u12c8\u1240 \u124b\u1295\u124b" },
            { "type.ca.ethiopic-amete-alem", "\u12e8\u12a2\u1275\u12ee\u1352\u12ad \u12a0\u1218\u1270 \u12a0\u1208\u121d \u12e8\u1240\u1295 \u12a0\u1246\u1323\u1320\u122d" },
            { "gu", "\u1309\u1303\u122d\u1272\u129b" },
            { "gv", "\u121b\u1295\u12ad\u1235\u129b" },
            { "ha", "\u1203\u12cd\u1233\u129b" },
            { "he", "\u12d5\u1265\u122b\u1235\u1325" },
            { "hi", "\u1212\u1295\u12f1\u129b" },
            { "bik", "\u1262\u12ae\u120d" },
            { "bin", "\u1262\u1292" },
            { "hr", "\u12ad\u122e\u123d\u12eb\u1295\u129b" },
            { "ht", "\u1203\u12ed\u1275\u129b" },
            { "hu", "\u1200\u1295\u130b\u122a\u129b" },
            { "hy", "\u12a0\u122d\u1218\u1293\u12ca" },
            { "frc", "\u12ab\u1301\u1295 \u134d\u122c\u1295\u127d" },
            { "ia", "\u12a2\u1295\u1274\u122d\u120a\u1295\u1313" },
            { "id", "\u12a2\u1295\u12f6\u1294\u12e5\u129b" },
            { "type.nu.tibt", "\u12e8\u1272\u1264\u1273\u1295 \u12a0\u1203\u12de\u127d" },
            { "ie", "\u12a5\u1295\u1270\u122d\u120a\u1295\u130d\u12c8" },
            { "ig", "\u12a2\u130d\u1266\u129b" },
            { "ii", "\u1232\u1279\u1295\u12ea\u129b" },
            { "ik", "\u12a5\u1291\u1352\u12eb\u1245\u129b" },
            { "frp", "\u12a0\u122d\u1352\u1273\u1295" },
            { "bjn", "\u1263\u1295\u1303\u122d" },
            { "is", "\u12a0\u12ed\u1235\u120b\u1295\u12f5\u129b" },
            { "it", "\u1323\u120a\u12eb\u1295\u129b" },
            { "iu", "\u12a5\u1291\u12ad\u1272\u1271\u1275\u129b" },
            { "ja", metaValue_ja },
            { "Mlym", "\u121b\u120b\u12eb\u120d\u121d" },
            { "doi", "\u12f6\u130d\u122a" },
            { "sma", "\u12f0\u1261\u1263\u12ca \u1233\u121a" },
            { "jv", "\u1303\u126b\u1295\u129b" },
            { "smj", "\u1209\u120c \u1233\u121a" },
            { "smn", "\u12a2\u1293\u122a \u1233\u121a" },
            { "ka", "\u1306\u122d\u1302\u12eb\u1295" },
            { "sms", "\u1235\u12ae\u120d\u1275 \u1233\u121a" },
            { "kg", "\u12ae\u1295\u130e\u129b" },
            { "ki", "\u12aa\u12a9\u12e9" },
            { "mas", "\u121b\u1233\u12ed" },
            { "kk", "\u12ab\u12db\u12ad\u129b" },
            { "kl", "\u12ab\u120b\u120a\u1231\u1275\u129b" },
            { "km", "\u12ad\u1218\u122d\u129b \u121b\u12a5\u12a8\u120b\u12ca" },
            { "kn", "\u12ab\u1293\u12f3\u129b" },
            { "type.colStrength.identical", "\u1201\u1209\u1295\u121d \u12f0\u122d\u12f5\u122d" },
            { "ko", metaValue_ko },
            { "ks", "\u12ab\u123d\u121a\u122d\u129b" },
            { "ku", "\u12a9\u122d\u12f5\u123d\u129b" },
            { "kw", "\u12ae\u122d\u1292\u123d" },
            { "ky", "\u12aa\u122d\u130a\u12dd\u129b" },
            { "type.colStrength.primary", "\u12e8\u1218\u1220\u1228\u1275 \u134a\u12f0\u120b\u1275 \u1265\u127b \u12f0\u122d\u12f5\u122d" },
            { "la", "\u120b\u1272\u1295\u129b" },
            { "lb", "\u1209\u12ad\u12d8\u121d\u1260\u122d\u1308\u122d\u129b" },
            { "type.nu.mlym", "\u12e8\u121b\u120b\u12eb\u120b\u121d\u129b \u12a0\u1203\u12de\u127d" },
            { "lg", "\u130b\u1295\u12f3\u129b" },
            { "Tibt", "\u1272\u1264\u1273\u1295" },
            { "ln", "\u120a\u1295\u130b\u120b\u129b" },
            { "type.colCaseLevel.no", "\u12eb\u1208\u1218\u120d\u12a8\u134a\u12f0\u120d \u1275\u1265 \u12f0\u122d\u12f5\u122d" },
            { "lo", "\u120b\u12cd\u1235\u129b" },
            { "type.ms.uksystem", "\u12a2\u121d\u1354\u122a\u12eb\u120d \u12e8\u1218\u1208\u12aa\u12eb \u1235\u122d\u12d3\u1275" },
            { "type.colStrength.tertiary", "\u12e8\u134a\u12f0\u120d \u132d\u1228\u1276\u127d/\u1218\u120d\u12a8\u134a\u12f0\u120d/\u1235\u134b\u1275 \u12f0\u122d\u12f5\u122d" },
            { "lt", "\u1209\u1274\u1295\u12eb\u1295\u129b" },
            { "lu", "\u1209\u1263 \u12ab\u1273\u1295\u130b" },
            { "lv", "\u120b\u1275\u126a\u12eb\u1295" },
            { "ListCompositionPattern", "{0}\u1363{1}" },
            { "mg", "\u121b\u120b\u130b\u1235\u129b" },
            { "type.co.ducet", "\u12e8\u1290\u1263\u122a \u12e9\u1292\u12ae\u12f5 \u12e8\u12f5\u122d\u12f5\u122d \u1245\u12f0\u121d \u1270\u12a8\u1270\u120d" },
            { "mi", "\u121b\u12ee\u122a\u129b" },
            { "mk", "\u121b\u1234\u12f6\u1295\u129b" },
            { "ml", "\u121b\u120b\u12eb\u120b\u121d\u129b" },
            { "mn", "\u121e\u1295\u130e\u120b\u12ca\u129b" },
            { "mr", "\u121b\u122b\u1272\u129b" },
            { "ms", "\u121b\u120b\u12ed\u129b" },
            { "mt", "\u121b\u120d\u1272\u1235\u129b" },
            { "my", "\u1261\u122d\u121b\u129b" },
            { "Armn", "\u12a0\u122d\u121c\u1295\u12eb\u12ca" },
            { "dsb", "\u12e8\u1273\u127d\u129b\u12cd \u1230\u122d\u1262\u12eb\u1295\u129b" },
            { "na", metaValue_NR },
            { "type.co.search", "\u1208\u1320\u1245\u120b\u120b \u1309\u12f3\u12ed \u134d\u1208\u130b" },
            { "nb", "\u12e8\u1296\u122d\u12cc\u12ed \u1266\u12ad\u121b\u120d" },
            { "nd", "\u1230\u121c\u1295 \u1295\u12f4\u1265\u120c" },
            { "ne", "\u1294\u1353\u120a\u129b" },
            { "nl", "\u12f0\u127d" },
            { "nn", "\u12e8\u1296\u122d\u12cc\u12ed \u1293\u12ed\u1296\u122d\u1235\u12ad" },
            { "no", "\u1296\u122d\u12cc\u1302\u12eb\u1295" },
            { "ny", "\u1295\u12eb\u1295\u1303" },
            { "kab", "\u12ab\u1265\u12ed\u120d" },
            { "type.colCaseFirst.lower", "\u1295\u12d1\u1235 \u1206\u1204 \u1218\u1300\u1218\u122a\u12eb \u12f0\u122d\u12f5\u122d" },
            { "oc", "\u12a6\u12aa\u1273\u1295\u129b" },
            { "kam", "\u12ab\u121d\u1263" },
            { "mer", "\u121c\u1229" },
            { "type.nu.armn", "\u12e8\u12a0\u122d\u1218\u1295\u129b \u1241\u1325\u122e\u127d" },
            { "om", "\u12a6\u122e\u121e\u129b" },
            { "dtp", "\u1234\u1295\u1270\u122b\u120d \u12f1\u1230\u1295" },
            { "or", "\u12a6\u122a\u12eb\u129b" },
            { "os", "\u12a6\u1234\u1272\u12ad" },
            { "bpy", "\u1262\u1239\u1295\u1351\u122a\u12eb" },
            { "mfe", "\u121e\u122a\u1232\u12e8\u129b" },
            { "pa", "\u1351\u1295\u1303\u1265\u129b" },
            { "dua", "\u12f1\u12cb\u120b\u129b" },
            { "bqi", "\u1263\u12ad\u1205\u1272\u12eb\u122a" },
            { "pl", "\u1356\u120a\u123d\u129b" },
            { "type.ca.dangi", "\u12e8\u12f3\u1295\u130a \u12e8\u1240\u1295 \u12a0\u1246\u1323\u1320\u122d" },
            { "ps", "\u1353\u123d\u1276\u129b" },
            { "pt", "\u1356\u122d\u1279\u130b\u120d\u129b" },
            { "key.co", "\u12a0\u1240\u121b\u1218\u1325 \u12f0\u122d\u12f5\u122d" },
            { "pt_BR", "\u12e8\u1265\u122b\u12da\u120d \u1356\u122d\u1279\u130b\u120d\u129b" },
            { "mgh", "\u121b\u12a9\u12cb \u121c\u1276" },
            { "bra", "\u1265\u122b\u1305" },
            { "key.ca", "\u12e8\u1240\u1295 \u12a0\u1246\u1323\u1320\u122d" },
            { "Laoo", "\u120b\u12a6" },
            { "mgo", "\u121c\u1273" },
            { "type.hc.h23", "\u12e824 \u1230\u12d3\u1275 \u1235\u122d\u12d3\u1275 (0\u201323)" },
            { "type.hc.h24", "\u12e824 \u1230\u12d3\u1275 \u1235\u122d\u12d3\u1275 (1\u201324)" },
            { "brh", "\u1265\u122b\u1201\u12ea" },
            { "type.nu.mymr", "\u12e8\u121b\u12eb\u1295\u121b\u122d \u12a0\u1203\u12de\u127d" },
            { "qu", "\u12b5\u127f\u129b" },
            { "brx", "\u1266\u12f6" },
            { "kde", "\u121b\u12ae\u1295\u12f4" },
            { "Ethi", "\u12a2\u1275\u12ee\u1352\u12ad" },
            { "type.hc.h12", "\u12e812 \u1230\u12d3\u1275 \u1235\u122d\u12d3\u1275 (1\u201312)" },
            { "type.hc.h11", "\u12e812 \u1230\u12d3\u1275 \u1235\u122d\u12d3\u1275 (0\u201311)" },
            { "rm", "\u122e\u121b\u1295\u123d" },
            { "rn", "\u1229\u1295\u12f2\u129b" },
            { "key.cu", "\u1308\u1295\u12d8\u1265" },
            { "ro", "\u122e\u121b\u1292\u12eb\u1295" },
            { "type.nu.orya", "\u12e8\u12a6\u122a\u12eb\u129b \u12a0\u1203\u12de\u127d" },
            { "type.nu.hanidec", "\u12e8\u127b\u12ed\u1295\u129b \u12a0\u1235\u122d\u12ee\u123d \u1241\u1325\u122e\u127d" },
            { "ru", "\u122b\u123d\u12eb\u129b" },
            { "bss", "\u12a0\u12ae\u1235" },
            { "rw", "\u12aa\u1295\u12eb\u122d\u12cb\u1295\u12f5\u129b" },
            { "zbl", "\u1265\u120a\u1235\u12ed\u121d\u1266\u120d\u1235" },
            { "kea", "\u12ab\u1261\u1268\u122d\u12f2\u12eb\u1291" },
            { "en_AU", "\u12e8\u12a0\u12cd\u1235\u1275\u122b\u120a\u12eb \u12a5\u1295\u130d\u120a\u12dd\u129b" },
            { "sa", "\u1233\u1295\u1235\u12ad\u122a\u1275\u129b" },
            { "sd", "\u1232\u1295\u12f5\u1202\u129b" },
            { "se", "\u1230\u121c\u1293\u12ca \u1233\u121a" },
            { "sg", "\u1233\u1295\u130e\u129b" },
            { "si", "\u1232\u1295\u1203\u120d\u129b" },
            { "sk", "\u1235\u120e\u126b\u12ad\u129b" },
            { "sl", "\u1235\u120e\u126a\u129b" },
            { "sm", "\u1233\u121e\u12a0\u129b" },
            { "sn", "\u123e\u1293\u129b" },
            { "so", "\u1231\u121b\u120d\u129b" },
            { "type.nu.arab", "\u12e8\u12a0\u1228\u1262\u12ad-\u12a2\u1295\u12f2\u12ad \u12a0\u1203\u12de\u127d" },
            { "sq", "\u120d\u1264\u1292\u129b" },
            { "sr", "\u1230\u122d\u1262\u129b" },
            { "ss", "\u1235\u12cb\u1272\u129b" },
            { "st", "\u1236\u12de\u129b" },
            { "su", "\u1231\u12f3\u1295\u129b" },
            { "sv", "\u1235\u12ca\u12f5\u1295\u129b" },
            { "sw", "\u1235\u12cb\u1202\u120a\u129b" },
            { "type.nu.hantfin", "\u12e8\u1263\u1205\u120b\u12ca \u127b\u12ed\u1295\u129b \u12e8\u1308\u1295\u12d8\u1265 \u1290\u12ad \u1241\u1325\u122e\u127d" },
            { "ta", "\u1273\u121a\u120d\u129b" },
            { "142", "\u12a5\u1232\u12eb" },
            { "bua", "\u1261\u122a\u12eb\u1275" },
            { "143", "\u1218\u12ab\u12a8\u1208\u129b\u12cd \u12a5\u1232\u12eb" },
            { "te", "\u1270\u1209\u1309\u129b" },
            { "145", "\u121d\u1235\u122b\u1243\u12ca \u12a5\u1232\u12eb" },
            { "tg", "\u1273\u1302\u12aa\u129b" },
            { "th", "\u1273\u12ed\u129b" },
            { "ti", "\u1275\u130d\u122d\u129b" },
            { "bug", "\u1261\u130a\u1294\u12dd" },
            { "type.colNumeric.yes", "\u12a0\u1203\u12de\u127d \u1260\u1241\u1325\u122d \u12f0\u122d\u12f5\u122d" },
            { "en_CA", "\u12e8\u12ab\u1293\u12f3 \u12a5\u1295\u130d\u120a\u12dd\u129b" },
            { "tk", "\u1271\u122d\u12ad\u1218\u1295\u129b" },
            { "tl", "\u1273\u130b\u120e\u1308\u129b" },
            { "tn", "\u133d\u12cb\u1293\u12ca\u129b" },
            { "to", "\u1276\u1295\u130b\u129b" },
            { "bum", "\u1261\u1209" },
            { "dyo", "\u1306\u120b \u134e\u1295\u12eb\u129b" },
            { "type.nu.jpan", "\u12e8\u1303\u1353\u1295\u129b \u1241\u1325\u122e\u127d" },
            { "tr", "\u1271\u122d\u12ad\u129b" },
            { "ts", "\u133e\u1295\u130b\u129b" },
            { "swb", "\u12ae\u121e\u122a\u12eb\u1295" },
            { "tt", "\u1273\u1273\u122d\u129b" },
            { "dyu", "\u12f5\u12e9\u120b" },
            { "tw", "\u1275\u12ca\u129b" },
            { "ty", "\u1273\u1202\u1273\u1295\u129b" },
            { "150", "\u12a0\u12cd\u122e\u1353" },
            { "key.colHiraganaQuaternary", "\u12e8\u12ab\u1293 \u12f5\u122d\u12f0\u122b" },
            { "151", "\u121d\u12d5\u122b\u1263\u12ca \u12a0\u12cd\u122e\u1353" },
            { "154", "\u1230\u121c\u1293\u12ca \u12a0\u12cd\u122e\u1353" },
            { "dzg", "\u12f3\u12db\u130b" },
            { "155", "\u121d\u1235\u122b\u1243\u12ca \u12a0\u12cd\u122e\u1353" },
            { "ug", "\u12a1\u12ca\u130d\u1201\u122d\u129b" },
            { "Kore", metaValue_ko },
            { "Zyyy", "\u12e8\u130b\u122b" },
            { "uk", "\u12e9\u12ad\u122c\u1295\u129b" },
            { "type.colCaseFirst.no", "\u1218\u12f0\u1260\u129b \u12e8\u1218\u120d\u12a8\u134a\u12f0\u120d \u12a0\u1240\u121b\u1218\u1325 \u12f0\u122d\u12f5\u122d" },
            { "type.colStrength.quaternary", "\u12e8\u134a\u12f0\u120d \u132d\u1228\u1276\u127d/\u1218\u120d\u12a8\u134a\u12f0\u120d/\u1235\u134b\u1275/\u12ab\u1293 \u12f0\u122d\u12f5\u122d" },
            { "type.ca.coptic", "\u12e8\u12ae\u1355\u1272\u12ad \u12e8\u1240\u1295 \u12a0\u1246\u1323\u1320\u122d" },
            { "ur", "\u12a1\u122d\u12f1\u129b" },
            { "uz", "\u12a1\u12dd\u1264\u12ad\u129b" },
            { "nds_NL", "\u12e8\u1273\u127d\u129b\u12cd \u1233\u12ad\u1230\u1295" },
            { "ve", "\u126c\u1295\u12f3" },
            { "type.ca.roc", "\u12e8\u121a\u1295\u1309 \u12e8\u1240\u1295 \u12a0\u1246\u1323\u1320\u122d" },
            { "vi", "\u126a\u1275\u1293\u121d\u129b" },
            { "khq", "\u12ae\u12ed\u122b \u127a\u1292" },
            { "key.hc", "\u12e8\u1230\u12d3\u1275 \u12d1\u12f0\u1275 (12 \u12c8\u12ed\u121d 24)" },
            { "vo", "\u126e\u120b\u1351\u12ad\u129b" },
            { "key.x", "\u1208\u130d\u120d \u1325\u1245\u121d" },
            { "syc", "\u12ad\u120b\u1232\u12ad \u1294\u12ed\u122b" },
            { "quc", "\u12aa\u127c" },
            { "qug", "\u127a\u121d\u1266\u122b\u12de \u1203\u12ed\u120b\u1295\u12f5 \u12a9\u1279\u12cb" },
            { "gaa", "\u130b" },
            { "gag", "\u130b\u1309\u12dd\u129b" },
            { "Grek", metaValue_GR },
            { "wo", "\u12ce\u120e\u134d\u129b" },
            { "zgh", "\u1218\u12f0\u1260\u129b \u12e8\u121e\u122e\u12ae \u1273\u121b\u12da\u130d\u1275" },
            { "ar_001", "\u12d8\u1218\u1293\u12ca \u1218\u12f0\u1260\u129b \u12d3\u1228\u1265\u129b" },
            { "key.colNumeric", "\u12e8\u1241\u1325\u122d \u12f5\u122d\u12f0\u122b" },
            { "Mong", "\u121e\u1295\u130e\u120a\u12eb\u129b" },
            { "Latn", "\u120b\u1272\u1295" },
            { "type.nu.hans", "\u1240\u1208\u120d \u12eb\u1209 \u12e8\u127b\u12ed\u1295\u129b \u1241\u1325\u122e\u127d" },
            { "type.nu.hant", "\u12e8\u1263\u1205\u120b\u12ca \u127b\u12ed\u1295\u129b \u1241\u1325\u122e\u127d" },
            { "xh", "\u12de\u1233\u129b" },
            { "type.nu.romanlow", "\u12e8\u122e\u121b\u1295 \u1295\u12d1\u1235 \u1206\u1204 \u1241\u1325\u122e\u127d" },
            { "byn", "\u1265\u120a\u1295" },
            { "moh", "\u121e\u1203\u12cd\u12ad" },
            { "yi", "\u12ed\u12f2\u123d\u129b" },
            { "yo", "\u12ee\u1229\u1263\u12ca\u129b" },
            { "type.nu.traditional", "\u1270\u1208\u121d\u12f7\u12ca \u1241\u1325\u122e\u127d" },
            { "es_MX", "\u12e8\u121c\u12ad\u1232\u12ae \u1235\u1353\u1295\u123d\u129b" },
            { "vai", "\u126b\u12ed" },
            { "za", "\u12e1\u12cb\u1295\u130d\u129b" },
            { "kln", "\u12ab\u1208\u1295\u1302\u1295" },
            { "zh", "\u127b\u12ed\u1295\u129b" },
            { "Bopo", "\u1266\u1356\u121e\u134e" },
            { "key.lb", "\u1218\u1235\u1218\u122d \u1218\u1235\u1260\u122a\u12eb \u1245\u1325" },
            { "zu", "\u12d9\u1209\u129b" },
            { "type.co.phonebook", "\u12e8\u1235\u120d\u12ad \u12f0\u1265\u1270\u122d \u12f5\u122d\u12f5\u122d \u1245\u12f0\u121d \u1270\u12a8\u1270\u120d" },
            { "Geor", "\u1306\u122d\u1302\u12eb\u12ca" },
            { "type.colCaseLevel.yes", "\u1260\u1218\u120d\u12a8\u134a\u12f0\u120d \u1275\u1265 \u12f0\u122d\u12f5\u122d" },
            { "type.nu.jpanfin", "\u12e8\u1303\u1353\u1295\u129b \u12e8\u1308\u1295\u12d8\u1265 \u1290\u12ad \u1241\u1325\u122e\u127d" },
            { "gez", "\u130d\u12d5\u12dd\u129b" },
            { "type.co.reformed", "\u12f3\u130d\u121d \u12e8\u1270\u1348\u1320\u1228 \u12e8\u12f5\u122d\u12f5\u122d \u1245\u12f0\u121d \u1270\u12a8\u1270\u120d" },
            { "key.colBackwards", "\u12e8\u128b\u120a\u12ee\u123d \u12e8\u134a\u12f0\u120d \u132d\u1228\u1275 \u12f5\u122d\u12f0\u122b" },
            { "ebu", "\u12a2\u1266\u129b" },
            { "zh_Hans", "\u1240\u1208\u120d \u12eb\u1208 \u127b\u12ed\u1295\u129b" },
            { "koi", "\u12ae\u121a \u1354\u122d\u121d\u12eb\u12ad" },
            { "kok", "\u12ae\u12ab\u1292" },
            { "zh_Hant", "\u1263\u1205\u120b\u12ca \u127b\u12ed\u1295\u129b" },
            { "type.nu.khmr", "\u12e8\u12ad\u1205\u1218\u122d \u12a0\u1203\u12de\u127d" },
            { "mua", "\u1219\u1295\u12f3\u1295\u130d" },
            { "type.nu.guru", "\u12e8\u1309\u122d\u1219\u12aa \u12a0\u1203\u12de\u127d" },
            { "cad", "\u12ab\u12f6" },
            { "key.ms", "\u12e8\u1218\u1208\u12aa\u12eb \u1235\u122d\u12d3\u1275" },
            { "mus", "\u12ad\u122a\u12ad" },
            { "car", "\u12ab\u122a\u1265" },
            { "cay", "\u12ab\u12e9\u130b" },
            { "type.nu.tamldec", "\u12e8\u1273\u121a\u120d \u12a0\u1203\u12de\u127d" },
            { "efi", "\u12a4\u134a\u12ad" },
            { "key.nu", "\u1241\u1325\u122e\u127d" },
            { "ksb", "\u123b\u121d\u1263\u120b" },
            { "type.colCaseFirst.upper", "\u12a0\u1262\u12ed \u1206\u1204 \u1218\u1300\u1218\u122a\u12eb \u12f0\u122d\u12f5\u122d" },
            { "Telu", "\u1270\u1209\u1309" },
            { "ksf", "\u1263\u134a\u12eb" },
        };
        return data;
    }
}
