/*
 * Decompiled with CFR 0.152.
 */
package git4idea.checkin;

import com.google.common.collect.HashMultiset;
import com.intellij.CommonBundle;
import com.intellij.diff.util.Side;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ChangeListData;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.ui.SelectFilePathsDialog;
import com.intellij.openapi.vcs.checkin.CheckinChangeListSpecificComponent;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.ex.PartialCommitHelper;
import com.intellij.openapi.vcs.ex.PartialLocalLineStatusTracker;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vcs.impl.PartialChangesUtil;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.concurrency.FutureResult;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.textCompletion.DefaultTextCompletionValueDescriptor;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.textCompletion.TextCompletionValueDescriptor;
import com.intellij.util.textCompletion.TextFieldWithCompletion;
import com.intellij.util.textCompletion.ValuesCompletionProvider;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.vcs.commit.AbstractCommitWorkflowKt;
import com.intellij.vcs.commit.AmendCommitAware;
import com.intellij.vcs.commit.AmendCommitHandler;
import com.intellij.vcs.commit.AmendCommitModeListener;
import com.intellij.vcs.commit.ToggleAmendCommitOption;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.VcsUserRegistry;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.util.VcsUserUtil;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitUserRegistry;
import git4idea.GitUtil;
import git4idea.branch.GitBranchUtil;
import git4idea.changes.GitChangeUtils;
import git4idea.checkin.GitCheckinExplicitMovementProvider;
import git4idea.checkin.GitCommitAndPushExecutorKt;
import git4idea.checkin.GitCommitAuthorCorrector;
import git4idea.checkin.GitPushAfterCommitDialog;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitConfigUtil;
import git4idea.config.GitVcsSettings;
import git4idea.config.GitVersionSpecialty;
import git4idea.i18n.GitBundle;
import git4idea.index.GitIndexUtil;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.repo.GitSubmoduleKt;
import git4idea.util.GitFileUtils;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutionException;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitCheckinEnvironment
implements CheckinEnvironment,
AmendCommitAware {
    private static final Logger LOG = Logger.getInstance(GitCheckinEnvironment.class);
    @NonNls
    private static final String GIT_COMMIT_MSG_FILE_PREFIX = "git-commit-msg-";
    @NonNls
    private static final String GIT_COMMIT_MSG_FILE_EXT = ".txt";
    private final Project myProject;
    public static final SimpleDateFormat COMMIT_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final VcsDirtyScopeManager myDirtyScopeManager;
    private final GitVcsSettings mySettings;
    private String myNextCommitAuthor;
    private boolean myNextCommitAmend;
    private Date myNextCommitAuthorDate;
    private boolean myNextCommitSignOff;
    private boolean myNextCommitSkipHook;
    private boolean myNextCommitCommitRenamesSeparately;

    public GitCheckinEnvironment(@NotNull Project project, @NotNull VcsDirtyScopeManager dirtyScopeManager, GitVcsSettings settings) {
        if (project == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(0);
        }
        if (dirtyScopeManager == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(1);
        }
        this.myNextCommitAuthor = null;
        this.myProject = project;
        this.myDirtyScopeManager = dirtyScopeManager;
        this.mySettings = settings;
    }

    public boolean isRefreshAfterCommitNeeded() {
        return true;
    }

    @NotNull
    public RefreshableOnComponent createCommitOptions(@NotNull CheckinProjectPanel commitPanel, @NotNull CommitContext commitContext) {
        if (commitPanel == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(2);
        }
        if (commitContext == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(3);
        }
        GitCheckinOptions gitCheckinOptions = new GitCheckinOptions(this.myProject, commitPanel, ToggleAmendCommitOption.isAmendCommitOptionSupported((CheckinProjectPanel)commitPanel, (AmendCommitAware)this));
        if (gitCheckinOptions == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(4);
        }
        return gitCheckinOptions;
    }

    @Nullable
    public String getDefaultMessageFor(@NotNull FilePath[] filesToCheckin) {
        if (filesToCheckin == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(5);
        }
        LinkedHashSet<String> messages = new LinkedHashSet<String>();
        GitRepositoryManager manager = GitUtil.getRepositoryManager(this.myProject);
        for (VirtualFile root : GitUtil.getRootsForFilePathsIfAny(this.myProject, Arrays.asList(filesToCheckin))) {
            GitRepository repository = (GitRepository)manager.getRepositoryForRoot(root);
            if (repository == null) {
                LOG.warn("Unregistered repository: " + root);
                continue;
            }
            File mergeMsg = repository.getRepositoryFiles().getMergeMessageFile();
            File squashMsg = repository.getRepositoryFiles().getSquashMessageFile();
            try {
                if (!mergeMsg.exists() && !squashMsg.exists()) continue;
                String encoding = GitConfigUtil.getCommitEncoding(this.myProject, root);
                if (mergeMsg.exists()) {
                    messages.add(GitCheckinEnvironment.loadMessage(mergeMsg, encoding));
                    continue;
                }
                messages.add(GitCheckinEnvironment.loadMessage(squashMsg, encoding));
            }
            catch (IOException e) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Unable to load merge message", (Throwable)e);
            }
        }
        return DvcsUtil.joinMessagesOrNull(messages);
    }

    private static String loadMessage(@NotNull File messageFile, @NotNull String encoding) throws IOException {
        if (messageFile == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(6);
        }
        if (encoding == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(7);
        }
        return FileUtil.loadFile((File)messageFile, (String)encoding);
    }

    public String getHelpId() {
        return null;
    }

    public String getCheckinOperationName() {
        return GitBundle.getString("commit.action.name");
    }

    public boolean isAmendCommitSupported() {
        return true;
    }

    @Nullable
    public String getLastCommitMessage(@NotNull VirtualFile root) throws VcsException {
        if (root == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(8);
        }
        GitLineHandler h = new GitLineHandler(this.myProject, root, GitCommand.LOG);
        h.addParameters("--max-count=1");
        h.addParameters("--encoding=UTF-8");
        String formatPattern = GitVersionSpecialty.STARTED_USING_RAW_BODY_IN_FORMAT.existsIn(this.myProject) ? "%B" : "%s%n%n%-b";
        h.addParameters("--pretty=format:" + formatPattern);
        return Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]);
    }

    @NotNull
    public List<VcsException> commit(@NotNull List<Change> changes, @NotNull String commitMessage, @NotNull CommitContext commitContext, @NotNull Set<String> feedback) {
        if (changes == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(9);
        }
        if (commitMessage == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(10);
        }
        if (commitContext == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(11);
        }
        if (feedback == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(12);
        }
        this.myNextCommitAmend = AbstractCommitWorkflowKt.isAmendCommitMode((CommitContext)commitContext);
        GitRepositoryManager manager = GitUtil.getRepositoryManager(this.myProject);
        ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        Map<VirtualFile, Collection<Change>> sortedChanges = GitCheckinEnvironment.sortChangesByGitRoot(this.myProject, changes, exceptions);
        LOG.assertTrue(!sortedChanges.isEmpty(), (Object)("Trying to commit an empty list of changes: " + changes));
        List<GitRepository> repositories = manager.sortByDependency(GitUtil.getRepositoriesFromRoots(manager, sortedChanges.keySet()));
        for (GitRepository repository : repositories) {
            Collection<Change> rootChanges = sortedChanges.get(repository.getRoot());
            Collection toCommit = ContainerUtil.map(rootChanges, CommitChange::new);
            if (this.myNextCommitCommitRenamesSeparately) {
                Pair<Collection<CommitChange>, List<VcsException>> pair = this.commitExplicitRenames(repository, toCommit, commitMessage);
                toCommit = (Collection)pair.first;
                List moveExceptions = (List)pair.second;
                if (!moveExceptions.isEmpty()) {
                    exceptions.addAll(moveExceptions);
                    continue;
                }
            }
            exceptions.addAll(this.commitRepository(repository, toCommit, commitMessage));
        }
        if (GitCommitAndPushExecutorKt.isPushAfterCommit(commitContext) && exceptions.isEmpty()) {
            ModalityState modality = ModalityState.defaultModalityState();
            TransactionGuard.getInstance().assertWriteSafeContext(modality);
            ArrayList<GitRepository> preselectedRepositories = new ArrayList<GitRepository>(repositories);
            GuiUtils.invokeLaterIfNeeded(() -> new GitPushAfterCommitDialog(this.myProject, preselectedRepositories, GitBranchUtil.getCurrentRepository(this.myProject)).showOrPush(), (ModalityState)modality, (Condition)this.myProject.getDisposed());
        }
        ArrayList<VcsException> arrayList = exceptions;
        if (arrayList == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    private List<VcsException> commitRepository(@NotNull GitRepository repository, @NotNull Collection<? extends CommitChange> changes, @NotNull String message) {
        block15: {
            block14: {
                if (repository == null) {
                    GitCheckinEnvironment.$$$reportNull$$$0(14);
                }
                if (changes == null) {
                    GitCheckinEnvironment.$$$reportNull$$$0(15);
                }
                if (message == null) {
                    GitCheckinEnvironment.$$$reportNull$$$0(16);
                }
                exceptions = new ArrayList<VcsException>();
                root = repository.getRoot();
                partialAddResult = this.addPartialChangesToIndex(repository, changes);
                callback = (Runnable)partialAddResult.first;
                changedWithIndex = new HashSet<CommitChange>((Collection)partialAddResult.second);
                caseOnlyRenameChanges = this.addCaseOnlyRenamesToIndex(repository, changes, changedWithIndex, exceptions);
                if (exceptions.isEmpty()) break block14;
                v0 = exceptions;
                if (v0 == null) {
                    GitCheckinEnvironment.$$$reportNull$$$0(17);
                }
                return v0;
            }
            changedWithIndex.addAll(caseOnlyRenameChanges);
            if (changedWithIndex.isEmpty() && !Registry.is((String)"git.force.commit.using.staging.area")) ** GOTO lbl34
            GitCheckinEnvironment.runWithMessageFile(this.myProject, root, message, (ThrowableConsumer<? super File, ? extends VcsException>)(ThrowableConsumer)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$commitRepository$1(java.util.List git4idea.repo.GitRepository java.util.Collection java.util.Set java.io.File ), (Ljava/io/File;)V)((GitCheckinEnvironment)this, exceptions, (GitRepository)repository, changes, changedWithIndex));
            if (exceptions.isEmpty()) break block15;
            v1 = exceptions;
            if (v1 == null) {
                GitCheckinEnvironment.$$$reportNull$$$0(18);
            }
            return v1;
        }
        try {
            block16: {
                callback.run();
                break block16;
lbl34:
                // 1 sources

                try {
                    GitCheckinEnvironment.runWithMessageFile(this.myProject, root, message, (ThrowableConsumer<? super File, ? extends VcsException>)(ThrowableConsumer)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$commitRepository$2(java.util.Collection com.intellij.openapi.vfs.VirtualFile java.io.File ), (Ljava/io/File;)V)((GitCheckinEnvironment)this, changes, (VirtualFile)root));
                }
                catch (VcsException ex) {
                    partialOperation = GitCheckinEnvironment.isMergeCommit(ex);
                    if (partialOperation == PartialOperation.NONE) {
                        throw ex;
                    }
                    GitCheckinEnvironment.runWithMessageFile(this.myProject, root, message, (ThrowableConsumer<? super File, ? extends VcsException>)(ThrowableConsumer)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$commitRepository$3(com.intellij.openapi.vfs.VirtualFile java.util.Collection java.util.List git4idea.checkin.GitCheckinEnvironment$PartialOperation com.intellij.openapi.vcs.VcsException java.io.File ), (Ljava/io/File;)V)((GitCheckinEnvironment)this, (VirtualFile)root, changes, exceptions, (PartialOperation)partialOperation, (VcsException)ex));
                }
            }
            GitUtil.getRepositoryManager(this.myProject).updateRepository(root);
            if (GitSubmoduleKt.isSubmodule(repository)) {
                VcsDirtyScopeManager.getInstance((Project)this.myProject).dirDirtyRecursively(repository.getRoot().getParent());
            }
        }
        catch (VcsException e) {
            exceptions.add(e);
        }
        v2 = exceptions;
        if (v2 == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(19);
        }
        return v2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @NotNull
    private List<VcsException> commitUsingIndex(@NotNull GitRepository repository, @NotNull Collection<? extends CommitChange> rootChanges, @NotNull Set<? extends CommitChange> changedWithIndex, @NotNull File messageFile) {
        ArrayList<VcsException> exceptions;
        block18: {
            HashSet<FilePath> excludedUnstagedDeletions;
            ArrayList excludedStagedChanges;
            VirtualFile root;
            block16: {
                ArrayList<VcsException> arrayList;
                block17: {
                    if (repository == null) {
                        GitCheckinEnvironment.$$$reportNull$$$0(20);
                    }
                    if (rootChanges == null) {
                        GitCheckinEnvironment.$$$reportNull$$$0(21);
                    }
                    if (changedWithIndex == null) {
                        GitCheckinEnvironment.$$$reportNull$$$0(22);
                    }
                    if (messageFile == null) {
                        GitCheckinEnvironment.$$$reportNull$$$0(23);
                    }
                    exceptions = new ArrayList<VcsException>();
                    Set added = ContainerUtil.map2SetNotNull(rootChanges, it -> it.afterPath);
                    Set removed = ContainerUtil.map2SetNotNull(rootChanges, it -> it.beforePath);
                    root = repository.getRoot();
                    String rootPath = root.getPath();
                    List<File> unmergedFiles = GitChangeUtils.getUnmergedFiles(repository);
                    if (!unmergedFiles.isEmpty()) {
                        throw new VcsException("Committing is not possible because you have unmerged files.");
                    }
                    Collection<Change> stagedChanges = GitChangeUtils.getStagedChanges(this.myProject, root);
                    LOG.debug("Found staged changes: " + GitUtil.getLogString(rootPath, stagedChanges));
                    excludedStagedChanges = new ArrayList();
                    GitCheckinEnvironment.processExcludedPaths(stagedChanges, added, removed, (PairConsumer<? super FilePath, ? super FilePath>)((PairConsumer)(before, after) -> {
                        if (before != null || after != null) {
                            excludedStagedChanges.add(new ChangedPath((FilePath)before, (FilePath)after));
                        }
                    }));
                    Collection<Change> unstagedChanges = GitChangeUtils.getUnstagedChanges(this.myProject, root, false);
                    LOG.debug("Found unstaged changes: " + GitUtil.getLogString(rootPath, unstagedChanges));
                    excludedUnstagedDeletions = new HashSet<FilePath>();
                    GitCheckinEnvironment.processExcludedPaths(unstagedChanges, added, removed, (PairConsumer<? super FilePath, ? super FilePath>)((PairConsumer)(before, after) -> {
                        if (before != null && after == null) {
                            excludedUnstagedDeletions.add((FilePath)before);
                        }
                    }));
                    if (!excludedStagedChanges.isEmpty()) {
                        LOG.info("Staged changes excluded for commit: " + GitCheckinEnvironment.getLogString(rootPath, excludedStagedChanges));
                        GitCheckinEnvironment.resetExcluded(this.myProject, root, excludedStagedChanges);
                    }
                    List<FilePath> alreadyHandledPaths = GitCheckinEnvironment.getPaths(changedWithIndex);
                    HashSet toAdd = new HashSet(added);
                    toAdd.removeAll(alreadyHandledPaths);
                    HashSet toRemove = new HashSet(removed);
                    toRemove.removeAll(toAdd);
                    toRemove.removeAll(alreadyHandledPaths);
                    LOG.debug(String.format("Updating index: added: %s, removed: %s", toAdd, toRemove));
                    GitCheckinEnvironment.updateIndex(this.myProject, root, toAdd, toRemove, exceptions);
                    if (exceptions.isEmpty()) break block16;
                    arrayList = exceptions;
                    if (excludedStagedChanges.isEmpty()) break block17;
                    GitCheckinEnvironment.restoreExcluded(this.myProject, root, excludedStagedChanges, excludedUnstagedDeletions);
                }
                ArrayList<VcsException> arrayList2 = arrayList;
                if (arrayList2 == null) {
                    GitCheckinEnvironment.$$$reportNull$$$0(24);
                }
                return arrayList2;
            }
            try {
                LOG.debug("Performing commit...");
                this.commitWithoutPaths(this.myProject, root, messageFile);
                break block18;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                finally {
                    if (!excludedStagedChanges.isEmpty()) {
                        GitCheckinEnvironment.restoreExcluded(this.myProject, root, excludedStagedChanges, excludedUnstagedDeletions);
                    }
                }
            }
            catch (VcsException e) {
                exceptions.add(e);
            }
        }
        ArrayList<VcsException> arrayList = exceptions;
        if (arrayList == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(25);
        }
        return arrayList;
    }

    @NotNull
    private Pair<Runnable, List<CommitChange>> addPartialChangesToIndex(@NotNull GitRepository repository, @NotNull Collection<? extends CommitChange> changes) throws VcsException {
        Set changelistIds;
        if (repository == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(26);
        }
        if (changes == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(27);
        }
        if ((changelistIds = ContainerUtil.map2SetNotNull(changes, change -> change.changelistId)).isEmpty()) {
            Pair pair = Pair.create((Object)EmptyRunnable.INSTANCE, (Object)ContainerUtil.emptyList());
            if (pair == null) {
                GitCheckinEnvironment.$$$reportNull$$$0(28);
            }
            return pair;
        }
        if (changelistIds.size() != 1) {
            throw new VcsException("Can't commit changes from multiple changelists at once");
        }
        String changelistId = (String)changelistIds.iterator().next();
        Pair result2 = (Pair)GitCheckinEnvironment.computeAfterLSTManagerUpdate(repository.getProject(), () -> {
            ArrayList<PartialCommitHelper> helpers = new ArrayList<PartialCommitHelper>();
            ArrayList<CommitChange> partialChanges = new ArrayList<CommitChange>();
            for (CommitChange change : changes) {
                PartialLocalLineStatusTracker tracker;
                if (change.changelistId == null || change.virtualFile == null || change.beforePath == null || change.afterPath == null || (tracker = PartialChangesUtil.getPartialTracker((Project)this.myProject, (VirtualFile)change.virtualFile)) == null) continue;
                if (!tracker.isOperational()) {
                    LOG.warn("Tracker is not operational for " + tracker.getVirtualFile().getPresentableUrl());
                    return null;
                }
                if (!tracker.hasPartialChangesToCommit()) continue;
                helpers.add(tracker.handlePartialCommit(Side.LEFT, Collections.singletonList(changelistId), true));
                partialChanges.add(change);
            }
            return Pair.create(helpers, partialChanges);
        });
        if (result2 == null) {
            throw new VcsException("Can't collect partial changes to commit");
        }
        List helpers = (List)result2.first;
        List partialChanges = (List)result2.second;
        ArrayList<Object> pathsToDelete = new ArrayList<Object>();
        for (CommitChange change2 : partialChanges) {
            if (!change2.isMove()) continue;
            pathsToDelete.add(ObjectUtils.assertNotNull((Object)change2.beforePath));
        }
        LOG.debug(String.format("Updating index for partial changes: removing: %s", pathsToDelete));
        GitFileUtils.deletePaths(this.myProject, repository.getRoot(), pathsToDelete, "--ignore-unmatch");
        LOG.debug(String.format("Updating index for partial changes: changes: %s", partialChanges));
        for (int i = 0; i < partialChanges.size(); ++i) {
            CommitChange change2;
            change2 = (CommitChange)partialChanges.get(i);
            FilePath path = (FilePath)ObjectUtils.assertNotNull((Object)change2.afterPath);
            PartialCommitHelper helper = (PartialCommitHelper)helpers.get(i);
            VirtualFile file = change2.virtualFile;
            if (file == null) {
                throw new VcsException("Can't find file: " + path.getPath());
            }
            GitIndexUtil.StagedFile stagedFile = GitCheckinEnvironment.getStagedFile(repository, change2);
            boolean isExecutable = stagedFile != null && stagedFile.isExecutable();
            byte[] fileContent = GitCheckinEnvironment.convertDocumentContentToBytes(repository, helper.getContent(), file);
            GitIndexUtil.write(repository, path, fileContent, isExecutable);
        }
        Runnable callback = () -> ApplicationManager.getApplication().invokeLater(() -> {
            for (PartialCommitHelper helper : helpers) {
                try {
                    helper.applyChanges();
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        });
        Pair pair = Pair.create((Object)callback, (Object)partialChanges);
        if (pair == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(29);
        }
        return pair;
    }

    @NotNull
    private static byte[] convertDocumentContentToBytes(@NotNull GitRepository repository, @NotNull String documentContent, @NotNull VirtualFile file) {
        String lineSeparator;
        if (repository == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(30);
        }
        if (documentContent == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(31);
        }
        if (file == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(32);
        }
        String text = (lineSeparator = FileDocumentManager.getInstance().getLineSeparator(file, repository.getProject())).equals("\n") ? documentContent : StringUtil.convertLineSeparators((String)documentContent, (String)lineSeparator);
        byte[] byArray = (byte[])LoadTextUtil.charsetForWriting((Project)repository.getProject(), (VirtualFile)file, (String)text, (Charset)file.getCharset()).second;
        if (byArray == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(33);
        }
        return byArray;
    }

    @Nullable
    private static GitIndexUtil.StagedFile getStagedFile(@NotNull GitRepository repository, @NotNull CommitChange change) throws VcsException {
        GitIndexUtil.StagedFile file;
        GitIndexUtil.StagedFile file2;
        FilePath bPath;
        if (repository == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(34);
        }
        if (change == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(35);
        }
        if ((bPath = change.beforePath) != null && (file2 = GitIndexUtil.listStaged(repository, bPath)) != null) {
            return file2;
        }
        FilePath aPath = change.afterPath;
        if (aPath != null && (file = GitIndexUtil.listStaged(repository, aPath)) != null) {
            return file;
        }
        return null;
    }

    @Nullable
    private static <T> T computeAfterLSTManagerUpdate(@NotNull Project project, @NotNull Computable<T> computation) {
        if (project == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(36);
        }
        if (computation == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(37);
        }
        assert (!ApplicationManager.getApplication().isDispatchThread());
        FutureResult ref = new FutureResult();
        LineStatusTrackerManager.getInstance((Project)project).invokeAfterUpdate(() -> {
            try {
                ref.set(computation.compute());
            }
            catch (Throwable e) {
                ref.setException(e);
            }
        });
        try {
            return (T)ref.get();
        }
        catch (InterruptedException | ExecutionException e) {
            return null;
        }
    }

    @NotNull
    private List<CommitChange> addCaseOnlyRenamesToIndex(@NotNull GitRepository repository, @NotNull Collection<? extends CommitChange> changes, @NotNull Set<CommitChange> alreadyProcessed, @NotNull List<? super VcsException> exceptions) {
        if (repository == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(38);
        }
        if (changes == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(39);
        }
        if (alreadyProcessed == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(40);
        }
        if (exceptions == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(41);
        }
        if (SystemInfo.isFileSystemCaseSensitive) {
            List<CommitChange> list = Collections.emptyList();
            if (list == null) {
                GitCheckinEnvironment.$$$reportNull$$$0(42);
            }
            return list;
        }
        List caseOnlyRenames = ContainerUtil.filter(changes, it -> !alreadyProcessed.contains(it) && GitCheckinEnvironment.isCaseOnlyRename(it));
        if (caseOnlyRenames.isEmpty()) {
            List list = caseOnlyRenames;
            if (list == null) {
                GitCheckinEnvironment.$$$reportNull$$$0(43);
            }
            return list;
        }
        LOG.info("Committing case only rename: " + GitCheckinEnvironment.getLogString(repository.getRoot().getPath(), caseOnlyRenames) + " in " + DvcsUtil.getShortRepositoryName((Repository)repository));
        List pathsToAdd = ContainerUtil.map((Collection)caseOnlyRenames, it -> it.afterPath);
        List pathsToDelete = ContainerUtil.map((Collection)caseOnlyRenames, it -> it.beforePath);
        LOG.debug(String.format("Updating index for case only changes: added: %s,\n removed: %s", pathsToAdd, pathsToDelete));
        GitCheckinEnvironment.updateIndex(this.myProject, repository.getRoot(), pathsToAdd, pathsToDelete, exceptions);
        List list = caseOnlyRenames;
        if (list == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(44);
        }
        return list;
    }

    private static boolean isCaseOnlyRename(@NotNull ChangedPath change) {
        if (change == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(45);
        }
        if (SystemInfo.isFileSystemCaseSensitive) {
            return false;
        }
        if (!change.isMove()) {
            return false;
        }
        FilePath afterPath = (FilePath)ObjectUtils.assertNotNull((Object)change.afterPath);
        FilePath beforePath = (FilePath)ObjectUtils.assertNotNull((Object)change.beforePath);
        return GitUtil.isCaseOnlyChange(beforePath.getPath(), afterPath.getPath());
    }

    @NotNull
    private static List<FilePath> getPaths(@NotNull Collection<? extends CommitChange> changes) {
        if (changes == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(46);
        }
        ArrayList<FilePath> files = new ArrayList<FilePath>();
        for (CommitChange commitChange : changes) {
            if (ChangesUtil.CASE_SENSITIVE_FILE_PATH_HASHING_STRATEGY.equals((Object)commitChange.beforePath, (Object)commitChange.afterPath)) {
                ContainerUtil.addIfNotNull(files, (Object)commitChange.beforePath);
                continue;
            }
            ContainerUtil.addIfNotNull(files, (Object)commitChange.beforePath);
            ContainerUtil.addIfNotNull(files, (Object)commitChange.afterPath);
        }
        ArrayList<FilePath> arrayList = files;
        if (arrayList == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(47);
        }
        return arrayList;
    }

    private static void processExcludedPaths(@NotNull Collection<? extends Change> changes, @NotNull Set<FilePath> added, @NotNull Set<FilePath> removed, @NotNull PairConsumer<? super FilePath, ? super FilePath> function) {
        if (changes == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(48);
        }
        if (added == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(49);
        }
        if (removed == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(50);
        }
        if (function == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(51);
        }
        for (Change change : changes) {
            FilePath before = ChangesUtil.getBeforePath((Change)change);
            FilePath after = ChangesUtil.getAfterPath((Change)change);
            if (removed.contains(before)) {
                before = null;
            }
            if (added.contains(after)) {
                after = null;
            }
            function.consume((Object)before, (Object)after);
        }
    }

    @NotNull
    private static String getLogString(@NotNull String root, @NotNull Collection<? extends ChangedPath> changes) {
        if (root == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(52);
        }
        if (changes == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(53);
        }
        String string = GitUtil.getLogString(root, changes, it -> it.beforePath, it -> it.afterPath);
        if (string == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(54);
        }
        return string;
    }

    @NotNull
    private Pair<Collection<CommitChange>, List<VcsException>> commitExplicitRenames(@NotNull GitRepository repository, @NotNull Collection<CommitChange> changes, @NotNull String message) {
        Pair pair;
        Pair<List<CommitChange>, List<CommitChange>> committedAndNewChanges;
        VirtualFile root;
        ArrayList<VcsException> exceptions;
        List providers;
        block11: {
            if (repository == null) {
                GitCheckinEnvironment.$$$reportNull$$$0(55);
            }
            if (changes == null) {
                GitCheckinEnvironment.$$$reportNull$$$0(56);
            }
            if (message == null) {
                GitCheckinEnvironment.$$$reportNull$$$0(57);
            }
            providers = ContainerUtil.filter((Object[])GitCheckinExplicitMovementProvider.EP_NAME.getExtensions(), it -> it.isEnabled(this.myProject));
            exceptions = new ArrayList<VcsException>();
            root = repository.getRoot();
            List beforePaths = ContainerUtil.mapNotNull(changes, it -> it.beforePath);
            List afterPaths = ContainerUtil.mapNotNull(changes, it -> it.afterPath);
            HashSet<GitCheckinExplicitMovementProvider.Movement> movedPaths = new HashSet<GitCheckinExplicitMovementProvider.Movement>();
            for (GitCheckinExplicitMovementProvider provider : providers) {
                Collection<GitCheckinExplicitMovementProvider.Movement> providerMovements = provider.collectExplicitMovements(this.myProject, beforePaths, afterPaths);
                if (providerMovements.isEmpty()) continue;
                message = provider.getCommitMessage(message);
                movedPaths.addAll(providerMovements);
            }
            committedAndNewChanges = this.addExplicitMovementsToIndex(repository, changes, movedPaths);
            if (committedAndNewChanges != null) break block11;
            Pair pair2 = Pair.create(changes, exceptions);
            if (pair2 == null) {
                GitCheckinEnvironment.$$$reportNull$$$0(58);
            }
            return pair2;
        }
        try {
            List movedChanges = (List)committedAndNewChanges.first;
            Collection newRootChanges = (Collection)committedAndNewChanges.second;
            GitCheckinEnvironment.runWithMessageFile(this.myProject, root, message, (ThrowableConsumer<? super File, ? extends VcsException>)((ThrowableConsumer)moveMessageFile -> exceptions.addAll(this.commitUsingIndex(repository, movedChanges, new HashSet(movedChanges), (File)moveMessageFile))));
            List committedMovements = ContainerUtil.mapNotNull((Collection)movedChanges, it -> Couple.of((Object)it.beforePath, (Object)it.afterPath));
            for (GitCheckinExplicitMovementProvider provider : providers) {
                provider.afterMovementsCommitted(this.myProject, committedMovements);
            }
            pair = Pair.create((Object)newRootChanges, exceptions);
        }
        catch (VcsException e) {
            exceptions.add(e);
            Pair pair3 = Pair.create(changes, exceptions);
            if (pair3 == null) {
                GitCheckinEnvironment.$$$reportNull$$$0(60);
            }
            return pair3;
        }
        if (pair == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(59);
        }
        return pair;
    }

    @Nullable
    private Pair<List<CommitChange>, List<CommitChange>> addExplicitMovementsToIndex(@NotNull GitRepository repository, @NotNull Collection<? extends CommitChange> changes, @NotNull Collection<? extends GitCheckinExplicitMovementProvider.Movement> explicitMoves) throws VcsException {
        if (repository == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(61);
        }
        if (changes == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(62);
        }
        if (explicitMoves == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(63);
        }
        if ((explicitMoves = GitCheckinEnvironment.filterExcludedChanges(explicitMoves, changes)).isEmpty()) {
            return null;
        }
        LOG.info("Committing explicit rename: " + explicitMoves + " in " + DvcsUtil.getShortRepositoryName((Repository)repository));
        HashMap<FilePath, GitCheckinExplicitMovementProvider.Movement> movesMap = new HashMap<FilePath, GitCheckinExplicitMovementProvider.Movement>();
        for (GitCheckinExplicitMovementProvider.Movement movement : explicitMoves) {
            movesMap.put(movement.getBefore(), movement);
            movesMap.put(movement.getAfter(), movement);
        }
        ArrayList<CommitChange> nextCommitChanges = new ArrayList<CommitChange>();
        ArrayList<CommitChange> arrayList = new ArrayList<CommitChange>();
        HashMap<FilePath, CommitChange> affectedBeforePaths = new HashMap<FilePath, CommitChange>();
        HashMap<FilePath, CommitChange> affectedAfterPaths = new HashMap<FilePath, CommitChange>();
        for (CommitChange commitChange : changes) {
            if (!movesMap.containsKey(commitChange.beforePath) && !movesMap.containsKey(commitChange.afterPath)) {
                nextCommitChanges.add(commitChange);
                continue;
            }
            if (commitChange.beforePath != null) {
                affectedBeforePaths.put(commitChange.beforePath, commitChange);
            }
            if (commitChange.afterPath == null) continue;
            affectedAfterPaths.put(commitChange.afterPath, commitChange);
        }
        List pathsToDelete = ContainerUtil.map(explicitMoves, move -> move.getBefore());
        LOG.debug(String.format("Updating index for explicit movements: removing: %s", pathsToDelete));
        GitFileUtils.deletePaths(this.myProject, repository.getRoot(), pathsToDelete, "--ignore-unmatch");
        for (GitCheckinExplicitMovementProvider.Movement movement : explicitMoves) {
            FilePath beforeFilePath = movement.getBefore();
            FilePath afterFilePath = movement.getAfter();
            CommitChange bChange = (CommitChange)ObjectUtils.assertNotNull(affectedBeforePaths.get(beforeFilePath));
            CommitChange aChange = (CommitChange)ObjectUtils.assertNotNull(affectedAfterPaths.get(afterFilePath));
            if (bChange.beforeRevision == null) {
                LOG.warn(String.format("Unknown before revision: %s, %s", bChange, aChange));
                continue;
            }
            GitIndexUtil.StagedFile stagedFile = GitIndexUtil.listTree(repository, beforeFilePath, bChange.beforeRevision);
            if (stagedFile == null) {
                LOG.warn(String.format("Can't get revision for explicit move: %s -> %s", beforeFilePath, afterFilePath));
                continue;
            }
            LOG.debug(String.format("Updating index for explicit movements: adding movement: %s -> %s", beforeFilePath, afterFilePath));
            Hash hash = HashImpl.build((String)stagedFile.getBlobHash());
            boolean isExecutable = stagedFile.isExecutable();
            GitIndexUtil.updateIndex(repository, afterFilePath, hash, isExecutable);
            nextCommitChanges.add(new CommitChange(afterFilePath, afterFilePath, null, null, aChange.changelistId, aChange.virtualFile));
            arrayList.add(new CommitChange(beforeFilePath, afterFilePath, null, null, null, null));
            affectedBeforePaths.remove(beforeFilePath);
            affectedAfterPaths.remove(afterFilePath);
        }
        affectedBeforePaths.forEach((bPath, change) -> nextCommitChanges.add(new CommitChange(change.beforePath, null, change.beforeRevision, null, change.changelistId, change.virtualFile)));
        affectedAfterPaths.forEach((aPath, change) -> nextCommitChanges.add(new CommitChange(null, change.afterPath, null, change.afterRevision, change.changelistId, change.virtualFile)));
        if (arrayList.isEmpty()) {
            return null;
        }
        return Pair.create(arrayList, nextCommitChanges);
    }

    @NotNull
    private static List<GitCheckinExplicitMovementProvider.Movement> filterExcludedChanges(@NotNull Collection<? extends GitCheckinExplicitMovementProvider.Movement> explicitMoves, @NotNull Collection<? extends CommitChange> changes) {
        if (explicitMoves == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(64);
        }
        if (changes == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(65);
        }
        HashMultiset movedPathsMultiSet = HashMultiset.create();
        for (GitCheckinExplicitMovementProvider.Movement movement : explicitMoves) {
            movedPathsMultiSet.add((Object)movement.getBefore());
            movedPathsMultiSet.add((Object)movement.getAfter());
        }
        HashMultiset beforePathsMultiSet = HashMultiset.create();
        HashMultiset hashMultiset = HashMultiset.create();
        for (CommitChange commitChange : changes) {
            ContainerUtil.addIfNotNull((Collection)beforePathsMultiSet, (Object)commitChange.beforePath);
            ContainerUtil.addIfNotNull((Collection)hashMultiset, (Object)commitChange.afterPath);
        }
        List list = ContainerUtil.filter(explicitMoves, move -> movedPathsMultiSet.count((Object)move.getBefore()) == 1 && movedPathsMultiSet.count((Object)move.getAfter()) == 1 && beforePathsMultiSet.count((Object)move.getBefore()) == 1 && afterPathsMultiSet.count((Object)move.getAfter()) == 1 && beforePathsMultiSet.count((Object)move.getAfter()) == 0 && afterPathsMultiSet.count((Object)move.getBefore()) == 0);
        if (list == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(66);
        }
        return list;
    }

    private static void resetExcluded(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends ChangedPath> changes) throws VcsException {
        if (project == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(67);
        }
        if (root == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(68);
        }
        if (changes == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(69);
        }
        THashSet allPaths = new THashSet(ChangesUtil.CASE_SENSITIVE_FILE_PATH_HASHING_STRATEGY);
        for (ChangedPath changedPath : changes) {
            ContainerUtil.addIfNotNull((Collection)allPaths, (Object)changedPath.afterPath);
            ContainerUtil.addIfNotNull((Collection)allPaths, (Object)changedPath.beforePath);
        }
        for (List list : VcsFileUtil.chunkPaths((VirtualFile)root, (Collection)allPaths)) {
            GitLineHandler handler = new GitLineHandler(project, root, GitCommand.RESET);
            handler.endOptions();
            handler.addParameters(list);
            Git.getInstance().runCommand(handler).throwOnError(new int[0]);
        }
    }

    private static void restoreExcluded(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends ChangedPath> changes, @NotNull Set<FilePath> unstagedDeletions) {
        if (project == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(70);
        }
        if (root == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(71);
        }
        if (changes == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(72);
        }
        if (unstagedDeletions == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(73);
        }
        ArrayList restoreExceptions = new ArrayList();
        HashSet toAdd = new HashSet();
        HashSet toRemove = new HashSet();
        for (ChangedPath changedPath : changes) {
            if (GitCheckinEnvironment.addAsCaseOnlyRename(project, root, changedPath, restoreExceptions)) continue;
            if (changedPath.beforePath == null && unstagedDeletions.contains(changedPath.afterPath)) {
                LOG.info("Ignored added-deleted staged change in " + changedPath.afterPath);
                continue;
            }
            ContainerUtil.addIfNotNull(toAdd, (Object)changedPath.afterPath);
            ContainerUtil.addIfNotNull(toRemove, (Object)changedPath.beforePath);
        }
        toRemove.removeAll(toAdd);
        LOG.debug(String.format("Restoring staged changes after commit: added: %s, removed: %s", toAdd, toRemove));
        GitCheckinEnvironment.updateIndex(project, root, toAdd, toRemove, restoreExceptions);
        for (VcsException vcsException : restoreExceptions) {
            LOG.warn((Throwable)vcsException);
        }
    }

    private static boolean addAsCaseOnlyRename(@NotNull Project project, @NotNull VirtualFile root, @NotNull ChangedPath change, @NotNull List<? super VcsException> exceptions) {
        if (project == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(74);
        }
        if (root == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(75);
        }
        if (change == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(76);
        }
        if (exceptions == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(77);
        }
        try {
            if (!GitCheckinEnvironment.isCaseOnlyRename(change)) {
                return false;
            }
            FilePath beforePath = (FilePath)ObjectUtils.assertNotNull((Object)change.beforePath);
            FilePath afterPath = (FilePath)ObjectUtils.assertNotNull((Object)change.afterPath);
            LOG.debug(String.format("Restoring staged case-only rename after commit: %s", change));
            GitLineHandler h = new GitLineHandler(project, root, GitCommand.MV);
            h.addParameters("-f", beforePath.getPath(), afterPath.getPath());
            Git.getInstance().runCommandWithoutCollectingOutput(h).throwOnError(new int[0]);
            return true;
        }
        catch (VcsException e) {
            exceptions.add(e);
            return false;
        }
    }

    private boolean mergeCommit(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends CommitChange> rootChanges, @NotNull File messageFile, @NotNull List<? super VcsException> exceptions, @NotNull PartialOperation partialOperation) {
        String output;
        if (project == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(78);
        }
        if (root == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(79);
        }
        if (rootChanges == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(80);
        }
        if (messageFile == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(81);
        }
        if (exceptions == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(82);
        }
        if (partialOperation == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(83);
        }
        Set added = ContainerUtil.map2SetNotNull(rootChanges, it -> it.afterPath);
        Set removed = ContainerUtil.map2SetNotNull(rootChanges, it -> it.beforePath);
        removed.removeAll(added);
        HashSet<FilePath> realAdded = new HashSet<FilePath>();
        HashSet<FilePath> realRemoved = new HashSet<FilePath>();
        GitLineHandler diff = new GitLineHandler(project, root, GitCommand.DIFF);
        diff.setSilent(true);
        diff.setStdoutSuppressed(true);
        diff.addParameters("--diff-filter=ADMRUX", "--name-status", "--no-renames", "HEAD");
        diff.endOptions();
        try {
            output = Git.getInstance().runCommand(diff).getOutputOrThrow(new int[0]);
        }
        catch (VcsException ex) {
            exceptions.add(ex);
            return false;
        }
        String rootPath = root.getPath();
        StringTokenizer lines = new StringTokenizer(output, "\n", false);
        block11: while (lines.hasMoreTokens()) {
            String line = lines.nextToken().trim();
            if (line.length() == 0) continue;
            String[] tk = line.split("\t");
            switch (tk[0].charAt(0)) {
                case 'A': 
                case 'M': {
                    realAdded.add(VcsUtil.getFilePath((String)(rootPath + "/" + tk[1])));
                    continue block11;
                }
                case 'D': {
                    realRemoved.add(VcsUtil.getFilePath((String)(rootPath + "/" + tk[1]), (boolean)false));
                    continue block11;
                }
            }
            throw new IllegalStateException("Unexpected status: " + line);
        }
        realAdded.removeAll(added);
        realRemoved.removeAll(removed);
        if (realAdded.size() != 0 || realRemoved.size() != 0) {
            ArrayList<FilePath> files = new ArrayList<FilePath>();
            files.addAll(realAdded);
            files.addAll(realRemoved);
            Ref mergeAll = new Ref();
            try {
                ApplicationManager.getApplication().invokeAndWait(() -> {
                    String message = GitBundle.message("commit.partial.merge.message", partialOperation.getName());
                    SelectFilePathsDialog dialog = new SelectFilePathsDialog(project, files, message, null, "Commit All Files", CommonBundle.getCancelButtonText(), false);
                    dialog.setTitle(GitBundle.getString("commit.partial.merge.title"));
                    dialog.show();
                    mergeAll.set((Object)dialog.isOK());
                });
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RuntimeException("Unable to invoke a message box on AWT thread", ex);
            }
            if (!((Boolean)mergeAll.get()).booleanValue()) {
                return false;
            }
            if (!GitCheckinEnvironment.updateIndex(project, root, realAdded, realRemoved, exceptions)) {
                return false;
            }
            for (FilePath f : realAdded) {
                VcsDirtyScopeManager.getInstance((Project)project).fileDirty(f);
            }
            for (FilePath f : realRemoved) {
                VcsDirtyScopeManager.getInstance((Project)project).fileDirty(f);
            }
        }
        try {
            this.commitWithoutPaths(project, root, messageFile);
        }
        catch (VcsException ex) {
            exceptions.add(ex);
            return false;
        }
        return true;
    }

    private void commitWithoutPaths(@NotNull Project project, @NotNull VirtualFile root, @NotNull File messageFile) throws VcsException {
        if (project == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(84);
        }
        if (root == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(85);
        }
        if (messageFile == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(86);
        }
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.COMMIT);
        handler.setStdoutSuppressed(false);
        handler.addParameters("-F");
        handler.addAbsoluteFile(messageFile);
        if (this.myNextCommitAmend) {
            handler.addParameters("--amend");
        }
        if (this.myNextCommitAuthor != null) {
            handler.addParameters("--author=" + this.myNextCommitAuthor);
        }
        if (this.myNextCommitAuthorDate != null) {
            handler.addParameters("--date", COMMIT_DATE_FORMAT.format(this.myNextCommitAuthorDate));
        }
        if (this.myNextCommitSignOff) {
            handler.addParameters("--signoff");
        }
        if (this.myNextCommitSkipHook) {
            handler.addParameters("--no-verify");
        }
        handler.endOptions();
        Git.getInstance().runCommand(handler).throwOnError(new int[0]);
    }

    private static PartialOperation isMergeCommit(VcsException ex) {
        String message = ex.getMessage();
        if (message.contains("cannot do a partial commit during a merge")) {
            return PartialOperation.MERGE;
        }
        if (message.contains("cannot do a partial commit during a cherry-pick")) {
            return PartialOperation.CHERRY_PICK;
        }
        return PartialOperation.NONE;
    }

    private static boolean updateIndex(Project project, VirtualFile root, Collection<? extends FilePath> added, Collection<? extends FilePath> removed, List<? super VcsException> exceptions) {
        boolean rc = true;
        if (!removed.isEmpty()) {
            try {
                GitFileUtils.deletePaths(project, root, removed, "--ignore-unmatch", "--cached", "-r");
            }
            catch (VcsException ex) {
                exceptions.add(ex);
                rc = false;
            }
        }
        if (!added.isEmpty()) {
            try {
                GitFileUtils.addPathsForce(project, root, added);
            }
            catch (VcsException ex) {
                exceptions.add(ex);
                rc = false;
            }
        }
        return rc;
    }

    @NotNull
    public static File createCommitMessageFile(@NotNull Project project, @NotNull VirtualFile root, @NotNull String message) throws IOException {
        if (project == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(87);
        }
        if (root == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(88);
        }
        if (message == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(89);
        }
        File file = FileUtil.createTempFile((String)GIT_COMMIT_MSG_FILE_PREFIX, (String)GIT_COMMIT_MSG_FILE_EXT);
        file.deleteOnExit();
        String encoding = GitConfigUtil.getCommitEncoding(project, root);
        try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding);){
            out.write(message);
        }
        File file2 = file;
        if (file2 == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(90);
        }
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runWithMessageFile(@NotNull Project project, @NotNull VirtualFile root, @NotNull String message, @NotNull ThrowableConsumer<? super File, ? extends VcsException> task) throws VcsException {
        File messageFile;
        if (project == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(91);
        }
        if (root == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(92);
        }
        if (message == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(93);
        }
        if (task == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(94);
        }
        try {
            messageFile = GitCheckinEnvironment.createCommitMessageFile(project, root, message);
        }
        catch (IOException ex) {
            throw new VcsException("Creation of commit message file failed", (Throwable)ex);
        }
        try {
            task.consume((Object)messageFile);
        }
        finally {
            if (!messageFile.delete()) {
                LOG.warn("Failed to remove temporary file: " + messageFile);
            }
        }
    }

    public List<VcsException> scheduleMissingFileForDeletion(@NotNull List<FilePath> files) {
        Map<VirtualFile, List<FilePath>> sortedFiles;
        if (files == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(95);
        }
        ArrayList<VcsException> rc = new ArrayList<VcsException>();
        try {
            sortedFiles = GitUtil.sortFilePathsByGitRoot(this.myProject, files);
        }
        catch (VcsException e) {
            rc.add(e);
            return rc;
        }
        for (Map.Entry<VirtualFile, List<FilePath>> e : sortedFiles.entrySet()) {
            try {
                VirtualFile root = e.getKey();
                GitFileUtils.deletePaths(this.myProject, root, (Collection<? extends FilePath>)e.getValue(), new String[0]);
                this.markRootDirty(root);
            }
            catch (VcsException ex) {
                rc.add(ex);
            }
        }
        return rc;
    }

    private void commit(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends FilePath> files, @NotNull File messageFile) throws VcsException {
        if (project == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(96);
        }
        if (root == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(97);
        }
        if (files == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(98);
        }
        if (messageFile == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(99);
        }
        boolean amend = this.myNextCommitAmend;
        for (List paths : VcsFileUtil.chunkPaths((VirtualFile)root, files)) {
            GitLineHandler handler = new GitLineHandler(project, root, GitCommand.COMMIT);
            handler.setStdoutSuppressed(false);
            if (this.myNextCommitSignOff) {
                handler.addParameters("--signoff");
            }
            if (amend) {
                handler.addParameters("--amend");
            } else {
                amend = true;
            }
            if (this.myNextCommitSkipHook) {
                handler.addParameters("--no-verify");
            }
            handler.addParameters("--only");
            handler.addParameters("-F");
            handler.addAbsoluteFile(messageFile);
            if (this.myNextCommitAuthor != null) {
                handler.addParameters("--author=" + this.myNextCommitAuthor);
            }
            if (this.myNextCommitAuthorDate != null) {
                handler.addParameters("--date", COMMIT_DATE_FORMAT.format(this.myNextCommitAuthorDate));
            }
            handler.endOptions();
            handler.addParameters(paths);
            Git.getInstance().runCommand(handler).throwOnError(new int[0]);
        }
    }

    public List<VcsException> scheduleUnversionedFilesForAddition(@NotNull List<VirtualFile> files) {
        Map<VirtualFile, List<VirtualFile>> sortedFiles;
        if (files == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(100);
        }
        ArrayList<VcsException> rc = new ArrayList<VcsException>();
        try {
            sortedFiles = GitUtil.sortFilesByGitRoot(this.myProject, files);
        }
        catch (VcsException e) {
            rc.add(e);
            return rc;
        }
        for (Map.Entry<VirtualFile, List<VirtualFile>> e : sortedFiles.entrySet()) {
            try {
                VirtualFile root = e.getKey();
                GitFileUtils.addFiles(this.myProject, root, (Collection<VirtualFile>)e.getValue());
                this.markRootDirty(root);
            }
            catch (VcsException ex) {
                rc.add(ex);
            }
        }
        return rc;
    }

    @NotNull
    private static Map<VirtualFile, Collection<Change>> sortChangesByGitRoot(@NotNull Project project, @NotNull List<? extends Change> changes, @NotNull List<? super VcsException> exceptions) {
        if (project == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(101);
        }
        if (changes == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(102);
        }
        if (exceptions == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(103);
        }
        HashMap<VirtualFile, Collection<Change>> result2 = new HashMap<VirtualFile, Collection<Change>>();
        for (Change change : changes) {
            try {
                FilePath filePath = ChangesUtil.getFilePath((Change)change);
                GitRepository repository = GitUtil.getRepositoryForFile(project, (FilePath)ObjectUtils.assertNotNull((Object)filePath.getParentPath()));
                Collection changeList = result2.computeIfAbsent(repository.getRoot(), key -> new ArrayList());
                changeList.add(change);
            }
            catch (VcsException e) {
                exceptions.add(e);
            }
        }
        HashMap<VirtualFile, Collection<Change>> hashMap = result2;
        if (hashMap == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(104);
        }
        return hashMap;
    }

    private void markRootDirty(VirtualFile root) {
        this.myDirtyScopeManager.dirDirtyRecursively(root);
    }

    public void reset() {
        this.myNextCommitAuthor = null;
        this.myNextCommitAuthorDate = null;
        this.myNextCommitSkipHook = false;
    }

    public void setSkipHooksForNextCommit(boolean skipHooksForNextCommit) {
        this.myNextCommitSkipHook = skipHooksForNextCommit;
    }

    public void setCommitRenamesSeparately(boolean commitRenamesSeparately) {
        this.myNextCommitCommitRenamesSeparately = commitRenamesSeparately;
    }

    private /* synthetic */ void lambda$commitRepository$3(VirtualFile root, Collection changes, List exceptions, PartialOperation partialOperation, VcsException ex, File messageFile) throws VcsException {
        if (!this.mergeCommit(this.myProject, root, changes, messageFile, exceptions, partialOperation)) {
            throw ex;
        }
    }

    private /* synthetic */ void lambda$commitRepository$2(Collection changes, VirtualFile root, File messageFile) throws VcsException {
        List<FilePath> files = GitCheckinEnvironment.getPaths(changes);
        this.commit(this.myProject, root, files, messageFile);
    }

    private /* synthetic */ void lambda$commitRepository$1(List exceptions, GitRepository repository, Collection changes, Set changedWithIndex, File messageFile) throws VcsException {
        exceptions.addAll(this.commitUsingIndex(repository, changes, changedWithIndex, messageFile));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 33: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 54: 
            case 58: 
            case 59: 
            case 60: 
            case 66: 
            case 90: 
            case 104: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 33: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 54: 
            case 58: 
            case 59: 
            case 60: 
            case 66: 
            case 90: 
            case 104: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirtyScopeManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitPanel";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitContext";
                break;
            }
            case 4: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 33: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 54: 
            case 58: 
            case 59: 
            case 60: 
            case 66: 
            case 90: 
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/checkin/GitCheckinEnvironment";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToCheckin";
                break;
            }
            case 6: 
            case 23: 
            case 81: 
            case 86: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encoding";
                break;
            }
            case 8: 
            case 52: 
            case 68: 
            case 71: 
            case 75: 
            case 79: 
            case 85: 
            case 88: 
            case 92: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 9: 
            case 15: 
            case 27: 
            case 39: 
            case 46: 
            case 48: 
            case 53: 
            case 56: 
            case 62: 
            case 65: 
            case 69: 
            case 72: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitMessage";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "feedback";
                break;
            }
            case 14: 
            case 20: 
            case 26: 
            case 30: 
            case 34: 
            case 38: 
            case 55: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 16: 
            case 57: 
            case 89: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 21: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootChanges";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changedWithIndex";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentContent";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 35: 
            case 45: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computation";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alreadyProcessed";
                break;
            }
            case 41: 
            case 77: 
            case 82: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptions";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "added";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removed";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 63: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "explicitMoves";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unstagedDeletions";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "partialOperation";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 95: 
            case 98: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/checkin/GitCheckinEnvironment";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommitOptions";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "commit";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "commitRepository";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "commitUsingIndex";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "addPartialChangesToIndex";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "convertDocumentContentToBytes";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "addCaseOnlyRenamesToIndex";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getPaths";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogString";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "commitExplicitRenames";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "filterExcludedChanges";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommitMessageFile";
                break;
            }
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "sortChangesByGitRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createCommitOptions";
                break;
            }
            case 4: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 33: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 54: 
            case 58: 
            case 59: 
            case 60: 
            case 66: 
            case 90: 
            case 104: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultMessageFor";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadMessage";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getLastCommitMessage";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 96: 
            case 97: 
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "commit";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "commitRepository";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "commitUsingIndex";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addPartialChangesToIndex";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "convertDocumentContentToBytes";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getStagedFile";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "computeAfterLSTManagerUpdate";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "addCaseOnlyRenamesToIndex";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isCaseOnlyRename";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getPaths";
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "processExcludedPaths";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getLogString";
                break;
            }
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "commitExplicitRenames";
                break;
            }
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "addExplicitMovementsToIndex";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "filterExcludedChanges";
                break;
            }
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "resetExcluded";
                break;
            }
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "restoreExcluded";
                break;
            }
            case 74: 
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "addAsCaseOnlyRename";
                break;
            }
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "mergeCommit";
                break;
            }
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "commitWithoutPaths";
                break;
            }
            case 87: 
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "createCommitMessageFile";
                break;
            }
            case 91: 
            case 92: 
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "runWithMessageFile";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "scheduleMissingFileForDeletion";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "scheduleUnversionedFilesForAddition";
                break;
            }
            case 101: 
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "sortChangesByGitRoot";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 33: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 54: 
            case 58: 
            case 59: 
            case 60: 
            case 66: 
            case 90: 
            case 104: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CommitChange
    extends ChangedPath {
        @Nullable
        public final VcsRevisionNumber beforeRevision;
        @Nullable
        public final VcsRevisionNumber afterRevision;
        @Nullable
        public final String changelistId;
        @Nullable
        public final VirtualFile virtualFile;

        CommitChange(@NotNull Change change) {
            if (change == null) {
                CommitChange.$$$reportNull$$$0(0);
            }
            super(ChangesUtil.getBeforePath((Change)change), ChangesUtil.getAfterPath((Change)change));
            ContentRevision bRev = change.getBeforeRevision();
            ContentRevision aRev = change.getAfterRevision();
            this.beforeRevision = bRev != null ? bRev.getRevisionNumber() : null;
            this.afterRevision = aRev != null ? aRev.getRevisionNumber() : null;
            this.changelistId = change instanceof ChangeListChange ? ((ChangeListChange)change).getChangeListId() : null;
            this.virtualFile = aRev instanceof CurrentContentRevision ? ((CurrentContentRevision)aRev).getVirtualFile() : null;
        }

        CommitChange(@Nullable FilePath beforePath, @Nullable FilePath afterPath, @Nullable VcsRevisionNumber beforeRevision, @Nullable VcsRevisionNumber afterRevision, @Nullable String changelistId, @Nullable VirtualFile virtualFile) {
            super(beforePath, afterPath);
            this.beforeRevision = beforeRevision;
            this.afterRevision = afterRevision;
            this.changelistId = changelistId;
            this.virtualFile = virtualFile;
        }

        @Override
        public String toString() {
            return super.toString() + ", changelist: " + this.changelistId;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "git4idea/checkin/GitCheckinEnvironment$CommitChange", "<init>"));
        }
    }

    private static class ChangedPath {
        @Nullable
        public final FilePath beforePath;
        @Nullable
        public final FilePath afterPath;

        ChangedPath(@Nullable FilePath beforePath, @Nullable FilePath afterPath) {
            assert (beforePath != null || afterPath != null);
            this.beforePath = beforePath;
            this.afterPath = afterPath;
        }

        public boolean isMove() {
            if (this.beforePath == null || this.afterPath == null) {
                return false;
            }
            return !ChangesUtil.CASE_SENSITIVE_FILE_PATH_HASHING_STRATEGY.equals((Object)this.beforePath, (Object)this.afterPath);
        }

        public String toString() {
            return String.format("%s -> %s", this.beforePath, this.afterPath);
        }
    }

    public class GitCheckinOptions
    implements CheckinChangeListSpecificComponent,
    RefreshableOnComponent,
    AmendCommitModeListener,
    Disposable {
        private final List<GitCheckinExplicitMovementProvider> myExplicitMovementProviders;
        @NotNull
        private final CheckinProjectPanel myCheckinProjectPanel;
        @NotNull
        private final JPanel myPanel;
        @NotNull
        private final EditorTextField myAuthorField;
        @Nullable
        private Date myAuthorDate;
        @NotNull
        private final JCheckBox mySignOffCheckbox;
        @NotNull
        private final JCheckBox myCommitRenamesSeparatelyCheckbox;
        @NotNull
        private final BalloonBuilder myAuthorNotificationBuilder;
        @Nullable
        private Balloon myAuthorBalloon;

        GitCheckinOptions(@NotNull Project project, CheckinProjectPanel panel, boolean showAmendOption) {
            if (project == null) {
                GitCheckinOptions.$$$reportNull$$$0(0);
            }
            if (panel == null) {
                GitCheckinOptions.$$$reportNull$$$0(1);
            }
            this.myExplicitMovementProviders = this.collectActiveMovementProviders(GitCheckinEnvironment.this.myProject);
            this.myCheckinProjectPanel = panel;
            this.myAuthorField = this.createTextField(project, this.getAuthors(project));
            this.myAuthorField.addFocusListener((FocusListener)new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    GitCheckinOptions.this.clearAuthorWarn();
                }
            });
            this.myAuthorNotificationBuilder = JBPopupFactory.getInstance().createBalloonBuilder((JComponent)new JLabel(GitBundle.getString("commit.author.diffs"))).setBorderInsets(UIManager.getInsets("Balloon.error.textInsets")).setBorderColor(JBUI.CurrentTheme.Validator.warningBorderColor()).setFillColor(JBUI.CurrentTheme.Validator.warningBackgroundColor()).setHideOnClickOutside(true).setHideOnFrameResize(false);
            this.myAuthorField.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent e) {
                    if ((e.getChangeFlags() & 4L) != 0L && GitCheckinOptions.this.myAuthorField.isShowing() && !StringUtil.isEmptyOrSpaces((String)GitCheckinOptions.this.myAuthorField.getText())) {
                        GitCheckinOptions.this.showAuthorBalloonNotification();
                        GitCheckinOptions.this.myAuthorField.removeHierarchyListener((HierarchyListener)this);
                    }
                }
            });
            JBLabel authorLabel = new JBLabel(GitBundle.message("commit.author", new Object[0]));
            authorLabel.setLabelFor((Component)this.myAuthorField);
            ToggleAmendCommitOption amendOption = showAmendOption ? new ToggleAmendCommitOption(this.myCheckinProjectPanel, (Disposable)this) : null;
            this.mySignOffCheckbox = new JBCheckBox("Sign-off commit", GitCheckinEnvironment.this.mySettings.shouldSignOffCommit());
            this.mySignOffCheckbox.setMnemonic(71);
            this.mySignOffCheckbox.setToolTipText(this.getToolTip(project, panel));
            this.myCommitRenamesSeparatelyCheckbox = new JBCheckBox(this.getExplicitMovementDescription(), GitCheckinEnvironment.this.mySettings.isCommitRenamesSeparately());
            GridBag gb = new GridBag().setDefaultAnchor(17).setDefaultInsets((Insets)JBUI.insets((int)2));
            this.myPanel = new JPanel(new GridBagLayout());
            this.myPanel.add((Component)authorLabel, gb.nextLine().next());
            this.myPanel.add((Component)this.myAuthorField, gb.next().fillCellHorizontally().weightx(1.0));
            if (amendOption != null) {
                this.myPanel.add((Component)amendOption, gb.nextLine().next().coverLine());
            }
            this.myPanel.add((Component)this.mySignOffCheckbox, gb.nextLine().next().coverLine());
            this.myPanel.add((Component)this.myCommitRenamesSeparatelyCheckbox, gb.nextLine().next().coverLine());
            this.getAmendHandler().addAmendCommitModeListener((AmendCommitModeListener)this, (Disposable)this);
        }

        @NotNull
        private AmendCommitHandler getAmendHandler() {
            AmendCommitHandler amendCommitHandler = this.myCheckinProjectPanel.getCommitWorkflowHandler().getAmendCommitHandler();
            if (amendCommitHandler == null) {
                GitCheckinOptions.$$$reportNull$$$0(2);
            }
            return amendCommitHandler;
        }

        public void dispose() {
        }

        public void amendCommitModeToggled() {
            this.updateRenamesCheckboxState();
        }

        public boolean isAmend() {
            return this.getAmendHandler().isAmendCommitMode();
        }

        @Nullable
        public String getAuthor() {
            String author = this.myAuthorField.getText();
            if (StringUtil.isEmptyOrSpaces((String)author)) {
                return null;
            }
            return GitCommitAuthorCorrector.correct(author);
        }

        @NotNull
        private String getToolTip(@NotNull Project project, @NotNull CheckinProjectPanel panel) {
            VcsUser user;
            if (project == null) {
                GitCheckinOptions.$$$reportNull$$$0(3);
            }
            if (panel == null) {
                GitCheckinOptions.$$$reportNull$$$0(4);
            }
            String signature = (user = (VcsUser)ContainerUtil.getFirstItem((List)ContainerUtil.mapNotNull((Collection)panel.getRoots(), it -> GitUserRegistry.getInstance(project).getUser((VirtualFile)it)))) != null ? StringUtil.escapeXmlEntities((String)VcsUserUtil.toExactString((VcsUser)user)) : "";
            String string = "<html>Adds the following line at the end of the commit message:<br/>Signed-off by: " + signature + "</html>";
            if (string == null) {
                GitCheckinOptions.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        private String getExplicitMovementDescription() {
            if (this.myExplicitMovementProviders.size() == 1) {
                String string = this.myExplicitMovementProviders.get(0).getDescription();
                if (string == null) {
                    GitCheckinOptions.$$$reportNull$$$0(6);
                }
                return string;
            }
            if ("Create extra commit with file movements" == null) {
                GitCheckinOptions.$$$reportNull$$$0(7);
            }
            return "Create extra commit with file movements";
        }

        private void showAuthorBalloonNotification() {
            if (this.myAuthorBalloon == null || this.myAuthorBalloon.isDisposed()) {
                this.myAuthorBalloon = this.myAuthorNotificationBuilder.createBalloon();
                this.myAuthorBalloon.show(new RelativePoint((Component)this.myAuthorField, new Point(this.myAuthorField.getWidth() / 2, this.myAuthorField.getHeight())), Balloon.Position.below);
            }
        }

        @NotNull
        private List<String> getAuthors(@NotNull Project project) {
            if (project == null) {
                GitCheckinOptions.$$$reportNull$$$0(8);
            }
            HashSet<String> authors = new HashSet<String>(this.getUsersList(project));
            ContainerUtil.addAll(authors, (Object[])GitCheckinEnvironment.this.mySettings.getCommitAuthors());
            ArrayList<String> list = new ArrayList<String>(authors);
            Collections.sort(list);
            ArrayList<String> arrayList = list;
            if (arrayList == null) {
                GitCheckinOptions.$$$reportNull$$$0(9);
            }
            return arrayList;
        }

        @NotNull
        private EditorTextField createTextField(@NotNull Project project, @NotNull List<String> list) {
            if (project == null) {
                GitCheckinOptions.$$$reportNull$$$0(10);
            }
            if (list == null) {
                GitCheckinOptions.$$$reportNull$$$0(11);
            }
            ValuesCompletionProvider.ValuesCompletionProviderDumbAware completionProvider = new ValuesCompletionProvider.ValuesCompletionProviderDumbAware((TextCompletionValueDescriptor)new DefaultTextCompletionValueDescriptor.StringValueDescriptor(), list);
            TextFieldWithCompletion textFieldWithCompletion = new TextFieldWithCompletion(project, (TextCompletionProvider)completionProvider, "", true, true, true){

                public void updateUI() {
                    this.setBackground(null);
                    super.updateUI();
                }
            };
            if (textFieldWithCompletion == null) {
                GitCheckinOptions.$$$reportNull$$$0(12);
            }
            return textFieldWithCompletion;
        }

        @NotNull
        private List<String> getUsersList(@NotNull Project project) {
            if (project == null) {
                GitCheckinOptions.$$$reportNull$$$0(13);
            }
            VcsUserRegistry userRegistry = (VcsUserRegistry)ServiceManager.getService((Project)project, VcsUserRegistry.class);
            List list = ContainerUtil.map((Collection)userRegistry.getUsers(), VcsUserUtil::toExactString);
            if (list == null) {
                GitCheckinOptions.$$$reportNull$$$0(14);
            }
            return list;
        }

        private void updateRenamesCheckboxState() {
            if (this.myExplicitMovementProviders.isEmpty() || !Registry.is((String)"git.allow.explicit.commit.renames")) {
                this.myCommitRenamesSeparatelyCheckbox.setVisible(false);
                this.myCommitRenamesSeparatelyCheckbox.setEnabled(false);
            } else {
                this.myCommitRenamesSeparatelyCheckbox.setVisible(true);
                this.myCommitRenamesSeparatelyCheckbox.setEnabled(!this.isAmend());
            }
        }

        public void refresh() {
            this.updateRenamesCheckboxState();
            this.myAuthorField.setText(null);
            this.clearAuthorWarn();
            this.myAuthorDate = null;
            GitCheckinEnvironment.this.reset();
        }

        public void saveState() {
            GitCheckinEnvironment.this.myNextCommitAuthor = this.getAuthor();
            if (GitCheckinEnvironment.this.myNextCommitAuthor != null) {
                GitCheckinEnvironment.this.mySettings.saveCommitAuthor(GitCheckinEnvironment.this.myNextCommitAuthor);
            }
            GitCheckinEnvironment.this.myNextCommitAuthorDate = this.myAuthorDate;
            GitCheckinEnvironment.this.mySettings.setSignOffCommit(this.mySignOffCheckbox.isSelected());
            GitCheckinEnvironment.this.myNextCommitSignOff = this.mySignOffCheckbox.isSelected();
            GitCheckinEnvironment.this.mySettings.setCommitRenamesSeparately(this.myCommitRenamesSeparatelyCheckbox.isSelected());
            GitCheckinEnvironment.this.myNextCommitCommitRenamesSeparately = this.myCommitRenamesSeparatelyCheckbox.isEnabled() && this.myCommitRenamesSeparatelyCheckbox.isSelected();
        }

        public void restoreState() {
            this.refresh();
        }

        public void onChangeListSelected(LocalChangeList list) {
            this.updateRenamesCheckboxState();
            Object data = list.getData();
            this.clearAuthorWarn();
            if (data instanceof ChangeListData) {
                this.fillAuthorAndDateFromData((ChangeListData)data);
            } else {
                this.myAuthorField.setText(null);
                this.myAuthorDate = null;
            }
            this.myPanel.revalidate();
            this.myPanel.repaint();
        }

        private void fillAuthorAndDateFromData(@NotNull ChangeListData data) {
            VcsUser author;
            if (data == null) {
                GitCheckinOptions.$$$reportNull$$$0(15);
            }
            if ((author = data.getAuthor()) != null && !this.isDefaultAuthor(author)) {
                this.myAuthorField.setText(VcsUserUtil.toExactString((VcsUser)author));
                this.myAuthorField.putClientProperty((Object)"JComponent.outline", (Object)"warning");
                if (this.myAuthorField.isShowing()) {
                    this.showAuthorBalloonNotification();
                }
            } else {
                this.myAuthorField.setText(null);
            }
            this.myAuthorDate = data.getDate();
        }

        private void clearAuthorWarn() {
            this.myAuthorField.putClientProperty((Object)"JComponent.outline", null);
            if (this.myAuthorBalloon != null) {
                this.myAuthorBalloon.hide();
                this.myAuthorBalloon = null;
            }
        }

        public JComponent getComponent() {
            return this.myPanel;
        }

        public boolean isDefaultAuthor(@NotNull VcsUser author) {
            if (author == null) {
                GitCheckinOptions.$$$reportNull$$$0(16);
            }
            GitRepositoryManager manager = GitUtil.getRepositoryManager(GitCheckinEnvironment.this.myProject);
            List affectedGitRoots = ContainerUtil.filter((Collection)this.myCheckinProjectPanel.getRoots(), root -> manager.getRepositoryForRoot((VirtualFile)root) != null);
            GitUserRegistry gitUserRegistry = GitUserRegistry.getInstance(GitCheckinEnvironment.this.myProject);
            return StreamEx.of((Collection)affectedGitRoots).map(vf -> gitUserRegistry.getUser((VirtualFile)vf)).allMatch(user -> user != null && VcsUserUtil.isSamePerson((VcsUser)author, (VcsUser)user));
        }

        @NotNull
        private List<GitCheckinExplicitMovementProvider> collectActiveMovementProviders(@NotNull Project project) {
            Object[] allProviders;
            List enabledProviders;
            if (project == null) {
                GitCheckinOptions.$$$reportNull$$$0(17);
            }
            if ((enabledProviders = ContainerUtil.filter((Object[])(allProviders = (GitCheckinExplicitMovementProvider[])GitCheckinExplicitMovementProvider.EP_NAME.getExtensions()), it -> it.isEnabled(project))).isEmpty()) {
                List<GitCheckinExplicitMovementProvider> list = Collections.emptyList();
                if (list == null) {
                    GitCheckinOptions.$$$reportNull$$$0(18);
                }
                return list;
            }
            if (Registry.is((String)"git.explicit.commit.renames.prohibit.multiple.calls")) {
                List list = enabledProviders;
                if (list == null) {
                    GitCheckinOptions.$$$reportNull$$$0(19);
                }
                return list;
            }
            List changes = ContainerUtil.map((Collection)ChangeListManager.getInstance((Project)project).getAllChanges(), CommitChange::new);
            List beforePaths = ContainerUtil.mapNotNull((Collection)changes, it -> it.beforePath);
            List afterPaths = ContainerUtil.mapNotNull((Collection)changes, it -> it.afterPath);
            List list = ContainerUtil.filter((Collection)enabledProviders, it -> {
                Collection<GitCheckinExplicitMovementProvider.Movement> movements = it.collectExplicitMovements(project, beforePaths, afterPaths);
                List filteredMovements = GitCheckinEnvironment.filterExcludedChanges(movements, changes);
                return !filteredMovements.isEmpty();
            });
            if (list == null) {
                GitCheckinOptions.$$$reportNull$$$0(20);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 12: 
                case 14: 
                case 18: 
                case 19: 
                case 20: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 12: 
                case 14: 
                case 18: 
                case 19: 
                case 20: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "panel";
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 12: 
                case 14: 
                case 18: 
                case 19: 
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/checkin/GitCheckinEnvironment$GitCheckinOptions";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "author";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/checkin/GitCheckinEnvironment$GitCheckinOptions";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAmendHandler";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getToolTip";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExplicitMovementDescription";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAuthors";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createTextField";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUsersList";
                    break;
                }
                case 18: 
                case 19: 
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collectActiveMovementProviders";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 12: 
                case 14: 
                case 18: 
                case 19: 
                case 20: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getToolTip";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getAuthors";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "createTextField";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "getUsersList";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "fillAuthorAndDateFromData";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "isDefaultAuthor";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "collectActiveMovementProviders";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 12: 
                case 14: 
                case 18: 
                case 19: 
                case 20: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static enum PartialOperation {
        NONE("none"),
        MERGE("merge"),
        CHERRY_PICK("cherry-pick");

        private final String myName;

        private PartialOperation(String name) {
            this.myName = name;
        }

        String getName() {
            return this.myName;
        }
    }
}

