/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.content.impl;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.util.BusyObject;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.content.AlertIcon;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import java.awt.Container;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContentImpl
extends UserDataHolderBase
implements Content {
    private String myDisplayName;
    private String myDescription;
    private JComponent myComponent;
    private Icon myIcon;
    private final PropertyChangeSupport myChangeSupport = new PropertyChangeSupport((Object)this);
    private ContentManager myManager;
    private boolean myIsLocked;
    private boolean myPinnable;
    private Icon myLayeredIcon = new LayeredIcon(2);
    private Disposable myDisposer;
    private boolean myShouldDisposeContent = true;
    private String myTabName;
    private String myToolwindowTitle;
    private boolean myCloseable = true;
    private ActionGroup myActions;
    private String myPlace;
    private AlertIcon myAlertIcon;
    private JComponent myActionsContextComponent;
    private JComponent mySearchComponent;
    private Computable<? extends JComponent> myFocusRequest;
    private BusyObject myBusyObject;
    private String mySeparator;
    private Icon myPopupIcon;
    private long myExecutionId;
    private String myHelpId;

    public ContentImpl(JComponent component, String displayName, boolean isPinnable) {
        this.myComponent = component;
        this.myDisplayName = displayName;
        this.myPinnable = isPinnable;
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    public void setComponent(JComponent component) {
        JComponent oldComponent = this.myComponent;
        this.myComponent = component;
        this.myChangeSupport.firePropertyChange("component", oldComponent, this.myComponent);
    }

    public JComponent getPreferredFocusableComponent() {
        Container traversalRoot;
        if (this.myFocusRequest != null) {
            return (JComponent)this.myFocusRequest.compute();
        }
        if (this.myComponent == null) {
            return null;
        }
        Container container = traversalRoot = this.myComponent.isFocusCycleRoot() ? this.myComponent : this.myComponent.getFocusCycleRootAncestor();
        if (traversalRoot == null) {
            return null;
        }
        return (JComponent)ObjectUtils.tryCast((Object)traversalRoot.getFocusTraversalPolicy().getDefaultComponent(this.myComponent), JComponent.class);
    }

    public void setPreferredFocusableComponent(JComponent c2) {
        this.setPreferredFocusedComponent((Computable<? extends JComponent>)((Computable)() -> c2));
    }

    public void setPreferredFocusedComponent(Computable<? extends JComponent> computable) {
        this.myFocusRequest = computable;
    }

    public void setIcon(Icon icon) {
        Icon oldValue = this.getIcon();
        this.myIcon = icon;
        this.myLayeredIcon = LayeredIcon.create((Icon)this.myIcon, (Icon)AllIcons.Nodes.TabPin);
        this.myChangeSupport.firePropertyChange("icon", oldValue, this.getIcon());
    }

    public Icon getIcon() {
        if (this.myIsLocked) {
            return this.myIcon == null ? ContentImpl.getEmptyPinIcon() : this.myLayeredIcon;
        }
        return this.myIcon;
    }

    @NotNull
    private static Icon getEmptyPinIcon() {
        Icon icon = IconHolder.ourEmptyPinIcon;
        if (icon == null) {
            ContentImpl.$$$reportNull$$$0(0);
        }
        return icon;
    }

    public void setDisplayName(String displayName) {
        String oldValue = this.myDisplayName;
        this.myDisplayName = displayName;
        this.myChangeSupport.firePropertyChange("displayName", oldValue, this.myDisplayName);
    }

    public String getDisplayName() {
        return this.myDisplayName;
    }

    public void setTabName(String tabName) {
        this.myTabName = tabName;
    }

    public String getTabName() {
        if (this.myTabName != null) {
            return this.myTabName;
        }
        return this.myDisplayName;
    }

    public void setToolwindowTitle(String toolwindowTitle) {
        this.myToolwindowTitle = toolwindowTitle;
    }

    public String getToolwindowTitle() {
        if (this.myToolwindowTitle != null) {
            return this.myToolwindowTitle;
        }
        return this.myDisplayName;
    }

    public Disposable getDisposer() {
        return this.myDisposer;
    }

    public void setDisposer(@NotNull Disposable disposer) {
        if (disposer == null) {
            ContentImpl.$$$reportNull$$$0(1);
        }
        this.myDisposer = disposer;
    }

    public void setShouldDisposeContent(boolean value) {
        this.myShouldDisposeContent = value;
    }

    public boolean shouldDisposeContent() {
        return this.myShouldDisposeContent;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(String description) {
        String oldValue = this.myDescription;
        this.myDescription = description;
        this.myChangeSupport.firePropertyChange("description", oldValue, this.myDescription);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.myChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.myChangeSupport.removePropertyChangeListener(l);
    }

    public void setManager(@Nullable ContentManager manager) {
        this.myManager = manager;
    }

    public ContentManager getManager() {
        return this.myManager;
    }

    public boolean isSelected() {
        return this.myManager != null && this.myManager.isSelected((Content)this);
    }

    public final void release() {
        Disposer.dispose((Disposable)this);
    }

    public boolean isValid() {
        return this.myManager != null;
    }

    public boolean isPinned() {
        return this.myIsLocked;
    }

    public void setPinned(boolean locked) {
        if (this.isPinnable()) {
            Icon oldIcon = this.getIcon();
            this.myIsLocked = locked;
            Icon newIcon = this.getIcon();
            this.myChangeSupport.firePropertyChange("icon", oldIcon, newIcon);
        }
    }

    public boolean isPinnable() {
        return this.myPinnable;
    }

    public void setPinnable(boolean pinnable) {
        this.myPinnable = pinnable;
    }

    public boolean isCloseable() {
        return this.myCloseable;
    }

    public void setCloseable(boolean closeable) {
        if (closeable == this.myCloseable) {
            return;
        }
        boolean old = this.myCloseable;
        this.myCloseable = closeable;
        this.myChangeSupport.firePropertyChange("isClosable", old, closeable);
    }

    public void setActions(ActionGroup actions, String place, @Nullable JComponent contextComponent) {
        ActionGroup oldActions = this.myActions;
        this.myActions = actions;
        this.myPlace = place;
        this.myActionsContextComponent = contextComponent;
        this.myChangeSupport.firePropertyChange("actions", oldActions, this.myActions);
    }

    public JComponent getActionsContextComponent() {
        return this.myActionsContextComponent;
    }

    public ActionGroup getActions() {
        return this.myActions;
    }

    public String getPlace() {
        return this.myPlace;
    }

    @NonNls
    public String toString() {
        StringBuilder sb = new StringBuilder("Content name=").append(this.myDisplayName);
        if (this.myIsLocked) {
            sb.append(", pinned");
        }
        if (this.myExecutionId != 0L) {
            sb.append(", executionId=").append(this.myExecutionId);
        }
        return sb.toString();
    }

    public void dispose() {
        if (this.myShouldDisposeContent && this.myComponent instanceof Disposable) {
            Disposer.dispose((Disposable)((Disposable)this.myComponent));
        }
        this.myComponent = null;
        this.myFocusRequest = null;
        this.myManager = null;
        this.clearUserData();
        if (this.myDisposer != null) {
            Disposer.dispose((Disposable)this.myDisposer);
            this.myDisposer = null;
        }
    }

    @Nullable
    public AlertIcon getAlertIcon() {
        return this.myAlertIcon;
    }

    public void setAlertIcon(@Nullable AlertIcon icon) {
        this.myAlertIcon = icon;
    }

    public void fireAlert() {
        this.myChangeSupport.firePropertyChange("alerting", null, (Object)true);
    }

    public void setBusyObject(BusyObject object) {
        this.myBusyObject = object;
    }

    public String getSeparator() {
        return this.mySeparator;
    }

    public void setSeparator(String separator) {
        this.mySeparator = separator;
    }

    public void setPopupIcon(Icon icon) {
        this.myPopupIcon = icon;
    }

    public Icon getPopupIcon() {
        return this.myPopupIcon != null ? this.myPopupIcon : this.getIcon();
    }

    public BusyObject getBusyObject() {
        return this.myBusyObject;
    }

    public void setSearchComponent(@Nullable JComponent comp) {
        this.mySearchComponent = comp;
    }

    public JComponent getSearchComponent() {
        return this.mySearchComponent;
    }

    public void setExecutionId(long executionId) {
        this.myExecutionId = executionId;
    }

    public long getExecutionId() {
        return this.myExecutionId;
    }

    public void setHelpId(String helpId) {
        this.myHelpId = helpId;
    }

    @Nullable
    public String getHelpId() {
        return this.myHelpId;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/content/impl/ContentImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmptyPinIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/content/impl/ContentImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setDisposer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class IconHolder {
        private static final Icon ourEmptyPinIcon;

        private IconHolder() {
        }

        static {
            Icon icon = AllIcons.Nodes.TabPin;
            int width = icon.getIconWidth();
            ourEmptyPinIcon = IconUtil.cropIcon((Icon)icon, (Rectangle)new Rectangle(width / 2, 0, width - width / 2, icon.getIconHeight()));
        }
    }
}

