/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceParameterObject;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessorBase;
import com.intellij.refactoring.changeSignature.OverriderMethodUsageInfo;
import com.intellij.refactoring.changeSignature.ParameterInfo;
import com.intellij.refactoring.introduceParameterObject.IntroduceParameterObjectClassDescriptor;
import com.intellij.refactoring.introduceParameterObject.IntroduceParameterObjectDelegate;
import com.intellij.refactoring.introduceParameterObject.IntroduceParameterObjectUsageViewDescriptor;
import com.intellij.refactoring.util.FixableUsageInfo;
import com.intellij.refactoring.util.FixableUsagesRefactoringProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class IntroduceParameterObjectProcessor<M extends PsiNamedElement, P extends ParameterInfo, C extends IntroduceParameterObjectClassDescriptor<M, P>>
extends FixableUsagesRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance(IntroduceParameterObjectProcessor.class);
    private final C myClassDescriptor;
    private final M myMethod;
    private final ChangeInfo myChangeInfo;
    private final P myMergedParameterInfo;
    private final IntroduceParameterObjectDelegate<M, P, C> myDelegate;
    private final ReadWriteAccessDetector.Access[] myAccessors;

    public IntroduceParameterObjectProcessor(M method, C classDescriptor, List<P> oldMethodParameters, boolean keepMethodAsDelegate) {
        super(method.getProject());
        this.myClassDescriptor = classDescriptor;
        this.myMethod = method;
        ParameterInfo[] paramsToMerge = classDescriptor.getParamsToMerge();
        ArrayList<Object> newParams = new ArrayList<Object>();
        int anchor2 = -1;
        for (int oldIdx = 0; oldIdx < oldMethodParameters.size(); ++oldIdx) {
            ParameterInfo param = (ParameterInfo)oldMethodParameters.get(oldIdx);
            Object mergedParameterInfo = ((IntroduceParameterObjectClassDescriptor)classDescriptor).getParameterInfo(oldIdx);
            if (mergedParameterInfo != null) {
                if (anchor2 != -1) continue;
                anchor2 = oldIdx;
                continue;
            }
            newParams.add(param);
        }
        this.myDelegate = IntroduceParameterObjectDelegate.findDelegate(method);
        LOG.assertTrue(this.myDelegate != null);
        this.myMergedParameterInfo = this.myDelegate.createMergedParameterInfo(classDescriptor, method, oldMethodParameters);
        newParams.add(anchor2, this.myMergedParameterInfo);
        this.myChangeInfo = this.myDelegate.createChangeSignatureInfo(this.myMethod, newParams, keepMethodAsDelegate);
        this.myAccessors = new ReadWriteAccessDetector.Access[paramsToMerge.length];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void findUsages(@NotNull List<FixableUsageInfo> usages) {
        void var5_7;
        if (usages == null) {
            IntroduceParameterObjectProcessor.$$$reportNull$$$0(0);
        }
        if (((IntroduceParameterObjectClassDescriptor)this.myClassDescriptor).isUseExistingClass()) {
            ((IntroduceParameterObjectClassDescriptor)this.myClassDescriptor).setExistingClassCompatibleConstructor(((IntroduceParameterObjectClassDescriptor)this.myClassDescriptor).findCompatibleConstructorInExistingClass(this.myMethod));
        }
        ArrayList<Object> methodHierarchy = new ArrayList<Object>();
        methodHierarchy.add(this.myMethod);
        UsageInfo[] usageInfoArray = ChangeSignatureProcessorBase.findUsages(this.myChangeInfo);
        int n = usageInfoArray.length;
        boolean bl = false;
        while (var5_7 < n) {
            UsageInfo info = usageInfoArray[var5_7];
            if (info instanceof OverriderMethodUsageInfo) {
                methodHierarchy.add(((OverriderMethodUsageInfo)info).getOverridingMethod());
            }
            usages.add(new ChangeSignatureUsageWrapper(info));
            ++var5_7;
        }
        ParameterInfo[] paramsToMerge = this.myClassDescriptor.getParamsToMerge();
        for (PsiElement psiElement : methodHierarchy) {
            IntroduceParameterObjectDelegate delegate = IntroduceParameterObjectDelegate.findDelegate(psiElement);
            if (delegate == null) continue;
            for (int i = 0; i < paramsToMerge.length; ++i) {
                ReadWriteAccessDetector.Access access = delegate.collectInternalUsages((Collection<? super FixableUsageInfo>)((Collection<FixableUsageInfo>)usages), (PsiNamedElement)psiElement, this.myClassDescriptor, paramsToMerge[i], this.myMergedParameterInfo.getName());
                if (this.myAccessors[i] != null && access != ReadWriteAccessDetector.Access.Write) continue;
                this.myAccessors[i] = access;
            }
        }
        this.myDelegate.collectUsagesToGenerateMissedFieldAccessors(usages, this.myMethod, this.myClassDescriptor, this.myAccessors);
        this.myDelegate.collectAdditionalFixes(usages, this.myMethod, this.myClassDescriptor);
    }

    @Override
    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            IntroduceParameterObjectProcessor.$$$reportNull$$$0(1);
        }
        UsageInfo[] usageInfos = (UsageInfo[])refUsages.get();
        MultiMap conflicts = new MultiMap();
        this.myDelegate.collectConflicts((MultiMap<PsiElement, String>)conflicts, usageInfos, this.myMethod, this.myClassDescriptor);
        ArrayList<UsageInfo> changeSignatureUsages = new ArrayList<UsageInfo>();
        HashSet<PsiFile> filesWithUsages = new HashSet<PsiFile>();
        for (UsageInfo usageInfo : usageInfos) {
            String conflictMessage;
            if (usageInfo instanceof ChangeSignatureUsageWrapper) {
                PsiFile containingFile;
                UsageInfo info = ((ChangeSignatureUsageWrapper)usageInfo).getInfo();
                PsiElement element = info.getElement();
                if (element != null && IntroduceParameterObjectDelegate.findDelegate(element) == null && filesWithUsages.add(containingFile = element.getContainingFile())) {
                    conflicts.putValue((Object)element, (Object)("Method is overridden in a language that doesn't support this refactoring: " + containingFile.getName()));
                }
                changeSignatureUsages.add(info);
                continue;
            }
            if (!(usageInfo instanceof FixableUsageInfo) || (conflictMessage = ((FixableUsageInfo)usageInfo).getConflictMessage()) == null) continue;
            conflicts.putValue((Object)usageInfo.getElement(), (Object)conflictMessage);
        }
        ChangeSignatureProcessorBase.collectConflictsFromExtensions((Ref<UsageInfo[]>)new Ref((Object)changeSignatureUsages.toArray(UsageInfo.EMPTY_ARRAY)), (MultiMap<PsiElement, String>)conflicts, this.myChangeInfo);
        return this.showConflicts((MultiMap<PsiElement, String>)conflicts, usageInfos);
    }

    @Override
    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            IntroduceParameterObjectProcessor.$$$reportNull$$$0(2);
        }
        IntroduceParameterObjectUsageViewDescriptor introduceParameterObjectUsageViewDescriptor = new IntroduceParameterObjectUsageViewDescriptor((PsiElement)this.myMethod);
        if (introduceParameterObjectUsageViewDescriptor == null) {
            IntroduceParameterObjectProcessor.$$$reportNull$$$0(3);
        }
        return introduceParameterObjectUsageViewDescriptor;
    }

    @Override
    protected void performRefactoring(@NotNull UsageInfo[] usageInfos) {
        PsiElement aClass;
        if (usageInfos == null) {
            IntroduceParameterObjectProcessor.$$$reportNull$$$0(4);
        }
        if ((aClass = ((IntroduceParameterObjectClassDescriptor)this.myClassDescriptor).createClass(this.myMethod, this.myAccessors)) != null) {
            ((IntroduceParameterObjectClassDescriptor)this.myClassDescriptor).setExistingClass(aClass);
            super.performRefactoring(usageInfos);
            ArrayList<UsageInfo> changeSignatureUsages = new ArrayList<UsageInfo>();
            for (UsageInfo info : usageInfos) {
                if (!(info instanceof ChangeSignatureUsageWrapper)) continue;
                changeSignatureUsages.add(((ChangeSignatureUsageWrapper)info).getInfo());
            }
            ChangeSignatureProcessorBase.doChangeSignature(this.myChangeInfo, changeSignatureUsages.toArray(UsageInfo.EMPTY_ARRAY));
        }
    }

    @Override
    @NotNull
    protected String getCommandName() {
        String string = RefactoringBundle.message((String)"refactoring.introduce.parameter.object.command.name", (Object[])new Object[]{((IntroduceParameterObjectClassDescriptor)this.myClassDescriptor).getClassName(), this.myMethod.getName()});
        if (string == null) {
            IntroduceParameterObjectProcessor.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/introduceParameterObject/IntroduceParameterObjectProcessor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/introduceParameterObject/IntroduceParameterObjectProcessor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageViewDescriptor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findUsages";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ChangeSignatureUsageWrapper
    extends FixableUsageInfo {
        private final UsageInfo myInfo;

        public ChangeSignatureUsageWrapper(UsageInfo info) {
            super(info.getElement());
            this.myInfo = info;
        }

        public UsageInfo getInfo() {
            return this.myInfo;
        }

        @Override
        public void fixUsage() throws IncorrectOperationException {
        }
    }
}

