/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl.pluginsAdvertisement;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileTypes.FileTypeFactory;
import com.intellij.openapi.fileTypes.PlainTextLikeFileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiser;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.UnknownFeature;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.UnknownFeaturesCollector;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginAdvertiserEditorNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel>
implements DumbAware {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"file.type.associations.detected");
    private final Set<String> myEnabledExtensions = new HashSet<String>();

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            PluginAdvertiserEditorNotificationProvider.$$$reportNull$$$0(0);
        }
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor, @NotNull Project project) {
        if (file2 == null) {
            PluginAdvertiserEditorNotificationProvider.$$$reportNull$$$0(1);
        }
        if (fileEditor == null) {
            PluginAdvertiserEditorNotificationProvider.$$$reportNull$$$0(2);
        }
        if (project == null) {
            PluginAdvertiserEditorNotificationProvider.$$$reportNull$$$0(3);
        }
        if (!(file2.getFileType() instanceof PlainTextLikeFileType)) {
            return null;
        }
        String extension = file2.getExtension();
        String fileName2 = file2.getName();
        if (extension != null && this.isIgnored("*." + extension, project) || this.isIgnored(fileName2, project)) {
            return null;
        }
        PluginsAdvertiser.KnownExtensions knownExtensions = PluginsAdvertiser.loadExtensions();
        if (knownExtensions != null) {
            EditorNotificationPanel panel2;
            EditorNotificationPanel editorNotificationPanel = panel2 = extension != null ? this.createPanel("*." + extension, knownExtensions, project) : null;
            if (panel2 != null) {
                return panel2;
            }
            return this.createPanel(fileName2, knownExtensions, project);
        }
        return null;
    }

    private boolean isIgnored(String extension, @NotNull Project project) {
        if (project == null) {
            PluginAdvertiserEditorNotificationProvider.$$$reportNull$$$0(4);
        }
        return this.myEnabledExtensions.contains(extension) || UnknownFeaturesCollector.getInstance(project).isIgnored(PluginAdvertiserEditorNotificationProvider.createExtensionFeature(extension));
    }

    private EditorNotificationPanel createPanel(String extension, PluginsAdvertiser.KnownExtensions knownExtensions, @NotNull Project project) {
        Set<PluginsAdvertiser.Plugin> plugins2;
        if (project == null) {
            PluginAdvertiserEditorNotificationProvider.$$$reportNull$$$0(5);
        }
        if ((plugins2 = knownExtensions.find(extension)) != null && !plugins2.isEmpty()) {
            return this.createPanel(extension, plugins2, project);
        }
        return null;
    }

    @Nullable
    private EditorNotificationPanel createPanel(String extension, Set<? extends PluginsAdvertiser.Plugin> plugins2, @NotNull Project project) {
        if (project == null) {
            PluginAdvertiserEditorNotificationProvider.$$$reportNull$$$0(6);
        }
        EditorNotificationPanel panel2 = new EditorNotificationPanel();
        panel2.setText("Plugins supporting " + extension + " files found.");
        IdeaPluginDescriptor disabledPlugin = PluginsAdvertiser.getDisabledPlugin(plugins2);
        if (disabledPlugin != null) {
            panel2.createActionLabel("Enable " + disabledPlugin.getName() + " plugin", () -> {
                this.myEnabledExtensions.add(extension);
                EditorNotifications.getInstance((Project)project).updateAllNotifications();
                PluginsAdvertiser.enablePlugins(project, Collections.singletonList(disabledPlugin));
            });
        } else if (PluginAdvertiserEditorNotificationProvider.hasNonBundledPlugin(plugins2)) {
            panel2.createActionLabel("Install plugins", () -> {
                HashSet<String> pluginIds = new HashSet<String>();
                for (PluginsAdvertiser.Plugin plugin : plugins2) {
                    pluginIds.add(plugin.myPluginId);
                }
                PluginsAdvertiser.installAndEnablePlugins(pluginIds, () -> {
                    this.myEnabledExtensions.add(extension);
                    EditorNotifications.getInstance((Project)project).updateAllNotifications();
                });
            });
        } else if (PluginsAdvertiser.hasBundledPluginToInstall(plugins2) != null) {
            if (PropertiesComponent.getInstance().isTrueValue("ignoreUltimateEdition")) {
                return null;
            }
            panel2.setText(extension + " files are supported by " + "IntelliJ IDEA Ultimate Edition");
            panel2.createActionLabel("Check IntelliJ IDEA Ultimate Edition", () -> {
                this.myEnabledExtensions.add(extension);
                PluginsAdvertiser.openDownloadPage();
            });
            panel2.createActionLabel("Do not suggest Ultimate Edition", () -> {
                PropertiesComponent.getInstance().setValue("ignoreUltimateEdition", "true");
                EditorNotifications.getInstance((Project)project).updateAllNotifications();
            });
        } else {
            return null;
        }
        panel2.createActionLabel("Ignore extension", () -> {
            UnknownFeaturesCollector.getInstance(project).ignoreFeature(PluginAdvertiserEditorNotificationProvider.createExtensionFeature(extension));
            EditorNotifications.getInstance((Project)project).updateAllNotifications();
        });
        return panel2;
    }

    private static boolean hasNonBundledPlugin(Set<? extends PluginsAdvertiser.Plugin> plugins2) {
        for (PluginsAdvertiser.Plugin plugin : plugins2) {
            if (plugin.myBundled) continue;
            return true;
        }
        return false;
    }

    private static UnknownFeature createExtensionFeature(String extension) {
        return new UnknownFeature(FileTypeFactory.FILE_TYPE_FACTORY_EP.getName(), "File Type", extension, extension);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginAdvertiserEditorNotificationProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginAdvertiserEditorNotificationProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isIgnored";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createPanel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

