/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.largeFilesEditor.editor;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.largeFilesEditor.PlatformActionsReplacer;
import com.intellij.largeFilesEditor.editor.EditorManager;
import com.intellij.largeFilesEditor.editor.EditorModel;
import com.intellij.largeFilesEditor.editor.LargeFileEditorState;
import com.intellij.largeFilesEditor.editor.Page;
import com.intellij.largeFilesEditor.editor.PropertiesGetter;
import com.intellij.largeFilesEditor.encoding.EditorManagerAccess;
import com.intellij.largeFilesEditor.encoding.EditorManagerAccessorImpl;
import com.intellij.largeFilesEditor.encoding.EncodingWidget;
import com.intellij.largeFilesEditor.file.FileManager;
import com.intellij.largeFilesEditor.file.FileManagerImpl;
import com.intellij.largeFilesEditor.file.ReadingPageResultHandler;
import com.intellij.largeFilesEditor.search.SearchManager;
import com.intellij.largeFilesEditor.search.SearchManagerImpl;
import com.intellij.largeFilesEditor.search.SearchResult;
import com.intellij.largeFilesEditor.search.SearchResultsPanelManagerAccessorImpl;
import com.intellij.largeFilesEditor.search.searchTask.FileDataProviderForSearch;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.WindowManager;
import java.beans.PropertyChangeListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorManagerImpl
extends UserDataHolderBase
implements EditorManager {
    private static final Logger logger = Logger.getInstance(EditorManagerImpl.class);
    private final Project project;
    private FileManager fileManager;
    private final EditorModel editorModel;
    private final DocumentEx document;
    private final VirtualFile vFile;
    private SearchManager searchManager;

    public EditorManagerImpl(Project project, VirtualFile vFile) {
        this.vFile = vFile;
        this.project = project;
        int customPageSize = PropertiesGetter.getPageSize();
        int customBorderShift = PropertiesGetter.getMaxPageBorderShiftBytes();
        this.document = EditorManagerImpl.createSpecialDocument(vFile);
        this.editorModel = new EditorModel(this.document, project, this.implementDataProviderForEditorModel());
        this.editorModel.putUserDataToEditor(KEY_EDITOR_MARK, new Object());
        this.editorModel.putUserDataToEditor(KEY_EDITOR_MANAGER, this);
        try {
            this.fileManager = new FileManagerImpl(vFile, customPageSize, customBorderShift);
        }
        catch (FileNotFoundException e) {
            logger.warn((Throwable)e);
            this.editorModel.setBrokenMode();
            Messages.showWarningDialog((String)"Can't open file: file not found.", (String)"Warning");
            this.requestClosingEditorTab();
            return;
        }
        this.searchManager = new SearchManagerImpl(this, this.fileManager.getFileDataProviderForSearch(), new SearchResultsPanelManagerAccessorImpl());
        this.createAndAddSpecialWidgetIfNeed(project);
        PlatformActionsReplacer.makeAdaptingOfPlatformActionsIfNeed();
        this.editorModel.addCaretListener(new MyCaretListener());
    }

    private void requestClosingEditorTab() {
        ApplicationManager.getApplication().invokeLater(() -> FileEditorManager.getInstance((Project)this.project).closeFile(this.vFile));
    }

    private void createAndAddSpecialWidgetIfNeed(Project project) {
        StatusBar statusBar = WindowManager.getInstance().getStatusBar(project);
        StatusBarWidget existedWidget = statusBar.getWidget("lfeEncoding");
        boolean needToAddNewWidget = false;
        if (existedWidget == null) {
            needToAddNewWidget = true;
        } else if (existedWidget instanceof EncodingWidget && ((EncodingWidget)existedWidget)._getProject() != project) {
            statusBar.removeWidget(existedWidget.ID());
            needToAddNewWidget = true;
        }
        if (needToAddNewWidget) {
            statusBar.addWidget((StatusBarWidget)new EncodingWidget(project, new EditorManagerAccessorImpl()));
        }
    }

    @Override
    public SearchManager getSearchManager() {
        return this.searchManager;
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.editorModel.getComponent();
        if (jComponent == null) {
            EditorManagerImpl.$$$reportNull$$$0(0);
        }
        return jComponent;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.editorModel.getEditor().getContentComponent();
    }

    @NotNull
    public String getName() {
        if ("Large File Editor" == null) {
            EditorManagerImpl.$$$reportNull$$$0(1);
        }
        return "Large File Editor";
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            EditorManagerImpl.$$$reportNull$$$0(2);
        }
        if (state instanceof LargeFileEditorState) {
            LargeFileEditorState largeFileEditorState = (LargeFileEditorState)state;
            this.editorModel.setCaretAndShow(largeFileEditorState.caretPageNumber, largeFileEditorState.caretSymbolOffsetInPage);
        }
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            EditorManagerImpl.$$$reportNull$$$0(3);
        }
        LargeFileEditorState state = new LargeFileEditorState();
        state.caretPageNumber = this.editorModel.getCaretPageNumber();
        state.caretSymbolOffsetInPage = this.editorModel.getCaretPageOffset();
        LargeFileEditorState largeFileEditorState = state;
        if (largeFileEditorState == null) {
            EditorManagerImpl.$$$reportNull$$$0(4);
        }
        return largeFileEditorState;
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            EditorManagerImpl.$$$reportNull$$$0(5);
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            EditorManagerImpl.$$$reportNull$$$0(6);
        }
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    public void dispose() {
        if (this.searchManager != null) {
            this.searchManager.dispose();
        }
        if (this.fileManager != null) {
            this.fileManager.dispose();
        }
        this.editorModel.dispose();
        this.vFile.putUserData(FileDocumentManagerImpl.HARD_REF_TO_DOCUMENT_KEY, null);
    }

    @Override
    public void showSearchResult(SearchResult searchResult) {
        this.editorModel.showSearchResult(searchResult);
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    @Override
    public long getCaretPageNumber() {
        return this.editorModel.getCaretPageNumber();
    }

    @Override
    public int getCaretPageOffset() {
        return this.editorModel.getCaretPageOffset();
    }

    @Override
    public Editor getEditor() {
        return this.editorModel.getEditor();
    }

    @Override
    @Nullable
    public VirtualFile getFile() {
        return this.getVirtualFile();
    }

    @Override
    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.vFile;
        if (virtualFile == null) {
            EditorManagerImpl.$$$reportNull$$$0(7);
        }
        return virtualFile;
    }

    @Override
    public EditorManagerAccess createAccessForEncodingWidget() {
        return new EditorManagerAccess(){

            @Override
            @NotNull
            public VirtualFile getVirtualFile() {
                VirtualFile virtualFile = EditorManagerImpl.this.getVirtualFile();
                if (virtualFile == null) {
                    1.$$$reportNull$$$0(0);
                }
                return virtualFile;
            }

            @Override
            @NotNull
            public Editor getEditor() {
                Editor editor = EditorManagerImpl.this.getEditor();
                if (editor == null) {
                    1.$$$reportNull$$$0(1);
                }
                return editor;
            }

            @Override
            public boolean tryChangeEncoding(@NotNull Charset charset) {
                if (charset == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (EditorManagerImpl.this.fileManager.hasBOM()) {
                    Messages.showWarningDialog((String)"Can't change file encoding, because it has BOM (Byte order mark)", (String)"Warning");
                    return false;
                }
                if (EditorManagerImpl.this.searchManager.isSearchWorkingNow()) {
                    Messages.showInfoMessage((String)"Can't change file encoding, because search is working now.", (String)"Can't Change Encoding");
                    return false;
                }
                EditorManagerImpl.this.fileManager.reset(charset);
                EditorManagerImpl.this.editorModel.fireEncodingWasChanged();
                return true;
            }

            @Override
            public String getCharsetName() {
                return EditorManagerImpl.this.fileManager.getCharsetName();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/largeFilesEditor/editor/EditorManagerImpl$1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "charset";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getVirtualFile";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getEditor";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/largeFilesEditor/editor/EditorManagerImpl$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "tryChangeEncoding";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @Override
    public FileDataProviderForSearch getFileDataProviderForSearch() {
        return this.fileManager.getFileDataProviderForSearch();
    }

    @Override
    @NotNull
    public EditorModel getEditorModel() {
        EditorModel editorModel = this.editorModel;
        if (editorModel == null) {
            EditorManagerImpl.$$$reportNull$$$0(8);
        }
        return editorModel;
    }

    private static DocumentEx createSpecialDocument(VirtualFile vFile) {
        DocumentImpl doc = new DocumentImpl("", false, false);
        UndoUtil.disableUndoFor((Document)doc);
        FileDocumentManagerImpl.registerDocument(doc, vFile);
        return doc;
    }

    private EditorModel.DataProvider implementDataProviderForEditorModel() {
        return new EditorModel.DataProvider(){

            @Override
            public Page getPage(long pageNumber) throws IOException {
                return EditorManagerImpl.this.fileManager.getPage_wait(pageNumber);
            }

            @Override
            public long getPagesAmount() throws IOException {
                return EditorManagerImpl.this.fileManager.getPagesAmount();
            }

            @Override
            public Project getProject() {
                return EditorManagerImpl.this.project;
            }

            @Override
            public void requestReadPage(long pageNumber, ReadingPageResultHandler readingPageResultHandler) {
                EditorManagerImpl.this.fileManager.requestReadPage(pageNumber, readingPageResultHandler);
            }

            @Override
            public List<TextRange> getAllSearchResultsInDocument(Document document) {
                if (EditorManagerImpl.this.searchManager != null) {
                    return EditorManagerImpl.this.searchManager.getAllSearchResultsInDocument(document);
                }
                return null;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/largeFilesEditor/editor/EditorManagerImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/largeFilesEditor/editor/EditorManagerImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFile";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorModel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyCaretListener
    implements CaretListener {
        private MyCaretListener() {
        }

        public void caretPositionChanged(@NotNull CaretEvent e) {
            if (e == null) {
                MyCaretListener.$$$reportNull$$$0(0);
            }
            EditorManagerImpl.this.searchManager.onCaretPositionChanged(e);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/largeFilesEditor/editor/EditorManagerImpl$MyCaretListener", "caretPositionChanged"));
        }
    }
}

