/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.DataManager;
import com.intellij.ide.actions.QualifiedNameProviderUtil;
import com.intellij.ide.actions.SearchEverywherePsiRenderer;
import com.intellij.ide.actions.searcheverywhere.CheckBoxSearchEverywhereToggleAction;
import com.intellij.ide.actions.searcheverywhere.PersistentSearchEverywhereContributorFilter;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereDataKeys;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereToggleAction;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereUI;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.ide.util.gotoByName.ChooseByNameInScopeItemProvider;
import com.intellij.ide.util.gotoByName.ChooseByNameItemProvider;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.FilteringGotoByModel;
import com.intellij.ide.util.scopeChooser.ScopeChooserCombo;
import com.intellij.ide.util.scopeChooser.ScopeDescriptor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButtonWithText;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.OffsetIcon;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FindSymbolParameters;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractGotoSEContributor
implements SearchEverywhereContributor<Object> {
    private static final Logger LOG = Logger.getInstance(AbstractGotoSEContributor.class);
    protected static final Pattern patternToDetectLinesAndColumns = Pattern.compile("(.+?)(?::|@|,| |#|#L|\\?l=| on line | at line |:?\\(|:?\\[)(\\d+)?(?:\\W(\\d+)?)?[)\\]]?");
    protected static final Pattern patternToDetectAnonymousClasses = Pattern.compile("([.\\w]+)((\\$[\\d]+)*(\\$)?)");
    protected static final Pattern patternToDetectMembers = Pattern.compile("(.+)(#)(.*)");
    protected static final Pattern patternToDetectSignatures = Pattern.compile("(.+#.*)\\(.*\\)");
    protected final Project myProject;
    protected final PsiElement psiContext;
    protected boolean myEverywhere;
    protected ScopeDescriptor myScopeDescriptor;

    protected AbstractGotoSEContributor(@Nullable Project project, @Nullable PsiElement context) {
        this.myProject = project;
        this.psiContext = context;
        this.myScopeDescriptor = new ScopeDescriptor((SearchScope)(project == null ? GlobalSearchScope.EMPTY_SCOPE : GlobalSearchScope.projectScope((Project)project)));
    }

    @NotNull
    public String getSearchProviderId() {
        String string = this.getClass().getSimpleName();
        if (string == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isShownInSeparateTab() {
        return true;
    }

    @NotNull
    protected List<AnAction> doGetActions(@NotNull String everywhereText, @Nullable PersistentSearchEverywhereContributorFilter<?> filter, final @NotNull Runnable onChanged) {
        if (everywhereText == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(1);
        }
        if (onChanged == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(2);
        }
        if (this.myProject == null || filter == null) {
            List<AnAction> list2 = Collections.emptyList();
            if (list2 == null) {
                AbstractGotoSEContributor.$$$reportNull$$$0(3);
            }
            return list2;
        }
        ArrayList<AnAction> result2 = new ArrayList<AnAction>();
        if (Registry.is((String)"search.everywhere.show.scopes")) {
            result2.add((AnAction)new ScopeChooserAction(){
                final GlobalSearchScope everywhereScope;
                final GlobalSearchScope projectScope;
                final boolean canToggleEverywhere;
                {
                    this.everywhereScope = GlobalSearchScope.everythingScope((Project)AbstractGotoSEContributor.this.myProject);
                    GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)AbstractGotoSEContributor.this.myProject);
                    if (!this.everywhereScope.equals(scope)) {
                        this.projectScope = scope;
                        this.canToggleEverywhere = true;
                    } else {
                        Ref result2 = Ref.create();
                        ScopeChooserCombo.processScopes(AbstractGotoSEContributor.this.myProject, SimpleDataContext.getProjectContext(AbstractGotoSEContributor.this.myProject), 0, (Processor<? super ScopeDescriptor>)((Processor)o -> {
                            if (o.scopeEquals((SearchScope)this.everywhereScope)) {
                                return true;
                            }
                            result2.set((Object)((GlobalSearchScope)o.getScope()));
                            return false;
                        }));
                        this.projectScope = (GlobalSearchScope)ObjectUtils.notNull((Object)result2.get());
                        this.canToggleEverywhere = false;
                    }
                }

                @Override
                void onScopeSelected(@NotNull ScopeDescriptor o) {
                    if (o == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    AbstractGotoSEContributor.this.myScopeDescriptor = o;
                    onChanged.run();
                }

                @Override
                @NotNull
                ScopeDescriptor getSelectedScope() {
                    ScopeDescriptor scopeDescriptor = AbstractGotoSEContributor.this.myScopeDescriptor;
                    if (scopeDescriptor == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return scopeDescriptor;
                }

                @Override
                void onProjectScopeToggled() {
                    this.setEverywhere(!AbstractGotoSEContributor.this.myScopeDescriptor.scopeEquals((SearchScope)this.everywhereScope));
                }

                public boolean isEverywhere() {
                    return AbstractGotoSEContributor.this.myScopeDescriptor.scopeEquals((SearchScope)this.everywhereScope);
                }

                public void setEverywhere(boolean everywhere) {
                    AbstractGotoSEContributor.this.myScopeDescriptor = new ScopeDescriptor((SearchScope)(everywhere ? this.everywhereScope : this.projectScope));
                    onChanged.run();
                }

                public boolean canToggleEverywhere() {
                    if (!this.canToggleEverywhere) {
                        return false;
                    }
                    return AbstractGotoSEContributor.this.myScopeDescriptor.scopeEquals((SearchScope)this.everywhereScope) || AbstractGotoSEContributor.this.myScopeDescriptor.scopeEquals((SearchScope)this.projectScope);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "o";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/AbstractGotoSEContributor$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/AbstractGotoSEContributor$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getSelectedScope";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "onScopeSelected";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            });
        } else {
            result2.add((AnAction)new CheckBoxSearchEverywhereToggleAction(everywhereText){

                public boolean isEverywhere() {
                    return AbstractGotoSEContributor.this.myEverywhere;
                }

                public void setEverywhere(boolean state) {
                    AbstractGotoSEContributor.this.myEverywhere = state;
                    onChanged.run();
                }
            });
        }
        result2.add((AnAction)new SearchEverywhereUI.FiltersAction(filter, onChanged));
        ArrayList<AnAction> arrayList = result2;
        if (arrayList == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    public void fetchElements(@NotNull String pattern, @NotNull ProgressIndicator progressIndicator, @NotNull Processor<? super Object> consumer) {
        if (pattern == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(5);
        }
        if (progressIndicator == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(6);
        }
        if (consumer == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(7);
        }
        if (this.myProject == null) {
            return;
        }
        if (!this.isEmptyPatternSupported() && pattern.isEmpty()) {
            return;
        }
        ProgressIndicatorUtils.yieldToPendingWriteActions();
        ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(() -> {
            if (!this.isDumbAware() && DumbService.isDumb((Project)this.myProject)) {
                return;
            }
            FilteringGotoByModel<?> model2 = this.createModel(this.myProject);
            if (progressIndicator.isCanceled()) {
                return;
            }
            PsiElement context = this.psiContext != null && this.psiContext.isValid() ? this.psiContext : null;
            ChooseByNamePopup popup2 = ChooseByNamePopup.createPopup(this.myProject, model2, context);
            try {
                GlobalSearchScope scope;
                ChooseByNameItemProvider provider = popup2.getProvider();
                GlobalSearchScope globalSearchScope = scope = Registry.is((String)"search.everywhere.show.scopes") ? (GlobalSearchScope)ObjectUtils.notNull((Object)this.myScopeDescriptor.getScope()) : null;
                if (scope != null && provider instanceof ChooseByNameInScopeItemProvider) {
                    FindSymbolParameters parameters = FindSymbolParameters.wrap(pattern, scope);
                    ((ChooseByNameInScopeItemProvider)provider).filterElements(popup2, parameters, progressIndicator, (Processor<Object>)((Processor)element -> {
                        if (progressIndicator.isCanceled()) {
                            return false;
                        }
                        if (element == null) {
                            LOG.error("Null returned from " + model2 + " in " + this);
                            return true;
                        }
                        return consumer.process(element);
                    }));
                } else {
                    boolean everywhere = scope == null ? this.myEverywhere : scope.isSearchInLibraries();
                    provider.filterElements(popup2, pattern, everywhere, progressIndicator, (Processor<Object>)((Processor)element -> {
                        if (progressIndicator.isCanceled()) {
                            return false;
                        }
                        if (element == null) {
                            LOG.error("Null returned from " + model2 + " in " + this);
                            return true;
                        }
                        return consumer.process(element);
                    }));
                }
            }
            finally {
                Disposer.dispose((Disposable)popup2);
            }
        }, progressIndicator);
    }

    @NotNull
    protected abstract FilteringGotoByModel<?> createModel(@NotNull Project var1);

    @NotNull
    public String filterControlSymbols(@NotNull String pattern) {
        if (pattern == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(8);
        }
        if (StringUtil.containsAnyChar((String)pattern, (String)":,;@[( #") || pattern.contains(" line ") || pattern.contains("?l=")) {
            String string = AbstractGotoSEContributor.applyPatternFilter(pattern, patternToDetectLinesAndColumns);
            if (string == null) {
                AbstractGotoSEContributor.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = pattern;
        if (string == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(10);
        }
        return string;
    }

    protected static String applyPatternFilter(String str, Pattern regex) {
        Matcher matcher = regex.matcher(str);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return str;
    }

    public boolean showInFindResults() {
        return true;
    }

    public boolean processSelectedItem(@NotNull Object selected2, int modifiers, @NotNull String searchText) {
        if (selected2 == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(11);
        }
        if (searchText == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(12);
        }
        if (selected2 instanceof PsiElement) {
            if (!((PsiElement)selected2).isValid()) {
                LOG.warn("Cannot navigate to invalid PsiElement");
                return true;
            }
            PsiElement psiElement = this.preparePsi((PsiElement)selected2, modifiers, searchText);
            Navigatable extNavigatable = this.createExtendedNavigatable(psiElement, searchText, modifiers);
            if (extNavigatable != null && extNavigatable.canNavigate()) {
                extNavigatable.navigate(true);
                return true;
            }
            NavigationUtil.activateFileWithPsiElement(psiElement, AbstractGotoSEContributor.openInCurrentWindow(modifiers));
        } else {
            EditSourceUtil.navigate((NavigationItem)((NavigationItem)selected2), (boolean)true, (boolean)AbstractGotoSEContributor.openInCurrentWindow(modifiers));
        }
        return true;
    }

    public Object getDataForItem(@NotNull Object element, @NotNull String dataId) {
        if (element == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(13);
        }
        if (dataId == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(14);
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            if (element instanceof PsiElement) {
                return element;
            }
            if (element instanceof DataProvider) {
                return ((DataProvider)element).getData(dataId);
            }
        }
        if (SearchEverywhereDataKeys.ITEM_STRING_DESCRIPTION.is(dataId) && element instanceof PsiElement) {
            return QualifiedNameProviderUtil.getQualifiedName((PsiElement)element);
        }
        return null;
    }

    public boolean isMultiSelectionSupported() {
        return true;
    }

    public boolean isDumbAware() {
        return DumbService.isDumbAware(this.createModel(this.myProject));
    }

    @NotNull
    public ListCellRenderer<Object> getElementsRenderer() {
        SERenderer sERenderer = new SERenderer();
        if (sERenderer == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(15);
        }
        return sERenderer;
    }

    public int getElementPriority(@NotNull Object element, @NotNull String searchPattern) {
        if (element == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(16);
        }
        if (searchPattern == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(17);
        }
        return 50;
    }

    @Nullable
    protected Navigatable createExtendedNavigatable(PsiElement psi, String searchText, int modifiers) {
        boolean positionSpecified;
        VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)psi);
        Pair<Integer, Integer> position = AbstractGotoSEContributor.getLineAndColumn(searchText);
        boolean bl = positionSpecified = (Integer)position.first >= 0 || (Integer)position.second >= 0;
        if (file2 != null && positionSpecified) {
            OpenFileDescriptor descriptor2 = new OpenFileDescriptor(psi.getProject(), file2, ((Integer)position.first).intValue(), ((Integer)position.second).intValue());
            return descriptor2.setUseCurrentWindow(AbstractGotoSEContributor.openInCurrentWindow(modifiers));
        }
        return null;
    }

    protected PsiElement preparePsi(PsiElement psiElement, int modifiers, String searchText) {
        return psiElement.getNavigationElement();
    }

    protected static Pair<Integer, Integer> getLineAndColumn(String text2) {
        int line2 = AbstractGotoSEContributor.getLineAndColumnRegexpGroup(text2, 2);
        int column = AbstractGotoSEContributor.getLineAndColumnRegexpGroup(text2, 3);
        if (line2 == -1 && column != -1) {
            line2 = 0;
        }
        return new Pair((Object)line2, (Object)column);
    }

    private static int getLineAndColumnRegexpGroup(String text2, int groupNumber) {
        Matcher matcher = patternToDetectLinesAndColumns.matcher(text2);
        if (matcher.matches()) {
            try {
                String group;
                if (groupNumber <= matcher.groupCount() && (group = matcher.group(groupNumber)) != null) {
                    return Integer.parseInt(group) - 1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    protected static boolean openInCurrentWindow(int modifiers) {
        return (modifiers & 1) == 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/AbstractGotoSEContributor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "everywhereText";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onChanged";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selected";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchText";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchProviderId";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/AbstractGotoSEContributor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetActions";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "filterControlSymbols";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doGetActions";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fetchElements";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "filterControlSymbols";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processSelectedItem";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getDataForItem";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getElementPriority";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static abstract class ScopeChooserAction
    extends ActionGroup
    implements CustomComponentAction,
    DumbAware,
    SearchEverywhereToggleAction {
        static final char CHOOSE = 'O';
        static final char TOGGLE = 'P';
        static final String TOGGLE_ACTION_NAME = "toggleProjectScope";

        ScopeChooserAction() {
        }

        abstract void onScopeSelected(@NotNull ScopeDescriptor var1);

        @NotNull
        abstract ScopeDescriptor getSelectedScope();

        abstract void onProjectScopeToggled();

        public boolean canBePerformed(@NotNull DataContext context) {
            if (context == null) {
                ScopeChooserAction.$$$reportNull$$$0(0);
            }
            return true;
        }

        public boolean isPopup() {
            return true;
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            if (EMPTY_ARRAY == null) {
                ScopeChooserAction.$$$reportNull$$$0(1);
            }
            return EMPTY_ARRAY;
        }

        @NotNull
        public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
            if (presentation == null) {
                ScopeChooserAction.$$$reportNull$$$0(2);
            }
            if (place == null) {
                ScopeChooserAction.$$$reportNull$$$0(3);
            }
            final ActionButtonWithText component = new ActionButtonWithText((AnAction)this, presentation, place, ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
            UIUtil.putClientProperty((JComponent)component, (Key)MnemonicHelper.MNEMONIC_CHECKER, keyCode -> KeyEvent.getExtendedKeyCodeForChar(80) == keyCode || KeyEvent.getExtendedKeyCodeForChar(79) == keyCode);
            MnemonicHelper.registerMnemonicAction((JComponent)component, (int)79);
            InputMap map2 = component.getInputMap(2);
            int mask = MnemonicHelper.getFocusAcceleratorKeyMask();
            map2.put(KeyStroke.getKeyStroke(80, mask, false), TOGGLE_ACTION_NAME);
            component.getActionMap().put(TOGGLE_ACTION_NAME, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataContext dataContext = DataManager.getInstance().getDataContext((Component)component);
                    KeyEvent inputEvent = new KeyEvent(component, 401, e.getWhen(), MnemonicHelper.getFocusAcceleratorKeyMask(), KeyEvent.getExtendedKeyCodeForChar(80), 'P');
                    AnActionEvent event = AnActionEvent.createFromAnAction((AnAction)this, (InputEvent)inputEvent, (String)"toolbar", (DataContext)dataContext);
                    ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
                    actionManager.fireBeforeActionPerformed((AnAction)this, dataContext, event);
                    this.onProjectScopeToggled();
                    actionManager.fireAfterActionPerformed((AnAction)this, dataContext, event);
                }
            });
            ActionButtonWithText actionButtonWithText = component;
            if (actionButtonWithText == null) {
                ScopeChooserAction.$$$reportNull$$$0(4);
            }
            return actionButtonWithText;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ScopeChooserAction.$$$reportNull$$$0(5);
            }
            ScopeDescriptor selection = this.getSelectedScope();
            String name = StringUtil.trimMiddle((String)selection.getDisplayName(), (int)30);
            String text2 = StringUtil.escapeMnemonics((String)name).replaceFirst("(?i)([PO])", "_$1");
            e.getPresentation().setText(text2);
            e.getPresentation().setIcon(OffsetIcon.getOriginalIcon((Icon)selection.getIcon()));
            String shortcutText = KeymapUtil.getKeystrokeText((KeyStroke)KeyStroke.getKeyStroke(79, MnemonicHelper.getFocusAcceleratorKeyMask(), true));
            String shortcutText2 = KeymapUtil.getKeystrokeText((KeyStroke)KeyStroke.getKeyStroke(80, MnemonicHelper.getFocusAcceleratorKeyMask(), true));
            e.getPresentation().setDescription("Choose scope (" + shortcutText + ")\nToggle scope (" + shortcutText2 + ")");
            JComponent button2 = (JComponent)e.getPresentation().getClientProperty(CustomComponentAction.COMPONENT_KEY);
            if (button2 != null) {
                button2.setBackground(selection.getColor());
            }
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            JComponent button2;
            if (e == null) {
                ScopeChooserAction.$$$reportNull$$$0(6);
            }
            if ((button2 = (JComponent)e.getPresentation().getClientProperty(CustomComponentAction.COMPONENT_KEY)) == null || !button2.isValid()) {
                return;
            }
            JBList fakeList = new JBList();
            ListCellRenderer<ScopeDescriptor> renderer2 = new ListCellRenderer<ScopeDescriptor>(){
                final ListCellRenderer<ScopeDescriptor> delegate = ScopeChooserCombo.createDefaultRenderer();

                @Override
                public Component getListCellRendererComponent(JList<? extends ScopeDescriptor> list2, ScopeDescriptor value, int index, boolean isSelected, boolean cellHasFocus) {
                    Component component = this.delegate.getListCellRendererComponent(list2, value, index, isSelected, cellHasFocus);
                    if (component instanceof JComponent && !(component instanceof JSeparator) && !(component instanceof TitledSeparator)) {
                        ((JComponent)component).setBorder((Border)JBUI.Borders.empty((int)2, (int)8));
                    }
                    return component;
                }
            };
            ArrayList items = new ArrayList();
            ScopeChooserCombo.processScopes((Project)e.getRequiredData(CommonDataKeys.PROJECT), e.getDataContext(), 17, (Processor<? super ScopeDescriptor>)((Processor)arg_0 -> ScopeChooserAction.lambda$actionPerformed$1(renderer2, (JList)fakeList, items, arg_0)));
            BaseListPopupStep<ScopeDescriptor> step = new BaseListPopupStep<ScopeDescriptor>("", items){

                @Nullable
                public PopupStep onChosen(ScopeDescriptor selectedValue, boolean finalChoice) {
                    this.onScopeSelected(selectedValue);
                    ActionToolbar toolbar = (ActionToolbar)UIUtil.uiParents((Component)button2, (boolean)true).filter(ActionToolbar.class).first();
                    if (toolbar != null) {
                        toolbar.updateActionsImmediately();
                    }
                    return FINAL_CHOICE;
                }

                public boolean isSpeedSearchEnabled() {
                    return true;
                }

                @NotNull
                public String getTextFor(ScopeDescriptor value) {
                    String string = value.getScope() instanceof GlobalSearchScope ? value.getDisplayName() : "";
                    if (string == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                public boolean isSelectable(ScopeDescriptor value) {
                    return value.getScope() instanceof GlobalSearchScope;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/searcheverywhere/AbstractGotoSEContributor$ScopeChooserAction$3", "getTextFor"));
                }
            };
            ScopeDescriptor selection = this.getSelectedScope();
            step.setDefaultOptionIndex(ContainerUtil.indexOf(items, o -> Comparing.equal((String)o.getDisplayName(), (String)selection.getDisplayName())));
            ListPopupImpl popup2 = new ListPopupImpl(e.getProject(), (ListPopupStep)step);
            popup2.setMaxRowCount(10);
            popup2.getList().setCellRenderer(renderer2);
            popup2.showUnderneathOf(button2);
        }

        private static /* synthetic */ boolean lambda$actionPerformed$1(ListCellRenderer renderer2, JList fakeList, List items, ScopeDescriptor o) {
            Component c2 = renderer2.getListCellRendererComponent(fakeList, o, -1, false, false);
            if (c2 instanceof JSeparator || c2 instanceof TitledSeparator || !o.scopeEquals(null) && o.getScope() instanceof GlobalSearchScope) {
                items.add(o);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/AbstractGotoSEContributor$ScopeChooserAction";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/AbstractGotoSEContributor$ScopeChooserAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createCustomComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "canBePerformed";
                    break;
                }
                case 1: 
                case 4: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createCustomComponent";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static class SERenderer
    extends SearchEverywherePsiRenderer {
        protected SERenderer() {
        }

        @Override
        public String getElementText(PsiElement element) {
            if (element instanceof NavigationItem) {
                return Optional.ofNullable(((NavigationItem)element).getPresentation()).map(presentation -> presentation.getPresentableText()).orElse(super.getElementText(element));
            }
            return super.getElementText(element);
        }
    }
}

