/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.UIBundle;
import java.util.Arrays;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolWindowMoveAction
extends DumbAwareAction {
    @NotNull
    private final Anchor myAnchor;

    @Nullable
    protected ToolWindowManager getToolWindowManager(AnActionEvent e) {
        Project project = e.getProject();
        return project == null || project.isDisposed() ? null : ToolWindowManager.getInstance((Project)project);
    }

    @Nullable
    protected ToolWindow getToolWindow(AnActionEvent e) {
        ToolWindowManager manager = this.getToolWindowManager(e);
        if (manager == null) {
            return null;
        }
        ToolWindow window = (ToolWindow)e.getData(PlatformDataKeys.TOOL_WINDOW);
        if (window != null) {
            return window;
        }
        String id = manager.getActiveToolWindowId();
        return id == null ? null : manager.getToolWindow(id);
    }

    public ToolWindowMoveAction(@NotNull Anchor anchor2) {
        if (anchor2 == null) {
            ToolWindowMoveAction.$$$reportNull$$$0(0);
        }
        super(anchor2.toString(), null, anchor2.getIcon());
        this.myAnchor = anchor2;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        ToolWindow toolWindow;
        if (e == null) {
            ToolWindowMoveAction.$$$reportNull$$$0(1);
        }
        if ((toolWindow = this.getToolWindow(e)) != null) {
            this.myAnchor.applyTo(toolWindow);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ToolWindowMoveAction.$$$reportNull$$$0(2);
        }
        ToolWindow toolWindow = this.getToolWindow(e);
        e.getPresentation().setEnabled(toolWindow != null && !this.myAnchor.isApplied(toolWindow));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/actions/ToolWindowMoveAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Group
    extends DefaultActionGroup {
        private boolean isInitialized = false;

        public Group() {
            super(UIBundle.message((String)"tool.window.move.to.action.group.name", (Object[])new Object[0]), true);
        }

        public boolean isDumbAware() {
            return true;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                Group.$$$reportNull$$$0(0);
            }
            if (!this.isInitialized) {
                for (Anchor anchor2 : Anchor.values()) {
                    this.add((AnAction)new ToolWindowMoveAction(anchor2));
                }
                this.isInitialized = true;
            }
            super.update(e);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/ToolWindowMoveAction$Group", "update"));
        }
    }

    public static enum Anchor {
        LeftTop,
        LeftBottom,
        BottomLeft,
        BottomRight,
        RightBottom,
        RightTop,
        TopRight,
        TopLeft;


        public String toString() {
            String top = UIBundle.message((String)"tool.window.move.to.top.action.name", (Object[])new Object[0]);
            String left = UIBundle.message((String)"tool.window.move.to.left.action.name", (Object[])new Object[0]);
            String bottom = UIBundle.message((String)"tool.window.move.to.bottom.action.name", (Object[])new Object[0]);
            String right = UIBundle.message((String)"tool.window.move.to.right.action.name", (Object[])new Object[0]);
            switch (this) {
                case LeftTop: {
                    return left + " " + top;
                }
                case LeftBottom: {
                    return left + " " + bottom;
                }
                case BottomLeft: {
                    return bottom + " " + left;
                }
                case BottomRight: {
                    return bottom + " " + right;
                }
                case RightBottom: {
                    return right + " " + bottom;
                }
                case RightTop: {
                    return right + " " + top;
                }
                case TopRight: {
                    return top + " " + right;
                }
                case TopLeft: {
                    return top + " " + left;
                }
            }
            return super.toString();
        }

        @NotNull
        private ToolWindowAnchor getAnchor() {
            switch (this) {
                case LeftTop: 
                case LeftBottom: {
                    ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.LEFT;
                    if (toolWindowAnchor == null) {
                        Anchor.$$$reportNull$$$0(0);
                    }
                    return toolWindowAnchor;
                }
                case BottomLeft: 
                case BottomRight: {
                    ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.BOTTOM;
                    if (toolWindowAnchor == null) {
                        Anchor.$$$reportNull$$$0(1);
                    }
                    return toolWindowAnchor;
                }
                case RightBottom: 
                case RightTop: {
                    ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.RIGHT;
                    if (toolWindowAnchor == null) {
                        Anchor.$$$reportNull$$$0(2);
                    }
                    return toolWindowAnchor;
                }
            }
            ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.TOP;
            if (toolWindowAnchor == null) {
                Anchor.$$$reportNull$$$0(3);
            }
            return toolWindowAnchor;
        }

        private boolean isSplit() {
            return Arrays.asList(LeftBottom, BottomRight, RightBottom, TopRight).contains((Object)this);
        }

        @NotNull
        private Icon getIcon() {
            switch (this) {
                case LeftTop: {
                    Icon icon = AllIcons.Actions.MoveToLeftTop;
                    if (icon == null) {
                        Anchor.$$$reportNull$$$0(4);
                    }
                    return icon;
                }
                case LeftBottom: {
                    Icon icon = AllIcons.Actions.MoveToLeftBottom;
                    if (icon == null) {
                        Anchor.$$$reportNull$$$0(5);
                    }
                    return icon;
                }
                case BottomLeft: {
                    Icon icon = AllIcons.Actions.MoveToBottomLeft;
                    if (icon == null) {
                        Anchor.$$$reportNull$$$0(6);
                    }
                    return icon;
                }
                case BottomRight: {
                    Icon icon = AllIcons.Actions.MoveToBottomRight;
                    if (icon == null) {
                        Anchor.$$$reportNull$$$0(7);
                    }
                    return icon;
                }
                case RightBottom: {
                    Icon icon = AllIcons.Actions.MoveToRightBottom;
                    if (icon == null) {
                        Anchor.$$$reportNull$$$0(8);
                    }
                    return icon;
                }
                case RightTop: {
                    Icon icon = AllIcons.Actions.MoveToRightTop;
                    if (icon == null) {
                        Anchor.$$$reportNull$$$0(9);
                    }
                    return icon;
                }
                case TopRight: {
                    Icon icon = AllIcons.Actions.MoveToTopRight;
                    if (icon == null) {
                        Anchor.$$$reportNull$$$0(10);
                    }
                    return icon;
                }
            }
            Icon icon = AllIcons.Actions.MoveToTopLeft;
            if (icon == null) {
                Anchor.$$$reportNull$$$0(11);
            }
            return icon;
        }

        boolean isApplied(@NotNull ToolWindow window) {
            if (window == null) {
                Anchor.$$$reportNull$$$0(12);
            }
            return this.getAnchor() == window.getAnchor() && window.isSplitMode() == this.isSplit();
        }

        void applyTo(@NotNull ToolWindow window) {
            if (window == null) {
                Anchor.$$$reportNull$$$0(13);
            }
            window.setAnchor(this.getAnchor(), null);
            window.setSplitMode(this.isSplit(), null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 12: 
                case 13: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 12: 
                case 13: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/actions/ToolWindowMoveAction$Anchor";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "window";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAnchor";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/actions/ToolWindowMoveAction$Anchor";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "isApplied";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "applyTo";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 12: 
                case 13: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

