/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.services;

import com.intellij.execution.services.ServiceEventListener;
import com.intellij.execution.services.ServiceViewAlwaysEnabledContributor;
import com.intellij.execution.services.ServiceViewContributor;
import com.intellij.execution.services.ServiceViewDescriptor;
import com.intellij.execution.services.ServiceViewDragHelper;
import com.intellij.execution.services.ServiceViewGroupingContributor;
import com.intellij.execution.services.ServiceViewProvidingContributor;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.WeighedItem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ColoredItem;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.concurrency.InvokerSupplier;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.TreeTraversal;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;

class ServiceModel
implements Disposable,
InvokerSupplier {
    private static final ExtensionPointName<ServiceViewContributor> EP_NAME = ExtensionPointName.create((String)"com.intellij.serviceViewContributor");
    private final Project myProject;
    private final Invoker myInvoker;
    private final List<ServiceViewItem> myRoots;
    private volatile boolean myRootsInitialized;

    ServiceModel(@NotNull Project project) {
        if (project == null) {
            ServiceModel.$$$reportNull$$$0(0);
        }
        this.myInvoker = new Invoker.BackgroundThread(this);
        this.myRoots = new CopyOnWriteArrayList<ServiceViewItem>();
        this.myProject = project;
    }

    public void dispose() {
    }

    @Override
    @NotNull
    public Invoker getInvoker() {
        Invoker invoker = this.myInvoker;
        if (invoker == null) {
            ServiceModel.$$$reportNull$$$0(1);
        }
        return invoker;
    }

    @NotNull
    List<? extends ServiceViewItem> getRoots() {
        List<Object> list2 = this.myRootsInitialized ? this.myRoots : Collections.emptyList();
        if (list2 == null) {
            ServiceModel.$$$reportNull$$$0(2);
        }
        return list2;
    }

    CancellablePromise<?> initRoots() {
        return this.getInvoker().runOrInvokeLater(() -> {
            if (!this.myRootsInitialized) {
                this.myRoots.addAll(this.doGetRoots());
                this.myRootsInitialized = true;
            }
        });
    }

    private List<? extends ServiceViewItem> doGetRoots() {
        ArrayList<ContributorNode> result2 = new ArrayList<ContributorNode>();
        for (ServiceViewContributor contributor : ServiceModel.getContributors()) {
            ContributorNode root = new ContributorNode(this.myProject, contributor);
            root.loadChildren();
            if (root.getChildren().isEmpty()) continue;
            result2.add(root);
        }
        return result2;
    }

    private JBIterable<ServiceViewItem> findItems(Object service, Class<?> contributorClass) {
        Object value = service instanceof ServiceViewProvidingContributor ? ((ServiceViewProvidingContributor)service).asService() : service;
        return ((JBTreeTraverser)JBTreeTraverser.from(node -> contributorClass.isInstance(node.getRootContributor()) ? new ArrayList<ServiceViewItem>(node.getChildren()) : null).withRoots(this.myRoots)).traverse(TreeTraversal.PLAIN_BFS).filter(node -> node.getValue().equals(value));
    }

    @Nullable
    ServiceViewItem findItem(Object service, Class<?> contributorClass) {
        return (ServiceViewItem)this.findItems(service, contributorClass).first();
    }

    @Nullable
    ServiceViewItem findItemById(List<String> ids, ServiceViewContributor contributor) {
        if (ids.isEmpty()) {
            return null;
        }
        List roots = ContainerUtil.filter(this.getRoots(), item -> contributor.equals(item.getContributor()));
        if (roots.isEmpty()) {
            return null;
        }
        return ServiceModel.findItemById(new LinkedList<String>(ids), roots);
    }

    private static ServiceViewItem findItemById(Deque<String> path, List<? extends ServiceViewItem> roots) {
        String id = path.removeFirst();
        for (ServiceViewItem serviceViewItem : roots) {
            if (!id.equals(serviceViewItem.getViewDescriptor().getId())) continue;
            return path.isEmpty() ? serviceViewItem : ServiceModel.findItemById(path, serviceViewItem.getChildren());
        }
        return null;
    }

    @NotNull
    CancellablePromise<?> refresh(@NotNull ServiceEventListener.ServiceEvent e) {
        if (e == null) {
            ServiceModel.$$$reportNull$$$0(3);
        }
        CancellablePromise<?> cancellablePromise = this.getInvoker().runOrInvokeLater(() -> {
            switch (e.type) {
                case SERVICE_ADDED: {
                    this.addService(e);
                    break;
                }
                case SERVICE_REMOVED: {
                    this.removeService(e);
                    break;
                }
                case SERVICE_CHANGED: {
                    this.serviceChanged(e);
                    break;
                }
                case SERVICE_STRUCTURE_CHANGED: {
                    this.serviceStructureChanged(e);
                    break;
                }
                case GROUP_CHANGED: {
                    this.groupChanged(e);
                    break;
                }
                default: {
                    this.reset(e.contributorClass);
                }
            }
        });
        if (cancellablePromise == null) {
            ServiceModel.$$$reportNull$$$0(4);
        }
        return cancellablePromise;
    }

    private void reset(Class<?> contributorClass) {
        int index = -1;
        if (this.myRoots.isEmpty()) {
            index = 0;
        } else {
            ServiceViewItem contributorNode = null;
            for (int i = 0; i < this.myRoots.size(); ++i) {
                ServiceViewItem child2 = this.myRoots.get(i);
                if (!contributorClass.isInstance(child2.getContributor())) continue;
                contributorNode = child2;
                index = i;
                break;
            }
            if (contributorNode != null) {
                this.myRoots.remove(contributorNode);
            } else {
                index = this.getContributorNodeIndex(contributorClass);
            }
        }
        ContributorNode newRoot = null;
        for (ServiceViewContributor contributor : ServiceModel.getContributors()) {
            if (!contributorClass.isInstance(contributor)) continue;
            newRoot = new ContributorNode(this.myProject, contributor);
            newRoot.loadChildren();
            if (!newRoot.getChildren().isEmpty()) break;
            newRoot = null;
            break;
        }
        if (newRoot != null) {
            this.myRoots.add(index, newRoot);
        }
    }

    private int getContributorNodeIndex(Class<?> contributorClass) {
        ServiceViewContributor contributor;
        int index = -1;
        ServiceViewContributor[] contributors = ServiceModel.getContributors();
        List existingContributors = ContainerUtil.map(this.myRoots, ServiceViewItem::getContributor);
        for (int i = contributors.length - 1; i >= 0 && !contributorClass.isInstance(contributor = contributors[i]) && (index = existingContributors.indexOf(contributor)) != 0; --i) {
        }
        if (index < 0) {
            index = this.myRoots.size();
        }
        return index;
    }

    private void addService(ServiceEventListener.ServiceEvent e) {
        ServiceViewItem item = this.findItem(e.target, e.contributorClass);
        if (item != null) {
            return;
        }
        if (e.parent != null) {
            ServiceViewContributor<?> parentContributor;
            ServiceViewItem parent = this.findItem(e.parent, e.contributorClass);
            ServiceViewContributor<?> serviceViewContributor = parentContributor = parent instanceof ServiceNode ? ((ServiceNode)parent).getProvidingContributor() : null;
            if (parentContributor == null) {
                return;
            }
            ServiceModel.addService(e.target, parent.getChildren(), this.myProject, parent, parentContributor);
            return;
        }
        ServiceViewItem contributorNode = null;
        for (ServiceViewItem child2 : this.myRoots) {
            if (!e.contributorClass.isInstance(child2.getContributor())) continue;
            contributorNode = child2;
            break;
        }
        if (contributorNode == null) {
            int index = this.getContributorNodeIndex(e.contributorClass);
            for (ServiceViewContributor contributor : ServiceModel.getContributors()) {
                if (!e.contributorClass.isInstance(contributor)) continue;
                contributorNode = new ContributorNode(this.myProject, contributor);
                this.myRoots.add(index, contributorNode);
                break;
            }
            if (contributorNode == null) {
                return;
            }
        }
        ServiceModel.addService(e.target, contributorNode.getChildren(), this.myProject, contributorNode, contributorNode.getContributor());
    }

    private void removeService(ServiceEventListener.ServiceEvent e) {
        ServiceViewItem item = this.findItem(e.target, e.contributorClass);
        if (item == null) {
            return;
        }
        ServiceViewItem parent = item.getParent();
        while (parent instanceof ServiceGroupNode) {
            parent.getChildren().remove(item);
            if (!parent.getChildren().isEmpty()) {
                return;
            }
            item = parent;
            parent = parent.getParent();
        }
        if (parent instanceof ContributorNode) {
            parent.getChildren().remove(item);
            if (!parent.getChildren().isEmpty()) {
                return;
            }
            item = parent;
            parent = parent.getParent();
        }
        if (parent == null) {
            this.myRoots.remove(item);
        } else {
            parent.getChildren().remove(item);
        }
    }

    private void serviceChanged(ServiceEventListener.ServiceEvent e) {
        ServiceViewContributor<?> providingContributor;
        ServiceViewItem item = this.findItem(e.target, e.contributorClass);
        if (item == null) {
            return;
        }
        if (item instanceof ServiceNode && (providingContributor = ((ServiceNode)item).getProvidingContributor()) != null && !providingContributor.equals(e.target)) {
            item.setViewDescriptor(providingContributor.getViewDescriptor());
            return;
        }
        ServiceViewDescriptor viewDescriptor = item.getContributor().getServiceDescriptor(e.target);
        item.setViewDescriptor(viewDescriptor);
    }

    private void groupChanged(ServiceEventListener.ServiceEvent e) {
        JBIterable groups = this.findItems(e.target, e.contributorClass).filter(ServiceGroupNode.class);
        ServiceGroupNode first = (ServiceGroupNode)groups.first();
        if (first == null) {
            return;
        }
        ServiceViewDescriptor viewDescriptor = ((ServiceViewGroupingContributor)first.getContributor()).getGroupDescriptor(e.target);
        for (ServiceViewItem group : groups) {
            group.setViewDescriptor(viewDescriptor);
            ServiceViewItem parent = group.getParent();
            if (parent == null) continue;
            List<ServiceViewItem> children2 = parent.getChildren();
            children2.remove(group);
            ServiceModel.addGroupOrdered(children2, (ServiceGroupNode)group);
        }
    }

    private void serviceStructureChanged(ServiceEventListener.ServiceEvent e) {
        ServiceViewContributor<?> providingContributor;
        ServiceViewItem item = this.findItem(e.target, e.contributorClass);
        if (item == null) {
            return;
        }
        ServiceViewItem parent = item.getParent();
        if (parent == null) {
            return;
        }
        ServiceGroupNode group = null;
        if (parent instanceof ServiceGroupNode) {
            group = (ServiceGroupNode)parent;
            parent = group.getParent();
            while (parent instanceof ServiceGroupNode) {
                parent = parent.getParent();
            }
            if (parent == null) {
                return;
            }
        }
        if (group != null) {
            group.getChildren().remove(item);
        } else {
            parent.getChildren().remove(item);
        }
        ServiceViewContributor<?> value = e.target;
        if (item instanceof ServiceNode && (providingContributor = ((ServiceNode)item).getProvidingContributor()) != null && !providingContributor.equals(e.target)) {
            value = providingContributor;
        }
        ServiceModel.addService(value, parent.getChildren(), this.myProject, parent, item.getContributor());
        while (group != null && group.getChildren().isEmpty()) {
            ServiceViewItem groupParent = group.getParent();
            if (groupParent == null) {
                return;
            }
            groupParent.getChildren().remove(group);
            group = groupParent instanceof ServiceGroupNode ? (ServiceGroupNode)groupParent : null;
        }
    }

    @NotNull
    public static ServiceViewContributor[] getContributors() {
        ServiceViewContributor[] result2 = (ServiceViewContributor[])EP_NAME.getExtensions();
        ServiceViewContributor[] serviceViewContributorArray = Registry.is((String)"ide.service.view") ? result2 : (ServiceViewContributor[])Arrays.stream(result2).filter(c2 -> c2 instanceof ServiceViewAlwaysEnabledContributor).toArray(ServiceViewContributor[]::new);
        if (serviceViewContributorArray == null) {
            ServiceModel.$$$reportNull$$$0(5);
        }
        return serviceViewContributorArray;
    }

    private static <T> List<ServiceViewItem> getContributorChildren(Project project, ServiceViewItem parent, ServiceViewContributor<T> contributor) {
        ArrayList<ServiceViewItem> children2 = new ArrayList<ServiceViewItem>();
        for (Object service : contributor.getServices(project)) {
            ServiceModel.addService(service, children2, project, parent, contributor);
        }
        return children2;
    }

    private static <T> void addService(Object service, List<ServiceViewItem> children2, Project project, ServiceViewItem parent, ServiceViewContributor<T> contributor) {
        Object value;
        Object typedService = service;
        Object object = value = service instanceof ServiceViewProvidingContributor ? ((ServiceViewProvidingContributor)service).asService() : service;
        if (!(contributor instanceof ServiceViewGroupingContributor) || !ServiceModel.addGroupNode((ServiceViewGroupingContributor)contributor, typedService, value, parent, project, children2)) {
            ServiceNode serviceNode = new ServiceNode(value, parent, contributor, contributor.getServiceDescriptor(typedService), project, service instanceof ServiceViewContributor ? (ServiceViewContributor)service : null);
            ServiceModel.addServiceOrdered(children2, serviceNode, contributor);
        }
    }

    private static <T, G> boolean addGroupNode(ServiceViewGroupingContributor<T, G> groupingContributor, T service, Object value, ServiceViewItem parent, Project project, List<ServiceViewItem> children2) {
        List groups = groupingContributor.getGroups(service);
        if (groups.isEmpty()) {
            return false;
        }
        List<ServiceViewItem> currentChildren = children2;
        ServiceViewItem groupParent = parent;
        for (Object group : groups) {
            boolean found = false;
            for (ServiceViewItem child2 : currentChildren) {
                if (!child2.getValue().equals(group)) continue;
                groupParent = child2;
                currentChildren = groupParent.getChildren();
                found = true;
                break;
            }
            if (found) continue;
            ServiceGroupNode groupNode = new ServiceGroupNode(group, groupParent, (ServiceViewContributor)groupingContributor, groupingContributor.getGroupDescriptor(group));
            ServiceModel.addGroupOrdered(currentChildren, groupNode);
            groupParent = groupNode;
            currentChildren = groupParent.getChildren();
        }
        ServiceNode serviceNode = new ServiceNode(value, groupParent, (ServiceViewContributor)groupingContributor, groupingContributor.getServiceDescriptor(service), project, service instanceof ServiceViewContributor ? (ServiceViewContributor)service : null);
        ServiceModel.addServiceOrdered(currentChildren, serviceNode, groupingContributor);
        return true;
    }

    private static void addServiceOrdered(List<ServiceViewItem> children2, ServiceNode child2, ServiceViewContributor<?> contributor) {
        if (!children2.isEmpty() && contributor instanceof Comparator) {
            Comparator comparator2 = (Comparator)contributor;
            for (int i = 0; i < children2.size(); ++i) {
                ServiceViewItem anchor2 = children2.get(i);
                if (!(anchor2 instanceof ServiceNode) || comparator2.compare(child2.getService(), ((ServiceNode)anchor2).getService()) >= 0) continue;
                children2.add(i, child2);
                return;
            }
        }
        children2.add(child2);
    }

    private static void addGroupOrdered(List<ServiceViewItem> children2, ServiceGroupNode child2) {
        if (!children2.isEmpty()) {
            for (int i = 0; i < children2.size(); ++i) {
                ServiceViewItem anchor2 = children2.get(i);
                if (anchor2 instanceof ServiceNode) {
                    children2.add(i, child2);
                    return;
                }
                if (!(anchor2 instanceof ServiceGroupNode) || ServiceModel.compareGroups(child2, (ServiceGroupNode)anchor2) >= 0) continue;
                children2.add(i, child2);
                return;
            }
        }
        children2.add(child2);
    }

    private static int compareGroups(ServiceGroupNode group1, ServiceGroupNode group2) {
        ServiceViewDescriptor groupDescriptor1 = group1.getViewDescriptor();
        WeighedItem weighedItem1 = (WeighedItem)ObjectUtils.tryCast((Object)groupDescriptor1, WeighedItem.class);
        ServiceViewDescriptor groupDescriptor2 = group2.getViewDescriptor();
        WeighedItem weighedItem2 = (WeighedItem)ObjectUtils.tryCast((Object)groupDescriptor2, WeighedItem.class);
        if (weighedItem1 != null) {
            if (weighedItem2 == null) {
                return -1;
            }
            int diff = weighedItem1.getWeight() - weighedItem2.getWeight();
            if (diff != 0) {
                return diff;
            }
        } else if (weighedItem2 != null) {
            return 1;
        }
        String name1 = ServiceViewDragHelper.getDisplayName(groupDescriptor1.getPresentation());
        String name2 = ServiceViewDragHelper.getDisplayName(groupDescriptor2.getPresentation());
        return StringUtil.naturalCompare((String)name1, (String)name2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/services/ServiceModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/services/ServiceModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvoker";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "refresh";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getContributors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "refresh";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ServiceGroupNode
    extends ServiceViewItem {
        ServiceGroupNode(@NotNull Object group, @Nullable ServiceViewItem parent, @NotNull ServiceViewContributor contributor, @NotNull ServiceViewDescriptor viewDescriptor) {
            if (group == null) {
                ServiceGroupNode.$$$reportNull$$$0(0);
            }
            if (contributor == null) {
                ServiceGroupNode.$$$reportNull$$$0(1);
            }
            if (viewDescriptor == null) {
                ServiceGroupNode.$$$reportNull$$$0(2);
            }
            super(group, parent, contributor, viewDescriptor);
        }

        @Override
        @NotNull
        protected List<ServiceViewItem> doGetChildren() {
            CopyOnWriteArrayList<ServiceViewItem> copyOnWriteArrayList = new CopyOnWriteArrayList<ServiceViewItem>();
            if (copyOnWriteArrayList == null) {
                ServiceGroupNode.$$$reportNull$$$0(3);
            }
            return copyOnWriteArrayList;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ServiceGroupNode node = (ServiceGroupNode)o;
            return this.getValue().equals(node.getValue()) && Comparing.equal((Object)this.getParent(), (Object)node.getParent());
        }

        @Override
        public int hashCode() {
            int result2 = super.hashCode();
            ServiceViewItem parent = this.getParent();
            result2 = 31 * result2 + (parent != null ? parent.hashCode() : 0);
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "group";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contributor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "viewDescriptor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/services/ServiceModel$ServiceGroupNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/services/ServiceModel$ServiceGroupNode";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doGetChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class ServiceNode
    extends ServiceViewItem {
        private final Project myProject;
        private final ServiceViewContributor<?> myProvidingContributor;

        ServiceNode(@NotNull Object service, @Nullable ServiceViewItem parent, @NotNull ServiceViewContributor contributor, @NotNull ServiceViewDescriptor viewDescriptor, @NotNull Project project, @Nullable ServiceViewContributor providingContributor) {
            if (service == null) {
                ServiceNode.$$$reportNull$$$0(0);
            }
            if (contributor == null) {
                ServiceNode.$$$reportNull$$$0(1);
            }
            if (viewDescriptor == null) {
                ServiceNode.$$$reportNull$$$0(2);
            }
            if (project == null) {
                ServiceNode.$$$reportNull$$$0(3);
            }
            super(service, parent, contributor, viewDescriptor);
            this.myProject = project;
            this.myProvidingContributor = providingContributor;
        }

        @Override
        @NotNull
        protected List<ServiceViewItem> doGetChildren() {
            CopyOnWriteArrayList copyOnWriteArrayList = this.myProvidingContributor == null ? Collections.emptyList() : new CopyOnWriteArrayList(ServiceModel.getContributorChildren(this.myProject, this, this.myProvidingContributor));
            if (copyOnWriteArrayList == null) {
                ServiceNode.$$$reportNull$$$0(4);
            }
            return copyOnWriteArrayList;
        }

        @Nullable
        ServiceViewContributor<?> getProvidingContributor() {
            return this.myProvidingContributor;
        }

        @NotNull
        private Object getService() {
            Object object = this.myProvidingContributor != null ? this.myProvidingContributor : this.getValue();
            if (object == null) {
                ServiceNode.$$$reportNull$$$0(5);
            }
            return object;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "service";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contributor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "viewDescriptor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/services/ServiceModel$ServiceNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/services/ServiceModel$ServiceNode";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doGetChildren";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getService";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class ContributorNode
    extends ServiceViewItem {
        private final Project myProject;

        ContributorNode(@NotNull Project project, @NotNull ServiceViewContributor contributor) {
            if (project == null) {
                ContributorNode.$$$reportNull$$$0(0);
            }
            if (contributor == null) {
                ContributorNode.$$$reportNull$$$0(1);
            }
            super(contributor, null, contributor, contributor.getViewDescriptor());
            this.myProject = project;
        }

        private void loadChildren() {
            List<ServiceViewItem> children2 = this.getChildren();
            if (!children2.isEmpty()) {
                children2.clear();
            }
            children2.addAll(ServiceModel.getContributorChildren(this.myProject, this, this.getContributor()));
        }

        @Override
        @NotNull
        protected List<ServiceViewItem> doGetChildren() {
            CopyOnWriteArrayList<ServiceViewItem> copyOnWriteArrayList = new CopyOnWriteArrayList<ServiceViewItem>();
            if (copyOnWriteArrayList == null) {
                ContributorNode.$$$reportNull$$$0(2);
            }
            return copyOnWriteArrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contributor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/services/ServiceModel$ContributorNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/services/ServiceModel$ContributorNode";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doGetChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static abstract class ServiceViewItem
    implements ColoredItem {
        private final Object myValue;
        private final ServiceViewItem myParent;
        private final ServiceViewContributor myContributor;
        private ServiceViewDescriptor myViewDescriptor;
        private List<ServiceViewItem> myChildren;
        private boolean myPresentationUpdated;

        protected ServiceViewItem(@NotNull Object value, @Nullable ServiceViewItem parent, @NotNull ServiceViewContributor contributor, @NotNull ServiceViewDescriptor viewDescriptor) {
            if (value == null) {
                ServiceViewItem.$$$reportNull$$$0(0);
            }
            if (contributor == null) {
                ServiceViewItem.$$$reportNull$$$0(1);
            }
            if (viewDescriptor == null) {
                ServiceViewItem.$$$reportNull$$$0(2);
            }
            this.myValue = value;
            this.myParent = parent;
            this.myContributor = contributor;
            this.myViewDescriptor = viewDescriptor;
        }

        @NotNull
        Object getValue() {
            Object object = this.myValue;
            if (object == null) {
                ServiceViewItem.$$$reportNull$$$0(3);
            }
            return object;
        }

        @NotNull
        ServiceViewContributor getContributor() {
            ServiceViewContributor serviceViewContributor = this.myContributor;
            if (serviceViewContributor == null) {
                ServiceViewItem.$$$reportNull$$$0(4);
            }
            return serviceViewContributor;
        }

        @NotNull
        ServiceViewContributor getRootContributor() {
            ServiceViewContributor serviceViewContributor = this.myParent == null ? this.myContributor : this.myParent.getRootContributor();
            if (serviceViewContributor == null) {
                ServiceViewItem.$$$reportNull$$$0(5);
            }
            return serviceViewContributor;
        }

        @NotNull
        ServiceViewDescriptor getViewDescriptor() {
            if (!this.myPresentationUpdated) {
                this.myPresentationUpdated = true;
                if (this.myValue instanceof NodeDescriptor) {
                    ((NodeDescriptor)this.myValue).update();
                }
            }
            ServiceViewDescriptor serviceViewDescriptor = this.myViewDescriptor;
            if (serviceViewDescriptor == null) {
                ServiceViewItem.$$$reportNull$$$0(6);
            }
            return serviceViewDescriptor;
        }

        private void setViewDescriptor(@NotNull ServiceViewDescriptor viewDescriptor) {
            if (viewDescriptor == null) {
                ServiceViewItem.$$$reportNull$$$0(7);
            }
            AppUIUtil.invokeOnEdt(() -> {
                this.myViewDescriptor = viewDescriptor;
                this.myPresentationUpdated = false;
            });
        }

        @Nullable
        ServiceViewItem getParent() {
            return this.myParent;
        }

        @NotNull
        List<ServiceViewItem> getChildren() {
            if (this.myChildren == null) {
                this.myChildren = this.doGetChildren();
            }
            List<ServiceViewItem> list2 = this.myChildren;
            if (list2 == null) {
                ServiceViewItem.$$$reportNull$$$0(8);
            }
            return list2;
        }

        boolean isChildrenInitialized() {
            return this.myChildren != null;
        }

        @NotNull
        protected abstract List<ServiceViewItem> doGetChildren();

        @Nullable
        public Color getColor() {
            ServiceViewDescriptor descriptor2 = this.getViewDescriptor();
            return descriptor2 instanceof ColoredItem ? ((ColoredItem)descriptor2).getColor() : null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ServiceViewItem node = (ServiceViewItem)o;
            return this.myValue.equals(node.myValue);
        }

        public int hashCode() {
            return this.myValue.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contributor";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "viewDescriptor";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/services/ServiceModel$ServiceViewItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/services/ServiceModel$ServiceViewItem";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContributor";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRootContributor";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getViewDescriptor";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "setViewDescriptor";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

