/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.hints.HintInfo;
import com.intellij.codeInsight.hints.InlayParameterHintsExtension;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.codeInsight.hints.PopupActionsKt;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u00012\u00020\u0002:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\u0005H\u0016J\b\u0010\r\u001a\u00020\u0005H\u0016J!\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0096\u0002J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/codeInsight/hints/EnableCustomHintsOption;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "()V", "lastOptionName", "", "getDisabledOptionInfoAtCaretOffset", "Lcom/intellij/codeInsight/hints/HintInfo$OptionInfo;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "isAvailable", "", "startInWriteAction", "Companion", "intellij.platform.lang.impl"})
public final class EnableCustomHintsOption
implements IntentionAction,
HighPriorityAction {
    private String lastOptionName = "";
    private static final String presentableFamilyName;
    public static final Companion Companion;

    @NotNull
    public String getText() {
        if (StringsKt.startsWith((String)this.lastOptionName, (String)"show", (boolean)true)) {
            return PopupActionsKt.access$capitalizeFirstLetter(this.lastOptionName);
        }
        String string = CodeInsightBundle.message((String)"inlay.hints.enable.custom.option", (Object[])new Object[]{this.lastOptionName});
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"CodeInsightBundle.messag\u2026.option\", lastOptionName)");
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = presentableFamilyName;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"presentableFamilyName");
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        EditorSettingsExternalizable editorSettingsExternalizable = EditorSettingsExternalizable.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorSettingsExternalizable, (String)"EditorSettingsExternalizable.getInstance()");
        if (!editorSettingsExternalizable.isShowParameterNameHints()) {
            return false;
        }
        if (!(editor instanceof EditorImpl)) {
            return false;
        }
        if ((InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(file2.getLanguage()) == null) {
            return false;
        }
        HintInfo.OptionInfo optionInfo = this.getDisabledOptionInfoAtCaretOffset(editor, file2);
        if (optionInfo == null) {
            return false;
        }
        HintInfo.OptionInfo option = optionInfo;
        this.lastOptionName = option.getOptionName();
        return true;
    }

    private final HintInfo.OptionInfo getDisabledOptionInfoAtCaretOffset(Editor editor, PsiFile file2) {
        CaretModel caretModel = editor.getCaretModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
        int offset = caretModel.getOffset();
        PsiElement psiElement = file2.findElementAt(offset);
        if (psiElement == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"file.findElementAt(offset) ?: return null");
        PsiElement element = psiElement;
        InlayParameterHintsProvider inlayParameterHintsProvider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(file2.getLanguage());
        if (inlayParameterHintsProvider == null) {
            return null;
        }
        InlayParameterHintsProvider provider = inlayParameterHintsProvider;
        PsiElement psiElement2 = PsiTreeUtil.findFirstParent((PsiElement)element, (Condition)((Condition)new Condition<PsiElement>(provider){
            final /* synthetic */ InlayParameterHintsProvider $provider;

            public final boolean value(PsiElement it) {
                PsiElement psiElement = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"it");
                return PopupActionsKt.access$hasDisabledOptionHintInfo(this.$provider, psiElement);
            }
            {
                this.$provider = inlayParameterHintsProvider;
            }
        }));
        if (psiElement2 == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"PsiTreeUtil.findFirstPar\u2026nfo(it) }) ?: return null");
        PsiElement target2 = psiElement2;
        HintInfo hintInfo = provider.getHintInfo(target2);
        if (!(hintInfo instanceof HintInfo.OptionInfo)) {
            hintInfo = null;
        }
        return (HintInfo.OptionInfo)hintInfo;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        HintInfo.OptionInfo optionInfo = this.getDisabledOptionInfoAtCaretOffset(editor, file2);
        if (optionInfo == null) {
            return;
        }
        HintInfo.OptionInfo option = optionInfo;
        option.enable();
        PopupActionsKt.access$refreshAllOpenEditors();
    }

    public boolean startInWriteAction() {
        return false;
    }

    static {
        Companion = new Companion(null);
        presentableFamilyName = CodeInsightBundle.message((String)"inlay.hints.intention.family.name", (Object[])new Object[0]);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/codeInsight/hints/EnableCustomHintsOption$Companion;", "", "()V", "presentableFamilyName", "", "kotlin.jvm.PlatformType", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

