/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.EditorBoundHighlightingPass;
import com.intellij.codeHighlighting.HighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.DefaultHighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.HighlightingSessionImpl;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.concurrency.Job;
import com.intellij.concurrency.JobLauncher;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashMap;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class PassExecutorService
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.PassExecutorService");
    private static final boolean CHECK_CONSISTENCY = ApplicationManager.getApplication().isUnitTestMode();
    private final Map<ScheduledPass, Job<Void>> mySubmittedPasses;
    private final Project myProject;
    private volatile boolean isDisposed;
    private final AtomicInteger nextPassId;
    private static final Key<Throwable> THROWABLE_KEY = Key.create((String)"THROWABLE_KEY");

    PassExecutorService(@NotNull Project project) {
        if (project == null) {
            PassExecutorService.$$$reportNull$$$0(0);
        }
        this.mySubmittedPasses = new ConcurrentHashMap<ScheduledPass, Job<Void>>();
        this.nextPassId = new AtomicInteger(100);
        this.myProject = project;
    }

    public void dispose() {
        this.cancelAll(true);
        ForkJoinPool.commonPool().awaitQuiescence(1L, TimeUnit.SECONDS);
        this.isDisposed = true;
    }

    void cancelAll(boolean waitForTermination) {
        for (Job<Void> submittedPass : this.mySubmittedPasses.values()) {
            submittedPass.cancel();
        }
        if (waitForTermination) {
            try {
                while (!this.waitFor(50)) {
                    boolean bl = false;
                }
            }
            catch (ProcessCanceledException processCanceledException) {
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable throwable) {
                LOG.error(throwable);
            }
        }
        this.mySubmittedPasses.clear();
    }

    void submitPasses(@NotNull Map<FileEditor, HighlightingPass[]> passesMap, @NotNull DaemonProgressIndicator updateProgress) {
        FileEditor fileEditor;
        if (passesMap == null) {
            PassExecutorService.$$$reportNull$$$0(1);
        }
        if (updateProgress == null) {
            PassExecutorService.$$$reportNull$$$0(2);
        }
        if (this.isDisposed()) {
            return;
        }
        MultiMap documentToEditors = MultiMap.createSet();
        MultiMap documentBoundPasses = MultiMap.createSmart();
        MultiMap editorBoundPasses = MultiMap.createSmart();
        ArrayList<Pair> passesWithNoDocuments = new ArrayList<Pair>();
        HashSet<VirtualFile> vFiles = new HashSet<VirtualFile>();
        for (Map.Entry<FileEditor, HighlightingPass[]> entry : passesMap.entrySet()) {
            Document document;
            FileEditor fileEditor2 = entry.getKey();
            HighlightingPass[] passes = entry.getValue();
            if (fileEditor2 instanceof TextEditor) {
                Editor editor = ((TextEditor)fileEditor2).getEditor();
                LOG.assertTrue(!(editor instanceof EditorWindow));
                document = editor.getDocument();
            } else {
                VirtualFile virtualFile = ((FileEditorManagerEx)FileEditorManager.getInstance((Project)this.myProject)).getFile(fileEditor2);
                Document document2 = document = virtualFile == null ? null : FileDocumentManager.getInstance().getDocument(virtualFile);
            }
            if (document != null) {
                vFiles.add(FileDocumentManager.getInstance().getFile(document));
            }
            int prevId = 0;
            for (HighlightingPass pass : passes) {
                if (pass instanceof EditorBoundHighlightingPass) {
                    EditorBoundHighlightingPass editorPass = (EditorBoundHighlightingPass)pass;
                    editorPass.setId(this.nextPassId.incrementAndGet());
                    editorBoundPasses.putValue((Object)fileEditor2, (Object)editorPass);
                    continue;
                }
                TextEditorHighlightingPass textEditorHighlightingPass = this.convertToTextHighlightingPass(pass, document, this.nextPassId, prevId);
                document = textEditorHighlightingPass.getDocument();
                documentBoundPasses.putValue((Object)fileEditor2, (Object)textEditorHighlightingPass);
                if (document == null) {
                    passesWithNoDocuments.add(Pair.create((Object)fileEditor2, (Object)textEditorHighlightingPass));
                } else {
                    documentToEditors.putValue((Object)document, (Object)fileEditor2);
                }
                prevId = textEditorHighlightingPass.getId();
            }
        }
        ArrayList<ScheduledPass> freePasses = new ArrayList<ScheduledPass>(documentToEditors.size() * 5);
        ArrayList<ScheduledPass> dependentPasses = new ArrayList<ScheduledPass>(documentToEditors.size() * 10);
        THashMap toBeSubmitted = new THashMap(passesMap.size());
        AtomicInteger threadsToStartCountdown = new AtomicInteger(0);
        for (Map.Entry entry : documentToEditors.entrySet()) {
            Collection fileEditors = (Collection)entry.getValue();
            Document document = (Document)entry.getKey();
            FileEditor preferredFileEditor = this.getPreferredFileEditor(document, fileEditors);
            List passes = (List)documentBoundPasses.get((Object)preferredFileEditor);
            if (passes.isEmpty()) continue;
            PassExecutorService.sortById(passes);
            for (TextEditorHighlightingPass currentPass : passes) {
                this.createScheduledPass(preferredFileEditor, currentPass, (Map<Pair<FileEditor, Integer>, ScheduledPass>)toBeSubmitted, passes, freePasses, dependentPasses, updateProgress, threadsToStartCountdown);
            }
        }
        for (Map.Entry entry : editorBoundPasses.entrySet()) {
            fileEditor = (FileEditor)entry.getKey();
            Collection createdEditorBoundPasses = (Collection)entry.getValue();
            List createdDocumentBoundPasses = (List)documentBoundPasses.get((Object)fileEditor);
            ArrayList<TextEditorHighlightingPass> allCreatedPasses = new ArrayList<TextEditorHighlightingPass>(createdDocumentBoundPasses);
            allCreatedPasses.addAll(createdEditorBoundPasses);
            for (EditorBoundHighlightingPass pass : createdEditorBoundPasses) {
                this.createScheduledPass(fileEditor, pass, (Map<Pair<FileEditor, Integer>, ScheduledPass>)toBeSubmitted, allCreatedPasses, freePasses, dependentPasses, updateProgress, threadsToStartCountdown);
            }
        }
        for (Pair pair : passesWithNoDocuments) {
            fileEditor = (FileEditor)pair.first;
            TextEditorHighlightingPass pass = (TextEditorHighlightingPass)pair.second;
            this.createScheduledPass(fileEditor, pass, (Map<Pair<FileEditor, Integer>, ScheduledPass>)toBeSubmitted, ContainerUtil.emptyList(), freePasses, dependentPasses, updateProgress, threadsToStartCountdown);
        }
        if (CHECK_CONSISTENCY && !ApplicationInfoImpl.isInStressTest()) {
            this.assertConsistency(freePasses, (Map<Pair<FileEditor, Integer>, ScheduledPass>)toBeSubmitted, threadsToStartCountdown);
        }
        PassExecutorService.log(updateProgress, null, vFiles + " ----- starting " + threadsToStartCountdown.get(), freePasses);
        for (ScheduledPass dependentPass : dependentPasses) {
            this.mySubmittedPasses.put(dependentPass, Job.NULL_JOB);
        }
        for (ScheduledPass freePass : freePasses) {
            this.submit(freePass);
        }
    }

    private void assertConsistency(List<? extends ScheduledPass> freePasses, Map<Pair<FileEditor, Integer>, ScheduledPass> toBeSubmitted, AtomicInteger threadsToStartCountdown) {
        assert (threadsToStartCountdown.get() == toBeSubmitted.size());
        TIntObjectHashMap id2Visits = new TIntObjectHashMap();
        for (ScheduledPass scheduledPass : freePasses) {
            id2Visits.put(scheduledPass.myPass.getId(), (Object)Pair.create((Object)scheduledPass, (Object)0));
            this.checkConsistency(scheduledPass, (TIntObjectHashMap<Pair<ScheduledPass, Integer>>)id2Visits);
        }
        id2Visits.forEachEntry((id, pair) -> {
            int count = (Integer)pair.second;
            assert (count == 0) : id;
            return true;
        });
        assert (id2Visits.size() == threadsToStartCountdown.get());
    }

    private void checkConsistency(ScheduledPass pass, TIntObjectHashMap<Pair<ScheduledPass, Integer>> id2Visits) {
        for (ScheduledPass succ : ContainerUtil.concat((List)pass.mySuccessorsOnCompletion, (List)pass.mySuccessorsOnSubmit)) {
            int succId = succ.myPass.getId();
            Pair succPair = (Pair)id2Visits.get(succId);
            if (succPair == null) {
                succPair = Pair.create((Object)succ, (Object)succ.myRunningPredecessorsCount.get());
                id2Visits.put(succId, (Object)succPair);
            }
            int newPred = (Integer)succPair.second - 1;
            id2Visits.put(succId, (Object)Pair.create((Object)succ, (Object)newPred));
            assert (newPred >= 0);
            if (newPred != 0) continue;
            this.checkConsistency(succ, id2Visits);
        }
    }

    @NotNull
    private TextEditorHighlightingPass convertToTextHighlightingPass(final @NotNull HighlightingPass pass, final Document document, @NotNull AtomicInteger id, int previousPassId) {
        TextEditorHighlightingPass textEditorHighlightingPass;
        if (pass == null) {
            PassExecutorService.$$$reportNull$$$0(3);
        }
        if (id == null) {
            PassExecutorService.$$$reportNull$$$0(4);
        }
        if (pass instanceof TextEditorHighlightingPass) {
            textEditorHighlightingPass = (TextEditorHighlightingPass)pass;
        } else {
            textEditorHighlightingPass = new TextEditorHighlightingPass(this.myProject, document, true){

                @Override
                public void doCollectInformation(@NotNull ProgressIndicator progress) {
                    if (progress == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    pass.collectInformation(progress);
                }

                @Override
                public void doApplyInformationToEditor() {
                    pass.applyInformationToEditor();
                    if (document != null) {
                        FileEditor[] editors;
                        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
                        for (FileEditor editor : editors = file2 == null ? new FileEditor[]{} : FileEditorManager.getInstance((Project)this.myProject).getEditors(file2)) {
                            PassExecutorService.this.repaintErrorStripeAndIcon(editor);
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/PassExecutorService$1", "doCollectInformation"));
                }
            };
            textEditorHighlightingPass.setId(id.incrementAndGet());
            if (previousPassId != 0) {
                textEditorHighlightingPass.setCompletionPredecessorIds(new int[]{previousPassId});
            }
        }
        TextEditorHighlightingPass textEditorHighlightingPass2 = textEditorHighlightingPass;
        if (textEditorHighlightingPass2 == null) {
            PassExecutorService.$$$reportNull$$$0(5);
        }
        return textEditorHighlightingPass2;
    }

    @NotNull
    private FileEditor getPreferredFileEditor(Document document, @NotNull Collection<? extends FileEditor> fileEditors) {
        FileEditor selected2;
        VirtualFile file2;
        if (fileEditors == null) {
            PassExecutorService.$$$reportNull$$$0(6);
        }
        assert (!fileEditors.isEmpty());
        if (document != null && (file2 = FileDocumentManager.getInstance().getFile(document)) != null && (selected2 = FileEditorManager.getInstance((Project)this.myProject).getSelectedEditor(file2)) != null && fileEditors.contains(selected2)) {
            FileEditor fileEditor = selected2;
            if (fileEditor == null) {
                PassExecutorService.$$$reportNull$$$0(7);
            }
            return fileEditor;
        }
        FileEditor fileEditor = fileEditors.iterator().next();
        if (fileEditor == null) {
            PassExecutorService.$$$reportNull$$$0(8);
        }
        return fileEditor;
    }

    @NotNull
    private ScheduledPass createScheduledPass(@NotNull FileEditor fileEditor, @NotNull TextEditorHighlightingPass pass, @NotNull Map<Pair<FileEditor, Integer>, ScheduledPass> toBeSubmitted, @NotNull List<TextEditorHighlightingPass> textEditorHighlightingPasses, @NotNull List<ScheduledPass> freePasses, @NotNull List<ScheduledPass> dependentPasses, @NotNull DaemonProgressIndicator updateProgress, @NotNull AtomicInteger threadsToStartCountdown) {
        ScheduledPass predecessor;
        int passId;
        Pair key;
        ScheduledPass scheduledPass;
        if (fileEditor == null) {
            PassExecutorService.$$$reportNull$$$0(9);
        }
        if (pass == null) {
            PassExecutorService.$$$reportNull$$$0(10);
        }
        if (toBeSubmitted == null) {
            PassExecutorService.$$$reportNull$$$0(11);
        }
        if (textEditorHighlightingPasses == null) {
            PassExecutorService.$$$reportNull$$$0(12);
        }
        if (freePasses == null) {
            PassExecutorService.$$$reportNull$$$0(13);
        }
        if (dependentPasses == null) {
            PassExecutorService.$$$reportNull$$$0(14);
        }
        if (updateProgress == null) {
            PassExecutorService.$$$reportNull$$$0(15);
        }
        if (threadsToStartCountdown == null) {
            PassExecutorService.$$$reportNull$$$0(16);
        }
        if ((scheduledPass = toBeSubmitted.get(key = Pair.create((Object)fileEditor, (Object)(passId = pass.getId())))) != null) {
            ScheduledPass scheduledPass2 = scheduledPass;
            if (scheduledPass2 == null) {
                PassExecutorService.$$$reportNull$$$0(17);
            }
            return scheduledPass2;
        }
        scheduledPass = new ScheduledPass(fileEditor, pass, updateProgress, threadsToStartCountdown);
        threadsToStartCountdown.incrementAndGet();
        toBeSubmitted.put((Pair<FileEditor, Integer>)key, scheduledPass);
        for (int predecessorId : pass.getCompletionPredecessorIds()) {
            predecessor = this.findOrCreatePredecessorPass(fileEditor, toBeSubmitted, textEditorHighlightingPasses, freePasses, dependentPasses, updateProgress, threadsToStartCountdown, predecessorId);
            if (predecessor == null) continue;
            predecessor.addSuccessorOnCompletion(scheduledPass);
        }
        for (int predecessorId : pass.getStartingPredecessorIds()) {
            predecessor = this.findOrCreatePredecessorPass(fileEditor, toBeSubmitted, textEditorHighlightingPasses, freePasses, dependentPasses, updateProgress, threadsToStartCountdown, predecessorId);
            if (predecessor == null) continue;
            predecessor.addSuccessorOnSubmit(scheduledPass);
        }
        if (scheduledPass.myRunningPredecessorsCount.get() == 0 && !freePasses.contains(scheduledPass)) {
            freePasses.add(scheduledPass);
        } else if (!dependentPasses.contains(scheduledPass)) {
            dependentPasses.add(scheduledPass);
        }
        if (pass.isRunIntentionPassAfter() && fileEditor instanceof TextEditor) {
            Editor editor = ((TextEditor)fileEditor).getEditor();
            ShowIntentionsPass ip = new ShowIntentionsPass(this.myProject, editor, -1);
            ip.setId(this.nextPassId.incrementAndGet());
            ip.setCompletionPredecessorIds(new int[]{scheduledPass.myPass.getId()});
            this.createScheduledPass(fileEditor, ip, toBeSubmitted, textEditorHighlightingPasses, freePasses, dependentPasses, updateProgress, threadsToStartCountdown);
        }
        ScheduledPass scheduledPass3 = scheduledPass;
        if (scheduledPass3 == null) {
            PassExecutorService.$$$reportNull$$$0(18);
        }
        return scheduledPass3;
    }

    private ScheduledPass findOrCreatePredecessorPass(@NotNull FileEditor fileEditor, @NotNull Map<Pair<FileEditor, Integer>, ScheduledPass> toBeSubmitted, @NotNull List<TextEditorHighlightingPass> textEditorHighlightingPasses, @NotNull List<ScheduledPass> freePasses, @NotNull List<ScheduledPass> dependentPasses, @NotNull DaemonProgressIndicator updateProgress, @NotNull AtomicInteger myThreadsToStartCountdown, int predecessorId) {
        Pair predKey;
        ScheduledPass predecessor;
        if (fileEditor == null) {
            PassExecutorService.$$$reportNull$$$0(19);
        }
        if (toBeSubmitted == null) {
            PassExecutorService.$$$reportNull$$$0(20);
        }
        if (textEditorHighlightingPasses == null) {
            PassExecutorService.$$$reportNull$$$0(21);
        }
        if (freePasses == null) {
            PassExecutorService.$$$reportNull$$$0(22);
        }
        if (dependentPasses == null) {
            PassExecutorService.$$$reportNull$$$0(23);
        }
        if (updateProgress == null) {
            PassExecutorService.$$$reportNull$$$0(24);
        }
        if (myThreadsToStartCountdown == null) {
            PassExecutorService.$$$reportNull$$$0(25);
        }
        if ((predecessor = toBeSubmitted.get(predKey = Pair.create((Object)fileEditor, (Object)predecessorId))) == null) {
            TextEditorHighlightingPass textEditorPass = PassExecutorService.findPassById(predecessorId, textEditorHighlightingPasses);
            predecessor = textEditorPass == null ? null : this.createScheduledPass(fileEditor, textEditorPass, toBeSubmitted, textEditorHighlightingPasses, freePasses, dependentPasses, updateProgress, myThreadsToStartCountdown);
        }
        return predecessor;
    }

    private static TextEditorHighlightingPass findPassById(int id, @NotNull List<? extends TextEditorHighlightingPass> textEditorHighlightingPasses) {
        if (textEditorHighlightingPasses == null) {
            PassExecutorService.$$$reportNull$$$0(26);
        }
        return (TextEditorHighlightingPass)ContainerUtil.find(textEditorHighlightingPasses, pass -> pass.getId() == id);
    }

    private void submit(@NotNull ScheduledPass pass) {
        if (pass == null) {
            PassExecutorService.$$$reportNull$$$0(27);
        }
        if (!pass.myUpdateProgress.isCanceled()) {
            Job<Void> job2 = JobLauncher.getInstance().submitToJobThread(pass, future2 -> {
                try {
                    if (!future2.isCancelled()) {
                        future2.get();
                    }
                }
                catch (InterruptedException | CancellationException exception) {
                }
                catch (ExecutionException e) {
                    LOG.error(e.getCause());
                }
            });
            this.mySubmittedPasses.put(pass, job2);
        }
    }

    private void applyInformationToEditorsLater(@NotNull FileEditor fileEditor, @NotNull TextEditorHighlightingPass pass, @NotNull DaemonProgressIndicator updateProgress, @NotNull AtomicInteger threadsToStartCountdown, @NotNull Runnable callbackOnApplied) {
        if (fileEditor == null) {
            PassExecutorService.$$$reportNull$$$0(28);
        }
        if (pass == null) {
            PassExecutorService.$$$reportNull$$$0(29);
        }
        if (updateProgress == null) {
            PassExecutorService.$$$reportNull$$$0(30);
        }
        if (threadsToStartCountdown == null) {
            PassExecutorService.$$$reportNull$$$0(31);
        }
        if (callbackOnApplied == null) {
            PassExecutorService.$$$reportNull$$$0(32);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.isDisposed() || this.myProject.isDisposed() || !fileEditor.isValid()) {
                updateProgress.cancel();
            }
            if (updateProgress.isCanceled()) {
                PassExecutorService.log(updateProgress, pass, " is canceled during apply, sorry");
                return;
            }
            Document document = pass.getDocument();
            try {
                if (fileEditor.getComponent().isDisplayable() || ApplicationManager.getApplication().isHeadlessEnvironment()) {
                    pass.applyInformationToEditor();
                    this.repaintErrorStripeAndIcon(fileEditor);
                    FileStatusMap fileStatusMap = DaemonCodeAnalyzerEx.getInstanceEx(this.myProject).getFileStatusMap();
                    if (document != null) {
                        fileStatusMap.markFileUpToDate(document, pass.getId());
                    }
                    PassExecutorService.log(updateProgress, pass, " Applied");
                }
            }
            catch (ProcessCanceledException e) {
                PassExecutorService.log(updateProgress, pass, "Error " + (Object)((Object)e));
                throw e;
            }
            catch (RuntimeException e) {
                VirtualFile file2 = document == null ? null : FileDocumentManager.getInstance().getFile(document);
                FileType fileType = file2 == null ? null : file2.getFileType();
                String message = "Exception while applying information to " + fileEditor + "(" + fileType + ")";
                PassExecutorService.log(updateProgress, pass, message + e);
                throw new RuntimeException(message, e);
            }
            if (threadsToStartCountdown.decrementAndGet() == 0) {
                HighlightingSessionImpl.waitForAllSessionsHighlightInfosApplied(updateProgress);
                PassExecutorService.log(updateProgress, pass, "Stopping ");
                updateProgress.stopIfRunning();
            } else {
                PassExecutorService.log(updateProgress, pass, "Finished but there are passes in the queue: " + threadsToStartCountdown.get());
            }
            callbackOnApplied.run();
        }, updateProgress.getModalityState());
    }

    private void repaintErrorStripeAndIcon(@NotNull FileEditor fileEditor) {
        if (fileEditor == null) {
            PassExecutorService.$$$reportNull$$$0(33);
        }
        if (fileEditor instanceof TextEditor) {
            DefaultHighlightInfoProcessor.repaintErrorStripeAndIcon(((TextEditor)fileEditor).getEditor(), this.myProject);
        }
    }

    protected boolean isDisposed() {
        return this.isDisposed;
    }

    @NotNull
    List<TextEditorHighlightingPass> getAllSubmittedPasses() {
        ArrayList<TextEditorHighlightingPass> result2 = new ArrayList<TextEditorHighlightingPass>(this.mySubmittedPasses.size());
        for (ScheduledPass scheduledPass : this.mySubmittedPasses.keySet()) {
            if (scheduledPass.myUpdateProgress.isCanceled()) continue;
            result2.add(scheduledPass.myPass);
        }
        PassExecutorService.sortById(result2);
        ArrayList<TextEditorHighlightingPass> arrayList = result2;
        if (arrayList == null) {
            PassExecutorService.$$$reportNull$$$0(34);
        }
        return arrayList;
    }

    private static void sortById(@NotNull List<? extends TextEditorHighlightingPass> result2) {
        if (result2 == null) {
            PassExecutorService.$$$reportNull$$$0(35);
        }
        ContainerUtil.quickSort(result2, Comparator.comparingInt(TextEditorHighlightingPass::getId));
    }

    private static int getThreadNum() {
        Matcher matcher = Pattern.compile("JobScheduler FJ pool (\\d*)/(\\d*)").matcher(Thread.currentThread().getName());
        String num = matcher.matches() ? matcher.group(1) : null;
        return StringUtil.parseInt((String)num, (int)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void log(ProgressIndicator progressIndicator, TextEditorHighlightingPass pass, Object ... info) {
        if (info == null) {
            PassExecutorService.$$$reportNull$$$0(36);
        }
        if (!LOG.isDebugEnabled()) return;
        String docText = pass == null || pass.getDocument() == null ? "" : ": '" + StringUtil.first((CharSequence)pass.getDocument().getCharsSequence(), (int)10, (boolean)true) + "'";
        Class<PassExecutorService> clazz = PassExecutorService.class;
        synchronized (PassExecutorService.class) {
            String infos = StringUtil.join((Object[])info, (Function)Functions.TO_STRING(), (String)" ");
            String message = StringUtil.repeatSymbol((char)' ', (int)(PassExecutorService.getThreadNum() * 4)) + " " + pass + " " + infos + "; progress=" + (progressIndicator == null ? null : Integer.valueOf(progressIndicator.hashCode())) + " " + (progressIndicator == null ? "?" : (progressIndicator.isCanceled() ? "X" : "V")) + docText;
            LOG.debug(message);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    private static void saveException(@NotNull Throwable e, @NotNull DaemonProgressIndicator indicator) {
        if (e == null) {
            PassExecutorService.$$$reportNull$$$0(37);
        }
        if (indicator == null) {
            PassExecutorService.$$$reportNull$$$0(38);
        }
        indicator.putUserDataIfAbsent(THROWABLE_KEY, e);
    }

    static Throwable getSavedException(@NotNull DaemonProgressIndicator indicator) {
        if (indicator == null) {
            PassExecutorService.$$$reportNull$$$0(39);
        }
        return (Throwable)indicator.getUserData(THROWABLE_KEY);
    }

    boolean waitFor(int millis) throws Throwable {
        try {
            for (Job<Void> job2 : this.mySubmittedPasses.values()) {
                job2.waitForCompletion(millis);
            }
            return true;
        }
        catch (TimeoutException ignored) {
            return false;
        }
        catch (InterruptedException e) {
            return true;
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 17: 
            case 18: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 17: 
            case 18: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "passesMap";
                break;
            }
            case 2: 
            case 15: 
            case 24: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateProgress";
                break;
            }
            case 3: 
            case 10: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 17: 
            case 18: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/PassExecutorService";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditors";
                break;
            }
            case 9: 
            case 19: 
            case 28: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 11: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toBeSubmitted";
                break;
            }
            case 12: 
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textEditorHighlightingPasses";
                break;
            }
            case 13: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "freePasses";
                break;
            }
            case 14: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependentPasses";
                break;
            }
            case 16: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadsToStartCountdown";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myThreadsToStartCountdown";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callbackOnApplied";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/PassExecutorService";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToTextHighlightingPass";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFileEditor";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createScheduledPass";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSubmittedPasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "submitPasses";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "convertToTextHighlightingPass";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 17: 
            case 18: 
            case 34: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPreferredFileEditor";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createScheduledPass";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreatePredecessorPass";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findPassById";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "submit";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "applyInformationToEditorsLater";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "repaintErrorStripeAndIcon";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "sortById";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "log";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "saveException";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getSavedException";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 17: 
            case 18: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ScheduledPass
    implements Runnable {
        private final FileEditor myFileEditor;
        private final TextEditorHighlightingPass myPass;
        private final AtomicInteger myThreadsToStartCountdown;
        private final AtomicInteger myRunningPredecessorsCount;
        private final List<ScheduledPass> mySuccessorsOnCompletion;
        private final List<ScheduledPass> mySuccessorsOnSubmit;
        @NotNull
        private final DaemonProgressIndicator myUpdateProgress;

        private ScheduledPass(@NotNull FileEditor fileEditor, @NotNull TextEditorHighlightingPass pass, @NotNull DaemonProgressIndicator progressIndicator, AtomicInteger threadsToStartCountdown) {
            if (fileEditor == null) {
                ScheduledPass.$$$reportNull$$$0(0);
            }
            if (pass == null) {
                ScheduledPass.$$$reportNull$$$0(1);
            }
            if (progressIndicator == null) {
                ScheduledPass.$$$reportNull$$$0(2);
            }
            if (threadsToStartCountdown == null) {
                ScheduledPass.$$$reportNull$$$0(3);
            }
            this.myRunningPredecessorsCount = new AtomicInteger(0);
            this.mySuccessorsOnCompletion = new ArrayList<ScheduledPass>();
            this.mySuccessorsOnSubmit = new ArrayList<ScheduledPass>();
            this.myFileEditor = fileEditor;
            this.myPass = pass;
            this.myThreadsToStartCountdown = threadsToStartCountdown;
            this.myUpdateProgress = progressIndicator;
        }

        @Override
        public void run() {
            ((ApplicationImpl)ApplicationManager.getApplication()).executeByImpatientReader(() -> {
                try {
                    this.doRun();
                }
                catch (ApplicationUtil.CannotRunReadActionException e) {
                    this.myUpdateProgress.cancel();
                }
                catch (Error | RuntimeException e) {
                    PassExecutorService.saveException(e, this.myUpdateProgress);
                    throw e;
                }
            });
        }

        private void doRun() {
            if (this.myUpdateProgress.isCanceled()) {
                return;
            }
            PassExecutorService.log(this.myUpdateProgress, this.myPass, "Started. ");
            for (ScheduledPass successor : this.mySuccessorsOnSubmit) {
                int predecessorsToRun = successor.myRunningPredecessorsCount.decrementAndGet();
                if (predecessorsToRun != 0) continue;
                PassExecutorService.this.submit(successor);
            }
            ProgressManager.getInstance().executeProcessUnderProgress(() -> {
                boolean success = ApplicationManagerEx.getApplicationEx().tryRunReadAction(() -> {
                    try {
                        if (DumbService.getInstance((Project)PassExecutorService.this.myProject).isDumb() && !DumbService.isDumbAware((Object)this.myPass)) {
                            return;
                        }
                        if (!this.myUpdateProgress.isCanceled() && !PassExecutorService.this.myProject.isDisposed()) {
                            this.myPass.collectInformation(this.myUpdateProgress);
                        }
                    }
                    catch (ProcessCanceledException e) {
                        PassExecutorService.log(this.myUpdateProgress, this.myPass, "Canceled ");
                        if (!this.myUpdateProgress.isCanceled()) {
                            this.myUpdateProgress.cancel(e);
                        }
                    }
                    catch (Error | RuntimeException e) {
                        this.myUpdateProgress.cancel(e);
                        LOG.error(e);
                        throw e;
                    }
                });
                if (!success) {
                    this.myUpdateProgress.cancel();
                }
            }, (ProgressIndicator)this.myUpdateProgress);
            PassExecutorService.log(this.myUpdateProgress, this.myPass, "Finished. ");
            if (!this.myUpdateProgress.isCanceled()) {
                PassExecutorService.this.applyInformationToEditorsLater(this.myFileEditor, this.myPass, this.myUpdateProgress, this.myThreadsToStartCountdown, () -> {
                    for (ScheduledPass successor : this.mySuccessorsOnCompletion) {
                        int predecessorsToRun = successor.myRunningPredecessorsCount.decrementAndGet();
                        if (predecessorsToRun != 0) continue;
                        PassExecutorService.this.submit(successor);
                    }
                });
            }
        }

        @NonNls
        public String toString() {
            return "SP: " + this.myPass;
        }

        private void addSuccessorOnCompletion(@NotNull ScheduledPass successor) {
            if (successor == null) {
                ScheduledPass.$$$reportNull$$$0(4);
            }
            this.mySuccessorsOnCompletion.add(successor);
            successor.myRunningPredecessorsCount.incrementAndGet();
        }

        private void addSuccessorOnSubmit(@NotNull ScheduledPass successor) {
            if (successor == null) {
                ScheduledPass.$$$reportNull$$$0(5);
            }
            this.mySuccessorsOnSubmit.add(successor);
            successor.myRunningPredecessorsCount.incrementAndGet();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileEditor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pass";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progressIndicator";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "threadsToStartCountdown";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "successor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/daemon/impl/PassExecutorService$ScheduledPass";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addSuccessorOnCompletion";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addSuccessorOnSubmit";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

