/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.events.Failure;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.notification.Notification;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class BuildConsoleUtils {
    private static final Pattern TAG_PATTERN = Pattern.compile("<[^>]*>");
    private static final Pattern A_PATTERN = Pattern.compile("<a ([^>]* )?href=[\"']([^>]*)[\"'][^>]*>");
    private static final String A_CLOSING = "</a>";
    private static final Set<String> NEW_LINES = ContainerUtil.set((Object[])new String[]{"<br>", "</br>", "<br/>", "<p>", "</p>", "<p/>", "<pre>", "</pre>"});

    public static boolean printDetails(ConsoleView consoleView, Failure failure) {
        return BuildConsoleUtils.printDetails(consoleView, failure, null);
    }

    public static boolean printDetails(final ConsoleView consoleView, final @Nullable Failure failure, @Nullable String details) {
        String text2;
        String string = text2 = failure == null ? details : (String)ObjectUtils.chooseNotNull((Object)failure.getDescription(), (Object)failure.getMessage());
        if (text2 == null && failure != null && failure.getError() != null) {
            text2 = failure.getError().getMessage();
        }
        if (text2 == null) {
            return false;
        }
        String content2 = StringUtil.convertLineSeparators((String)text2);
        while (true) {
            Matcher tagMatcher;
            if (!(tagMatcher = TAG_PATTERN.matcher(content2)).find()) break;
            String tagStart = tagMatcher.group();
            consoleView.print(content2.substring(0, tagMatcher.start()), ConsoleViewContentType.ERROR_OUTPUT);
            Matcher aMatcher = A_PATTERN.matcher(tagStart);
            if (aMatcher.matches()) {
                final String href = aMatcher.group(2);
                int linkEnd = content2.indexOf(A_CLOSING, tagMatcher.end());
                if (linkEnd > 0) {
                    String linkText = content2.substring(tagMatcher.end(), linkEnd).replaceAll(TAG_PATTERN.pattern(), "");
                    consoleView.printHyperlink(linkText, new HyperlinkInfo(){

                        public void navigate(Project project) {
                            if (failure == null) {
                                return;
                            }
                            Notification notification = failure.getNotification();
                            if (notification != null && notification.getListener() != null) {
                                notification.getListener().hyperlinkUpdate(notification, IJSwingUtilities.createHyperlinkEvent(href, consoleView.getComponent()));
                            }
                        }
                    });
                    content2 = content2.substring(linkEnd + A_CLOSING.length());
                    continue;
                }
            }
            if (NEW_LINES.contains(tagStart)) {
                consoleView.print("\n", ConsoleViewContentType.SYSTEM_OUTPUT);
            } else {
                consoleView.print(content2.substring(tagMatcher.start(), tagMatcher.end()), ConsoleViewContentType.ERROR_OUTPUT);
            }
            content2 = content2.substring(tagMatcher.end());
        }
        consoleView.print(content2, ConsoleViewContentType.ERROR_OUTPUT);
        consoleView.print("\n", ConsoleViewContentType.SYSTEM_OUTPUT);
        return true;
    }
}

