/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.InspectionToolsRegistrarCore;
import com.intellij.codeInspection.ex.JobDescriptor;
import com.intellij.diagnostic.PluginException;
import com.intellij.lang.Language;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.ResourceUtil;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InspectionToolWrapper<T extends InspectionProfileEntry, E extends InspectionEP> {
    public static final InspectionToolWrapper[] EMPTY_ARRAY = new InspectionToolWrapper[0];
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.ex.InspectionToolWrapper");
    protected T myTool;
    protected final E myEP;

    protected InspectionToolWrapper(@NotNull E ep) {
        if (ep == null) {
            InspectionToolWrapper.$$$reportNull$$$0(0);
        }
        this(null, ep);
    }

    protected InspectionToolWrapper(@NotNull T tool) {
        if (tool == null) {
            InspectionToolWrapper.$$$reportNull$$$0(1);
        }
        this(tool, null);
    }

    protected InspectionToolWrapper(@Nullable T tool, @Nullable E ep) {
        assert (tool != null || ep != null) : "must not be both null";
        this.myEP = ep;
        this.myTool = tool;
    }

    protected InspectionToolWrapper(@NotNull InspectionToolWrapper<T, ? extends E> other) {
        if (other == null) {
            InspectionToolWrapper.$$$reportNull$$$0(2);
        }
        this.myEP = other.myEP;
        this.myTool = other.myTool == null ? null : (this.myEP == null ? (InspectionProfileEntry)InspectionToolsRegistrarCore.instantiateTool(other.myTool.getClass()) : ((InspectionEP)this.myEP).instantiateTool());
    }

    public void initialize(@NotNull GlobalInspectionContext context) {
        if (context == null) {
            InspectionToolWrapper.$$$reportNull$$$0(3);
        }
    }

    @NotNull
    public abstract InspectionToolWrapper<T, E> createCopy();

    @NotNull
    public T getTool() {
        Object tool = this.myTool;
        if (tool == null) {
            tool = ((InspectionEP)this.myEP).instantiateTool();
            this.myTool = tool;
            if (!((InspectionProfileEntry)tool).getShortName().equals(((InspectionEP)this.myEP).getShortName())) {
                LOG.error((Throwable)new PluginException("Short name not matched for " + tool.getClass() + ": getShortName() = #" + ((InspectionProfileEntry)tool).getShortName() + "; ep.shortName = #" + ((InspectionEP)this.myEP).getShortName(), this.myEP.getPluginId()));
            }
        }
        T t = tool;
        if (t == null) {
            InspectionToolWrapper.$$$reportNull$$$0(4);
        }
        return t;
    }

    public boolean isInitialized() {
        return this.myTool != null;
    }

    @Nullable
    public String getLanguage() {
        return this.myEP == null ? null : ((InspectionEP)this.myEP).language;
    }

    public boolean applyToDialects() {
        return this.myEP != null && ((InspectionEP)this.myEP).applyToDialects;
    }

    public boolean isApplicable(@NotNull Language language) {
        String langId;
        if (language == null) {
            InspectionToolWrapper.$$$reportNull$$$0(5);
        }
        return (langId = this.getLanguage()) == null || language.getID().equals(langId) || this.applyToDialects() && language.isKindOf(langId);
    }

    public boolean isCleanupTool() {
        return this.myEP != null ? ((InspectionEP)this.myEP).cleanupTool : this.getTool() instanceof CleanupLocalInspectionTool;
    }

    @NotNull
    public String getShortName() {
        String string = this.myEP != null ? ((InspectionEP)this.myEP).getShortName() : ((InspectionProfileEntry)this.getTool()).getShortName();
        if (string == null) {
            InspectionToolWrapper.$$$reportNull$$$0(6);
        }
        return string;
    }

    public String getID() {
        return this.getShortName();
    }

    @NotNull
    public String getDisplayName() {
        if (this.myEP == null) {
            String string = ((InspectionProfileEntry)this.getTool()).getDisplayName();
            if (string == null) {
                InspectionToolWrapper.$$$reportNull$$$0(7);
            }
            return string;
        }
        String name = ((InspectionEP)this.myEP).getDisplayName();
        String string = name == null ? ((InspectionProfileEntry)this.getTool()).getDisplayName() : name;
        if (string == null) {
            InspectionToolWrapper.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        if (this.myEP == null) {
            String string = ((InspectionProfileEntry)this.getTool()).getGroupDisplayName();
            if (string == null) {
                InspectionToolWrapper.$$$reportNull$$$0(9);
            }
            return string;
        }
        String groupDisplayName = ((InspectionEP)this.myEP).getGroupDisplayName();
        String string = groupDisplayName == null ? ((InspectionProfileEntry)this.getTool()).getGroupDisplayName() : groupDisplayName;
        if (string == null) {
            InspectionToolWrapper.$$$reportNull$$$0(10);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return this.myEP == null ? ((InspectionProfileEntry)this.getTool()).isEnabledByDefault() : ((InspectionEP)this.myEP).enabledByDefault;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = this.myEP == null ? ((InspectionProfileEntry)this.getTool()).getDefaultLevel() : ((InspectionEP)this.myEP).getDefaultLevel();
        if (highlightDisplayLevel == null) {
            InspectionToolWrapper.$$$reportNull$$$0(11);
        }
        return highlightDisplayLevel;
    }

    @NotNull
    public String[] getGroupPath() {
        if (this.myEP == null) {
            String[] stringArray = ((InspectionProfileEntry)this.getTool()).getGroupPath();
            if (stringArray == null) {
                InspectionToolWrapper.$$$reportNull$$$0(12);
            }
            return stringArray;
        }
        String[] path2 = ((InspectionEP)this.myEP).getGroupPath();
        String[] stringArray = path2 == null ? ((InspectionProfileEntry)this.getTool()).getGroupPath() : path2;
        if (stringArray == null) {
            InspectionToolWrapper.$$$reportNull$$$0(13);
        }
        return stringArray;
    }

    public String getStaticDescription() {
        return this.myEP == null || ((InspectionEP)this.myEP).hasStaticDescription ? ((InspectionProfileEntry)this.getTool()).getStaticDescription() : null;
    }

    public String loadDescription() {
        String description = this.getStaticDescription();
        if (description != null) {
            return description;
        }
        try {
            InputStream descriptionStream = this.getDescriptionStream();
            return descriptionStream != null ? ResourceUtil.loadText((InputStream)descriptionStream) : null;
        }
        catch (IOException iOException) {
            return ((InspectionProfileEntry)this.getTool()).loadDescription();
        }
    }

    private InputStream getDescriptionStream() {
        Application app = ApplicationManager.getApplication();
        String fileName = this.getDescriptionFileName();
        if (this.myEP == null || app.isUnitTestMode() || app.isHeadlessEnvironment()) {
            return ResourceUtil.getResourceAsStream((ClassLoader)this.getDescriptionContextClass().getClassLoader(), (String)"inspectionDescriptions", (String)fileName);
        }
        return this.myEP.getLoaderForClass().getResourceAsStream("inspectionDescriptions/" + fileName);
    }

    @NotNull
    private String getDescriptionFileName() {
        String string = this.getShortName() + ".html";
        if (string == null) {
            InspectionToolWrapper.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    public final String getFolderName() {
        String string = this.getShortName();
        if (string == null) {
            InspectionToolWrapper.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    public Class<? extends InspectionProfileEntry> getDescriptionContextClass() {
        Class<?> clazz = this.getTool().getClass();
        if (clazz == null) {
            InspectionToolWrapper.$$$reportNull$$$0(16);
        }
        return clazz;
    }

    public String getMainToolId() {
        return ((InspectionProfileEntry)this.getTool()).getMainToolId();
    }

    public E getExtension() {
        return this.myEP;
    }

    public String toString() {
        return this.getShortName();
    }

    public void cleanup(@NotNull Project project) {
        T tool;
        if (project == null) {
            InspectionToolWrapper.$$$reportNull$$$0(17);
        }
        if ((tool = this.myTool) != null) {
            ((InspectionProfileEntry)tool).cleanup(project);
        }
    }

    @NotNull
    public abstract JobDescriptor[] getJobDescriptors(@NotNull GlobalInspectionContext var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ep";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ex/InspectionToolWrapper";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ex/InspectionToolWrapper";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTool";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupPath";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptionFileName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFolderName";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptionContextClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "initialize";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "cleanup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

