/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.inline;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.inline.InlineOptionsDialog;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.pyi.PyiUtil;
import com.jetbrains.python.refactoring.inline.PyInlineFunctionHandler;
import com.jetbrains.python.refactoring.inline.PyInlineFunctionProcessor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0011\u001a\u00020\fH\u0014J\b\u0010\u0012\u001a\u00020\u0013H\u0014J\b\u0010\u0014\u001a\u00020\u000eH\u0014J\b\u0010\u0015\u001a\u00020\u000eH\u0014J\b\u0010\u0016\u001a\u00020\u000eH\u0014J\b\u0010\u0017\u001a\u00020\u000eH\u0014J\b\u0010\u0018\u001a\u00020\u000eH\u0014J\b\u0010\u0019\u001a\u00020\u000eH\u0014J\u0012\u0010\u001a\u001a\u00020\u00102\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0014J\u0010\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\tH\u0014J\b\u0010\u001f\u001a\u00020\fH\u0014R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/jetbrains/python/refactoring/inline/PyInlineFunctionDialog;", "Lcom/intellij/refactoring/inline/InlineOptionsDialog;", "project", "Lcom/intellij/openapi/project/Project;", "myEditor", "Lcom/intellij/openapi/editor/Editor;", "myFunction", "Lcom/jetbrains/python/psi/PyFunction;", "myReference", "Lcom/intellij/psi/PsiReference;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lcom/jetbrains/python/psi/PyFunction;Lcom/intellij/psi/PsiReference;)V", "isMethod", "", "myFunctionName", "", "myNumberOfOccurrences", "", "allowInlineAll", "doAction", "", "getBorderTitle", "getHelpId", "getInlineAllText", "getInlineThisText", "getKeepTheDeclarationText", "getNameLabelText", "getNumberOfOccurrences", "nameIdentifierOwner", "Lcom/intellij/psi/PsiNameIdentifierOwner;", "ignoreOccurrence", "reference", "isInlineThis", "intellij.python.community.impl"})
public final class PyInlineFunctionDialog
extends InlineOptionsDialog {
    private final boolean isMethod;
    private final String myFunctionName;
    private final int myNumberOfOccurrences;
    private final Editor myEditor;
    private final PyFunction myFunction;
    private final PsiReference myReference;

    protected void doAction() {
        PyFunction originalFunction = (PyFunction)PyiUtil.getOriginalElement(this.myFunction);
        Project project = this.myProject;
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"myProject");
        PyFunction pyFunction = originalFunction;
        if (pyFunction == null) {
            pyFunction = this.myFunction;
        }
        this.invokeRefactoring(new PyInlineFunctionProcessor(project, this.myEditor, pyFunction, this.myReference, this.isInlineThisOnly(), !this.isKeepTheDeclaration()));
    }

    @NotNull
    protected String getNameLabelText() {
        String text2;
        String string = text2 = this.isMethod ? "Method " + this.myFunctionName : "Function " + this.myFunctionName;
        if (this.myNumberOfOccurrences != -1) {
            return text2 + " has " + this.myNumberOfOccurrences + " occurrence" + (this.myNumberOfOccurrences == 1 ? "" : "s");
        }
        return text2;
    }

    @NotNull
    protected String getBorderTitle() {
        return "Inline";
    }

    @NotNull
    protected String getInlineAllText() {
        String string = PyBundle.message("refactoring.inline.all.remove.declaration", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"PyBundle.message(\"refact\u2026.all.remove.declaration\")");
        return string;
    }

    @NotNull
    protected String getKeepTheDeclarationText() {
        String string = PyBundle.message("refactoring.inline.all.keep.declaration", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"PyBundle.message(\"refact\u2026ne.all.keep.declaration\")");
        return string;
    }

    @NotNull
    protected String getInlineThisText() {
        String string = PyBundle.message("refactoring.inline.this.only", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"PyBundle.message(\"refactoring.inline.this.only\")");
        return string;
    }

    @NotNull
    protected String getHelpId() {
        return PyInlineFunctionHandler.Companion.getREFACTORING_ID();
    }

    protected boolean allowInlineAll() {
        return true;
    }

    protected boolean isInlineThis() {
        return true;
    }

    protected boolean ignoreOccurrence(@NotNull PsiReference reference) {
        Intrinsics.checkParameterIsNotNull((Object)reference, (String)"reference");
        return PsiTreeUtil.getParentOfType((PsiElement)reference.getElement(), PyImportStatementBase.class) == null;
    }

    protected int getNumberOfOccurrences(@Nullable PsiNameIdentifierOwner nameIdentifierOwner) {
        int fromOtherLocation;
        PsiElement stubOrImplementation;
        int originalNum = super.getNumberOfOccurrences(nameIdentifierOwner);
        PsiElement psiElement = stubOrImplementation = PyiUtil.isInsideStub(this.myFunction) ? PyiUtil.getOriginalElement(this.myFunction) : PyiUtil.getPythonStub(this.myFunction);
        if (originalNum != -1 && stubOrImplementation != null && (fromOtherLocation = super.getNumberOfOccurrences((PsiNameIdentifierOwner)stubOrImplementation)) != -1) {
            return originalNum + fromOtherLocation;
        }
        return originalNum;
    }

    public PyInlineFunctionDialog(@NotNull Project project, @NotNull Editor myEditor, @NotNull PyFunction myFunction, @Nullable PsiReference myReference) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)myEditor, (String)"myEditor");
        Intrinsics.checkParameterIsNotNull((Object)myFunction, (String)"myFunction");
        super(project, true, (PsiElement)myFunction);
        this.myEditor = myEditor;
        this.myFunction = myFunction;
        this.myReference = myReference;
        this.isMethod = this.myFunction.asMethod() != null;
        this.myFunctionName = this.myFunction.getName();
        this.myNumberOfOccurrences = this.getNumberOfOccurrences(this.myFunction);
        PsiReference psiReference = this.myReference;
        this.myInvokedOnReference = PsiTreeUtil.getParentOfType((PsiElement)(psiReference != null ? psiReference.getElement() : null), PyImportStatementBase.class) == null;
        this.setTitle(this.isMethod ? "Inline method " + this.myFunctionName : "Inline function " + this.myFunctionName);
        this.init();
    }
}

