/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Predicate;
import com.jetbrains.python.FunctionParameter;
import com.jetbrains.python.nameResolver.FQNamesProvider;
import com.jetbrains.python.nameResolver.NameResolverTools;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallSiteExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PyCallExpression
extends PyCallSiteExpression {
    @Override
    @Nullable
    default public PyExpression getReceiver(@Nullable PyCallable resolvedCallee) {
        PyFunction function;
        if (resolvedCallee instanceof PyFunction && !"__new__".equals((function = (PyFunction)resolvedCallee).getName()) && function.getModifier() == PyFunction.Modifier.STATICMETHOD) {
            return null;
        }
        PyExpression callee = this.getCallee();
        if (callee instanceof PyQualifiedExpression) {
            PyQualifiedExpression qualifiedCallee = (PyQualifiedExpression)callee;
            Predicate isConstructorName = name -> "__init__".equals(name) || "__new__".equals(name);
            if (resolvedCallee instanceof PyFunction && qualifiedCallee.isQualified() && isConstructorName.apply((Object)resolvedCallee.getName()) && !isConstructorName.apply((Object)qualifiedCallee.getName())) {
                return null;
            }
            return qualifiedCallee.getQualifier();
        }
        return null;
    }

    @Override
    @NotNull
    default public List<PyExpression> getArguments(@Nullable PyCallable resolvedCallee) {
        List<PyExpression> list = Arrays.asList(this.getArguments());
        if (list == null) {
            PyCallExpression.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Nullable
    public PyExpression getCallee();

    @Nullable
    default public PyArgumentList getArgumentList() {
        return (PyArgumentList)PsiTreeUtil.getChildOfType((PsiElement)this, PyArgumentList.class);
    }

    @NotNull
    default public PyExpression[] getArguments() {
        PyArgumentList argList = this.getArgumentList();
        PyExpression[] pyExpressionArray = argList != null ? argList.getArguments() : PyExpression.EMPTY_ARRAY;
        if (pyExpressionArray == null) {
            PyCallExpression.$$$reportNull$$$0(1);
        }
        return pyExpressionArray;
    }

    @Nullable
    default public <T extends PsiElement> T getArgument(int index, @NotNull Class<T> argClass) {
        PyExpression[] args;
        if (argClass == null) {
            PyCallExpression.$$$reportNull$$$0(2);
        }
        return (T)((args = this.getArguments()).length > index ? (PsiElement)ObjectUtils.tryCast((Object)args[index], argClass) : null);
    }

    @Nullable
    default public <T extends PsiElement> T getArgument(int index, @NotNull String keyword, @NotNull Class<T> argClass) {
        PyExpression arg;
        if (keyword == null) {
            PyCallExpression.$$$reportNull$$$0(3);
        }
        if (argClass == null) {
            PyCallExpression.$$$reportNull$$$0(4);
        }
        if ((arg = this.getKeywordArgument(keyword)) != null) {
            return (T)((PsiElement)ObjectUtils.tryCast((Object)arg, argClass));
        }
        return this.getArgument(index, argClass);
    }

    @Nullable
    default public <T extends PsiElement> T getArgument(@NotNull FunctionParameter parameter, @NotNull Class<T> argClass) {
        PyArgumentList list;
        if (parameter == null) {
            PyCallExpression.$$$reportNull$$$0(5);
        }
        if (argClass == null) {
            PyCallExpression.$$$reportNull$$$0(6);
        }
        if ((list = this.getArgumentList()) == null) {
            return null;
        }
        return (T)((PsiElement)ObjectUtils.tryCast((Object)list.getValueExpressionForParam(parameter), argClass));
    }

    @Nullable
    default public PyExpression getKeywordArgument(@NotNull String keyword) {
        if (keyword == null) {
            PyCallExpression.$$$reportNull$$$0(7);
        }
        for (PyExpression arg : this.getArguments()) {
            PyKeywordArgument keywordArg;
            if (!(arg instanceof PyKeywordArgument) || !keyword.equals((keywordArg = (PyKeywordArgument)arg).getKeyword())) continue;
            return keywordArg.getValueExpression();
        }
        return null;
    }

    @NotNull
    default public List<PyCallable> multiResolveCalleeFunction(@NotNull PyResolveContext resolveContext) {
        if (resolveContext == null) {
            PyCallExpression.$$$reportNull$$$0(8);
        }
        List list = ContainerUtil.mapNotNull(this.multiResolveCallee(resolveContext, 0), PyMarkedCallee::getElement);
        if (list == null) {
            PyCallExpression.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    default public List<PyMarkedCallee> multiResolveCallee(@NotNull PyResolveContext resolveContext) {
        if (resolveContext == null) {
            PyCallExpression.$$$reportNull$$$0(10);
        }
        List<PyMarkedCallee> list = this.multiResolveCallee(resolveContext, 0);
        if (list == null) {
            PyCallExpression.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    public List<PyMarkedCallee> multiResolveCallee(@NotNull PyResolveContext var1, int var2);

    @NotNull
    default public List<PyArgumentsMapping> multiMapArguments(@NotNull PyResolveContext resolveContext) {
        if (resolveContext == null) {
            PyCallExpression.$$$reportNull$$$0(12);
        }
        List<PyArgumentsMapping> list = this.multiMapArguments(resolveContext, 0);
        if (list == null) {
            PyCallExpression.$$$reportNull$$$0(13);
        }
        return list;
    }

    @NotNull
    public List<PyArgumentsMapping> multiMapArguments(@NotNull PyResolveContext var1, int var2);

    default public boolean isCalleeText(String ... nameCandidates) {
        PyExpression callee;
        if (nameCandidates == null) {
            PyCallExpression.$$$reportNull$$$0(14);
        }
        return (callee = this.getCallee()) instanceof PyReferenceExpression && ContainerUtil.exists((Object[])nameCandidates, name -> name.equals(((PyReferenceExpression)callee).getReferencedName()));
    }

    default public boolean isCallee(FQNamesProvider ... name) {
        PyExpression callee;
        if (name == null) {
            PyCallExpression.$$$reportNull$$$0(15);
        }
        return (callee = this.getCallee()) != null && NameResolverTools.isName(callee, name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/PyCallExpression";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argClass";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyword";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameCandidates";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/PyCallExpression";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolveCalleeFunction";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolveCallee";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "multiMapArguments";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getArgument";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getKeywordArgument";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "multiResolveCalleeFunction";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "multiResolveCallee";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "multiMapArguments";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isCalleeText";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isCallee";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PyMarkedCallee
    extends RatedResolveResult {
        @NotNull
        private final PyCallableType myCallableType;
        @Nullable
        private final PyFunction.Modifier myModifier;
        private final int myImplicitOffset;
        private final boolean myImplicitlyResolved;

        public PyMarkedCallee(@NotNull PyCallableType callableType, @Nullable PyCallable function, @Nullable PyFunction.Modifier modifier, int offset, boolean implicitlyResolved, int rate) {
            if (callableType == null) {
                PyMarkedCallee.$$$reportNull$$$0(0);
            }
            super(rate, (PsiElement)function);
            this.myCallableType = callableType;
            this.myModifier = modifier;
            this.myImplicitOffset = offset;
            this.myImplicitlyResolved = implicitlyResolved;
        }

        @NotNull
        public PyCallableType getCallableType() {
            PyCallableType pyCallableType = this.myCallableType;
            if (pyCallableType == null) {
                PyMarkedCallee.$$$reportNull$$$0(1);
            }
            return pyCallableType;
        }

        @Nullable
        public PyCallable getElement() {
            return (PyCallable)super.getElement();
        }

        @Nullable
        public PyFunction.Modifier getModifier() {
            return this.myModifier;
        }

        public int getImplicitOffset() {
            return this.myImplicitOffset;
        }

        public boolean isImplicitlyResolved() {
            return this.myImplicitlyResolved;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callableType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/psi/PyCallExpression$PyMarkedCallee";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/psi/PyCallExpression$PyMarkedCallee";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCallableType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class PyArgumentsMapping {
        @NotNull
        private final PyCallSiteExpression myCallSiteExpression;
        @Nullable
        private final PyMarkedCallee myMarkedCallee;
        @NotNull
        private final List<PyCallableParameter> myImplicitParameters;
        @NotNull
        private final Map<PyExpression, PyCallableParameter> myMappedParameters;
        @NotNull
        private final List<PyCallableParameter> myUnmappedParameters;
        @NotNull
        private final List<PyExpression> myUnmappedArguments;
        @NotNull
        private final List<PyCallableParameter> myParametersMappedToVariadicPositionalArguments;
        @NotNull
        private final List<PyCallableParameter> myParametersMappedToVariadicKeywordArguments;
        @NotNull
        private final Map<PyExpression, PyCallableParameter> myMappedTupleParameters;

        public PyArgumentsMapping(@NotNull PyCallSiteExpression callSiteExpression, @Nullable PyMarkedCallee markedCallee, @NotNull List<PyCallableParameter> implicitParameters, @NotNull Map<PyExpression, PyCallableParameter> mappedParameters, @NotNull List<PyCallableParameter> unmappedParameters, @NotNull List<PyExpression> unmappedArguments, @NotNull List<PyCallableParameter> parametersMappedToVariadicPositionalArguments, @NotNull List<PyCallableParameter> parametersMappedToVariadicKeywordArguments, @NotNull Map<PyExpression, PyCallableParameter> tupleMappedParameters) {
            if (callSiteExpression == null) {
                PyArgumentsMapping.$$$reportNull$$$0(0);
            }
            if (implicitParameters == null) {
                PyArgumentsMapping.$$$reportNull$$$0(1);
            }
            if (mappedParameters == null) {
                PyArgumentsMapping.$$$reportNull$$$0(2);
            }
            if (unmappedParameters == null) {
                PyArgumentsMapping.$$$reportNull$$$0(3);
            }
            if (unmappedArguments == null) {
                PyArgumentsMapping.$$$reportNull$$$0(4);
            }
            if (parametersMappedToVariadicPositionalArguments == null) {
                PyArgumentsMapping.$$$reportNull$$$0(5);
            }
            if (parametersMappedToVariadicKeywordArguments == null) {
                PyArgumentsMapping.$$$reportNull$$$0(6);
            }
            if (tupleMappedParameters == null) {
                PyArgumentsMapping.$$$reportNull$$$0(7);
            }
            this.myCallSiteExpression = callSiteExpression;
            this.myMarkedCallee = markedCallee;
            this.myImplicitParameters = implicitParameters;
            this.myMappedParameters = mappedParameters;
            this.myUnmappedParameters = unmappedParameters;
            this.myUnmappedArguments = unmappedArguments;
            this.myParametersMappedToVariadicPositionalArguments = parametersMappedToVariadicPositionalArguments;
            this.myParametersMappedToVariadicKeywordArguments = parametersMappedToVariadicKeywordArguments;
            this.myMappedTupleParameters = tupleMappedParameters;
        }

        @NotNull
        public static PyArgumentsMapping empty(@NotNull PyCallSiteExpression callSiteExpression) {
            if (callSiteExpression == null) {
                PyArgumentsMapping.$$$reportNull$$$0(8);
            }
            PyArgumentsMapping pyArgumentsMapping = new PyArgumentsMapping(callSiteExpression, null, Collections.emptyList(), Collections.emptyMap(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyMap());
            if (pyArgumentsMapping == null) {
                PyArgumentsMapping.$$$reportNull$$$0(9);
            }
            return pyArgumentsMapping;
        }

        @NotNull
        public PyCallSiteExpression getCallSiteExpression() {
            PyCallSiteExpression pyCallSiteExpression = this.myCallSiteExpression;
            if (pyCallSiteExpression == null) {
                PyArgumentsMapping.$$$reportNull$$$0(10);
            }
            return pyCallSiteExpression;
        }

        @Nullable
        public PyMarkedCallee getMarkedCallee() {
            return this.myMarkedCallee;
        }

        @NotNull
        public List<PyCallableParameter> getImplicitParameters() {
            List<PyCallableParameter> list = this.myImplicitParameters;
            if (list == null) {
                PyArgumentsMapping.$$$reportNull$$$0(11);
            }
            return list;
        }

        @NotNull
        public Map<PyExpression, PyCallableParameter> getMappedParameters() {
            Map<PyExpression, PyCallableParameter> map2 = this.myMappedParameters;
            if (map2 == null) {
                PyArgumentsMapping.$$$reportNull$$$0(12);
            }
            return map2;
        }

        @NotNull
        public List<PyCallableParameter> getUnmappedParameters() {
            List<PyCallableParameter> list = this.myUnmappedParameters;
            if (list == null) {
                PyArgumentsMapping.$$$reportNull$$$0(13);
            }
            return list;
        }

        @NotNull
        public List<PyExpression> getUnmappedArguments() {
            List<PyExpression> list = this.myUnmappedArguments;
            if (list == null) {
                PyArgumentsMapping.$$$reportNull$$$0(14);
            }
            return list;
        }

        @NotNull
        public List<PyCallableParameter> getParametersMappedToVariadicPositionalArguments() {
            List<PyCallableParameter> list = this.myParametersMappedToVariadicPositionalArguments;
            if (list == null) {
                PyArgumentsMapping.$$$reportNull$$$0(15);
            }
            return list;
        }

        @NotNull
        public List<PyCallableParameter> getParametersMappedToVariadicKeywordArguments() {
            List<PyCallableParameter> list = this.myParametersMappedToVariadicKeywordArguments;
            if (list == null) {
                PyArgumentsMapping.$$$reportNull$$$0(16);
            }
            return list;
        }

        @NotNull
        public Map<PyExpression, PyCallableParameter> getMappedTupleParameters() {
            Map<PyExpression, PyCallableParameter> map2 = this.myMappedTupleParameters;
            if (map2 == null) {
                PyArgumentsMapping.$$$reportNull$$$0(17);
            }
            return map2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callSiteExpression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "implicitParameters";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mappedParameters";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unmappedParameters";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unmappedArguments";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parametersMappedToVariadicPositionalArguments";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parametersMappedToVariadicKeywordArguments";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tupleMappedParameters";
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/psi/PyCallExpression$PyArgumentsMapping";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/psi/PyCallExpression$PyArgumentsMapping";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "empty";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCallSiteExpression";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getImplicitParameters";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMappedParameters";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnmappedParameters";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnmappedArguments";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParametersMappedToVariadicPositionalArguments";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParametersMappedToVariadicKeywordArguments";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMappedTupleParameters";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "empty";
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

