/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.configuration;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.util.NullableConsumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.JBUI;
import com.intellij.webcore.packaging.PackagesNotificationPanel;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.configuration.PyConfigurableInterpreterList;
import com.jetbrains.python.configuration.PythonSdkDetailsDialog;
import com.jetbrains.python.packaging.PyPackageManagers;
import com.jetbrains.python.packaging.ui.PyInstalledPackagesPanel;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.sdk.PyCustomSdkUiProvider;
import com.jetbrains.python.sdk.PyRenderedSdkType;
import com.jetbrains.python.sdk.PySdkListCellRenderer;
import com.jetbrains.python.sdk.PySdkRenderingKt;
import com.jetbrains.python.sdk.PythonSdkDetailsStep;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.PythonSdkUpdater;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import kotlin.jvm.functions.Function1;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyActiveSdkConfigurable
implements UnnamedConfigurable {
    public static final Topic<ActiveSdkListener> ACTIVE_PYTHON_SDK_TOPIC = new Topic("Active SDK changed", ActiveSdkListener.class);
    @NotNull
    private final Project myProject;
    @Nullable
    private final Module myModule;
    private final MySdkModelListener mySdkModelListener;
    private PyConfigurableInterpreterList myInterpreterList;
    private ProjectSdksModel myProjectSdksModel;
    private NullableConsumer<Sdk> myAddSdkCallback;
    private boolean mySdkSettingsWereModified;
    private JPanel myMainPanel;
    private ComboBox<Object> mySdkCombo;
    private PyInstalledPackagesPanel myPackagesPanel;
    private JButton myDetailsButton;
    private static final String SHOW_ALL = PyBundle.message("active.sdk.dialog.show.all.item", new Object[0]);
    private Set<Sdk> myInitialSdkSet;
    private Disposable myDisposable;

    public PyActiveSdkConfigurable(@NotNull Project project) {
        if (project == null) {
            PyActiveSdkConfigurable.$$$reportNull$$$0(0);
        }
        this.mySdkModelListener = new MySdkModelListener();
        this.mySdkSettingsWereModified = false;
        this.myDisposable = null;
        this.myModule = null;
        this.myProject = project;
        this.layoutPanel();
        this.initContent();
    }

    public PyActiveSdkConfigurable(@NotNull Module module2) {
        if (module2 == null) {
            PyActiveSdkConfigurable.$$$reportNull$$$0(1);
        }
        this.mySdkModelListener = new MySdkModelListener();
        this.mySdkSettingsWereModified = false;
        this.myDisposable = null;
        this.myModule = module2;
        this.myProject = module2.getProject();
        this.layoutPanel();
        this.initContent();
    }

    private void layoutPanel() {
        GridBagLayout layout = new GridBagLayout();
        this.myMainPanel = new JPanel(layout);
        JLabel interpreterLabel = new JLabel(PyBundle.message("active.sdk.dialog.project.interpreter", new Object[0]));
        JLabel emptyLabel = new JLabel("  ");
        this.mySdkCombo = new ComboBox<Object>(){

            public void setSelectedItem(Object item) {
                if (SHOW_ALL.equals(item)) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        PythonSdkDetailsDialog allDialog = PyActiveSdkConfigurable.this.myModule == null ? new PythonSdkDetailsDialog(PyActiveSdkConfigurable.this.myProject, (NullableConsumer<? super Sdk>)PyActiveSdkConfigurable.this.myAddSdkCallback, PyActiveSdkConfigurable.this.getSettingsModifiedCallback()) : new PythonSdkDetailsDialog(PyActiveSdkConfigurable.this.myModule, (NullableConsumer<? super Sdk>)PyActiveSdkConfigurable.this.myAddSdkCallback, PyActiveSdkConfigurable.this.getSettingsModifiedCallback());
                        allDialog.show();
                    });
                    return;
                }
                if (!"separator".equals(item)) {
                    super.setSelectedItem(item);
                }
            }

            public void paint(Graphics g) {
                try {
                    this.putClientProperty("JComboBox.isTableCellEditor", Boolean.FALSE);
                    super.paint(g);
                }
                finally {
                    this.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
                }
            }
        };
        new ComboboxSpeedSearch(this.mySdkCombo);
        this.mySdkCombo.putClientProperty((Object)"JComboBox.isTableCellEditor", (Object)Boolean.TRUE);
        PackagesNotificationPanel notificationsArea = new PackagesNotificationPanel();
        JComponent notificationsComponent = notificationsArea.getComponent();
        Dimension preferredSize = this.mySdkCombo.getPreferredSize();
        this.mySdkCombo.setPreferredSize(preferredSize);
        notificationsArea.hide();
        this.myDetailsButton = new FixedSizeButton();
        this.myDetailsButton.setIcon(AllIcons.General.GearPlain);
        this.myDetailsButton.setPreferredSize(new Dimension(preferredSize.height, preferredSize.height));
        this.myPackagesPanel = new PyInstalledPackagesPanel(this.myProject, notificationsArea);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = JBUI.insets((int)2);
        c.gridx = 0;
        c.gridy = 0;
        this.myMainPanel.add((Component)interpreterLabel, c);
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 0.1;
        this.myMainPanel.add((Component)this.mySdkCombo, c);
        c.insets = JBUI.insets((int)2, (int)0, (int)2, (int)2);
        c.gridx = 2;
        c.gridy = 0;
        c.weightx = 0.0;
        this.myMainPanel.add((Component)this.myDetailsButton, c);
        PyCustomSdkUiProvider customUiProvider = PyCustomSdkUiProvider.getInstance();
        if (customUiProvider != null) {
            this.myDisposable = Disposer.newDisposable();
            customUiProvider.customizeActiveSdkPanel(this.myProject, this.mySdkCombo, this.myMainPanel, c, this.myDisposable);
        }
        c.insets = JBUI.insets((int)2, (int)2, (int)0, (int)2);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 3;
        c.weightx = 0.0;
        this.myMainPanel.add((Component)emptyLabel, c);
        c.gridx = 0;
        ++c.gridy;
        c.weighty = 1.0;
        c.gridwidth = 3;
        c.gridheight = -1;
        c.fill = 1;
        this.myMainPanel.add((Component)((Object)this.myPackagesPanel), c);
        c.gridheight = 0;
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 3;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 15;
        this.myMainPanel.add((Component)notificationsComponent, c);
    }

    @NotNull
    private Runnable getSettingsModifiedCallback() {
        Runnable runnable = () -> {
            this.mySdkSettingsWereModified = true;
        };
        if (runnable == null) {
            PyActiveSdkConfigurable.$$$reportNull$$$0(2);
        }
        return runnable;
    }

    private void initContent() {
        this.myInterpreterList = PyConfigurableInterpreterList.getInstance(this.myProject);
        this.myProjectSdksModel = this.myInterpreterList.getModel();
        this.myInitialSdkSet = this.myProjectSdksModel.getProjectSdks().keySet();
        this.myProjectSdksModel.addListener((SdkModel.Listener)this.mySdkModelListener);
        this.mySdkCombo.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                Sdk selectedSdk = (Sdk)this.mySdkCombo.getSelectedItem();
                PyPackageManagers packageManagers = PyPackageManagers.getInstance();
                this.myPackagesPanel.updatePackages(selectedSdk != null ? packageManagers.getManagementService(this.myProject, selectedSdk) : null);
                this.myPackagesPanel.updateNotifications(selectedSdk);
            }
        });
        this.myAddSdkCallback = new SdkAddedCallback();
        this.myDetailsButton.addActionListener(e -> this.showDetails());
    }

    private void showDetails() {
        PythonSdkDetailsDialog allDialog = this.myModule == null ? new PythonSdkDetailsDialog(this.myProject, this.myAddSdkCallback, this.getSettingsModifiedCallback()) : new PythonSdkDetailsDialog(this.myModule, this.myAddSdkCallback, this.getSettingsModifiedCallback());
        PythonSdkDetailsStep.show(this.myProject, this.myModule, this.myProjectSdksModel.getSdks(), allDialog, this.myMainPanel, this.myDetailsButton.getLocationOnScreen(), this.myAddSdkCallback);
    }

    public JComponent createComponent() {
        return this.myMainPanel;
    }

    public boolean isModified() {
        Sdk sdk = this.getSdk();
        Sdk selectedSdk = this.getSelectedSdk();
        return this.mySdkSettingsWereModified || !Comparing.equal((Object)sdk, (Object)selectedSdk);
    }

    @Nullable
    private Sdk getSelectedSdk() {
        Sdk selectedItem = (Sdk)this.mySdkCombo.getSelectedItem();
        return selectedItem == null ? null : this.myProjectSdksModel.findSdk(selectedItem);
    }

    @Nullable
    protected Sdk getSdk() {
        if (this.myModule == null) {
            return ProjectRootManager.getInstance((Project)this.myProject).getProjectSdk();
        }
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)this.myModule);
        return rootManager.getSdk();
    }

    public void apply() throws ConfigurationException {
        this.mySdkSettingsWereModified = false;
        Sdk selectedSdk = this.getSelectedSdk();
        if (selectedSdk != null && this.myInitialSdkSet.contains(selectedSdk)) {
            PythonSdkUpdater.updateOrShowError(selectedSdk, null, this.myProject, null);
        }
        if (selectedSdk != null) {
            this.updateSdkList(false);
            this.myProjectSdksModel.apply();
            this.setSelectedSdk(selectedSdk);
        }
        Sdk prevSdk = this.getSdk();
        this.setSdk(selectedSdk);
        this.rehighlightVersionSpecific(selectedSdk, prevSdk);
    }

    private void setSelectedSdk(@Nullable Sdk selectedSdk) {
        this.mySdkCombo.getModel().setSelectedItem(selectedSdk == null ? null : this.myProjectSdksModel.findSdk(selectedSdk.getName()));
    }

    private void rehighlightVersionSpecific(@Nullable Sdk newSdk, @Nullable Sdk prevSdk) {
        if (prevSdk != null && newSdk != null) {
            PythonSdkFlavor flavor1 = PythonSdkFlavor.getFlavor(newSdk);
            PythonSdkFlavor flavor2 = PythonSdkFlavor.getFlavor(prevSdk);
            if (flavor1 != null && flavor2 != null) {
                LanguageLevel languageLevel1 = flavor1.getLanguageLevel(newSdk);
                LanguageLevel languageLevel2 = flavor2.getLanguageLevel(prevSdk);
                if (languageLevel1.isPy3K() && languageLevel2.isPython2() || languageLevel1.isPython2() && languageLevel2.isPy3K()) {
                    PyUtil.rehighlightOpenEditors(this.myProject);
                }
            }
        }
    }

    protected void setSdk(Sdk item) {
        ApplicationManager.getApplication().runWriteAction(() -> ProjectRootManager.getInstance((Project)this.myProject).setProjectSdk(item));
        if (this.myModule != null) {
            ModuleRootModificationUtil.setModuleSdk((Module)this.myModule, (Sdk)item);
            ((ActiveSdkListener)this.myProject.getMessageBus().syncPublisher(ACTIVE_PYTHON_SDK_TOPIC)).activeSdkChanged(this.myModule, item);
        }
    }

    public void reset() {
        this.updateSdkList(false);
        Sdk sdk = this.getSdk();
        this.setSelectedSdk(sdk);
    }

    private void updateSdkList(boolean preserveSelection) {
        Sdk selection;
        List<Sdk> allPythonSdks = this.myInterpreterList.getAllPythonSdks(this.myProject);
        Sdk sdk = selection = preserveSelection ? (Sdk)ObjectUtils.tryCast((Object)this.mySdkCombo.getSelectedItem(), Sdk.class) : null;
        if (!allPythonSdks.contains(selection)) {
            selection = null;
        }
        ArrayList<Object> items = new ArrayList<Object>();
        items.add(null);
        Map<PyRenderedSdkType, List<Sdk>> moduleSdksByTypes2 = PySdkRenderingKt.groupModuleSdksByTypes(allPythonSdks, this.myModule, (Function1<? super Sdk, Boolean>)((Function1)PythonSdkType::isInvalid));
        if (selection != null && !StreamEx.of(moduleSdksByTypes2.values()).flatCollection(Function.identity()).toList().contains(selection)) {
            items.add(0, selection);
        }
        PyRenderedSdkType[] renderedSdkTypes = PyRenderedSdkType.values();
        for (int i = 0; i < renderedSdkTypes.length; ++i) {
            PyRenderedSdkType currentSdkType = renderedSdkTypes[i];
            if (!moduleSdksByTypes2.containsKey((Object)currentSdkType)) continue;
            if (i != 0) {
                items.add("separator");
            }
            items.addAll((Collection)moduleSdksByTypes2.get((Object)currentSdkType));
        }
        items.add("separator");
        items.add(SHOW_ALL);
        this.mySdkCombo.setRenderer((ListCellRenderer)((Object)new PySdkListCellRenderer(null)));
        this.mySdkCombo.setModel((ComboBoxModel)new CollectionComboBoxModel(items, (Object)selection));
    }

    public void disposeUIResources() {
        this.myProjectSdksModel.removeListener((SdkModel.Listener)this.mySdkModelListener);
        this.myInterpreterList.disposeModel();
        if (this.myDisposable != null) {
            Disposer.dispose((Disposable)this.myDisposable);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/configuration/PyActiveSdkConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/configuration/PyActiveSdkConfigurable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettingsModifiedCallback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class SdkAddedCallback
    implements NullableConsumer<Sdk> {
        private SdkAddedCallback() {
        }

        public void consume(Sdk sdk) {
            if (sdk == null) {
                return;
            }
            if (PyActiveSdkConfigurable.this.myProjectSdksModel.findSdk(sdk.getName()) == null) {
                PyActiveSdkConfigurable.this.myProjectSdksModel.addSdk(sdk);
            }
            PyActiveSdkConfigurable.this.updateSdkList(false);
            PyActiveSdkConfigurable.this.setSelectedSdk(sdk);
        }
    }

    private class MySdkModelListener
    implements SdkModel.Listener {
        private MySdkModelListener() {
        }

        public void sdkAdded(@NotNull Sdk sdk) {
            if (sdk == null) {
                MySdkModelListener.$$$reportNull$$$0(0);
            }
            PyActiveSdkConfigurable.this.updateSdkList(true);
        }

        public void beforeSdkRemove(@NotNull Sdk sdk) {
            if (sdk == null) {
                MySdkModelListener.$$$reportNull$$$0(1);
            }
            PyActiveSdkConfigurable.this.updateSdkList(true);
        }

        public void sdkChanged(@NotNull Sdk sdk, String previousName) {
            if (sdk == null) {
                MySdkModelListener.$$$reportNull$$$0(2);
            }
            PyActiveSdkConfigurable.this.updateSdkList(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "sdk";
            objectArray2[1] = "com/jetbrains/python/configuration/PyActiveSdkConfigurable$MySdkModelListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "sdkAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeSdkRemove";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "sdkChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface ActiveSdkListener {
        public void activeSdkChanged(@NotNull Module var1, @Nullable Sdk var2);
    }
}

