# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class StructuredImplicitConnectivity(Object):
    """
    StructuredImplicitConnectivity - a distributed structured dataset
    that is implicitly connected among partitions without abutting.
    
    Superclass: Object
    
    This creates a gap between partitions and introduces a cell that
    spans multiple zones. This typically arises with finite difference
    grids, which are partitioned with respect to the nodes of the grid,
    or, when a filter samples the grid, e.g., to get a lower resolution
    representation.
    
    This class is intended as a lower-level helper for higher level VTK
    filters that provides functionality for resolving the implicit
    connectivity (gap) between two or more partitions of a distributed
    structured dataset.
    
    @warning
    The present implementation requires: 
     one block/grid per rank. 
     2-D (XY,YZ or XZ planes) or 3-D datasets. 
     node-center fields must match across processes.  
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkStructuredImplicitConnectivity, obj, update, **traits)
    
    def get_output_image_data(self, *args):
        """
        V.get_output_image_data(int, ImageData)
        C++: void GetOutputImageData(const int gridID, ImageData *grid)
        Gets the output uniform grid instance on this process.
        \param grid_id the ID of the grid.
        \param grid pointer to data-structure where to store the output.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetOutputImageData, *my_args)
        return ret

    def get_output_rectilinear_grid(self, *args):
        """
        V.get_output_rectilinear_grid(int, RectilinearGrid)
        C++: void GetOutputRectilinearGrid(const int gridID,
            RectilinearGrid *grid)
        Gets the output rectilinear grid instance on this process.
        \param grid_id the ID of the grid.
        \param grid pointer to data-structure where to store the output.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetOutputRectilinearGrid, *my_args)
        return ret

    def get_output_structured_grid(self, *args):
        """
        V.get_output_structured_grid(int, StructuredGrid)
        C++: void GetOutputStructuredGrid(const int gridID,
            StructuredGrid *grid)
        Gets the output structured grid instance on this process.
        \param grid_id the ID of the grid
        \param grid pointer to data-structure where to store the output.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetOutputStructuredGrid, *my_args)
        return ret

    def establish_connectivity(self):
        """
        V.establish_connectivity()
        C++: void EstablishConnectivity()
        Finds implicit connectivity for a distributed structured dataset.
        
        ote This is a collective operation, all ranks must call this
        method.
        \pre this->Controller != nullptr
        \pre this->_domain_info != nullptr
        """
        ret = self._vtk_obj.EstablishConnectivity()
        return ret
        

    def exchange_data(self):
        """
        V.exchange_data()
        C++: void ExchangeData()
        Exchanges one layer (row or column) of data between neighboring
        grids to fix the implicit connectivity.
        
        ote This is a collective operation, all ranks must call this
        method.
        \pre this->Controller != nullptr
        \pre this->_domain_info != nullptr
        """
        ret = self._vtk_obj.ExchangeData()
        return ret
        

    def has_implicit_connectivity(self):
        """
        V.has_implicit_connectivity() -> bool
        C++: bool HasImplicitConnectivity()
        Checks if there is implicit connectivity.
        \return status true if implicit connectivity in one or more
            dimensions.
        """
        ret = self._vtk_obj.HasImplicitConnectivity()
        return ret
        

    def register_grid(self, *args):
        """
        V.register_grid(int, [int, int, int, int, int, int], Points,
            PointData)
        C++: void RegisterGrid(const int gridID, int extent[6],
            Points *gridPnts, PointData *pointData)"""
        my_args = deref_array(args, [('int', ['int', 'int', 'int', 'int', 'int', 'int'], 'vtkPoints', 'vtkPointData')])
        ret = self._wrap_call(self._vtk_obj.RegisterGrid, *my_args)
        return ret

    def register_rectilinear_grid(self, *args):
        """
        V.register_rectilinear_grid(int, [int, int, int, int, int, int],
            DataArray, DataArray, DataArray, PointData)
        C++: void RegisterRectilinearGrid(const int gridID, int extent[6],
             DataArray *xcoords, DataArray *ycoords,
            DataArray *zcoords, PointData *pointData)"""
        my_args = deref_array(args, [('int', ['int', 'int', 'int', 'int', 'int', 'int'], 'vtkDataArray', 'vtkDataArray', 'vtkDataArray', 'vtkPointData')])
        ret = self._wrap_call(self._vtk_obj.RegisterRectilinearGrid, *my_args)
        return ret

    def set_whole_extent(self, *args):
        """
        V.set_whole_extent([int, int, int, int, int, int])
        C++: void SetWholeExtent(int wholeExt[6])
        Sets the whole extent for the distributed structured domain.
        \param whole_ext the extent of the entire domain (in).
        
        ote All ranks must call this method with the same whole extent.
        \post this->_domain_info != nullptr
        """
        ret = self._wrap_call(self._vtk_obj.SetWholeExtent, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(StructuredImplicitConnectivity, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit StructuredImplicitConnectivity properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit StructuredImplicitConnectivity properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit StructuredImplicitConnectivity properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

