/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyEncoding;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.DataType;
import org.jruby.util.ByteList;
import org.jruby.util.RubyStringBuilder;

public class TypeConverter {
    public static IRubyObject convertToType(IRubyObject obj, RubyClass target, String convertMethod, boolean raise2) {
        return TypeConverter.convertToType(target.getClassRuntime().getCurrentContext(), obj, target, convertMethod, raise2);
    }

    public static IRubyObject convertToType(ThreadContext context, IRubyObject obj, RubyClass target, String convertMethod, boolean raise2) {
        IRubyObject r = obj.checkCallMethod(context, convertMethod);
        return r == null ? TypeConverter.handleUncoercibleObject(context.runtime, obj, target, raise2) : r;
    }

    public static IRubyObject convertToType(ThreadContext context, IRubyObject obj, RubyClass target, JavaSites.CheckedSites sites, boolean raise2) {
        IRubyObject r = obj.checkCallMethod(context, sites);
        return r == null ? TypeConverter.handleUncoercibleObject(context.runtime, obj, target, raise2) : r;
    }

    public static IRubyObject convertToType(IRubyObject obj, RubyClass target, String convertMethod) {
        if (target.isInstance(obj)) {
            return obj;
        }
        IRubyObject val = TypeConverter.convertToType(obj, target, convertMethod, true);
        if (!target.isInstance(val)) {
            throw TypeConverter.newTypeError(obj.getRuntime(), obj, target, convertMethod, val);
        }
        return val;
    }

    public static IRubyObject convertToType(ThreadContext context, IRubyObject obj, RubyClass target, JavaSites.CheckedSites sites) {
        if (target.isInstance(obj)) {
            return obj;
        }
        IRubyObject val = TypeConverter.convertToType(context, obj, target, sites, true);
        if (!target.isInstance(val)) {
            throw TypeConverter.newTypeError(context.runtime, obj, target, sites.methodName, val);
        }
        return val;
    }

    @Deprecated
    public static IRubyObject convertToType19(IRubyObject obj, RubyClass target, String convertMethod, boolean raise2) {
        return TypeConverter.convertToType(obj, target, convertMethod, raise2);
    }

    @Deprecated
    public static IRubyObject convertToType19(ThreadContext context, IRubyObject obj, RubyClass target, JavaSites.CheckedSites sites, boolean raise2) {
        return TypeConverter.convertToType(context, obj, target, sites, raise2);
    }

    @Deprecated
    public static IRubyObject convertToType19(IRubyObject obj, RubyClass target, String convertMethod) {
        return TypeConverter.convertToType(obj, target, convertMethod);
    }

    @Deprecated
    public static IRubyObject convertToType19(ThreadContext context, IRubyObject obj, RubyClass target, JavaSites.CheckedSites sites) {
        return TypeConverter.convertToType(context, obj, target, sites);
    }

    public static RubyFloat toFloat(Ruby runtime2, IRubyObject obj) {
        if (obj instanceof RubyNumeric) {
            return ((RubyNumeric)obj).convertToFloat();
        }
        if (obj instanceof RubyString || obj.isNil()) {
            throw runtime2.newTypeError(obj, "Float");
        }
        return (RubyFloat)TypeConverter.convertToType(obj, runtime2.getFloat(), "to_f", true);
    }

    public static IRubyObject checkData(IRubyObject obj) {
        if (obj instanceof DataType) {
            return obj;
        }
        Ruby runtime2 = obj.getRuntime();
        throw runtime2.newTypeError(RubyStringBuilder.str(runtime2, "wrong argument type ", TypeConverter.typeAsString(obj), " (expected Data)"));
    }

    public static RubyString typeAsString(IRubyObject obj) {
        if (obj.isNil()) {
            return obj.getRuntime().newString("nil");
        }
        if (obj instanceof RubyBoolean) {
            return obj.getRuntime().newString(obj.isTrue() ? "true" : "false");
        }
        return obj.getMetaClass().getRealClass().rubyName();
    }

    public static RubySymbol checkID(IRubyObject obj) {
        Ruby runtime2 = obj.getRuntime();
        if (obj instanceof RubySymbol || obj instanceof RubyString) {
            return RubySymbol.newHardSymbol(runtime2, obj);
        }
        IRubyObject str = TypeConverter.convertToTypeWithCheck(obj, runtime2.getString(), "to_str");
        if (!str.isNil()) {
            return RubySymbol.newHardSymbol(runtime2, str);
        }
        ThreadContext context = runtime2.getCurrentContext();
        throw runtime2.newTypeError(obj.callMethod(context, "inspect") + " is not a symbol nor a string");
    }

    public static RubySymbol checkID(Ruby runtime2, String name2) {
        return RubySymbol.newHardSymbol(runtime2, name2.intern());
    }

    public static IRubyObject convertToTypeWithCheck(IRubyObject obj, RubyClass target, String convertMethod) {
        if (target.isInstance(obj)) {
            return obj;
        }
        IRubyObject val = TypeConverter.convertToType(obj, target, convertMethod, false);
        if (val.isNil()) {
            return val;
        }
        if (!target.isInstance(val)) {
            throw TypeConverter.newTypeError(obj, target, convertMethod, val);
        }
        return val;
    }

    public static IRubyObject convertToTypeWithCheck(ThreadContext context, IRubyObject obj, RubyClass target, JavaSites.CheckedSites sites) {
        if (target.isInstance(obj)) {
            return obj;
        }
        IRubyObject val = TypeConverter.convertToType(context, obj, target, sites, false);
        if (val == context.nil) {
            return val;
        }
        if (!target.isInstance(val)) {
            throw TypeConverter.newTypeError(context.runtime, obj, target, sites.methodName, val);
        }
        return val;
    }

    @Deprecated
    public static IRubyObject convertToTypeWithCheck19(IRubyObject obj, RubyClass target, String convertMethod) {
        return TypeConverter.convertToTypeWithCheck(obj, target, convertMethod);
    }

    @Deprecated
    public static IRubyObject convertToTypeWithCheck19(ThreadContext context, IRubyObject obj, RubyClass target, JavaSites.CheckedSites sites) {
        return TypeConverter.convertToTypeWithCheck(context, obj, target, sites);
    }

    public static RaiseException newTypeError(IRubyObject obj, RubyClass target, String convertMethod, IRubyObject val) {
        return TypeConverter.newTypeError(obj.getRuntime(), obj, target, convertMethod, val);
    }

    public static RaiseException newTypeError(Ruby runtime2, IRubyObject obj, RubyClass target, String methodName, IRubyObject val) {
        RubyString className = RubyStringBuilder.types(runtime2, obj.getMetaClass());
        return runtime2.newTypeError(RubyStringBuilder.str(runtime2, "can't convert ", className, " to ", RubyStringBuilder.types(runtime2, target), " (", className, '#' + methodName + " gives ", RubyStringBuilder.types(runtime2, val.getMetaClass()), ")"));
    }

    public static IRubyObject checkIntegerType(ThreadContext context, IRubyObject obj) {
        if (obj instanceof RubyFixnum) {
            return obj;
        }
        JavaSites.TypeConverterSites sites = TypeConverter.sites(context);
        IRubyObject conv = TypeConverter.convertToTypeWithCheck(context, obj, context.runtime.getInteger(), sites.to_int_checked);
        return conv instanceof RubyInteger ? conv : context.nil;
    }

    public static IRubyObject checkIntegerType(Ruby runtime2, IRubyObject obj, String method2) {
        if (method2.equals("to_int")) {
            return TypeConverter.checkIntegerType(runtime2.getCurrentContext(), obj);
        }
        if (obj instanceof RubyFixnum) {
            return obj;
        }
        if (method2.equals("to_i")) {
            ThreadContext context = runtime2.getCurrentContext();
            JavaSites.TypeConverterSites sites = TypeConverter.sites(context);
            IRubyObject conv = TypeConverter.convertToTypeWithCheck(context, obj, runtime2.getInteger(), sites.to_i_checked);
            return conv instanceof RubyInteger ? conv : runtime2.getNil();
        }
        IRubyObject conv = TypeConverter.convertToType(obj, runtime2.getInteger(), method2, false);
        return conv instanceof RubyInteger ? conv : runtime2.getNil();
    }

    public static IRubyObject checkFloatType(Ruby runtime2, IRubyObject obj) {
        if (obj instanceof RubyFloat) {
            return obj;
        }
        ThreadContext context = runtime2.getCurrentContext();
        JavaSites.TypeConverterSites sites = TypeConverter.sites(context);
        return TypeConverter.convertToTypeWithCheck(context, obj, runtime2.getFloat(), sites.to_f_checked);
    }

    public static IRubyObject checkHashType(Ruby runtime2, IRubyObject obj) {
        if (obj instanceof RubyHash) {
            return obj;
        }
        return TypeConverter.convertToTypeWithCheck(obj, runtime2.getHash(), "to_hash");
    }

    public static IRubyObject checkHashType(ThreadContext context, JavaSites.CheckedSites sites, IRubyObject obj) {
        if (obj instanceof RubyHash) {
            return obj;
        }
        return TypeConverter.convertToTypeWithCheck(context, obj, context.runtime.getHash(), sites);
    }

    public static IRubyObject checkStringType(Ruby runtime2, IRubyObject obj) {
        if (obj instanceof RubyString) {
            return obj;
        }
        return TypeConverter.convertToTypeWithCheck(obj, runtime2.getString(), "to_str");
    }

    public static IRubyObject checkStringType(ThreadContext context, JavaSites.CheckedSites sites, IRubyObject obj) {
        if (obj instanceof RubyString) {
            return obj;
        }
        return TypeConverter.convertToTypeWithCheck(context, obj, context.runtime.getString(), sites);
    }

    public static IRubyObject checkStringType(ThreadContext context, JavaSites.CheckedSites sites, IRubyObject obj, RubyClass target) {
        if (obj instanceof RubyString) {
            return obj;
        }
        return TypeConverter.convertToTypeWithCheck(context, obj, target, sites);
    }

    public static IRubyObject checkArrayType(Ruby runtime2, IRubyObject obj) {
        if (obj instanceof RubyArray) {
            return obj;
        }
        return TypeConverter.convertToTypeWithCheck(obj, runtime2.getArray(), "to_ary");
    }

    public static IRubyObject checkArrayType(ThreadContext context, JavaSites.CheckedSites sites, IRubyObject obj) {
        if (obj instanceof RubyArray) {
            return obj;
        }
        return TypeConverter.convertToTypeWithCheck(context, obj, context.runtime.getArray(), sites);
    }

    public static IRubyObject ioCheckIO(Ruby runtime2, IRubyObject obj) {
        if (obj instanceof RubyIO) {
            return obj;
        }
        return TypeConverter.convertToTypeWithCheck(obj, runtime2.getIO(), "to_io");
    }

    public static RubyIO ioGetIO(Ruby runtime2, IRubyObject obj) {
        return (RubyIO)TypeConverter.convertToType(obj, runtime2.getIO(), "to_io");
    }

    public static IRubyObject checkArrayType(ThreadContext context, IRubyObject obj) {
        return TypeConverter.convertToTypeWithCheck(context, obj, context.runtime.getArray(), TypeConverter.sites((ThreadContext)context).to_ary_checked);
    }

    @Deprecated
    public static IRubyObject checkArrayType(IRubyObject obj) {
        return TypeConverter.checkArrayType(obj.getRuntime().getCurrentContext(), obj);
    }

    public static IRubyObject handleUncoercibleObject(boolean raise2, IRubyObject obj, RubyClass target) {
        return TypeConverter.handleUncoercibleObject(obj.getRuntime(), obj, target, raise2);
    }

    public static IRubyObject handleUncoercibleObject(Ruby runtime2, IRubyObject obj, RubyClass target, boolean raise2) {
        if (raise2) {
            throw runtime2.newTypeError(RubyStringBuilder.str(runtime2, "no implicit conversion of ", TypeConverter.typeAsString(obj), " into ", target));
        }
        return runtime2.getNil();
    }

    @Deprecated
    public static IRubyObject handleImplicitlyUncoercibleObject(boolean raise2, IRubyObject obj, RubyClass target) {
        return TypeConverter.handleUncoercibleObject(obj.getRuntime(), obj, target, raise2);
    }

    public static void checkType(ThreadContext context, IRubyObject x, RubyModule type2) {
        assert (x != RubyBasicObject.UNDEF);
        ClassIndex xt = x.getMetaClass().getClassIndex();
        if (xt != type2.getClassIndex()) {
            Ruby runtime2 = context.runtime;
            throw context.runtime.newTypeError(RubyStringBuilder.str(runtime2, "wrong argument type ", RubyStringBuilder.types(runtime2, x.getMetaClass()), " (expected ", RubyStringBuilder.types(runtime2, type2), ")"));
        }
    }

    public static IRubyObject convertToInteger(ThreadContext context, IRubyObject val, int base) {
        IRubyObject tmp;
        Ruby runtime2;
        block11: {
            runtime2 = context.runtime;
            do {
                switch (val.getMetaClass().getClassIndex()) {
                    case FLOAT: {
                        if (base != 0) {
                            TypeConverter.raiseIntegerBaseError(context);
                        }
                        return RubyNumeric.dbl2ival(context.runtime, ((RubyFloat)val).getValue());
                    }
                    case INTEGER: {
                        if (base != 0) {
                            TypeConverter.raiseIntegerBaseError(context);
                        }
                        return val;
                    }
                    case STRING: {
                        return RubyNumeric.str2inum(context.runtime, (RubyString)val, base, true);
                    }
                    case NIL: {
                        if (base != 0) {
                            TypeConverter.raiseIntegerBaseError(context);
                        }
                        throw context.runtime.newTypeError("can't convert nil into Integer");
                    }
                }
                if (val instanceof RubyString) {
                    return RubyNumeric.str2inum(context.runtime, (RubyString)val, base, true);
                }
                if (base == 0) break block11;
            } while ((tmp = TypeConverter.checkStringType(context.runtime, val)) != context.nil);
            TypeConverter.raiseIntegerBaseError(context);
        }
        return (tmp = TypeConverter.convertToType(context, val, runtime2.getInteger(), TypeConverter.sites((ThreadContext)context).to_int_checked, false)) != context.nil ? tmp : TypeConverter.convertToType(context, val, runtime2.getInteger(), TypeConverter.sites((ThreadContext)context).to_i_checked);
    }

    public static RubyArray rb_Array(ThreadContext context, IRubyObject val) {
        IRubyObject tmp = TypeConverter.checkArrayType(context, val);
        if (tmp == context.nil) {
            JavaSites.TypeConverterSites sites = TypeConverter.sites(context);
            tmp = TypeConverter.convertToTypeWithCheck(context, val, context.runtime.getArray(), sites.to_a_checked);
            if (tmp == context.nil) {
                return context.runtime.newArray(val);
            }
        }
        return (RubyArray)tmp;
    }

    public static RubyArray to_ary(ThreadContext context, IRubyObject ary) {
        return (RubyArray)TypeConverter.convertToType(context, ary, context.runtime.getArray(), TypeConverter.sites((ThreadContext)context).to_ary_checked);
    }

    private static void raiseIntegerBaseError(ThreadContext context) {
        throw context.runtime.newArgumentError("base specified for non string value");
    }

    private static JavaSites.TypeConverterSites sites(ThreadContext context) {
        return context.sites.TypeConverter;
    }

    @Deprecated
    public static IRubyObject convertToType(IRubyObject obj, RubyClass target, int convertMethodIndex, String convertMethod, boolean raise2) {
        if (!obj.respondsTo(convertMethod)) {
            return TypeConverter.handleUncoercibleObject(raise2, obj, target);
        }
        return obj.callMethod(obj.getRuntime().getCurrentContext(), convertMethod);
    }

    @Deprecated
    public static IRubyObject convertToType(IRubyObject obj, RubyClass target, int convertMethodIndex, String convertMethod) {
        if (target.isInstance(obj)) {
            return obj;
        }
        IRubyObject val = TypeConverter.convertToType(obj, target, convertMethod, true);
        if (!target.isInstance(val)) {
            Ruby runtime2 = obj.getRuntime();
            throw runtime2.newTypeError(RubyStringBuilder.str(runtime2, RubyStringBuilder.types(runtime2, obj.getMetaClass()), "#" + convertMethod + " should return ", RubyStringBuilder.types(runtime2, target)));
        }
        return val;
    }

    @Deprecated
    public static IRubyObject convertToTypeWithCheck(IRubyObject obj, RubyClass target, int convertMethodIndex, String convertMethod) {
        if (target.isInstance(obj)) {
            return obj;
        }
        IRubyObject val = TypeConverter.convertToType(obj, target, convertMethod, false);
        if (val.isNil()) {
            return val;
        }
        if (!target.isInstance(val)) {
            Ruby runtime2 = obj.getRuntime();
            throw runtime2.newTypeError(RubyStringBuilder.str(runtime2, RubyStringBuilder.types(runtime2, obj.getMetaClass()), "#" + convertMethod + " should return ", RubyStringBuilder.types(runtime2, target)));
        }
        return val;
    }

    @Deprecated
    public static String convertToIdentifier(IRubyObject obj) {
        if (obj instanceof RubyString) {
            return new String(ByteList.plain(((RubyString)obj).getByteList()), RubyEncoding.ISO).intern();
        }
        return obj.asJavaString().intern();
    }

    @Deprecated
    public static IRubyObject convertToTypeOrRaise(IRubyObject obj, RubyClass target, String convertMethod) {
        if (target.isInstance(obj)) {
            return obj;
        }
        IRubyObject val = TypeConverter.convertToType(obj, target, convertMethod, true);
        if (val.isNil()) {
            return val;
        }
        if (!target.isInstance(val)) {
            Ruby runtime2 = obj.getRuntime();
            throw runtime2.newTypeError(RubyStringBuilder.str(runtime2, RubyStringBuilder.types(runtime2, obj.getMetaClass()), "#" + convertMethod + " should return ", RubyStringBuilder.types(runtime2, target)));
        }
        return val;
    }
}

