/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.common.experimental;

import java.util.Random;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.daemon.common.experimental.LoopbackNetworkInterfaceKtor;
import org.jetbrains.kotlin.daemon.common.experimental.socketInfrastructure.ServerSocketWrapper;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u001a\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"portSelectionRng", "Ljava/util/Random;", "findPortForSocket", "Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/ServerSocketWrapper;", "attempts", "", "portRangeStart", "portRangeEnd", "daemon-common-new"})
public final class NetworkUtilsKt {
    private static final Random portSelectionRng = new Random();

    @NotNull
    public static final ServerSocketWrapper findPortForSocket(int attempts, int portRangeStart, int portRangeEnd) {
        int i = 0;
        Exception lastException = null;
        while (i++ < attempts) {
            int port = portSelectionRng.nextInt(portRangeEnd - portRangeStart) + portRangeStart;
            try {
                return new ServerSocketWrapper(port, LoopbackNetworkInterfaceKtor.INSTANCE.getServerLoopbackSocketFactoryKtor().createServerSocket(port));
            }
            catch (Exception e) {
                lastException = e;
            }
        }
        throw (Throwable)new IllegalStateException("Cannot find free socketPort in " + attempts + " attempts", lastException);
    }
}

