/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.jvm.JvmGeneratorExtensions;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassDescriptor;
import org.jetbrains.kotlin.load.java.sam.SamAdapterDescriptor;
import org.jetbrains.kotlin.load.java.sam.SamConstructorDescriptor;
import org.jetbrains.kotlin.load.java.sam.SingleAbstractMethodUtils;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorExtensions;
import org.jetbrains.kotlin.synthetic.SamAdapterExtensionFunctionDescriptor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\rB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\"\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/JvmGeneratorExtensions;", "Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorExtensions;", "()V", "externalDeclarationOrigin", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;", "getExternalDeclarationOrigin", "()Lkotlin/jvm/functions/Function1;", "samConversion", "Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorExtensions$SamConversion;", "getSamConversion", "()Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorExtensions$SamConversion;", "JvmSamConversion", "backend.jvm"})
public final class JvmGeneratorExtensions
extends GeneratorExtensions {
    @Nullable
    private static final Function1<DeclarationDescriptor, IrDeclarationOrigin> externalDeclarationOrigin;
    public static final JvmGeneratorExtensions INSTANCE;

    @Override
    @Nullable
    public Function1<DeclarationDescriptor, IrDeclarationOrigin> getExternalDeclarationOrigin() {
        return externalDeclarationOrigin;
    }

    @Override
    @NotNull
    public GeneratorExtensions.SamConversion getSamConversion() {
        return JvmSamConversion.Instance;
    }

    private JvmGeneratorExtensions() {
    }

    static {
        JvmGeneratorExtensions jvmGeneratorExtensions;
        INSTANCE = jvmGeneratorExtensions = new JvmGeneratorExtensions();
        externalDeclarationOrigin = externalDeclarationOrigin.1.INSTANCE;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0016\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\bH\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0004H\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/JvmGeneratorExtensions$JvmSamConversion;", "Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorExtensions$SamConversion;", "()V", "getFunctionTypeForSAMClass", "Lorg/jetbrains/kotlin/types/KotlinType;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getOriginalForSamAdapter", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "isSamConstructor", "", "isSamType", "type", "Instance", "backend.jvm"})
    public static class JvmSamConversion
    extends GeneratorExtensions.SamConversion {
        public static final Instance Instance = new Instance(null);

        @Override
        @Nullable
        public CallableDescriptor getOriginalForSamAdapter(@NotNull CallableDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            CallableDescriptor callableDescriptor = descriptor2;
            return callableDescriptor instanceof SamAdapterDescriptor ? (FunctionDescriptor)((SamAdapterDescriptor)descriptor2).getBaseDescriptorForSynthetic() : (callableDescriptor instanceof SamAdapterExtensionFunctionDescriptor ? ((SamAdapterExtensionFunctionDescriptor)descriptor2).getBaseDescriptorForSynthetic() : null);
        }

        @Override
        public boolean isSamConstructor(@NotNull CallableDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            return descriptor2 instanceof SamConstructorDescriptor;
        }

        @Override
        public boolean isSamType(@NotNull KotlinType type2) {
            Intrinsics.checkParameterIsNotNull(type2, "type");
            return SingleAbstractMethodUtils.isSamType(type2);
        }

        @Override
        @NotNull
        public KotlinType getFunctionTypeForSAMClass(@NotNull ClassDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            if (!(descriptor2 instanceof JavaClassDescriptor)) {
                throw (Throwable)((Object)new AssertionError((Object)("SAM should be represented by a Java class: " + descriptor2)));
            }
            FunctionDescriptor functionDescriptor = SingleAbstractMethodUtils.getSingleAbstractMethodOrNull((JavaClassDescriptor)descriptor2);
            if (functionDescriptor == null) {
                throw (Throwable)((Object)new AssertionError((Object)(descriptor2 + " should have a single abstract method")));
            }
            Intrinsics.checkExpressionValueIsNotNull(functionDescriptor, "SingleAbstractMethodUtil\u2026 single abstract method\")");
            FunctionDescriptor singleAbstractMethod = functionDescriptor;
            SimpleType simpleType2 = SingleAbstractMethodUtils.getFunctionTypeForAbstractMethod(singleAbstractMethod, false);
            Intrinsics.checkExpressionValueIsNotNull(simpleType2, "SingleAbstractMethodUtil\u2026gleAbstractMethod, false)");
            return simpleType2;
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/JvmGeneratorExtensions$JvmSamConversion$Instance;", "Lorg/jetbrains/kotlin/backend/jvm/JvmGeneratorExtensions$JvmSamConversion;", "()V", "backend.jvm"})
        public static final class Instance
        extends JvmSamConversion {
            private Instance() {
            }

            public /* synthetic */ Instance(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

