"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardViewport = DashboardViewport;

var _react = _interopRequireDefault(require("react"));

var _exit_full_screen = require("ui/exit_full_screen");

var _grid = require("../grid");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
function DashboardViewport(_ref) {
  var maximizedPanelId = _ref.maximizedPanelId,
      getEmbeddableFactory = _ref.getEmbeddableFactory,
      panelCount = _ref.panelCount,
      title = _ref.title,
      description = _ref.description,
      useMargins = _ref.useMargins,
      isFullScreenMode = _ref.isFullScreenMode,
      onExitFullScreenMode = _ref.onExitFullScreenMode;
  return _react.default.createElement("div", {
    "data-shared-items-count": panelCount,
    "data-shared-items-container": true,
    "data-title": title,
    "data-description": description,
    className: useMargins ? 'dshDashboardViewport-withMargins' : 'dshDashboardViewport'
  }, isFullScreenMode && _react.default.createElement(_exit_full_screen.ExitFullScreenButton, {
    onExitFullScreenMode: onExitFullScreenMode
  }), _react.default.createElement(_grid.DashboardGrid, {
    getEmbeddableFactory: getEmbeddableFactory,
    maximizedPanelId: maximizedPanelId
  }));
}