"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.embeddablePlugin = void 0;

var _actions = require("./actions");

var _embeddables = require("./embeddables");

var _triggers = require("./triggers");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var embeddablePlugin = {
  addAction: function addAction(action) {
    return _actions.actionRegistry.set(action.id, action);
  },
  addEmbeddableFactory: function addEmbeddableFactory(factory) {
    return _embeddables.embeddableFactories.set(factory.type, factory);
  },
  attachAction: function attachAction(data) {
    return (0, _triggers.attachAction)(_triggers.triggerRegistry, data);
  }
};
exports.embeddablePlugin = embeddablePlugin;