import { toString } from './function';
export const URI = 'Store';
/**
 * @since 1.0.0
 */
export class Store {
    constructor(peek, pos) {
        this.peek = peek;
        this.pos = pos;
    }
    /** Reposition the focus at the specified position */
    seek(s) {
        return new Store(this.peek, s);
    }
    map(f) {
        return new Store(s => f(this.peek(s)), this.pos);
    }
    extract() {
        return this.peek(this.pos);
    }
    extend(f) {
        return new Store(s => f(this.seek(s)), this.pos);
    }
    inspect() {
        return this.toString();
    }
    toString() {
        return `new Store(${toString(this.peek)}, ${toString(this.pos)})`;
    }
}
const map = (sa, f) => {
    return sa.map(f);
};
const extract = (sa) => {
    return sa.extract();
};
const extend = (sa, f) => {
    return sa.extend(f);
};
/**
 * Extract a value from a position which depends on the current position
 *
 * @since 1.0.0
 */
export const peeks = (f) => (sa) => (s) => {
    return sa.peek(f(sa.pos));
};
/**
 * Reposition the focus at the specified position, which depends on the current position
 *
 * @since 1.0.0
 */
export const seeks = (f) => (sa) => {
    return new Store(sa.peek, f(sa.pos));
};
export function experiment(F) {
    return f => sa => F.map(f(sa.pos), s => sa.peek(s));
}
/**
 * @since 1.0.0
 */
export const store = {
    URI,
    map,
    extract,
    extend
};
