/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.python.antlr.adapter.AstAdapter;
import org.python.core.AstList$PyExposer;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PySlice;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.Traverseproc;
import org.python.core.Visitproc;
import org.python.expose.ExposedType;

@ExposedType(name="_ast.astlist", base=PyList.class)
public class AstList
extends PySequence
implements Cloneable,
List,
Traverseproc {
    public static final PyType TYPE;
    private static final PyString[] fields;
    private List data;
    private AstAdapter adapter;

    public PyString[] get_fields() {
        return fields;
    }

    public AstList() {
        this(TYPE, new ArrayList(), null);
    }

    public AstList(List data) {
        this(TYPE, data, null);
    }

    public AstList(List data, AstAdapter adapter) {
        this(TYPE, data, adapter);
    }

    public AstList(PyType type, List data, AstAdapter adapter) {
        super(TYPE);
        if (data == null) {
            data = new ArrayList();
        }
        this.data = data;
        this.adapter = adapter;
    }

    final PyObject astlist___ne__(PyObject o) {
        return this.seq___ne__(o);
    }

    final PyObject astlist___eq__(PyObject o) {
        return this.seq___eq__(o);
    }

    final PyObject astlist___lt__(PyObject o) {
        return this.seq___lt__(o);
    }

    final PyObject astlist___le__(PyObject o) {
        return this.seq___le__(o);
    }

    final PyObject astlist___gt__(PyObject o) {
        return this.seq___gt__(o);
    }

    final PyObject astlist___ge__(PyObject o) {
        return this.seq___ge__(o);
    }

    final boolean astlist___contains__(PyObject o) {
        return this.object___contains__(o);
    }

    final void astlist___delitem__(PyObject index) {
        this.seq___delitem__(index);
    }

    final void astlist___setitem__(PyObject o, PyObject def) {
        this.seq___setitem__(o, def);
    }

    final PyObject astlist___getitem__(PyObject o) {
        PyObject ret = this.seq___finditem__(o);
        if (ret == null) {
            throw Py.IndexError("index out of range: " + o);
        }
        return ret;
    }

    final boolean astlist___nonzero__() {
        return this.seq___nonzero__();
    }

    public PyObject astlist___iter__() {
        return this.seq___iter__();
    }

    final PyObject astlist___getslice__(PyObject start, PyObject stop, PyObject step) {
        return this.seq___getslice__(start, stop, step);
    }

    final void astlist___setslice__(PyObject start, PyObject stop, PyObject step, PyObject value) {
        if (value == null) {
            value = step;
            step = null;
        }
        this.seq___setslice__(start, stop, step, value);
    }

    final void astlist___delslice__(PyObject start, PyObject stop, PyObject step) {
        this.seq___delslice__(start, stop, step);
    }

    @Override
    public PyObject __imul__(PyObject o) {
        return this.astlist___imul__(o);
    }

    final PyObject astlist___imul__(PyObject o) {
        if (!o.isIndex()) {
            return null;
        }
        int count2 = o.asIndex(Py.OverflowError);
        int size = this.size();
        if (size == 0 || count2 == 1) {
            return this;
        }
        if (count2 < 1) {
            this.clear();
            return this;
        }
        if (size > Integer.MAX_VALUE / count2) {
            throw Py.MemoryError("");
        }
        int oldsize = this.data.size();
        for (int i = 1; i < count2; ++i) {
            this.data.addAll(this.data.subList(0, oldsize));
        }
        return this;
    }

    @Override
    public PyObject __mul__(PyObject o) {
        return this.astlist___mul__(o);
    }

    final PyObject astlist___mul__(PyObject o) {
        if (!o.isIndex()) {
            return null;
        }
        return this.repeat(o.asIndex(Py.OverflowError));
    }

    @Override
    public PyObject __rmul__(PyObject o) {
        return this.astlist___rmul__(o);
    }

    final PyObject astlist___rmul__(PyObject o) {
        if (!o.isIndex()) {
            return null;
        }
        return this.repeat(o.asIndex(Py.OverflowError));
    }

    @Override
    public PyObject __iadd__(PyObject other) {
        return this.astlist___iadd__(other);
    }

    final PyObject astlist___iadd__(PyObject o) {
        PyObject it;
        PyType oType = o.getType();
        if (oType == TYPE || oType == PyTuple.TYPE || this == o) {
            this.extend(AstList.fastSequence(o, "argument must be iterable"));
            return this;
        }
        try {
            it = o.__iter__();
        }
        catch (PyException pye) {
            if (!pye.match(Py.TypeError)) {
                throw pye;
            }
            return null;
        }
        this.extend(it);
        return this;
    }

    @Override
    public PyObject __add__(PyObject other) {
        return this.astlist___add__(other);
    }

    final PyObject astlist___add__(PyObject o) {
        AstList sum = null;
        Object oList = o.__tojava__(List.class);
        if (oList != Py.NoConversion && oList != null) {
            List otherList = (List)oList;
            sum = new AstList();
            sum.extend(this);
            Iterator i = otherList.iterator();
            while (i.hasNext()) {
                sum.add(i.next());
            }
        }
        return sum;
    }

    @Override
    public PyObject __radd__(PyObject o) {
        return this.astlist___radd__(o);
    }

    final PyObject astlist___radd__(PyObject o) {
        PyList sum = null;
        Object oList = o.__tojava__(List.class);
        if (oList != Py.NoConversion && oList != null) {
            sum = new PyList();
            sum.addAll((Collection)((List)oList));
            sum.extend(this);
        }
        return sum;
    }

    @Override
    public int __len__() {
        return this.data.size();
    }

    @Override
    public String toString() {
        return this.astlist_toString();
    }

    final String astlist_toString() {
        return this.data.toString();
    }

    public void append(PyObject o) {
        this.astlist_append(o);
    }

    final void astlist_append(PyObject o) {
        this.data.add(o);
    }

    public Object clone() {
        return new AstList(this);
    }

    final int astlist_count(PyObject value) {
        int count2 = 0;
        for (Object o : this.data) {
            if (!o.equals(value)) continue;
            ++count2;
        }
        return count2;
    }

    public int count(PyObject value) {
        return this.astlist_count(value);
    }

    public int index(PyObject o) {
        return this.astlist_index(o, 0, this.size());
    }

    public int index(PyObject o, int start) {
        return this.astlist_index(o, start, this.size());
    }

    public int index(PyObject o, int start, int stop) {
        return this.astlist_index(o, start, stop);
    }

    final int astlist_index(PyObject o, PyObject start, PyObject stop) {
        int startInt = start == null ? 0 : PySlice.calculateSliceIndex(start);
        int stopInt = stop == null ? this.size() : PySlice.calculateSliceIndex(stop);
        return this.astlist_index(o, startInt, stopInt);
    }

    final int astlist_index(PyObject o, int start, int stop) {
        return this._index(o, "astlist.index(x): x not in list", start, stop);
    }

    final int astlist_index(PyObject o, int start) {
        return this._index(o, "astlist.index(x): x not in list", start, this.size());
    }

    final int astlist_index(PyObject o) {
        return this._index(o, "astlist.index(x): x not in list", 0, this.size());
    }

    private int _index(PyObject o, String message, int start, int stop) {
        int validStart;
        int validStop = this.boundToSequence(stop);
        for (int i = validStart = this.boundToSequence(start); i < validStop && i < this.size(); ++i) {
            if (!this.data.get(i).equals(o)) continue;
            return i;
        }
        throw Py.ValueError(message);
    }

    @Override
    protected void del(int i) {
        this.data.remove(i);
    }

    protected void delRange(int start, int stop, int step) {
        block3: {
            block2: {
                if (step < 1) break block2;
                for (int i = start; i < stop; --stop, i += step) {
                    this.remove(i);
                    --i;
                }
                break block3;
            }
            if (step >= 0) break block3;
            for (int i = start; i >= 0 && i >= stop; i += step) {
                this.remove(i);
            }
        }
    }

    final void astlist_extend(PyObject iterable) {
        int length = this.size();
        this.setslice(length, length, 1, iterable);
    }

    public void extend(PyObject iterable) {
        this.astlist_extend(iterable);
    }

    @Override
    protected PyObject getslice(int start, int stop, int step) {
        if (step > 0 && stop < start) {
            stop = start;
        }
        int n = AstList.sliceLength(start, stop, step);
        List newList = this.data.subList(start, stop);
        if (step == 1) {
            newList = this.data.subList(start, stop);
            return new AstList(newList, this.adapter);
        }
        int j = 0;
        int i = start;
        while (j < n) {
            newList.set(j, this.data.get(i));
            ++j;
            i += step;
        }
        return new AstList(newList, this.adapter);
    }

    public void insert(int index, PyObject o) {
        this.astlist_insert(index, o);
    }

    final void astlist_insert(int index, PyObject o) {
        if (index < 0) {
            index = Math.max(0, this.size() + index);
        }
        if (index > this.size()) {
            index = this.size();
        }
        this.data.add(index, o);
    }

    final void astlist_remove(PyObject value) {
        this.del(this._index(value, "astlist.remove(x): x not in list", 0, this.size()));
    }

    public void remove(PyObject value) {
        this.astlist_remove(value);
    }

    public void reverse() {
        this.astlist_reverse();
    }

    final void astlist_reverse() {
        Collections.reverse(this.data);
    }

    public PyObject pop() {
        return this.pop(-1);
    }

    public PyObject pop(int n) {
        return this.astlist_pop(n);
    }

    final PyObject astlist_pop(int n) {
        if (this.adapter == null) {
            return (PyObject)this.data.remove(n);
        }
        Object element = this.data.remove(n);
        return this.adapter.ast2py(element);
    }

    @Override
    protected PyObject repeat(int count2) {
        if (count2 < 0) {
            count2 = 0;
        }
        int size = this.size();
        int newSize = size * count2;
        if (count2 != 0 && newSize / count2 != size) {
            throw Py.MemoryError("");
        }
        ArrayList newList = new ArrayList();
        for (int i = 0; i < count2; ++i) {
            newList.addAll(this.data);
        }
        return new AstList(newList);
    }

    @Override
    protected void setslice(int start, int stop, int step, PyObject value) {
        if (stop < start) {
            stop = start;
        }
        if (value instanceof PySequence) {
            PySequence sequence = (PySequence)value;
            this.setslicePySequence(start, stop, step, sequence);
        } else if (value instanceof List) {
            List list = (List)value.__tojava__(List.class);
            if (list != null && list != Py.NoConversion) {
                this.setsliceList(start, stop, step, list);
            }
        } else {
            this.setsliceIterable(start, stop, step, value);
        }
    }

    protected void setslicePySequence(int start, int stop, int step, PySequence value) {
        if (step != 0) {
            if (value == this) {
                PyList newseq = new PyList();
                PyObject iter = value.__iter__();
                PyObject item = null;
                while ((item = iter.__iternext__()) != null) {
                    newseq.append(item);
                }
                value = newseq;
            }
            int n = value.__len__();
            int i = 0;
            int j = start;
            while (i < n) {
                this.pyset(j, value.pyget(i));
                ++i;
                j += step;
            }
        }
    }

    protected void setsliceList(int start, int stop, int step, List value) {
        if (step != 1) {
            throw Py.TypeError("setslice with java.util.List and step != 1 not supported yet");
        }
        int n = value.size();
        for (int i = 0; i < n; ++i) {
            this.data.add(i + start, value.get(i));
        }
    }

    protected void setsliceIterable(int start, int stop, int step, PyObject value) {
        PyObject[] seq;
        try {
            seq = Py.make_array(value);
        }
        catch (PyException pye) {
            if (pye.match(Py.TypeError)) {
                throw Py.TypeError("can only assign an iterable");
            }
            throw pye;
        }
        this.setslicePySequence(start, stop, step, new PyList(seq));
    }

    public void add(int index, Object element) {
        this.data.add(index, element);
    }

    @Override
    public boolean add(Object o) {
        return this.data.add(o);
    }

    public boolean addAll(int index, Collection c) {
        return this.data.addAll(index, c);
    }

    @Override
    public boolean addAll(Collection c) {
        return this.data.addAll(c);
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.data.contains(o);
    }

    @Override
    public boolean containsAll(Collection c) {
        return this.data.containsAll(c);
    }

    public Object get(int index) {
        return this.data.get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.data.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public Iterator iterator() {
        return this.data.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.data.lastIndexOf(o);
    }

    public ListIterator listIterator() {
        return this.data.listIterator();
    }

    public ListIterator listIterator(int index) {
        return this.data.listIterator(index);
    }

    public boolean pyadd(PyObject o) {
        this.data.add(o);
        return true;
    }

    public void pyadd(int index, PyObject element) {
        this.data.add(index, element);
    }

    @Override
    public PyObject pyget(int index) {
        if (this.adapter == null) {
            return (PyObject)this.data.get(index);
        }
        return this.adapter.ast2py(this.data.get(index));
    }

    @Override
    public void pyset(int index, PyObject element) {
        if (this.adapter == null) {
            this.data.set(index, element);
        } else {
            Object o = this.adapter.py2ast(element);
            this.data.set(index, o);
        }
    }

    public Object remove(int index) {
        return this.data.remove(index);
    }

    @Override
    public boolean remove(Object o) {
        return this.data.remove(o);
    }

    @Override
    public boolean removeAll(Collection c) {
        return this.data.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection c) {
        return this.data.retainAll(c);
    }

    public Object set(int index, Object element) {
        return this.data.set(index, element);
    }

    @Override
    public int size() {
        return this.data.size();
    }

    public List subList(int fromIndex, int toIndex) {
        return this.data.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.data.toArray();
    }

    @Override
    public Object[] toArray(Object[] a) {
        return this.data.toArray(a);
    }

    public Object __tojava__(Class c) {
        if (c.isInstance(this)) {
            return this;
        }
        return Py.NoConversion;
    }

    @Override
    public int traverse(Visitproc visit, Object arg) {
        for (Object ob : this.data) {
            int retVal;
            if (!(ob instanceof PyObject) || (retVal = visit.visit((PyObject)ob, arg)) == 0) continue;
            return retVal;
        }
        return 0;
    }

    @Override
    public boolean refersDirectlyTo(PyObject ob) {
        return this.data.contains(ob);
    }

    static {
        PyType.addBuilder(AstList.class, new AstList$PyExposer());
        TYPE = PyType.fromClass(AstList.class);
        fields = new PyString[0];
    }
}

