/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.io.export.api;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.gephi.desktop.io.export.ExportControllerUI;
import org.gephi.desktop.io.export.GraphFileExporterUIPanel;
import org.gephi.desktop.io.export.api.TopDialog;
import org.gephi.desktop.io.export.spi.ExporterClassUI;
import org.gephi.io.exporter.api.FileType;
import org.gephi.io.exporter.spi.Exporter;
import org.gephi.io.exporter.spi.ExporterUI;
import org.gephi.io.exporter.spi.GraphExporter;
import org.gephi.io.exporter.spi.GraphFileExporterBuilder;
import org.gephi.ui.utils.DialogFileFilter;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public final class GraphFileExporterUI
implements ExporterClassUI {
    private GraphFileExporterBuilder selectedBuilder;
    private GraphExporter selectedExporter;
    private File selectedFile;
    private boolean visibleOnlyGraph = false;
    private JDialog dialog;

    @Override
    public String getName() {
        return NbBundle.getMessage(GraphFileExporterUI.class, (String)"GraphFileExporterUI_title");
    }

    @Override
    public boolean isEnable() {
        return true;
    }

    @Override
    public void action() {
        this.action(Lookup.getDefault().lookupAll(GraphFileExporterBuilder.class).toArray(new GraphFileExporterBuilder[0]));
    }

    public void action(GraphFileExporterBuilder exporterBuilder) {
        this.action(new GraphFileExporterBuilder[]{exporterBuilder});
    }

    public void action(final GraphFileExporterBuilder[] exporterBuilders) {
        String LAST_PATH = "GraphFileExporterUI_Last_Path";
        String LAST_PATH_DEFAULT = "GraphFileExporterUI_Last_Path_Default";
        String LAST_FILE_FILTER = "GraphFileExporterUI_Last_File_Filter";
        final ExportControllerUI exportController = (ExportControllerUI)Lookup.getDefault().lookup(ExportControllerUI.class);
        if (exportController == null) {
            return;
        }
        String lastPathDefault = NbPreferences.forModule(GraphFileExporterUI.class).get("GraphFileExporterUI_Last_Path_Default", null);
        String lastPath = NbPreferences.forModule(GraphFileExporterUI.class).get("GraphFileExporterUI_Last_Path", lastPathDefault);
        String lastFileFilterString = NbPreferences.forModule(GraphFileExporterUI.class).get("GraphFileExporterUI_Last_File_Filter", null);
        FlowLayout layout = new FlowLayout(2);
        JPanel optionsPanel = new JPanel(layout);
        final JButton optionsButton = new JButton(NbBundle.getMessage(GraphFileExporterUI.class, (String)"GraphFileExporterUI_optionsButton_name"));
        optionsPanel.add(optionsButton);
        optionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExporterUI exporterUI = exportController.getExportController().getUI((Exporter)GraphFileExporterUI.this.selectedExporter);
                if (exporterUI != null) {
                    JPanel panel = exporterUI.getPanel();
                    exporterUI.setup((Exporter)GraphFileExporterUI.this.selectedExporter);
                    DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(GraphFileExporterUI.class, (String)"GraphFileExporterUI_optionsDialog_title", (Object)GraphFileExporterUI.this.selectedBuilder.getName()));
                    TopDialog topDialog = new TopDialog(GraphFileExporterUI.this.dialog, dd.getTitle(), dd.isModal(), (NotifyDescriptor)dd, dd.getClosingOptions(), dd.getButtonListener());
                    topDialog.setVisible(true);
                    Object result = dd.getValue() != null ? dd.getValue() : NotifyDescriptor.CLOSED_OPTION;
                    exporterUI.unsetup(result == NotifyDescriptor.OK_OPTION);
                }
            }
        });
        final JPanel southPanel = new JPanel(new BorderLayout());
        southPanel.add((Component)optionsPanel, "North");
        GraphFileExporterUIPanel graphSettings = new GraphFileExporterUIPanel();
        graphSettings.setVisibleOnlyGraph(this.visibleOnlyGraph);
        southPanel.add((Component)graphSettings, "Center");
        File lastPathDir = null;
        if (lastPath != null) {
            for (lastPathDir = new File(lastPath).getParentFile(); lastPathDir != null && !lastPathDir.exists(); lastPathDir = lastPathDir.getParentFile()) {
            }
        }
        final JFileChooser chooser = new JFileChooser(lastPathDir){

            @Override
            protected JDialog createDialog(Component parent) throws HeadlessException {
                GraphFileExporterUI.this.dialog = super.createDialog(parent);
                GraphFileExporterUI.this.dialog.setSize(640, 480);
                GraphFileExporterUI.this.dialog.setResizable(true);
                Component c = GraphFileExporterUI.this.dialog.getContentPane().getComponent(0);
                if (c != null && c instanceof JComponent) {
                    Insets insets = ((JComponent)c).getInsets();
                    southPanel.setBorder(BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right));
                }
                GraphFileExporterUI.this.dialog.getContentPane().add((Component)southPanel, "South");
                return GraphFileExporterUI.this.dialog;
            }

            @Override
            public void approveSelection() {
                if (GraphFileExporterUI.this.canExport(this)) {
                    super.approveSelection();
                }
            }
        };
        chooser.setDialogTitle(NbBundle.getMessage(GraphFileExporterUI.class, (String)"GraphFileExporterUI_filechooser_title"));
        chooser.addPropertyChangeListener("fileFilterChanged", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DialogFileFilter fileFilter = (DialogFileFilter)evt.getNewValue();
                NbPreferences.forModule(GraphFileExporterUI.class).put("GraphFileExporterUI_Last_File_Filter", fileFilter.getExtensions().toString());
                GraphFileExporterUI.this.selectedBuilder = GraphFileExporterUI.this.getExporter(exporterBuilders, fileFilter);
                if (GraphFileExporterUI.this.selectedBuilder != null) {
                    GraphFileExporterUI.this.selectedExporter = GraphFileExporterUI.this.selectedBuilder.buildExporter();
                }
                if (GraphFileExporterUI.this.selectedBuilder != null && exportController.getExportController().getUI((Exporter)GraphFileExporterUI.this.selectedExporter) != null) {
                    optionsButton.setEnabled(true);
                } else {
                    optionsButton.setEnabled(false);
                }
                if (GraphFileExporterUI.this.selectedFile != null && fileFilter != null) {
                    String fileName = GraphFileExporterUI.this.selectedFile.getName();
                    String directoryPath = chooser.getCurrentDirectory().getAbsolutePath();
                    if (fileName.lastIndexOf(".") != -1) {
                        fileName = fileName.substring(0, fileName.lastIndexOf("."));
                        fileName = fileName.concat((String)fileFilter.getExtensions().get(0));
                        GraphFileExporterUI.this.selectedFile = new File(directoryPath, fileName);
                        chooser.setSelectedFile(GraphFileExporterUI.this.selectedFile);
                    }
                }
            }
        });
        chooser.addPropertyChangeListener("SelectedFileChangedProperty", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() != null) {
                    GraphFileExporterUI.this.selectedFile = (File)evt.getNewValue();
                }
            }
        });
        DialogFileFilter defaultFileFilter = null;
        DialogFileFilter lastFileFilter = null;
        for (GraphFileExporterBuilder graphFileExporter : exporterBuilders) {
            for (FileType fileType : graphFileExporter.getFileTypes()) {
                DialogFileFilter dialogFileFilter = new DialogFileFilter(fileType.getName());
                dialogFileFilter.addExtensions(fileType.getExtensions());
                if (defaultFileFilter == null) {
                    defaultFileFilter = dialogFileFilter;
                }
                if (lastFileFilterString != null && dialogFileFilter.getExtensions().toString().equals(lastFileFilterString)) {
                    lastFileFilter = dialogFileFilter;
                }
                chooser.addChoosableFileFilter((FileFilter)dialogFileFilter);
            }
        }
        chooser.setAcceptAllFileFilterUsed(false);
        if (lastFileFilter != null) {
            defaultFileFilter = lastFileFilter;
        }
        chooser.setFileFilter((FileFilter)defaultFileFilter);
        this.selectedFile = new File(chooser.getCurrentDirectory(), "Untitled" + (String)defaultFileFilter.getExtensions().get(0));
        if (lastPathDir != null && lastPathDir.exists() && lastPathDir.isDirectory()) {
            this.selectedFile = new File(lastPath);
        }
        chooser.setSelectedFile(this.selectedFile);
        int returnFile = chooser.showSaveDialog(null);
        if (returnFile == 0) {
            File file = chooser.getSelectedFile();
            file = FileUtil.normalizeFile((File)file);
            FileObject fileObject = FileUtil.toFileObject((File)file);
            NbPreferences.forModule(GraphFileExporterUI.class).put("GraphFileExporterUI_Last_Path", file.getAbsolutePath());
            this.visibleOnlyGraph = graphSettings.isVisibleOnlyGraph();
            this.selectedExporter.setExportVisible(this.visibleOnlyGraph);
            exportController.exportFile(fileObject, (Exporter)this.selectedExporter);
        }
        this.dialog = null;
    }

    private boolean canExport(JFileChooser chooser) {
        File file = chooser.getSelectedFile();
        String defaultExtention = this.selectedBuilder.getFileTypes()[0].getExtension();
        try {
            if (!file.getPath().endsWith(defaultExtention)) {
                this.selectedFile = file = new File(file.getPath() + defaultExtention);
                chooser.setSelectedFile(file);
            }
            if (!file.exists()) {
                if (!file.createNewFile()) {
                    String failMsg = NbBundle.getMessage(GraphFileExporterUI.class, (String)"GraphFileExporterUI_SaveFailed", (Object[])new Object[]{file.getPath()});
                    JOptionPane.showMessageDialog(null, failMsg);
                    return false;
                }
            } else {
                String overwriteMsg = NbBundle.getMessage(GraphFileExporterUI.class, (String)"GraphFileExporterUI_overwriteDialog_message", (Object[])new Object[]{file.getPath()});
                if (JOptionPane.showConfirmDialog(null, overwriteMsg, NbBundle.getMessage(GraphFileExporterUI.class, (String)"GraphFileExporterUI_overwriteDialog_title"), 0) != 0) {
                    return false;
                }
            }
        }
        catch (IOException ex) {
            NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)ex.getMessage(), 2);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)msg);
            return false;
        }
        return true;
    }

    private GraphFileExporterBuilder getExporter(GraphFileExporterBuilder[] exporterBuilders, DialogFileFilter fileFilter) {
        for (GraphFileExporterBuilder graphFileExporter : exporterBuilders) {
            for (FileType fileType : graphFileExporter.getFileTypes()) {
                DialogFileFilter tempFilter = new DialogFileFilter(fileType.getName());
                tempFilter.addExtensions(fileType.getExtensions());
                if (!tempFilter.equals((Object)fileFilter)) continue;
                return graphFileExporter;
            }
        }
        return null;
    }
}

